/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.HostConfigFaultFaultMsg;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.ResourceInUseFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.util.Map;

@Sample(name="remove-virtual-switch", description="removes a virtual switch")
public class RemoveVirtualSwitch
extends ConnectedVimServiceBase {
    private String host;
    private String virtualswitchid;

    @Option(name="hostname", description="Name of the host")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="vswitchid", description="Name of the switch to be added")
    public void setVirtualswitchid(String string) {
        this.virtualswitchid = string;
    }

    void removeVirtualSwitch() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem");
        ManagedObjectReference managedObjectReference = map.get(this.host);
        if (managedObjectReference != null) {
            try {
                HostConfigManager hostConfigManager = (HostConfigManager)this.getMOREFs.entityProps(managedObjectReference, new String[]{"configManager"}).get("configManager");
                ManagedObjectReference managedObjectReference2 = hostConfigManager.getNetworkSystem();
                this.vimPort.removeVirtualSwitch(managedObjectReference2, this.virtualswitchid);
                System.out.println(" : Successful removing : " + this.virtualswitchid);
            }
            catch (HostConfigFaultFaultMsg hostConfigFaultFaultMsg) {
                System.out.println(" : Failed : Configuration falilures. ");
            }
            catch (NotFoundFaultMsg notFoundFaultMsg) {
                System.out.println("Failed : " + (Object)((Object)notFoundFaultMsg));
            }
            catch (ResourceInUseFaultMsg resourceInUseFaultMsg) {
                System.out.println(" : Failed removing switch " + this.virtualswitchid);
                System.out.println("There are virtual network adapters associated with the virtual switch.");
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println(" : Failed removing switch: " + this.virtualswitchid);
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.printSoapFaultException(sOAPFaultException);
            }
        } else {
            System.out.println("Host not found");
        }
    }

    void printSoapFaultException(SOAPFaultException sOAPFaultException) {
        System.out.println("SOAP Fault -");
        if (sOAPFaultException.getFault().hasDetail()) {
            System.out.println(sOAPFaultException.getFault().getDetail().getFirstChild().getLocalName());
        }
        if (sOAPFaultException.getFault().getFaultString() != null) {
            System.out.println("\n Message: " + sOAPFaultException.getFault().getFaultString());
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.removeVirtualSwitch();
    }
}

