/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfPerfCounterInfo;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfMetricSeries;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PerfSampleInfo;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="realtime-performance", description=" This sample displays performance measurements from the current time  at the console")
public class RealTime
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private ManagedObjectReference perfManager;
    private String virtualmachinename;

    @Option(name="vmname", description="name of the vm")
    public void setVirtualmachinename(String string) {
        this.virtualmachinename = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        try {
            RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
            if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
                arrayList.addAll(retrieveResult.getObjects());
            }
            String string = null;
            if (retrieveResult != null && retrieveResult.getToken() != null) {
                string = retrieveResult.getToken();
            }
            while (string != null && !string.isEmpty()) {
                retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
                string = null;
                if (retrieveResult == null) continue;
                string = retrieveResult.getToken();
                if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
                arrayList.addAll(retrieveResult.getObjects());
            }
        }
        catch (SOAPFaultException sOAPFaultException) {
            this.printSoapFaultException(sOAPFaultException);
        }
        catch (Exception exception) {
            System.out.println(" : Failed Getting Contents");
            exception.printStackTrace();
        }
        return arrayList;
    }

    void displayValues(List<PerfEntityMetricBase> list, Map<Integer, PerfCounterInfo> map) {
        for (int i = 0; i < list.size(); ++i) {
            List list2 = ((PerfEntityMetric)list.get(i)).getValue();
            List list3 = ((PerfEntityMetric)list.get(i)).getSampleInfo();
            System.out.println("Sample time range: " + ((PerfSampleInfo)list3.get(0)).getTimestamp().toString() + " - " + ((PerfSampleInfo)list3.get(list3.size() - 1)).getTimestamp().toString());
            for (int j = 0; j < list2.size(); ++j) {
                PerfCounterInfo perfCounterInfo = map.get(new Integer(((PerfMetricSeries)list2.get(j)).getId().getCounterId()));
                if (perfCounterInfo != null) {
                    System.out.println(perfCounterInfo.getNameInfo().getSummary());
                }
                if (!(list2.get(j) instanceof PerfMetricIntSeries)) continue;
                PerfMetricIntSeries perfMetricIntSeries = (PerfMetricIntSeries)list2.get(j);
                List list4 = perfMetricIntSeries.getValue();
                for (Long l : list4) {
                    System.out.print(l + " ");
                }
                System.out.println();
            }
        }
    }

    List<PerfCounterInfo> getPerfCounters() {
        List list = null;
        try {
            PropertySpec propertySpec = new PropertySpec();
            propertySpec.setAll(Boolean.FALSE);
            propertySpec.getPathSet().add("perfCounter");
            propertySpec.setType("PerformanceManager");
            ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
            arrayList.add(propertySpec);
            ObjectSpec objectSpec = new ObjectSpec();
            objectSpec.setObj(this.perfManager);
            ArrayList<ObjectSpec> arrayList2 = new ArrayList<ObjectSpec>();
            arrayList2.add(objectSpec);
            PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
            propertyFilterSpec.getPropSet().add(propertySpec);
            propertyFilterSpec.getObjectSet().add(objectSpec);
            ArrayList<PropertyFilterSpec> arrayList3 = new ArrayList<PropertyFilterSpec>();
            arrayList3.add(propertyFilterSpec);
            ArrayList<PropertyFilterSpec> arrayList4 = new ArrayList<PropertyFilterSpec>(1);
            arrayList4.add(propertyFilterSpec);
            List<ObjectContent> list2 = this.retrievePropertiesAllObjects(arrayList4);
            if (list2 != null) {
                for (ObjectContent objectContent : list2) {
                    List list3 = objectContent.getPropSet();
                    if (list3 == null) continue;
                    for (DynamicProperty dynamicProperty : list3) {
                        List list4;
                        list = list4 = ((ArrayOfPerfCounterInfo)dynamicProperty.getVal()).getPerfCounterInfo();
                    }
                }
            }
        }
        catch (SOAPFaultException sOAPFaultException) {
            this.printSoapFaultException(sOAPFaultException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    void doRealTime() throws IOException, RuntimeFaultFaultMsg, InterruptedException, InvalidPropertyFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        ManagedObjectReference managedObjectReference = map.get(this.virtualmachinename);
        if (managedObjectReference != null) {
            ArrayList<PerfMetricId> arrayList;
            PerfCounterInfo perfCounterInfo2;
            int n;
            List<PerfCounterInfo> list = this.getPerfCounters();
            ArrayList<PerfCounterInfo> arrayList2 = new ArrayList<PerfCounterInfo>();
            for (int i = 0; i < list.size(); ++i) {
                if (!"cpu".equalsIgnoreCase(list.get(i).getGroupInfo().getKey())) continue;
                arrayList2.add(list.get(i));
            }
            HashMap<Integer, PerfCounterInfo> hashMap = new HashMap<Integer, PerfCounterInfo>();
            while (true) {
                n = 0;
                for (PerfCounterInfo perfCounterInfo2 : arrayList2) {
                    System.out.println(++n + " - " + perfCounterInfo2.getNameInfo().getSummary());
                }
                System.out.println("Please select a counter from the above list\nEnter 0 to end: ");
                arrayList = new BufferedReader(new InputStreamReader(System.in));
                n = Integer.parseInt(((BufferedReader)((Object)arrayList)).readLine());
                if (n <= arrayList2.size()) break;
                System.out.println("*** Value out of range!");
            }
            if (--n < 0) {
                return;
            }
            perfCounterInfo2 = (PerfCounterInfo)arrayList2.get(n);
            hashMap.put(new Integer(perfCounterInfo2.getKey()), perfCounterInfo2);
            List list2 = this.vimPort.queryAvailablePerfMetric(this.perfManager, managedObjectReference, null, null, new Integer(20));
            arrayList = new ArrayList<PerfMetricId>();
            if (list2 != null) {
                for (int i = 0; i < list2.size(); ++i) {
                    if (!hashMap.containsKey(new Integer(((PerfMetricId)list2.get(i)).getCounterId()))) continue;
                    arrayList.add((PerfMetricId)list2.get(i));
                }
            }
            this.monitorPerformance(this.perfManager, managedObjectReference, arrayList, hashMap);
        } else {
            System.out.println("Virtual Machine " + this.virtualmachinename + " not found");
        }
    }

    void monitorPerformance(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, List<PerfMetricId> list, Map<Integer, PerfCounterInfo> map) throws RuntimeFaultFaultMsg, InterruptedException {
        PerfQuerySpec perfQuerySpec = new PerfQuerySpec();
        perfQuerySpec.setEntity(managedObjectReference2);
        perfQuerySpec.setMaxSample(new Integer(10));
        perfQuerySpec.getMetricId().addAll(list);
        perfQuerySpec.setIntervalId(new Integer(20));
        ArrayList<PerfQuerySpec> arrayList = new ArrayList<PerfQuerySpec>();
        arrayList.add(perfQuerySpec);
        while (true) {
            List list2;
            List list3;
            if ((list3 = (list2 = this.vimPort.queryPerf(managedObjectReference, arrayList))) != null) {
                this.displayValues(list3, map);
            }
            System.out.println("Sleeping 10 seconds...");
            Thread.sleep(10000L);
        }
    }

    void printSoapFaultException(SOAPFaultException sOAPFaultException) {
        System.out.println("SOAP Fault -");
        if (sOAPFaultException.getFault().hasDetail()) {
            System.out.println(sOAPFaultException.getFault().getDetail().getFirstChild().getLocalName());
        }
        if (sOAPFaultException.getFault().getFaultString() != null) {
            System.out.println("\n Message: " + sOAPFaultException.getFault().getFaultString());
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, IOException, InterruptedException, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.perfManager = this.serviceContent.getPerfManager();
        this.doRealTime();
    }
}

