/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.performance.widgets.LineChart;
import com.vmware.vim25.ArrayOfPerfCounterInfo;
import com.vmware.vim25.ArrayOfPerfInterval;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfEntityMetricCSV;
import com.vmware.vim25.PerfInterval;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfMetricSeriesCSV;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

@Sample(name="vi-usage", description="This sample creates a GUI for graphical representation of the counters")
public class VIUsage
extends ConnectedVimServiceBase
implements ActionListener {
    private ManagedObjectReference perfManager;
    private ManagedObjectReference propCollectorRef;
    private String hostname;
    private String countername;
    private PerfInterval[] intervals;
    private LineChart chart;
    private JPanel mainPanel;
    private JPanel selectPanel;
    private JPanel displayPanel;
    private JComboBox intervalBox = null;
    private JLabel chartLabel = null;
    private String stats;
    private ManagedObjectReference hostmor;
    private JFrame frame;

    @Option(name="hostname")
    public void setHostname(String string) {
        this.hostname = string;
    }

    @Option(name="counter")
    public void setCountername(String string) {
        this.countername = string;
    }

    void init() {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.perfManager = this.serviceContent.getPerfManager();
    }

    void populateData() throws DatatypeConfigurationException {
        this.createMainPanel();
        this.initChart();
        this.updateChart();
    }

    public void displayUsage() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InterruptedException {
        this.stats = this.countername;
        Map<String, ManagedObjectReference> map = null;
        try {
            map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            invalidPropertyFaultMsg.printStackTrace();
        }
        this.hostmor = (ManagedObjectReference)map.get(this.hostname);
        if (this.hostmor == null) {
            System.out.println("Host " + this.hostname + " Not Found");
            return;
        }
        Map<String, Object> map2 = null;
        try {
            map2 = this.getMOREFs.entityProps(this.perfManager, new String[]{"historicalInterval"});
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            invalidPropertyFaultMsg.printStackTrace();
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        ArrayOfPerfInterval arrayOfPerfInterval = (ArrayOfPerfInterval)map2.get("historicalInterval");
        List list = arrayOfPerfInterval.getPerfInterval();
        this.intervals = new PerfInterval[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.intervals[i] = (PerfInterval)list.get(i);
        }
        if (this.intervals.length == 0) {
            System.out.println("No historical intervals");
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    VIUsage.this.createAndShowGUI();
                }
                catch (SOAPFaultException sOAPFaultException) {
                    VIUsage.printSoapFaultException(sOAPFaultException);
                }
                catch (Exception exception) {
                    System.out.println("Exception -: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });
        Thread.currentThread().join();
    }

    private void initChart() {
        String string;
        int n;
        PerfInterval perfInterval = this.intervals[this.intervalBox.getSelectedIndex()];
        int n2 = perfInterval.getSamplingPeriod();
        if (n2 <= 300) {
            n = 3600 / n2;
            string = "{3}:{4}";
        } else if (n2 <= 3600) {
            n = 21600 / n2;
            string = "{1}/{2} {3}:{4}";
        } else {
            n = 86400 / n2;
            string = "{1}/{2}";
        }
        int n3 = n;
        if (this.chart != null) {
            this.displayPanel.remove(this.chart);
        }
        this.chart = new LineChart(n, n2 * 1000, string, string, n3, true);
        this.chart.setPreferredSize(new Dimension(600, 150));
        this.displayPanel.add(this.chart);
        if (this.frame != null) {
            this.frame.pack();
        }
    }

    private void updateChart() throws DatatypeConfigurationException {
        ArrayOfPerfCounterInfo arrayOfPerfCounterInfo;
        List list = new ArrayList();
        Map<String, Object> map = null;
        try {
            map = this.getMOREFs.entityProps(this.perfManager, new String[]{"perfCounter"});
            arrayOfPerfCounterInfo = (ArrayOfPerfCounterInfo)map.get("perfCounter");
            list = arrayOfPerfCounterInfo.getPerfCounterInfo();
        }
        catch (SOAPFaultException sOAPFaultException) {
            VIUsage.printSoapFaultException(sOAPFaultException);
        }
        catch (Exception exception) {
            System.out.println("Error in getting perfCounter property: " + exception);
            return;
        }
        if (list != null && !list.isEmpty()) {
            List list2;
            Object object;
            Object object2;
            String string;
            Object object32;
            Object object4;
            String string2;
            String[] stringArray2;
            arrayOfPerfCounterInfo = new HashMap();
            for (String[] stringArray2 : list) {
                string2 = stringArray2.getGroupInfo().getKey();
                object4 = stringArray2.getNameInfo().getKey();
                object32 = stringArray2.getRollupType().value();
                string = string2 + "." + (String)object4 + "." + (String)object32;
                arrayOfPerfCounterInfo.put(string, stringArray2);
            }
            ArrayList arrayList = new ArrayList();
            stringArray2 = new String[1];
            string2 = this.stats;
            if (arrayOfPerfCounterInfo.containsKey(string2)) {
                object4 = (PerfCounterInfo)arrayOfPerfCounterInfo.get(string2);
                stringArray2[0] = object4.getNameInfo().getLabel();
                object32 = "";
                string = new PerfMetricId();
                string.setCounterId(object4.getKey());
                string.setInstance((String)object32);
                arrayList.add(string);
            } else {
                System.out.println("Unknown counter " + string2);
                for (Object object32 : list) {
                    string = object32.getGroupInfo().getKey();
                    object2 = object32.getNameInfo().getKey();
                    object = object32.getRollupType().value();
                    System.out.println("Counter " + string + "." + (String)object2 + "." + (String)object);
                }
                System.out.println("Select The Counter From This list");
                System.exit(1);
            }
            object4 = this.intervals[this.intervalBox.getSelectedIndex()];
            object32 = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            string = new PerfQuerySpec();
            string.setEntity(this.hostmor);
            string.setFormat("csv");
            string.setIntervalId(Integer.valueOf(object4.getSamplingPeriod()));
            string.getMetricId().addAll(arrayList);
            object2 = new ArrayList();
            try {
                object = Arrays.asList(string);
                list2 = this.vimPort.queryPerf(this.perfManager, (List)object);
                object2 = list2;
            }
            catch (SOAPFaultException sOAPFaultException) {
                VIUsage.printSoapFaultException(sOAPFaultException);
            }
            catch (Exception exception) {
                System.out.println("Error in queryPerf: " + exception);
                return;
            }
            if (object2 == null || object2.size() == 0) {
                System.out.println("queryPerf returned no entity metrics");
                return;
            }
            object = (PerfEntityMetricBase)object2.get(0);
            list2 = (PerfEntityMetricCSV)object;
            List list3 = list2.getValue();
            List list4 = list3;
            if (list4.size() == 0) {
                System.out.println("queryPerf returned no CSV series");
                return;
            }
            String string3 = stringArray2[0];
            PerfMetricSeriesCSV perfMetricSeriesCSV = (PerfMetricSeriesCSV)list4.get(0);
            String[] stringArray3 = perfMetricSeriesCSV.getValue().split(",");
            int[] nArray = new int[stringArray3.length];
            for (int i = 0; i < stringArray3.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray3[i]);
            }
            this.chart.setValues(nArray, ((XMLGregorianCalendar)object32).getMillisecond());
            this.displayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string3), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }
    }

    private void createMainPanel() {
        this.selectPanel = new JPanel();
        this.displayPanel = new JPanel();
        this.chartLabel = new JLabel();
        this.chartLabel.setHorizontalAlignment(0);
        this.chartLabel.setVerticalAlignment(0);
        this.chartLabel.setVerticalTextPosition(0);
        this.chartLabel.setHorizontalTextPosition(0);
        String[] stringArray = new String[this.intervals.length];
        for (int i = 0; i < this.intervals.length; ++i) {
            stringArray[i] = this.intervals[i].getName();
        }
        this.intervalBox = new JComboBox<String>(stringArray);
        this.selectPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Interval"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.displayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Metric Name"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.displayPanel.add(this.chartLabel);
        this.selectPanel.add(this.intervalBox);
        this.intervalBox.addActionListener(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.add(this.selectPanel);
        this.mainPanel.add(this.displayPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            System.out.println("Updating interval");
            this.initChart();
            try {
                this.updateChart();
            }
            catch (SOAPFaultException sOAPFaultException) {
                VIUsage.printSoapFaultException(sOAPFaultException);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                System.out.println("Error encountered: " + datatypeConfigurationException);
            }
        }
    }

    private void createAndShowGUI() throws DatatypeConfigurationException {
        try {
            String string = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string);
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.populateData();
        this.frame = new JFrame("VIUsage");
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    VIUsage.this.connection.disconnect();
                }
                catch (SOAPFaultException sOAPFaultException) {
                    VIUsage.printSoapFaultException(sOAPFaultException);
                }
                catch (Exception exception) {
                    System.out.println("Failed to disconnect - " + exception.getMessage());
                    exception.printStackTrace();
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        });
        this.frame.setContentPane(this.mainPanel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private static void printSoapFaultException(SOAPFaultException sOAPFaultException) {
        System.out.println("SOAP Fault -");
        if (sOAPFaultException.getFault().hasDetail()) {
            System.out.println(sOAPFaultException.getFault().getDetail().getFirstChild().getLocalName());
        }
        if (sOAPFaultException.getFault().getFaultString() != null) {
            System.out.println("\n Message: " + sOAPFaultException.getFault().getFaultString());
        }
    }

    @Action
    public void run() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InterruptedException {
        this.init();
        this.displayUsage();
    }
}

