/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.security.credstore;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class CredentialStoreCipher {
    public static final String ALGORITHM = "RC4";
    final Cipher cipher = Cipher.getInstance("RC4");

    public CredentialStoreCipher(SecretKey secretKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        this.cipher.init(1, secretKey);
    }

    public static SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        return keyGenerator.generateKey();
    }

    public byte[] encrypt(byte[] byArray) {
        try {
            return this.cipher.doFinal(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoGraphicException(generalSecurityException);
        }
    }

    public byte[] decrypt(byte[] byArray) {
        try {
            return this.cipher.doFinal(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoGraphicException(generalSecurityException);
        }
    }

    private class CryptoGraphicException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public CryptoGraphicException(GeneralSecurityException generalSecurityException) {
            super(generalSecurityException);
        }
    }
}

