/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.security.credstore;

import com.vmware.security.credstore.FileInputStreamNoClose;
import jakarta.xml.bind.DatatypeConverter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

class CredentialStoreStorage {
    private final String docRoot = "viCredentials";
    private final String versionTag = "version";
    private final String cacheEntryTag = "passwordEntry";
    private final String hostnameTag = "host";
    private final String usernameTag = "username";
    private final String passwordTag = "password";
    private Map<Key, String> cacheData;
    private String cacheVersion;
    private int entryCount;
    private final File cachePath;
    private final boolean defaultCachePath;
    private FileLock lock;
    private RandomAccessFile inoutFile;

    public CredentialStoreStorage(File file, boolean bl) throws IOException {
        if (file == null) {
            throw new IOException("Store not initialised.");
        }
        this.cachePath = file;
        this.defaultCachePath = bl;
    }

    private void getReadLock() throws IOException {
        this.inoutFile = new RandomAccessFile(this.cachePath, "r");
        FileChannel fileChannel = this.inoutFile.getChannel();
        this.lock = fileChannel.tryLock(0L, 1L, true);
        int n = 1;
        while (this.lock == null) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lock = fileChannel.tryLock(0L, 1L, true);
            if (++n != 12) continue;
        }
        if (this.lock == null) {
            throw new IOException("Unable to acquire a read lock");
        }
    }

    private void getWriteLock() throws IOException {
        this.inoutFile = new RandomAccessFile(this.cachePath, "rw");
        FileChannel fileChannel = this.inoutFile.getChannel();
        this.lock = fileChannel.tryLock();
        int n = 1;
        while (this.lock == null) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lock = fileChannel.tryLock();
            if (++n != 12) continue;
        }
        if (this.lock == null) {
            throw new IOException("Unable to acquire a write lock");
        }
    }

    private void releaseLock() throws IOException {
        if (this.lock != null) {
            this.lock.release();
        }
        this.inoutFile.close();
        this.inoutFile = null;
    }

    private void storeCache() throws IOException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("viCredentials");
            document.appendChild(element);
            if (this.cacheVersion == null) {
                throw new IOException("Empty credentials store state. Nothing to write");
            }
            Element element2 = document.createElement("version");
            Text text = document.createTextNode(this.cacheVersion);
            element2.appendChild(text);
            element.appendChild(element2);
            if (this.cacheData != null) {
                for (Key object52 : this.cacheData.keySet()) {
                    object4 = document.createElement("passwordEntry");
                    object3 = document.createElement("host");
                    object3.appendChild(document.createTextNode(object52.hostname));
                    object4.appendChild((Node)object3);
                    object2 = document.createElement("username");
                    object2.appendChild(document.createTextNode(object52.username));
                    object4.appendChild((Node)object2);
                    object = document.createElement("password");
                    object.appendChild(document.createTextNode(this.cacheData.get(new Key(object52.hostname, object52.username))));
                    object4.appendChild((Node)object);
                    element.appendChild((Node)object4);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            object4 = new StringWriter();
            object3 = new StreamResult((Writer)object4);
            object2 = new DOMSource(document);
            transformer.transform((Source)object2, (Result)object3);
            object = ((StringWriter)object4).toString();
            this.inoutFile.setLength(0L);
            this.inoutFile.write(((String)object).getBytes("UTF-8"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (IOException)new IOException(parserConfigurationException.toString()).initCause(parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw (IOException)new IOException(transformerConfigurationException.toString()).initCause(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw (IOException)new IOException(transformerException.toString()).initCause(transformerException);
        }
    }

    private void loadCache() throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            FileInputStreamNoClose fileInputStreamNoClose = new FileInputStreamNoClose(this.inoutFile.getFD());
            Document document = documentBuilder.parse(fileInputStreamNoClose);
            if (document.getDocumentElement().getNodeName() != "viCredentials") {
                throw new IOException("Invalid document root: " + document.getDocumentElement().getNodeName());
            }
            NodeList nodeList = document.getElementsByTagName("version");
            if (nodeList.getLength() != 1) {
                throw new IOException("Missing/too many credentials store version entry");
            }
            Node node = nodeList.item(0);
            this.cacheVersion = node.getFirstChild().getNodeValue();
            NodeList nodeList2 = document.getElementsByTagName("passwordEntry");
            this.entryCount = nodeList2.getLength();
            this.cacheData = new TreeMap<Key, String>();
            for (int i = 0; i < this.entryCount; ++i) {
                String string = null;
                String string2 = null;
                String string3 = null;
                Node node2 = nodeList2.item(i);
                NodeList nodeList3 = node2.getChildNodes();
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Node node3 = nodeList3.item(j);
                    if (node3.getNodeName() == "host") {
                        string = node3.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (node3.getNodeName() == "username") {
                        string2 = node3.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (node3.getNodeName() != "password") continue;
                    string3 = node3.getFirstChild().getNodeValue();
                }
                if (string == null || string2 == null || string3 == null) {
                    throw new IOException("Missing element(s) in credentials store.");
                }
                this.cacheData.put(new Key(string, string2), string3);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (IOException)new IOException(parserConfigurationException.toString()).initCause(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
        }
    }

    public byte[] getPassword(String string, String string2) throws IOException {
        if (this.cachePath.isDirectory()) {
            throw new IOException("Credentials store file path do not contain filename.");
        }
        if (!this.cachePath.exists()) {
            return null;
        }
        try {
            this.getReadLock();
            this.loadCache();
        }
        finally {
            this.releaseLock();
        }
        Key key = new Key(string, string2);
        if (this.cacheData != null) {
            for (Key key2 : this.cacheData.keySet()) {
                if (key2.compareTo(key) != 0) continue;
                return DatatypeConverter.parseHexBinary((String)this.cacheData.get(key2));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(String string, String string2) throws IOException {
        if (this.cachePath.isDirectory()) {
            throw new IOException("Credentials store file path do not contain filename.");
        }
        if (!this.cachePath.exists()) {
            return false;
        }
        try {
            this.getWriteLock();
            this.loadCache();
            Key key = new Key(string, string2);
            if (this.cacheData != null) {
                boolean bl = this.cacheData.keySet().remove(key);
                if (bl) {
                    System.out.println("Removing entry from the credstore...");
                    this.storeCache();
                }
                boolean bl2 = bl;
                return bl2;
            }
        }
        finally {
            this.releaseLock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(String string, String string2, byte[] byArray) throws IOException {
        if (this.cachePath.isDirectory()) {
            throw new IOException("Credentials store file path do not contain filename.");
        }
        if (!this.cachePath.exists()) {
            CredentialStoreStorage.createCache(this.cachePath, this.defaultCachePath);
        }
        try {
            this.getWriteLock();
            if (this.inoutFile.length() > 0L) {
                this.loadCache();
            }
            String string3 = DatatypeConverter.printHexBinary((byte[])byArray);
            if (this.cacheData != null) {
                boolean bl = this.cacheData.put(new Key(string, string2), string3) != null;
                this.storeCache();
                boolean bl2 = !bl;
                return bl2;
            }
            this.cacheData = new TreeMap<Key, String>();
            this.cacheVersion = "1.0";
            this.entryCount = 0;
            this.cacheData.put(new Key(string, string2), string3);
            this.storeCache();
        }
        finally {
            this.releaseLock();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createCache(File file, boolean bl) throws IOException {
        String string = file.getParent();
        if (string == null) return;
        File file2 = new File(string);
        if (!file2.exists()) {
            if (!bl) throw new IOException("Credentials store file path do not exist.");
            file2.mkdirs();
            if (File.separatorChar != '/') return;
            Runtime runtime = Runtime.getRuntime();
            runtime.exec("chmod 0700 " + file2.getPath());
            file.createNewFile();
            runtime.exec("chmod 0600 " + file.getPath());
            return;
        } else {
            file.createNewFile();
            if (File.separatorChar != '/') return;
            Runtime runtime = Runtime.getRuntime();
            runtime.exec("chmod 0600 " + file.getPath());
        }
    }

    public void clearPasswords() throws IOException {
        if (this.cachePath.isDirectory()) {
            throw new IOException("Credentials store file path do not contain filename.");
        }
        if (!this.cachePath.exists()) {
            return;
        }
        try {
            this.getWriteLock();
            this.cacheData = null;
            this.cacheVersion = "1.0";
            this.entryCount = 0;
            System.out.println("Clearing all entries from the credstore...");
            this.storeCache();
        }
        finally {
            this.releaseLock();
        }
    }

    public Set<String> getHosts() throws IOException {
        if (this.cachePath.isDirectory()) {
            throw new IOException("Credentials store file path do not contain filename.");
        }
        if (!this.cachePath.exists()) {
            return new HashSet<String>();
        }
        try {
            this.getReadLock();
            this.loadCache();
        }
        finally {
            this.releaseLock();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Key key : this.cacheData.keySet()) {
            hashSet.add(key.hostname);
        }
        return hashSet;
    }

    public Set<String> getUserNames(String string) throws IOException {
        if (this.cachePath.isDirectory()) {
            throw new IOException("Credentials store file path do not contain filename.");
        }
        if (!this.cachePath.exists()) {
            return new HashSet<String>();
        }
        try {
            this.getReadLock();
            this.loadCache();
        }
        finally {
            this.releaseLock();
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (this.cacheData != null) {
            for (Key key : this.cacheData.keySet()) {
                if (string.compareToIgnoreCase(key.hostname) != 0) continue;
                hashSet.add(key.username);
            }
        }
        return hashSet;
    }

    private static class Key
    implements Comparable<Key> {
        String hostname;
        String username;

        Key(String string, String string2) {
            this.hostname = string;
            this.username = string2;
        }

        @Override
        public int compareTo(Key key) {
            int n = this.hostname.compareToIgnoreCase(key.hostname);
            if (n == 0) {
                n = this.username.compareTo(key.username);
            }
            return n;
        }
    }
}

