/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.storage;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayUpdateOperation;
import com.vmware.vim25.ClusterAntiAffinityRuleSpec;
import com.vmware.vim25.ClusterRuleInfo;
import com.vmware.vim25.ClusterRuleSpec;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PodStorageDrsEntry;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.StorageDrsConfigSpec;
import com.vmware.vim25.StorageDrsPodConfigSpec;
import com.vmware.vim25.StorageDrsVmConfigInfo;
import com.vmware.vim25.StorageDrsVmConfigSpec;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDiskAntiAffinityRuleSpec;
import com.vmware.vim25.VirtualMachineConfigInfo;
import jakarta.xml.soap.SOAPException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Sample(name="sdrs-rules", description="This sample demonstrates how to Add/List/Modify/Delete the rules for an\nexisting SDRS cluster.")
public class SDRSRules
extends ConnectedVimServiceBase {
    static final String[] validOptions = new String[]{"addVmAntiAffinity", "addVmdkAntiAffinity", "list", "modifyVmAntiAffinity", "modifyVmdkAntiAffinity", "deleteVmAntiAffinity", "deleteVmdkAntiAffinity"};
    private ManagedObjectReference propCollectorRef;
    String option = null;
    String storagePodName = null;
    String ruleName = null;
    String newRuleName = null;
    Boolean enabled = null;
    String vmName = null;
    List<String> vm = new ArrayList<String>();

    @Option(name="podname", description="StoragePod name.")
    public void setPodName(String string) {
        this.storagePodName = string;
    }

    @Option(name="option", description="valid option are: \"addVmAntiAffinity\",\n\"addVmdkAntiAffinity\", \"list\", \"modifyVmAntiAffinity\",\n\"modifyVmdkAntiAffinity\", \"deleteVmAntiAffinity\" and\n\"deleteVmdkAntiAffinity\".")
    public void setOption(String string) {
        this.option = string;
    }

    @Option(name="rulename", required=false, description="Rule name.")
    public void setRuleName(String string) {
        this.ruleName = string;
    }

    @Option(name="vmlist", required=false, description="Comma separated,\nlist of VM name. It is required while\nadding VmAntiAffinity Rule.")
    public void setVmList(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            this.vm.add(string2);
        }
    }

    @Option(name="newrulename", required=false, description="New name for rule while modifying")
    public void setNewRuleName(String string) {
        this.newRuleName = string;
    }

    @Option(name="enable", required=false, description="Flag to indicate whether or not the rule is enabled.")
    public void setEnabled(String string) {
        this.enabled = new Boolean("true".equalsIgnoreCase(string) || "enable".equalsIgnoreCase(string));
    }

    @Option(name="vmname", required=false, description="virtual machine name.")
    public void setVmName(String string) {
        this.vmName = string;
    }

    void validate() {
        if (!this.isValidOption(this.option)) {
            throw new IllegalArgumentException("the option '--option " + this.option + "' is not a valid value");
        }
    }

    boolean isValidOption(String string) {
        boolean bl = false;
        for (String string2 : validOptions) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void addVmAntiAffinityRule(String string, String string2, boolean bl, List<String> list) throws RemoteException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.serviceContent.getStorageResourceManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "StoragePod", new RetrieveOptions());
        ManagedObjectReference managedObjectReference2 = map.get(string);
        if (managedObjectReference2 != null) {
            ManagedObjectReference managedObjectReference3 = null;
            StorageDrsConfigSpec storageDrsConfigSpec = new StorageDrsConfigSpec();
            StorageDrsPodConfigSpec storageDrsPodConfigSpec = new StorageDrsPodConfigSpec();
            ClusterAntiAffinityRuleSpec clusterAntiAffinityRuleSpec = new ClusterAntiAffinityRuleSpec();
            ClusterRuleSpec clusterRuleSpec = new ClusterRuleSpec();
            clusterAntiAffinityRuleSpec.setName(string2);
            if (bl) {
                clusterAntiAffinityRuleSpec.setEnabled(Boolean.valueOf(true));
            } else {
                clusterAntiAffinityRuleSpec.setEnabled(Boolean.valueOf(false));
            }
            for (String string3 : list) {
                managedObjectReference3 = this.getMOREFs.vmByVMname(string3, this.propCollectorRef);
                if (managedObjectReference3 != null) {
                    clusterAntiAffinityRuleSpec.getVm().add(managedObjectReference3);
                    continue;
                }
                String string4 = "\nFailure: Virtual Machine " + string3 + " not found.";
                throw new RuntimeException(string4);
            }
            clusterAntiAffinityRuleSpec.setUserCreated(Boolean.valueOf(true));
            clusterAntiAffinityRuleSpec.setMandatory(Boolean.valueOf(false));
            clusterRuleSpec.setInfo((ClusterRuleInfo)clusterAntiAffinityRuleSpec);
            clusterRuleSpec.setOperation(ArrayUpdateOperation.ADD);
            storageDrsPodConfigSpec.getRule().add(clusterRuleSpec);
            storageDrsConfigSpec.setPodConfigSpec(storageDrsPodConfigSpec);
            ManagedObjectReference managedObjectReference4 = this.vimPort.configureStorageDrsForPodTask(managedObjectReference, managedObjectReference2, storageDrsConfigSpec, true);
            if (!this.getTaskResultAfterDone(managedObjectReference4)) {
                String string3;
                string3 = "\nFailure: Adding VmAntiAffinity Rule.";
                throw new RuntimeException(string3);
            }
        } else {
            String string5 = "\nFailure: StoragePod " + string + " not found.";
            throw new RuntimeException(string5);
        }
        System.out.printf("\nSuccess: Adding VmAntiAffinity Rule.", new Object[0]);
    }

    void addVmdkAntiAffinityRule(String string, String string2, boolean bl, String string3) throws RemoteException, SOAPException, RuntimeFaultFaultMsg, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.serviceContent.getStorageResourceManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "StoragePod", new RetrieveOptions());
        ManagedObjectReference managedObjectReference2 = map.get(string);
        if (managedObjectReference2 != null) {
            Object object;
            VirtualMachineConfigInfo virtualMachineConfigInfo;
            ManagedObjectReference managedObjectReference3 = null;
            StorageDrsConfigSpec storageDrsConfigSpec = new StorageDrsConfigSpec();
            StorageDrsVmConfigSpec storageDrsVmConfigSpec = new StorageDrsVmConfigSpec();
            StorageDrsVmConfigInfo storageDrsVmConfigInfo = new StorageDrsVmConfigInfo();
            VirtualDiskAntiAffinityRuleSpec virtualDiskAntiAffinityRuleSpec = new VirtualDiskAntiAffinityRuleSpec();
            virtualDiskAntiAffinityRuleSpec.setName(string2);
            if (bl) {
                virtualDiskAntiAffinityRuleSpec.setEnabled(Boolean.valueOf(true));
            } else {
                virtualDiskAntiAffinityRuleSpec.setEnabled(Boolean.valueOf(false));
            }
            managedObjectReference3 = this.getMOREFs.vmByVMname(string3, this.propCollectorRef);
            if (managedObjectReference3 != null) {
                virtualMachineConfigInfo = (VirtualMachineConfigInfo)this.getMOREFs.entityProps(managedObjectReference3, new String[]{"config"}).get("config");
                object = virtualMachineConfigInfo.getHardware().getDevice();
                ArrayList<VirtualDevice> arrayList = new ArrayList<VirtualDevice>();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    VirtualDevice virtualDevice = (VirtualDevice)iterator.next();
                    if (!virtualDevice.getClass().getSimpleName().equalsIgnoreCase("VirtualDisk")) continue;
                    arrayList.add(virtualDevice);
                    virtualDiskAntiAffinityRuleSpec.getDiskId().add(virtualDevice.getKey());
                }
                if (arrayList.size() < 2) {
                    throw new SOAPException("VM should have minimum of 2 virtual disks while adding VMDK AntiAffinity Rule.");
                }
                System.out.println("Adding below list of virtual disk to rule " + string2 + " :");
                for (VirtualDevice virtualDevice : arrayList) {
                    System.out.println("Virtual Disk : " + virtualDevice.getDeviceInfo().getLabel() + ", Key : " + virtualDevice.getKey());
                }
            } else {
                String string4 = "\nFailure: Virtual Machine " + string3 + " not found.";
                throw new RuntimeException(string4);
            }
            virtualDiskAntiAffinityRuleSpec.setUserCreated(Boolean.valueOf(true));
            virtualDiskAntiAffinityRuleSpec.setMandatory(Boolean.valueOf(false));
            storageDrsVmConfigInfo.setIntraVmAntiAffinity(virtualDiskAntiAffinityRuleSpec);
            storageDrsVmConfigInfo.setVm(managedObjectReference3);
            storageDrsVmConfigSpec.setInfo(storageDrsVmConfigInfo);
            storageDrsVmConfigSpec.setOperation(ArrayUpdateOperation.EDIT);
            storageDrsConfigSpec.getVmConfigSpec().add(storageDrsVmConfigSpec);
            virtualMachineConfigInfo = this.vimPort.configureStorageDrsForPodTask(managedObjectReference, managedObjectReference2, storageDrsConfigSpec, true);
            if (!this.getTaskResultAfterDone((ManagedObjectReference)virtualMachineConfigInfo)) {
                object = "\nFailure: Adding VmdkAntiAffinity Rule.";
                throw new RuntimeException((String)object);
            }
        } else {
            String string5 = "\nFailure: StoragePod " + string + " not found.";
            throw new RuntimeException(string5);
        }
        System.out.printf("\nSuccess: Adding VmdkAntiAffinity Rule.", new Object[0]);
    }

    void listRules(String string) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "StoragePod", new RetrieveOptions());
        ManagedObjectReference managedObjectReference = map.get(string);
        if (managedObjectReference != null) {
            Object object2;
            PodStorageDrsEntry podStorageDrsEntry = (PodStorageDrsEntry)this.getMOREFs.entityProps(managedObjectReference, new String[]{"podStorageDrsEntry"}).get("podStorageDrsEntry");
            System.out.println("\n List of VM anti-affinity rules: ");
            List list = podStorageDrsEntry.getStorageDrsConfig().getPodConfig().getRule();
            for (Object object2 : list) {
                System.out.println(object2.getName());
            }
            System.out.println("\n List of VMDK anti-affinity rules: ");
            List list2 = podStorageDrsEntry.getStorageDrsConfig().getVmConfig();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                StorageDrsVmConfigInfo storageDrsVmConfigInfo = (StorageDrsVmConfigInfo)object2.next();
                if (storageDrsVmConfigInfo.getIntraVmAntiAffinity() == null) continue;
                System.out.println(storageDrsVmConfigInfo.getIntraVmAntiAffinity().getName());
            }
        } else {
            String string2 = "\nFailure: StoragePod " + string + " not found.";
            throw new RuntimeException(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void modifyVmAntiAffinityRule(String string, String string2, String string3, Boolean bl, String string4) throws RemoteException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        Object object;
        ManagedObjectReference managedObjectReference = this.serviceContent.getStorageResourceManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "StoragePod", new RetrieveOptions());
        ManagedObjectReference managedObjectReference2 = map.get(string);
        if (managedObjectReference2 == null) {
            String string5 = "\nFailure: StoragePod " + string + " not found.";
            throw new RuntimeException(string5);
        }
        PodStorageDrsEntry podStorageDrsEntry = (PodStorageDrsEntry)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"podStorageDrsEntry"}).get("podStorageDrsEntry");
        ClusterRuleSpec clusterRuleSpec = new ClusterRuleSpec();
        List list = podStorageDrsEntry.getStorageDrsConfig().getPodConfig().getRule();
        ManagedObjectReference managedObjectReference3 = null;
        StorageDrsConfigSpec storageDrsConfigSpec = new StorageDrsConfigSpec();
        StorageDrsPodConfigSpec storageDrsPodConfigSpec = new StorageDrsPodConfigSpec();
        ClusterAntiAffinityRuleSpec clusterAntiAffinityRuleSpec = null;
        for (Object object2 : list) {
            if (!object2.getName().equalsIgnoreCase(string2)) continue;
            clusterAntiAffinityRuleSpec = (ClusterAntiAffinityRuleSpec)object2;
        }
        if (clusterAntiAffinityRuleSpec == null) {
            object = "\nFailure: Rule " + string2 + " not found.";
            throw new RuntimeException((String)object);
        }
        if (string3 != null) {
            clusterAntiAffinityRuleSpec.setName(string3);
        }
        if (bl != null) {
            if (bl.booleanValue()) {
                clusterAntiAffinityRuleSpec.setEnabled(Boolean.valueOf(true));
            } else {
                clusterAntiAffinityRuleSpec.setEnabled(Boolean.valueOf(false));
            }
        }
        if (string4 != null) {
            managedObjectReference3 = this.getMOREFs.vmByVMname(string4, this.propCollectorRef);
            if (managedObjectReference3 == null) {
                object = "\nFailure: Virtual Machine " + string4 + " not found.";
                throw new RuntimeException((String)object);
            }
            clusterAntiAffinityRuleSpec.getVm().add(managedObjectReference3);
        }
        clusterRuleSpec.setInfo(clusterAntiAffinityRuleSpec);
        clusterRuleSpec.setOperation(ArrayUpdateOperation.EDIT);
        storageDrsPodConfigSpec.getRule().add(clusterRuleSpec);
        storageDrsConfigSpec.setPodConfigSpec(storageDrsPodConfigSpec);
        object = this.vimPort.configureStorageDrsForPodTask(managedObjectReference, managedObjectReference2, storageDrsConfigSpec, true);
        if (!this.getTaskResultAfterDone((ManagedObjectReference)object)) {
            Object object2;
            object2 = "\nFailure: Modifying VmAntiAffinityRule.";
            throw new RuntimeException((String)object2);
        }
        System.out.printf("\nSuccess: Modifying VmAntiAffinityRule.", new Object[0]);
    }

    void modifyVmdkAntiAffinityRule(String string, String string2, String string3, Boolean bl) throws RemoteException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.serviceContent.getStorageResourceManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "StoragePod", new RetrieveOptions());
        ManagedObjectReference managedObjectReference2 = map.get(string);
        if (managedObjectReference2 != null) {
            Object object;
            PodStorageDrsEntry podStorageDrsEntry = (PodStorageDrsEntry)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"podStorageDrsEntry"}).get("podStorageDrsEntry");
            StorageDrsVmConfigInfo storageDrsVmConfigInfo = null;
            StorageDrsConfigSpec storageDrsConfigSpec = new StorageDrsConfigSpec();
            StorageDrsVmConfigSpec storageDrsVmConfigSpec = new StorageDrsVmConfigSpec();
            List list = podStorageDrsEntry.getStorageDrsConfig().getVmConfig();
            for (Object object2 : list) {
                if (object2.getIntraVmAntiAffinity() == null || !object2.getIntraVmAntiAffinity().getName().equalsIgnoreCase(string2)) continue;
                storageDrsVmConfigInfo = object2;
            }
            if (storageDrsVmConfigInfo != null) {
                if (string3 != null) {
                    storageDrsVmConfigInfo.getIntraVmAntiAffinity().setName(string3);
                }
                if (bl != null) {
                    if (bl.booleanValue()) {
                        storageDrsVmConfigInfo.getIntraVmAntiAffinity().setEnabled(Boolean.valueOf(true));
                    } else {
                        storageDrsVmConfigInfo.getIntraVmAntiAffinity().setEnabled(Boolean.valueOf(false));
                    }
                }
            } else {
                object = "\nFailure: Rule " + string2 + " not found.";
                throw new RuntimeException((String)object);
            }
            storageDrsVmConfigSpec.setInfo(storageDrsVmConfigInfo);
            storageDrsVmConfigSpec.setOperation(ArrayUpdateOperation.EDIT);
            storageDrsConfigSpec.getVmConfigSpec().add(storageDrsVmConfigSpec);
            object = this.vimPort.configureStorageDrsForPodTask(managedObjectReference, managedObjectReference2, storageDrsConfigSpec, true);
            if (!this.getTaskResultAfterDone((ManagedObjectReference)object)) {
                Object object2;
                object2 = "\nFailure: Modifying VmdkAntiAffinityRule.";
                throw new RuntimeException((String)object2);
            }
        } else {
            String string4 = "\nFailure: StoragePod " + string + " not found.";
            throw new RuntimeException(string4);
        }
        System.out.printf("\nSuccess: Modifying VmdkAntiAffinityRule.", new Object[0]);
    }

    void deleteVmAntiAffinityRule(String string, String string2) throws RemoteException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.serviceContent.getStorageResourceManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "StoragePod", new RetrieveOptions());
        ManagedObjectReference managedObjectReference2 = map.get(string);
        if (managedObjectReference2 != null) {
            Object object;
            PodStorageDrsEntry podStorageDrsEntry = (PodStorageDrsEntry)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"podStorageDrsEntry"}).get("podStorageDrsEntry");
            ClusterRuleSpec clusterRuleSpec = new ClusterRuleSpec();
            List list = podStorageDrsEntry.getStorageDrsConfig().getPodConfig().getRule();
            StorageDrsConfigSpec storageDrsConfigSpec = new StorageDrsConfigSpec();
            StorageDrsPodConfigSpec storageDrsPodConfigSpec = new StorageDrsPodConfigSpec();
            ClusterAntiAffinityRuleSpec clusterAntiAffinityRuleSpec = null;
            for (Object object2 : list) {
                if (!object2.getName().equalsIgnoreCase(string2)) continue;
                clusterAntiAffinityRuleSpec = (ClusterAntiAffinityRuleSpec)object2;
            }
            if (clusterAntiAffinityRuleSpec == null) {
                object = "\nFailure: Rule " + string2 + " not found.";
                throw new RuntimeException((String)object);
            }
            clusterRuleSpec.setInfo(clusterAntiAffinityRuleSpec);
            clusterRuleSpec.setOperation(ArrayUpdateOperation.REMOVE);
            clusterRuleSpec.setRemoveKey((Object)clusterAntiAffinityRuleSpec.getKey());
            storageDrsPodConfigSpec.getRule().add(clusterRuleSpec);
            storageDrsConfigSpec.setPodConfigSpec(storageDrsPodConfigSpec);
            object = this.vimPort.configureStorageDrsForPodTask(managedObjectReference, managedObjectReference2, storageDrsConfigSpec, true);
            if (!this.getTaskResultAfterDone((ManagedObjectReference)object)) {
                Object object2;
                object2 = "\nFailure: Deleting VmAntiAffinity Rule.";
                throw new RuntimeException((String)object2);
            }
        } else {
            String string3 = "\nFailure: StoragePod " + string + " not found.";
            throw new RuntimeException(string3);
        }
        System.out.printf("\nSuccess: Deleting VmAntiAffinity Rule.", new Object[0]);
    }

    void deleteVmdkAntiAffinityRule(String string, String string2) throws RemoteException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.serviceContent.getStorageResourceManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "StoragePod", new RetrieveOptions());
        ManagedObjectReference managedObjectReference2 = map.get(string);
        if (managedObjectReference2 != null) {
            Object object;
            PodStorageDrsEntry podStorageDrsEntry = (PodStorageDrsEntry)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"podStorageDrsEntry"}).get("podStorageDrsEntry");
            StorageDrsVmConfigInfo storageDrsVmConfigInfo = null;
            StorageDrsConfigSpec storageDrsConfigSpec = new StorageDrsConfigSpec();
            StorageDrsVmConfigSpec storageDrsVmConfigSpec = new StorageDrsVmConfigSpec();
            List list = podStorageDrsEntry.getStorageDrsConfig().getVmConfig();
            for (Object object2 : list) {
                if (object2.getIntraVmAntiAffinity() == null || !object2.getIntraVmAntiAffinity().getName().equalsIgnoreCase(string2)) continue;
                storageDrsVmConfigInfo = object2;
            }
            if (storageDrsVmConfigInfo == null) {
                object = "\nFailure: Rule " + string2 + " not found.";
                throw new RuntimeException((String)object);
            }
            storageDrsVmConfigInfo.setIntraVmAntiAffinity(null);
            storageDrsVmConfigSpec.setInfo(storageDrsVmConfigInfo);
            storageDrsVmConfigSpec.setOperation(ArrayUpdateOperation.EDIT);
            storageDrsConfigSpec.getVmConfigSpec().add(storageDrsVmConfigSpec);
            object = this.vimPort.configureStorageDrsForPodTask(managedObjectReference, managedObjectReference2, storageDrsConfigSpec, true);
            if (!this.getTaskResultAfterDone((ManagedObjectReference)object)) {
                Object object2;
                object2 = "\nFailure: Deleting VmdkAntiAffinity Rule.";
                throw new RuntimeException((String)object2);
            }
        } else {
            String string3 = "\nFailure: StoragePod " + string + " not found.";
            throw new RuntimeException(string3);
        }
        System.out.printf("\nSuccess: Deleting VmdkAntiAffinity Rule.", new Object[0]);
    }

    @Action
    public void run() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, RemoteException, SOAPException {
        this.validate();
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        if (this.option.equalsIgnoreCase("list")) {
            this.listRules(this.storagePodName);
        } else if (this.option.equalsIgnoreCase("addVmAntiAffinity")) {
            this.addVmAntiAffinityRule(this.storagePodName, this.ruleName, this.enabled, this.vm);
        } else if (this.option.equalsIgnoreCase("addVmdkAntiAffinity")) {
            this.addVmdkAntiAffinityRule(this.storagePodName, this.ruleName, this.enabled, this.vmName);
        } else if (this.option.equalsIgnoreCase("modifyVmAntiAffinity")) {
            this.modifyVmAntiAffinityRule(this.storagePodName, this.ruleName, this.newRuleName, this.enabled, this.vmName);
        } else if (this.option.equalsIgnoreCase("modifyVmdkAntiAffinity")) {
            this.modifyVmdkAntiAffinityRule(this.storagePodName, this.ruleName, this.newRuleName, this.enabled);
        } else if (this.option.equalsIgnoreCase("deleteVmAntiAffinity")) {
            this.deleteVmAntiAffinityRule(this.storagePodName, this.ruleName);
        } else if (this.option.equalsIgnoreCase("deleteVmdkAntiAffinity")) {
            this.deleteVmdkAntiAffinityRule(this.storagePodName, this.ruleName);
        }
    }
}

