/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapp;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.HttpNfcLeaseDeviceUrl;
import com.vmware.vim25.HttpNfcLeaseInfo;
import com.vmware.vim25.HttpNfcLeaseState;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.VimPortType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

@Sample(name="ovf-manager-export-vmdk", description="This is a demonstrates OVFManager.Exports VMDK's of a VM to the localSystem.")
public class OVFManagerExportVMDK
extends ConnectedVimServiceBase {
    volatile long TOTAL_BYTES = 0L;
    HttpNfcLeaseExtender leaseExtender;
    volatile long TOTAL_BYTES_WRITTEN = 0L;
    boolean vmdkFlag = false;
    String vmname = null;
    String host = null;
    String localPath = null;

    @Option(name="vmname", description="Name of the virtual machine")
    public void setVmname(String string) {
        this.vmname = string;
    }

    @Option(name="host", description="")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="localpath", description="Absolute path of localSystem folder")
    public void setLocalPath(String string) {
        this.localPath = string;
    }

    void exportVM() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        File file = new File(this.localPath);
        if (!file.exists()) {
            System.out.println("Wrong or invalid path " + this.localPath);
            return;
        }
        ManagedObjectReference managedObjectReference = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem").get(this.host);
        if (managedObjectReference == null) {
            throw new RuntimeException(" Source Host " + this.host + " Not Found.");
        }
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.inFolderByType(managedObjectReference, "VirtualMachine").get(this.vmname);
        if (managedObjectReference2 == null) {
            throw new RuntimeException("Virtual Machine " + this.vmname + " Not Found.");
        }
        System.out.println("Getting the HTTP NFCLEASE for the VM: " + this.vmname);
        try {
            ManagedObjectReference managedObjectReference3 = this.vimPort.exportVm(managedObjectReference2);
            Object[] objectArray = this.waitForValues.wait(managedObjectReference3, new String[]{"state"}, new String[]{"state"}, new Object[][]{{HttpNfcLeaseState.READY, HttpNfcLeaseState.ERROR}});
            if (objectArray[0].equals(HttpNfcLeaseState.READY)) {
                long l;
                System.out.println("HttpNfcLeaseState: " + objectArray[0]);
                HttpNfcLeaseInfo httpNfcLeaseInfo = (HttpNfcLeaseInfo)this.getMOREFs.entityProps(managedObjectReference3, new String[]{"info"}).get("info");
                httpNfcLeaseInfo.setLeaseTimeout(300000000);
                this.printHttpNfcLeaseInfo(httpNfcLeaseInfo, this.host);
                this.TOTAL_BYTES = l = httpNfcLeaseInfo.getTotalDiskCapacityInKB() * 1024L;
                this.leaseExtender = new OVFManagerExportVMDK().new HttpNfcLeaseExtender(managedObjectReference3, this.vimPort);
                Thread thread = new Thread(this.leaseExtender);
                thread.start();
                List list = httpNfcLeaseInfo.getDeviceUrl();
                for (HttpNfcLeaseDeviceUrl httpNfcLeaseDeviceUrl : list) {
                    System.out.println("Downloading Files:");
                    String string = httpNfcLeaseDeviceUrl.getUrl();
                    String string2 = string.substring(string.lastIndexOf("/") + 1);
                    System.out.println("Absolute File Name: " + string2);
                    System.out.println("VMDK URL: " + string.replace("*", this.host));
                    this.writeVMDKFile(string2, string.replace("*", this.host), l, this.vmname);
                }
                System.out.println("Completed Downloading the files");
                this.vmdkFlag = true;
                thread.interrupt();
                this.vimPort.httpNfcLeaseProgress(managedObjectReference3, 100);
                this.vimPort.httpNfcLeaseComplete(managedObjectReference3);
            } else {
                System.out.println("HttpNfcLeaseState not ready");
                for (Object object : objectArray) {
                    System.out.println("HttpNfcLeaseState: " + object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void printHttpNfcLeaseInfo(HttpNfcLeaseInfo httpNfcLeaseInfo, String string) {
        System.out.println("########################################################");
        System.out.println("HttpNfcLeaseInfo");
        System.out.println("Lease Timeout: " + httpNfcLeaseInfo.getLeaseTimeout());
        System.out.println("Total Disk capacity: " + httpNfcLeaseInfo.getTotalDiskCapacityInKB());
        List list = httpNfcLeaseInfo.getDeviceUrl();
        int n = 1;
        for (HttpNfcLeaseDeviceUrl httpNfcLeaseDeviceUrl : list) {
            System.out.println("HttpNfcLeaseDeviceUrl : " + n++);
            System.out.println("   Device URL Import Key: " + httpNfcLeaseDeviceUrl.getImportKey());
            System.out.println("   Device URL Key: " + httpNfcLeaseDeviceUrl.getKey());
            System.out.println("   Device URL : " + httpNfcLeaseDeviceUrl.getUrl());
            System.out.println("   Updated device URL: " + httpNfcLeaseDeviceUrl.getUrl().replace("*", string));
            System.out.println("   SSL Thumbprint : " + httpNfcLeaseDeviceUrl.getSslThumbprint());
        }
        System.out.println("########################################################");
    }

    void writeVMDKFile(String string, String string2, long l, String string3) throws IOException {
        HttpURLConnection httpURLConnection = this.getHTTPConnection(string2);
        InputStream inputStream = httpURLConnection.getInputStream();
        String string4 = this.localPath + "/" + string3 + "-" + string;
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string4));
        byte[] byArray = new byte[102400];
        int n = 0;
        long l2 = 0L;
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            l2 += (long)n;
        }
        System.out.println("Exported File " + string3 + "-" + string + " : " + l2);
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    HttpURLConnection getHTTPConnection(String string) throws IOException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setAllowUserInteraction(true);
        httpURLConnection.connect();
        return httpURLConnection;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.exportVM();
    }

    public class HttpNfcLeaseExtender
    implements Runnable {
        private ManagedObjectReference httpNfcLease = null;
        private VimPortType vimPort = null;

        public HttpNfcLeaseExtender(ManagedObjectReference managedObjectReference, VimPortType vimPortType) {
            this.httpNfcLease = managedObjectReference;
            this.vimPort = vimPortType;
        }

        @Override
        public void run() {
            try {
                System.out.println("---------------------- Thread for Checking the HTTP NFCLEASE vmdkFlag: " + OVFManagerExportVMDK.this.vmdkFlag + "----------------------");
                while (!OVFManagerExportVMDK.this.vmdkFlag) {
                    System.out.println("#### TOTAL_BYTES_WRITTEN " + OVFManagerExportVMDK.this.TOTAL_BYTES_WRITTEN);
                    System.out.println("#### TOTAL_BYTES " + OVFManagerExportVMDK.this.TOTAL_BYTES);
                    try {
                        this.vimPort.httpNfcLeaseProgress(this.httpNfcLease, 0);
                        Thread.sleep(290000000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("---------------------- Thread interrupted ----------------------");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

