/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.ConfigTarget;
import com.vmware.vim25.CustomizationFaultFaultMsg;
import com.vmware.vim25.DistributedVirtualSwitchPortConnection;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFaultFaultMsg;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.OpaqueNetworkSummary;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualEthernetCard;
import com.vmware.vim25.VirtualEthernetCardDistributedVirtualPortBackingInfo;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim25.VirtualEthernetCardOpaqueNetworkBackingInfo;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineCloneSpecTpmProvisionPolicy;
import com.vmware.vim25.VirtualMachineNetworkInfo;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualPCNet32;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Sample(name="vm-clone", description="This sample makes a template of an existing VM and deploy multiple instances of this template onto a datacenter")
public class VMClone
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private String dataCenterName;
    private String vmPathName;
    private String cloneName;
    private String targetNetworkName;
    private String hostName;

    @Option(name="datacentername", description="name of Datacenter")
    public void setDataCenterName(String string) {
        this.dataCenterName = string;
    }

    @Option(name="vmpath", description="inventory path of the VM")
    public void setVmPathName(String string) {
        this.vmPathName = string;
    }

    @Option(name="clonename", description="name of the clone")
    public void setCloneName(String string) {
        this.cloneName = string;
    }

    @Option(name="hostname", required=false, description="name of target host")
    public void setHostName(String string) {
        this.hostName = string;
    }

    @Option(name="targetnetworkname", required=false, description="name of the target network Options: Standard|Distributed|Opaque Network")
    public void setTargetNetworkName(String string) {
        this.targetNetworkName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    ConfigTarget getConfigTargetForHost(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference2;
        ConfigTarget configTarget;
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference, new String[]{"parent"}).get("parent");
        if (managedObjectReference3 == null) {
            System.out.println("No Compute Resource Found On Specified Host");
        }
        if ((configTarget = this.vimPort.queryConfigTarget(managedObjectReference2 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference3, new String[]{"environmentBrowser"}).get("environmentBrowser"), managedObjectReference)) == null) {
            throw new RuntimeException("No ConfigTarget found in ComputeResource");
        }
        return configTarget;
    }

    public HashMap<String, VirtualDeviceBackingInfo> getAvailableHostNetworkDevice(ConfigTarget configTarget) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        VirtualEthernetCardNetworkBackingInfo virtualEthernetCardNetworkBackingInfo;
        HashMap<String, VirtualDeviceBackingInfo> hashMap = new HashMap<String, VirtualDeviceBackingInfo>();
        for (VirtualMachineNetworkInfo virtualMachineNetworkInfo : configTarget.getNetwork()) {
            virtualEthernetCardNetworkBackingInfo = new VirtualEthernetCardNetworkBackingInfo();
            virtualEthernetCardNetworkBackingInfo.setDeviceName(virtualMachineNetworkInfo.getNetwork().getName());
            hashMap.put(virtualMachineNetworkInfo.getNetwork().getName(), (VirtualDeviceBackingInfo)virtualEthernetCardNetworkBackingInfo);
        }
        for (VirtualMachineNetworkInfo virtualMachineNetworkInfo : configTarget.getDistributedVirtualPortgroup()) {
            virtualEthernetCardNetworkBackingInfo = new VirtualEthernetCardDistributedVirtualPortBackingInfo();
            virtualEthernetCardNetworkBackingInfo.setPort(new DistributedVirtualSwitchPortConnection());
            virtualEthernetCardNetworkBackingInfo.getPort().setPortgroupKey(virtualMachineNetworkInfo.getPortgroupKey());
            virtualEthernetCardNetworkBackingInfo.getPort().setSwitchUuid(virtualMachineNetworkInfo.getSwitchUuid());
            hashMap.put(virtualMachineNetworkInfo.getPortgroupName(), (VirtualDeviceBackingInfo)virtualEthernetCardNetworkBackingInfo);
        }
        for (VirtualMachineNetworkInfo virtualMachineNetworkInfo : configTarget.getOpaqueNetwork()) {
            virtualEthernetCardNetworkBackingInfo = (OpaqueNetworkSummary)this.getMOREFs.entityProps(virtualMachineNetworkInfo.getNetwork().getNetwork(), new String[]{"summary"}).get("summary");
            VirtualEthernetCardOpaqueNetworkBackingInfo virtualEthernetCardOpaqueNetworkBackingInfo = new VirtualEthernetCardOpaqueNetworkBackingInfo();
            virtualEthernetCardOpaqueNetworkBackingInfo.setOpaqueNetworkId(virtualEthernetCardNetworkBackingInfo.getOpaqueNetworkId());
            virtualEthernetCardOpaqueNetworkBackingInfo.setOpaqueNetworkType(virtualEthernetCardNetworkBackingInfo.getOpaqueNetworkType());
            hashMap.put(virtualMachineNetworkInfo.getNetwork().getName(), (VirtualDeviceBackingInfo)virtualEthernetCardOpaqueNetworkBackingInfo);
        }
        return hashMap;
    }

    VirtualDeviceConfigSpec changeVmNicSpec(ManagedObjectReference managedObjectReference, String string, ManagedObjectReference managedObjectReference2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List list = null;
        list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(managedObjectReference, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        VirtualPCNet32 virtualPCNet32 = new VirtualPCNet32();
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        ConfigTarget configTarget = this.getConfigTargetForHost(managedObjectReference2);
        HashMap<String, VirtualDeviceBackingInfo> hashMap = this.getAvailableHostNetworkDevice(configTarget);
        if (hashMap.containsKey(string)) {
            for (VirtualDevice virtualDevice : list) {
                if (!virtualDevice.getDeviceInfo().getLabel().contains("Network adapter")) continue;
                virtualPCNet32 = (VirtualEthernetCard)virtualDevice;
                virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.EDIT);
                virtualPCNet32.setBacking(hashMap.get(string));
                virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualPCNet32);
            }
        }
        return virtualDeviceConfigSpec;
    }

    void cloneVM() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, CustomizationFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, MigrationFaultFaultMsg, InvalidStateFaultMsg, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ManagedObjectReference managedObjectReference;
        ManagedObjectReference managedObjectReference2 = this.vimPort.findByInventoryPath(this.serviceContent.getSearchIndex(), this.dataCenterName);
        if (managedObjectReference2 == null) {
            System.out.printf("The specified datacenter [ %s ]is not found %n", this.dataCenterName);
            return;
        }
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getDynamicProperty(managedObjectReference2, "vmFolder");
        if (managedObjectReference3 == null) {
            System.out.println("The virtual machine is not found");
            return;
        }
        ManagedObjectReference managedObjectReference4 = this.vimPort.findByInventoryPath(this.serviceContent.getSearchIndex(), this.vmPathName);
        if (managedObjectReference4 == null) {
            System.out.printf("The VMPath specified [ %s ] is not found %n", this.vmPathName);
            return;
        }
        VirtualMachineCloneSpec virtualMachineCloneSpec = new VirtualMachineCloneSpec();
        VirtualMachineRelocateSpec virtualMachineRelocateSpec = new VirtualMachineRelocateSpec();
        if (this.targetNetworkName != null && this.hostName != null) {
            managedObjectReference = this.getMOREFs.inContainerByType(managedObjectReference2, "HostSystem").get(this.hostName);
            if (managedObjectReference == null) {
                System.out.println("Host " + this.hostName + " not found");
                return;
            }
            VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
            virtualDeviceConfigSpec = this.changeVmNicSpec(managedObjectReference4, this.targetNetworkName, managedObjectReference);
            virtualMachineRelocateSpec.getDeviceChange().add(virtualDeviceConfigSpec);
        }
        virtualMachineCloneSpec.setLocation(virtualMachineRelocateSpec);
        virtualMachineCloneSpec.setPowerOn(false);
        virtualMachineCloneSpec.setTemplate(false);
        virtualMachineCloneSpec.setTpmProvisionPolicy(VirtualMachineCloneSpecTpmProvisionPolicy.REPLACE.value());
        System.out.printf("Cloning Virtual Machine [%s] to clone name [%s] %n", this.vmPathName.substring(this.vmPathName.lastIndexOf("/") + 1), this.cloneName);
        managedObjectReference = this.vimPort.cloneVMTask(managedObjectReference4, managedObjectReference3, this.cloneName, virtualMachineCloneSpec);
        if (this.getTaskResultAfterDone(managedObjectReference)) {
            System.out.printf("Successfully cloned Virtual Machine [%s] to clone name [%s] %n", this.vmPathName.substring(this.vmPathName.lastIndexOf("/") + 1), this.cloneName);
        } else {
            System.out.printf("Failure Cloning Virtual Machine [%s] to clone name [%s] %n", this.vmPathName.substring(this.vmPathName.lastIndexOf("/") + 1), this.cloneName);
        }
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    Object getDynamicProperty(ManagedObjectReference managedObjectReference, String string) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List list;
        ObjectContent[] objectContentArray = this.getObjectProperties(managedObjectReference, new String[]{string});
        Object object = null;
        if (objectContentArray != null && (list = objectContentArray[0].getPropSet()) != null) {
            Object object2 = ((DynamicProperty)list.get(0)).getVal();
            String string2 = object2.getClass().getName();
            if (string2.indexOf("ArrayOf") != -1) {
                String string3 = string2.substring(string2.indexOf("ArrayOf") + "ArrayOf".length(), string2.length());
                string3 = this.methodExists(object2, "get" + string3, null) ? "get" + string3 : "get_" + string3.toLowerCase();
                Method method = object2.getClass().getDeclaredMethod(string3, null);
                object = method.invoke(object2, (Object[])null);
            } else {
                object = object2.getClass().isArray() ? object2 : object2;
            }
        }
        return object;
    }

    ObjectContent[] getObjectProperties(ManagedObjectReference managedObjectReference, String[] stringArray) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        if (managedObjectReference == null) {
            return null;
        }
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(new PropertySpec());
        if (stringArray == null || stringArray.length == 0) {
            ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).setAll(Boolean.TRUE);
        } else {
            ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).setAll(Boolean.FALSE);
        }
        ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).setType(managedObjectReference.getType());
        ((PropertySpec)propertyFilterSpec.getPropSet().get(0)).getPathSet().addAll(Arrays.asList(stringArray));
        propertyFilterSpec.getObjectSet().add(new ObjectSpec());
        ((ObjectSpec)propertyFilterSpec.getObjectSet().get(0)).setObj(managedObjectReference);
        ((ObjectSpec)propertyFilterSpec.getObjectSet().get(0)).setSkip(Boolean.FALSE);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        return list.toArray(new ObjectContent[list.size()]);
    }

    boolean methodExists(Object object, String string, Class[] classArray) throws NoSuchMethodException {
        boolean bl = false;
        Method method = object.getClass().getMethod(string, classArray);
        if (method != null) {
            bl = true;
        }
        return bl;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, NoSuchMethodException, MigrationFaultFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, IllegalAccessException, CustomizationFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvocationTargetException, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.cloneVM();
    }
}

