/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Sample(name="vm-power-ops", description="Demonstrates VirtualMachine Power operations on multiple Virtual Machines. Works with groups of Virtual Machines all at one time. You must specify one of --vmname or --datacentername or --hostname or --all all Virtual Machines that match these criteria will have the power operation issued to them. For example to power off all the virtual machines visible use the options  --operation poweroff --all true together and all virtual machines will be turned off.")
public class VMPowerOps
extends ConnectedVimServiceBase {
    String vmName = null;
    String operation = null;
    String datacenter = null;
    String guestId = null;
    String host = null;
    Boolean all = false;

    @Option(name="operation", description="type of the operation\n[poweron | poweroff | reset | suspend | reboot | shutdown | standby]")
    public void setOperation(String string) {
        this.operation = string;
    }

    @Option(name="datacentername", required=false, description="name of the datacenter. use this option to send power operations to all the virtual machines in an entire data center.")
    public void setDatacenter(String string) {
        this.datacenter = string;
    }

    @Option(name="guestid", required=false, description="guest id of the vm. use this option to send power operations to a single guest.")
    public void setGuestId(String string) {
        this.guestId = string;
    }

    @Option(name="hostname", required=false, description="name of the host. use this option to send power operations to all the virtual machines on a single host.")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="vmname", required=false, description="name of the virtual machine. Use this option to send power operations to only this virtual machine.")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="all", required=false, description="set to true to send power operation to all virtual machines that can be found. overrides all other options.")
    public void setAll(Boolean bl) {
        this.all = bl;
    }

    void validate() throws IllegalArgumentException {
        if (this.all.booleanValue() && (this.vmName != null || this.datacenter != null || this.guestId != null || this.host != null)) {
            System.out.println("Did you really mean all? Use '--all true' by itself not with --vmname or --datacentername or --guestid or --hostname");
            throw new IllegalArgumentException("--all true occurred in conjunction with other options");
        }
        if (!(this.operation.equalsIgnoreCase("poweron") || this.operation.equalsIgnoreCase("poweroff") || this.operation.equalsIgnoreCase("reset") || this.operation.equalsIgnoreCase("standby") || this.operation.equalsIgnoreCase("shutdown") || this.operation.equalsIgnoreCase("reboot") || this.operation.equalsIgnoreCase("suspend"))) {
            System.out.println("Invalid Operation name ' " + this.operation + "' valid operations are poweron, standby, poweroff, standby, reboot, shutdown, suspend");
            throw new IllegalArgumentException("Invalid Operation Type Or Name");
        }
    }

    Map<String, ManagedObjectReference> getMOREFsInContainerByType(ManagedObjectReference managedObjectReference, String string) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        String string2 = "name";
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getViewManager();
        ManagedObjectReference managedObjectReference3 = this.vimPort.createContainerView(managedObjectReference2, managedObjectReference, Arrays.asList(string), true);
        HashMap<String, ManagedObjectReference> hashMap = new HashMap<String, ManagedObjectReference>();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType(string);
        propertySpec.getPathSet().add(string2);
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("view");
        traversalSpec.setPath("view");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.setType("ContainerView");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference3);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.serviceContent.getPropertyCollector(), arrayList, new RetrieveOptions());
        ArrayList arrayList2 = new ArrayList();
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList2.addAll(retrieveResult.getObjects());
        }
        String string3 = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string3 = retrieveResult.getToken();
        }
        while (string3 != null && !string3.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.serviceContent.getPropertyCollector(), string3);
            string3 = null;
            if (retrieveResult == null) continue;
            string3 = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList2.addAll(retrieveResult.getObjects());
        }
        for (ObjectContent objectContent : arrayList2) {
            ManagedObjectReference managedObjectReference4 = objectContent.getObj();
            String string4 = null;
            List list = objectContent.getPropSet();
            if (list != null) {
                for (DynamicProperty dynamicProperty : list) {
                    string4 = (String)dynamicProperty.getVal();
                }
            }
            hashMap.put(string4, managedObjectReference4);
        }
        return hashMap;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    Map<String, ManagedObjectReference> getVms() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        Object object;
        ManagedObjectReference managedObjectReference;
        ManagedObjectReference managedObjectReference2 = new HashMap();
        ManagedObjectReference managedObjectReference3 = this.serviceContent.getRootFolder();
        if (this.datacenter != null) {
            managedObjectReference = this.getMOREFs.inContainerByType(managedObjectReference3, "Datacenter");
            System.out.println("Number of datacenters found: " + managedObjectReference.size());
            object = (ManagedObjectReference)managedObjectReference.get(this.datacenter);
            if (object == null) {
                System.out.println("No datacenter by the name " + this.datacenter + " found!");
            }
            managedObjectReference3 = object;
        }
        if (this.host != null) {
            managedObjectReference = this.getMOREFs.inContainerByType(managedObjectReference3, "HostSystem").get(this.host);
            if (managedObjectReference == null) {
                System.out.println("No host by the name " + this.host + " found!");
                return managedObjectReference2;
            }
            managedObjectReference3 = managedObjectReference;
        }
        managedObjectReference = this.getMOREFs.inContainerByType(managedObjectReference3, "VirtualMachine");
        if (this.vmName != null) {
            if (!managedObjectReference.containsKey(this.vmName)) {
                throw new IllegalStateException("No VM by the name of '" + this.vmName + "' found!");
            }
            managedObjectReference2.put(this.vmName, (ManagedObjectReference)managedObjectReference.get(this.vmName));
            return managedObjectReference2;
        }
        if (this.guestId != null) {
            object = this.getMOREFs.entityProps(new ArrayList<ManagedObjectReference>(managedObjectReference.values()), new String[]{"summary.config.guestId", "name"});
            for (ManagedObjectReference managedObjectReference4 : object.keySet()) {
                if (!this.guestId.equalsIgnoreCase((String)((Map)object.get(managedObjectReference4)).get("summary.config.guestId"))) continue;
                managedObjectReference2.put((String)((Map)object.get(managedObjectReference4)).get("name"), managedObjectReference4);
            }
            return managedObjectReference2;
        }
        managedObjectReference2 = managedObjectReference;
        return managedObjectReference2;
    }

    void runOperation() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        Map<String, ManagedObjectReference> map = this.getVms();
        if (map == null || map.isEmpty()) {
            System.out.println("No Virtual Machine found matching the specified criteria");
            return;
        }
        if (this.operation.equalsIgnoreCase("poweron")) {
            this.powerOnVM(map);
        } else if (this.operation.equalsIgnoreCase("poweroff")) {
            this.powerOffVM(map);
        } else if (this.operation.equalsIgnoreCase("reset")) {
            this.resetVM(map);
        } else if (this.operation.equalsIgnoreCase("suspend")) {
            this.suspendVM(map);
        } else if (this.operation.equalsIgnoreCase("reboot")) {
            this.rebootVM(map);
        } else if (this.operation.equalsIgnoreCase("shutdown")) {
            this.shutdownVM(map);
        } else if (this.operation.equalsIgnoreCase("standby")) {
            this.standbyVM(map);
        }
    }

    void powerOnVM(Map<String, ManagedObjectReference> map) {
        for (String string : map.keySet()) {
            ManagedObjectReference managedObjectReference = map.get(string);
            try {
                System.out.println("Powering on virtual machine : " + string + "[" + managedObjectReference.getValue() + "]");
                ManagedObjectReference managedObjectReference2 = this.vimPort.powerOnVMTask(managedObjectReference, null);
                if (!this.getTaskResultAfterDone(managedObjectReference2)) continue;
                System.out.println(string + "[" + managedObjectReference.getValue() + "] powered on successfully");
            }
            catch (Exception exception) {
                System.out.println("Unable to poweron vm : " + string + "[" + managedObjectReference.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    void powerOffVM(Map<String, ManagedObjectReference> map) {
        for (String string : map.keySet()) {
            ManagedObjectReference managedObjectReference = map.get(string);
            try {
                System.out.println("Powering off virtual machine : " + string + "[" + managedObjectReference.getValue() + "]");
                ManagedObjectReference managedObjectReference2 = this.vimPort.powerOffVMTask(managedObjectReference);
                if (!this.getTaskResultAfterDone(managedObjectReference2)) continue;
                System.out.println(string + "[" + managedObjectReference.getValue() + "] powered off successfully");
            }
            catch (Exception exception) {
                System.out.println("Unable to poweroff vm : " + string + "[" + managedObjectReference.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    void resetVM(Map<String, ManagedObjectReference> map) {
        for (String string : map.keySet()) {
            ManagedObjectReference managedObjectReference = map.get(string);
            try {
                System.out.println("Reseting virtual machine : " + string + "[" + managedObjectReference.getValue() + "]");
                ManagedObjectReference managedObjectReference2 = this.vimPort.resetVMTask(managedObjectReference);
                if (!this.getTaskResultAfterDone(managedObjectReference2)) continue;
                System.out.println(string + "[" + managedObjectReference.getValue() + "] reset successfully");
            }
            catch (Exception exception) {
                System.out.println("Unable to reset vm : " + string + "[" + managedObjectReference.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    void suspendVM(Map<String, ManagedObjectReference> map) {
        for (String string : map.keySet()) {
            ManagedObjectReference managedObjectReference = map.get(string);
            try {
                System.out.println("Suspending virtual machine : " + string + "[" + managedObjectReference.getValue() + "]");
                ManagedObjectReference managedObjectReference2 = this.vimPort.suspendVMTask(managedObjectReference);
                if (!this.getTaskResultAfterDone(managedObjectReference2)) continue;
                System.out.println(string + "[" + managedObjectReference.getValue() + "] suspended successfully");
            }
            catch (Exception exception) {
                System.out.println("Unable to suspend vm : " + string + "[" + managedObjectReference.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    void rebootVM(Map<String, ManagedObjectReference> map) {
        for (String string : map.keySet()) {
            ManagedObjectReference managedObjectReference = map.get(string);
            try {
                System.out.println("Rebooting guest os in virtual machine : " + string + "[" + managedObjectReference.getValue() + "]");
                this.vimPort.rebootGuest(managedObjectReference);
                System.out.println("Guest os in vm : " + string + "[" + managedObjectReference.getValue() + "] rebooted");
            }
            catch (Exception exception) {
                System.out.println("Unable to reboot guest os in vm : " + string + "[" + managedObjectReference.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    void shutdownVM(Map<String, ManagedObjectReference> map) {
        for (String string : map.keySet()) {
            ManagedObjectReference managedObjectReference = map.get(string);
            try {
                System.out.println("Shutting down guest os in virtual machine : " + string + "[" + managedObjectReference.getValue() + "]");
                this.vimPort.shutdownGuest(managedObjectReference);
                System.out.println("Guest os in vm : " + string + "[" + managedObjectReference.getValue() + "] shutdown");
            }
            catch (Exception exception) {
                System.out.println("Unable to shutdown guest os in vm : " + string + "[" + managedObjectReference.getValue() + "]");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    void standbyVM(Map<String, ManagedObjectReference> map) {
        for (String string : map.keySet()) {
            ManagedObjectReference managedObjectReference = map.get(string);
            try {
                System.out.println("Putting the guest os in virtual machine : " + string + "[" + managedObjectReference.getValue() + "] in standby mode");
                this.vimPort.standbyGuest(managedObjectReference);
                System.out.println("Guest os in vm : " + string + "[" + managedObjectReference.getValue() + "] in standby mode");
            }
            catch (Exception exception) {
                System.out.println("Unable to put the guest os in vm : " + string + "[" + managedObjectReference.getValue() + "] to standby mode");
                System.err.println("Reason :" + exception.getLocalizedMessage());
            }
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.validate();
        if (this.checkOptions()) {
            this.runOperation();
        }
    }

    public boolean checkOptions() {
        boolean bl = false;
        if (this.all.booleanValue()) {
            this.vmName = null;
            this.datacenter = null;
            this.host = null;
            System.out.println("Power operations will be broadcast to ALL virtual machines.");
            bl = true;
        } else {
            if (this.vmName == null && this.datacenter == null && this.guestId == null && this.host == null && System.console() != null) {
                throw new IllegalStateException("You must specify one of --vmname or --datacentername or --hostname or --all");
            }
            bl = true;
        }
        return bl;
    }
}

