/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFaultFaultMsg;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TimedoutFaultMsg;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VirtualMachineMovePriority;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Sample(name="vmotion", description="Used to validate if VMotion is feasible between two hosts or not,\nIt is also used to perform migrate/relocate task depending on the data given")
public class VMotion
extends ConnectedVimServiceBase {
    String[] meTree = new String[]{"ManagedEntity", "ComputeResource", "ClusterComputeResource", "Datacenter", "Folder", "HostSystem", "ResourcePool", "VirtualMachine"};
    String[] crTree = new String[]{"ComputeResource", "ClusterComputeResource"};
    String[] hcTree = new String[]{"HistoryCollector", "EventHistoryCollector", "TaskHistoryCollector"};
    ManagedObjectReference propCollectorRef = null;
    String vmName = null;
    String targetHost = null;
    String targetPool = null;
    String sourceHost = null;
    String targetDS = null;
    String priority = null;
    String state = null;

    @Option(name="vmname", description="name of the virtual machine")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="targethost", description="Name of the target host")
    public void setTargetHost(String string) {
        this.targetHost = string;
    }

    @Option(name="sourcehost", description="Name of the host containing the virtual machine")
    public void setSourceHost(String string) {
        this.sourceHost = string;
    }

    @Option(name="targetpool", description="Name of the target resource pool")
    public void setTargetPool(String string) {
        this.targetPool = string;
    }

    @Option(name="targetdatastore", description="Name of the target datastore")
    public void setTargetDS(String string) {
        this.targetDS = string;
    }

    @Option(name="priority", description="The priority of the migration task: default_Priority, high_Priority,low_Priority")
    public void setPriority(String string) {
        this.priority = string;
    }

    @Option(name="state", required=false)
    public void setState(String string) {
        this.state = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    List<SelectionSpec> buildFullTraversal() {
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("rpToVm");
        traversalSpec.setType("ResourcePool");
        traversalSpec.setPath("vm");
        traversalSpec.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setName("vAppToVM");
        traversalSpec2.setType("VirtualApp");
        traversalSpec2.setPath("vm");
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setType("HostSystem");
        traversalSpec3.setPath("vm");
        traversalSpec3.setName("hToVm");
        traversalSpec3.getSelectSet().add(this.getSelectionSpec("visitFolders"));
        traversalSpec3.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setType("Datacenter");
        traversalSpec4.setPath("datastore");
        traversalSpec4.setName("dcToDs");
        traversalSpec4.setSkip(Boolean.FALSE);
        TraversalSpec traversalSpec5 = new TraversalSpec();
        traversalSpec5.setType("ResourcePool");
        traversalSpec5.setPath("resourcePool");
        traversalSpec5.setSkip(Boolean.FALSE);
        traversalSpec5.setName("rpToRp");
        traversalSpec5.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        traversalSpec5.getSelectSet().add(this.getSelectionSpec("rpToVm"));
        TraversalSpec traversalSpec6 = new TraversalSpec();
        traversalSpec6.setType("ComputeResource");
        traversalSpec6.setPath("resourcePool");
        traversalSpec6.setSkip(Boolean.FALSE);
        traversalSpec6.setName("crToRp");
        traversalSpec6.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        traversalSpec6.getSelectSet().add(this.getSelectionSpec("rpToVm"));
        TraversalSpec traversalSpec7 = new TraversalSpec();
        traversalSpec7.setSkip(Boolean.FALSE);
        traversalSpec7.setType("ComputeResource");
        traversalSpec7.setPath("host");
        traversalSpec7.setName("crToH");
        TraversalSpec traversalSpec8 = new TraversalSpec();
        traversalSpec8.setSkip(Boolean.FALSE);
        traversalSpec8.setType("Datacenter");
        traversalSpec8.setPath("hostFolder");
        traversalSpec8.setName("dcToHf");
        traversalSpec8.getSelectSet().add(this.getSelectionSpec("visitFolders"));
        TraversalSpec traversalSpec9 = new TraversalSpec();
        traversalSpec9.setName("vAppToRp");
        traversalSpec9.setType("VirtualApp");
        traversalSpec9.setPath("resourcePool");
        traversalSpec9.getSelectSet().add(this.getSelectionSpec("rpToRp"));
        TraversalSpec traversalSpec10 = new TraversalSpec();
        traversalSpec10.setType("Datacenter");
        traversalSpec10.setSkip(Boolean.FALSE);
        traversalSpec10.setPath("vmFolder");
        traversalSpec10.setName("dcToVmf");
        traversalSpec10.getSelectSet().add(this.getSelectionSpec("visitFolders"));
        TraversalSpec traversalSpec11 = new TraversalSpec();
        traversalSpec11.setType("Folder");
        traversalSpec11.setPath("childEntity");
        traversalSpec11.setSkip(Boolean.FALSE);
        traversalSpec11.setName("visitFolders");
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add(this.getSelectionSpec("visitFolders"));
        arrayList.add(this.getSelectionSpec("dcToVmf"));
        arrayList.add(this.getSelectionSpec("dcToHf"));
        arrayList.add(this.getSelectionSpec("dcToDs"));
        arrayList.add(this.getSelectionSpec("crToRp"));
        arrayList.add(this.getSelectionSpec("crToH"));
        arrayList.add(this.getSelectionSpec("hToVm"));
        arrayList.add(this.getSelectionSpec("rpToVm"));
        arrayList.add(this.getSelectionSpec("rpToRp"));
        arrayList.add(this.getSelectionSpec("vAppToRp"));
        arrayList.add(this.getSelectionSpec("vAppToVM"));
        traversalSpec11.getSelectSet().addAll(arrayList);
        ArrayList<SelectionSpec> arrayList2 = new ArrayList<SelectionSpec>();
        arrayList2.add((SelectionSpec)traversalSpec11);
        arrayList2.add((SelectionSpec)traversalSpec10);
        arrayList2.add((SelectionSpec)traversalSpec8);
        arrayList2.add((SelectionSpec)traversalSpec4);
        arrayList2.add((SelectionSpec)traversalSpec6);
        arrayList2.add((SelectionSpec)traversalSpec7);
        arrayList2.add((SelectionSpec)traversalSpec3);
        arrayList2.add((SelectionSpec)traversalSpec);
        arrayList2.add((SelectionSpec)traversalSpec9);
        arrayList2.add((SelectionSpec)traversalSpec2);
        arrayList2.add((SelectionSpec)traversalSpec5);
        return arrayList2;
    }

    SelectionSpec getSelectionSpec(String string) {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName(string);
        return selectionSpec;
    }

    List<DynamicProperty> getDynamicProarray(ManagedObjectReference managedObjectReference, String string, String string2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add(string2);
        propertySpec.setType(string);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.FALSE);
        objectSpec.getSelectSet().addAll(this.buildFullTraversal());
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        ObjectContent objectContent = list.get(0);
        List list2 = objectContent.getPropSet();
        return list2;
    }

    TraversalSpec getHostSystemTraversalSpec() {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("VisitFolders");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("computeResourceToHostSystem");
        traversalSpec.setType("ComputeResource");
        traversalSpec.setPath("host");
        traversalSpec.setSkip(Boolean.valueOf(false));
        traversalSpec.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setName("hostFolderToComputeResource");
        traversalSpec2.setType("Folder");
        traversalSpec2.setPath("childEntity");
        traversalSpec2.setSkip(Boolean.valueOf(false));
        traversalSpec2.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setName("DataCenterToHostFolder");
        traversalSpec3.setType("Datacenter");
        traversalSpec3.setPath("hostFolder");
        traversalSpec3.setSkip(Boolean.valueOf(false));
        traversalSpec3.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setName("VisitFolders");
        traversalSpec4.setType("Folder");
        traversalSpec4.setPath("childEntity");
        traversalSpec4.setSkip(Boolean.valueOf(false));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(selectionSpec);
        arrayList.add(traversalSpec3);
        arrayList.add(traversalSpec2);
        arrayList.add(traversalSpec);
        traversalSpec4.getSelectSet().addAll(arrayList);
        return traversalSpec4;
    }

    ManagedObjectReference getHostByHostName(String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference = null;
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getRootFolder();
        TraversalSpec traversalSpec = this.getHostSystemTraversalSpec();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("name");
        propertySpec.setType("HostSystem");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference2);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        if (list != null) {
            for (ObjectContent objectContent : list) {
                ManagedObjectReference managedObjectReference3 = objectContent.getObj();
                String string2 = null;
                List list2 = objectContent.getPropSet();
                DynamicProperty[] dynamicPropertyArray = list2.toArray(new DynamicProperty[list2.size()]);
                if (dynamicPropertyArray != null) {
                    for (DynamicProperty dynamicProperty : dynamicPropertyArray) {
                        string2 = (String)dynamicProperty.getVal();
                    }
                }
                if (string2 == null || !string2.equals(string)) continue;
                managedObjectReference = managedObjectReference3;
                break;
            }
        } else {
            System.out.println("The Object Content is Null");
        }
        if (managedObjectReference == null) {
            throw new RuntimeException("Host " + string + " not found.");
        }
        return managedObjectReference;
    }

    DatastoreSummary getDataStoreSummary(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        DatastoreSummary datastoreSummary = new DatastoreSummary();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("summary");
        propertySpec.setType("Datastore");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.FALSE);
        objectSpec.getSelectSet().addAll(this.buildFullTraversal());
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        for (int i = 0; i < list.size(); ++i) {
            List list2 = list.get(i).getPropSet();
            for (int j = 0; j < list2.size(); ++j) {
                datastoreSummary = (DatastoreSummary)((DynamicProperty)list2.get(j)).getVal();
            }
        }
        return datastoreSummary;
    }

    ManagedObjectReference browseDSMOR(List<ManagedObjectReference> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DatastoreSummary datastoreSummary = this.getDataStoreSummary(list.get(i));
                String string = datastoreSummary.getName();
                if (!string.equalsIgnoreCase(this.targetDS)) continue;
                managedObjectReference = list.get(i);
                break;
            }
        }
        return managedObjectReference;
    }

    String checkOperationType(String string, String string2, String string3) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        String string4 = "";
        if (string.equalsIgnoreCase(string2)) {
            return "same";
        }
        ManagedObjectReference managedObjectReference = this.getHostByHostName(string);
        ManagedObjectReference managedObjectReference2 = this.getHostByHostName(string2);
        List<DynamicProperty> list = this.getDynamicProarray(managedObjectReference, "HostSystem", "datastore");
        ArrayOfManagedObjectReference arrayOfManagedObjectReference = (ArrayOfManagedObjectReference)list.get(0).getVal();
        List list2 = arrayOfManagedObjectReference.getManagedObjectReference();
        ManagedObjectReference managedObjectReference3 = this.browseDSMOR(list2);
        List<DynamicProperty> list3 = this.getDynamicProarray(managedObjectReference2, "HostSystem", "datastore");
        ArrayOfManagedObjectReference arrayOfManagedObjectReference2 = (ArrayOfManagedObjectReference)list3.get(0).getVal();
        List list4 = arrayOfManagedObjectReference2.getManagedObjectReference();
        ManagedObjectReference managedObjectReference4 = this.browseDSMOR(list4);
        string4 = managedObjectReference3 != null && managedObjectReference4 != null ? "migrate" : "relocate";
        return string4;
    }

    List<PropertySpec> buildPropertySpecArray(String[][] stringArray) {
        Object object;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            Set<Object> set = (Set)hashMap.get(stringArray[i][0]);
            if (set == null) {
                set = new HashSet<Object>();
                hashMap.put(stringArray[i][0], set);
            }
            boolean bl = false;
            for (int j = 0; j < stringArray[i].length; ++j) {
                object = stringArray[i][j];
                if (bl) {
                    set.add(object);
                    continue;
                }
                bl = true;
            }
        }
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (String string : hashMap.keySet()) {
            PropertySpec propertySpec = new PropertySpec();
            object = (Set)hashMap.get(string);
            propertySpec.setType(string);
            propertySpec.setAll(object.isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                propertySpec.getPathSet().add(string2);
            }
            arrayList.add(propertySpec);
        }
        return arrayList;
    }

    List<ObjectContent> getContentsRecursively(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, String[][] stringArray, boolean bl) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference3;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ManagedObjectReference managedObjectReference4 = managedObjectReference;
        if (managedObjectReference4 == null) {
            managedObjectReference4 = this.serviceContent.getPropertyCollector();
        }
        if ((managedObjectReference3 = managedObjectReference2) == null) {
            managedObjectReference3 = this.serviceContent.getRootFolder();
        }
        List<SelectionSpec> list = null;
        if (bl) {
            list = this.buildFullTraversal();
        }
        List<PropertySpec> list2 = this.buildPropertySpecArray(stringArray);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference3);
        objectSpec.setSkip(Boolean.FALSE);
        objectSpec.getSelectSet().addAll(list);
        ArrayList<ObjectSpec> arrayList = new ArrayList<ObjectSpec>();
        arrayList.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(list2);
        propertyFilterSpec.getObjectSet().addAll(arrayList);
        ArrayList<PropertyFilterSpec> arrayList2 = new ArrayList<PropertyFilterSpec>();
        arrayList2.add(propertyFilterSpec);
        List<ObjectContent> list3 = this.retrievePropertiesAllObjects(arrayList2);
        return list3;
    }

    boolean typeIsA(String string, String string2) {
        block5: {
            block6: {
                block4: {
                    if (string.equals(string2)) {
                        return true;
                    }
                    if (!string.equals("ManagedEntity")) break block4;
                    for (int i = 0; i < this.meTree.length; ++i) {
                        if (!this.meTree[i].equals(string2)) continue;
                        return true;
                    }
                    break block5;
                }
                if (!string.equals("ComputeResource")) break block6;
                for (int i = 0; i < this.crTree.length; ++i) {
                    if (!this.crTree[i].equals(string2)) continue;
                    return true;
                }
                break block5;
            }
            if (!string.equals("HistoryCollector")) break block5;
            for (int i = 0; i < this.hcTree.length; ++i) {
                if (!this.hcTree[i].equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    ManagedObjectReference getDecendentMoRef(ManagedObjectReference managedObjectReference, String string, String string2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String[][] stringArray = new String[][]{{string, "name"}};
        List<ObjectContent> list = this.getContentsRecursively(null, managedObjectReference, stringArray, true);
        if (list == null || list.size() == 0) {
            return null;
        }
        ObjectContent objectContent = null;
        ManagedObjectReference managedObjectReference2 = null;
        List list2 = null;
        String string3 = null;
        boolean bl = false;
        for (int i = 0; i < list.size() && !bl; ++i) {
            objectContent = list.get(i);
            managedObjectReference2 = objectContent.getObj();
            list2 = objectContent.getPropSet();
            string3 = null;
            if (string != null && !this.typeIsA(string, managedObjectReference2.getType())) continue;
            if (list2.size() > 0) {
                string3 = (String)((DynamicProperty)list2.get(0)).getVal();
            }
            bl = string3 != null && string2.equals(string3);
        }
        if (!bl) {
            managedObjectReference2 = null;
        }
        return managedObjectReference2;
    }

    void migrateVM(String string, String string2, String string3, String string4, String string5) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, FileFaultFaultMsg, MigrationFaultFaultMsg, InvalidStateFaultMsg, TimedoutFaultMsg, InvalidCollectorVersionFaultMsg {
        VirtualMachinePowerState virtualMachinePowerState = null;
        VirtualMachineMovePriority virtualMachineMovePriority = null;
        if (this.state != null) {
            if (VirtualMachinePowerState.POWERED_OFF.toString().equalsIgnoreCase(this.state)) {
                virtualMachinePowerState = VirtualMachinePowerState.POWERED_OFF;
            } else if (VirtualMachinePowerState.POWERED_ON.toString().equalsIgnoreCase(this.state)) {
                virtualMachinePowerState = VirtualMachinePowerState.POWERED_ON;
            } else if (VirtualMachinePowerState.SUSPENDED.toString().equalsIgnoreCase(this.state)) {
                virtualMachinePowerState = VirtualMachinePowerState.SUSPENDED;
            }
        }
        if (string5 == null) {
            virtualMachineMovePriority = VirtualMachineMovePriority.DEFAULT_PRIORITY;
        } else if (VirtualMachineMovePriority.DEFAULT_PRIORITY.toString().equalsIgnoreCase(string5)) {
            virtualMachineMovePriority = VirtualMachineMovePriority.DEFAULT_PRIORITY;
        } else if (VirtualMachineMovePriority.HIGH_PRIORITY.toString().equalsIgnoreCase(string5)) {
            virtualMachineMovePriority = VirtualMachineMovePriority.HIGH_PRIORITY;
        } else if (VirtualMachineMovePriority.LOW_PRIORITY.toString().equalsIgnoreCase(string5)) {
            virtualMachineMovePriority = VirtualMachineMovePriority.LOW_PRIORITY;
        }
        ManagedObjectReference managedObjectReference = this.getHostByHostName(string4);
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("Source Host" + this.sourceHost + " Not Found.");
        }
        ManagedObjectReference managedObjectReference2 = this.getDecendentMoRef(managedObjectReference, "VirtualMachine", string);
        if (managedObjectReference2 == null) {
            throw new IllegalArgumentException("Virtual Machine " + this.vmName + " Not Found.");
        }
        ManagedObjectReference managedObjectReference3 = this.getDecendentMoRef(null, "ResourcePool", string2);
        if (managedObjectReference3 == null) {
            throw new IllegalArgumentException("Target Resource Pool " + this.targetPool + " Not Found.");
        }
        ManagedObjectReference managedObjectReference4 = this.getHostByHostName(string3);
        if (managedObjectReference4 == null) {
            throw new IllegalArgumentException(" Target Host " + this.targetHost + " Not Found.");
        }
        System.out.println("Migrating the Virtual Machine " + string);
        ManagedObjectReference managedObjectReference5 = this.vimPort.migrateVMTask(managedObjectReference2, managedObjectReference3, managedObjectReference4, virtualMachineMovePriority, virtualMachinePowerState);
        if (this.getTaskResultAfterDone(managedObjectReference5)) {
            System.out.println("Migration of Virtual Machine " + string + " done successfully to " + string3);
        } else {
            System.out.println("Error::  Migration failed");
        }
    }

    void relocateVM(String string, String string2, String string3, String string4, String string5) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, MigrationFaultFaultMsg, InvalidStateFaultMsg, TimedoutFaultMsg, InvalidCollectorVersionFaultMsg {
        VirtualMachineMovePriority virtualMachineMovePriority = null;
        if (this.priority == null) {
            virtualMachineMovePriority = VirtualMachineMovePriority.DEFAULT_PRIORITY;
        } else if (VirtualMachineMovePriority.DEFAULT_PRIORITY.toString().equalsIgnoreCase(this.priority)) {
            virtualMachineMovePriority = VirtualMachineMovePriority.DEFAULT_PRIORITY;
        } else if (VirtualMachineMovePriority.HIGH_PRIORITY.toString().equalsIgnoreCase(this.priority)) {
            virtualMachineMovePriority = VirtualMachineMovePriority.HIGH_PRIORITY;
        } else if (VirtualMachineMovePriority.LOW_PRIORITY.toString().equalsIgnoreCase(this.priority)) {
            virtualMachineMovePriority = VirtualMachineMovePriority.LOW_PRIORITY;
        }
        ManagedObjectReference managedObjectReference = this.getHostByHostName(string5);
        if (managedObjectReference == null) {
            throw new IllegalArgumentException(" Source Host " + this.sourceHost + " Not Found.");
        }
        ManagedObjectReference managedObjectReference2 = this.getDecendentMoRef(managedObjectReference, "VirtualMachine", string);
        if (managedObjectReference2 == null) {
            throw new IllegalArgumentException("Virtual Machine " + this.vmName + " Not Found.");
        }
        ManagedObjectReference managedObjectReference3 = this.getDecendentMoRef(null, "ResourcePool", string2);
        if (managedObjectReference3 == null) {
            throw new IllegalArgumentException(" Target Resource Pool " + this.targetPool + " Not Found.");
        }
        ManagedObjectReference managedObjectReference4 = this.getHostByHostName(string3);
        if (managedObjectReference4 == null) {
            throw new IllegalArgumentException(" Target Host " + this.targetHost + " Not Found.");
        }
        List<DynamicProperty> list = this.getDynamicProarray(managedObjectReference4, "HostSystem", "datastore");
        ArrayOfManagedObjectReference arrayOfManagedObjectReference = (ArrayOfManagedObjectReference)list.get(0).getVal();
        List list2 = arrayOfManagedObjectReference.getManagedObjectReference();
        ManagedObjectReference managedObjectReference5 = this.browseDSMOR(list2);
        if (managedObjectReference5 == null) {
            throw new IllegalArgumentException(" DataSource " + string4 + " Not Found.");
        }
        VirtualMachineRelocateSpec virtualMachineRelocateSpec = new VirtualMachineRelocateSpec();
        virtualMachineRelocateSpec.setDatastore(managedObjectReference5);
        virtualMachineRelocateSpec.setHost(managedObjectReference4);
        virtualMachineRelocateSpec.setPool(managedObjectReference3);
        System.out.println("Relocating the Virtual Machine " + string);
        ManagedObjectReference managedObjectReference6 = this.vimPort.relocateVMTask(managedObjectReference2, virtualMachineRelocateSpec, virtualMachineMovePriority);
        if (this.getTaskResultAfterDone(managedObjectReference6)) {
            System.out.println("Relocation done successfully of " + string + " to host " + string3);
        } else {
            System.out.println("Error::  Relocation failed");
        }
    }

    void migrateOrRelocateVM() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, MigrationFaultFaultMsg, InvalidCollectorVersionFaultMsg, TimedoutFaultMsg, InvalidDatastoreFaultMsg {
        String string = this.checkOperationType(this.targetHost, this.sourceHost, this.targetDS);
        if (string.equalsIgnoreCase("migrate")) {
            this.migrateVM(this.vmName, this.targetPool, this.targetHost, this.sourceHost, this.priority);
        } else if (string.equalsIgnoreCase("relocate")) {
            this.relocateVM(this.vmName, this.targetPool, this.targetHost, this.targetDS, this.sourceHost);
        } else {
            if (string.equalsIgnoreCase("same")) {
                throw new IllegalArgumentException("targethost and sourcehost must not be same");
            }
            throw new IllegalArgumentException(string + " Not Found.");
        }
    }

    boolean customValidation() {
        boolean bl = true;
        if (!(this.state == null || this.state.equalsIgnoreCase("poweredOn") || this.state.equalsIgnoreCase("poweredOff") || this.state.equalsIgnoreCase("suspended"))) {
            System.out.println("Must specify 'poweredOn', 'poweredOff' or 'suspended' for 'state' option\n");
            bl = false;
        }
        if (!(this.priority == null || this.priority.equalsIgnoreCase("default_Priority") || this.priority.equalsIgnoreCase("high_Priority") || this.priority.equalsIgnoreCase("low_Priority"))) {
            System.out.println("Must specify 'default_Priority', 'high_Priority  'or 'low_Priority' for 'priority' option\n");
            bl = false;
        }
        return bl;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, MigrationFaultFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, TimedoutFaultMsg {
        if (this.customValidation()) {
            this.propCollectorRef = this.serviceContent.getPropertyCollector();
            this.migrateOrRelocateVM();
        }
    }
}

