#!/bin/bash

set -e
## You need to set env variables : JAVA_HOME, VIMSDKHOME
## or modify the value here

export SAMPLEDIR=${PWD}/samples
export SAMPLEJARDIR=${PWD}/lib
export SMSJAVADIR=${PWD}

export WSDL_V1=version1/smService.wsdl
export WSDL_V2=smsService.wsdl

if [ ! -d ${SAMPLEJARDIR} ]; then
   mkdir -p ${SAMPLEJARDIR}
fi

if [ -z  "$WSDLPATH" ]
then
	pushd ../../wsdl
	export WSDLPATH=$PWD
    echo "wsdlpath $WSDLPATH"
	popd
else
    echo "${WSDLPATH} is NOT empty"
fi

if [ ! -z "$JAVA_HOME" ] || [ ! -z "$JAVAHOME" ];
then
        export JAVA_HOME="${JAVAHOME}"
else
      echo "JAVA_HOME not defined. Must be defined to run java apps."
      exit
fi

if [ -z "$VIMSDKHOME" ]
then
    echo "Environment variable VIMSDKHOME must be set to build the SDK."
    echo "Exiting."
    exit
fi
pushd "$VIMSDKHOME"/../libs/jaxws-ri
export JAXWS_HOME=$PWD
echo " JAXWS_HOME : $JAXWS_HOME"
popd

pushd "$VIMSDKHOME"/../libs/jaxb-ri
export JAXB_HOME=$PWD
popd

# source clean.sh
export LOCALCLASSPATH=$PWD:$PWD/lib/*:$JAXWS_HOME/lib/*:$VIMSDKHOME/java/JAXWS/lib/vim25.jar:$VIMSDKHOME/java/JAXWS/lib/samples-core-1.0.0.jar:$VIMSDKHOME/java/JAXWS/lib/samples-annotations-1.0.0.jar

for i in lib/*.jar
 do
    export LOCALCLASSPATH=$LOCALCLASSPATH:$PWD/$i
done

. clean.sh ;

if [ -d "samples/com/vmware/vim/sms" ]
then
    rm -rf samples/com/vmware/vim/sms
fi
mkdir -p samples/com/vmware/vim/sms

cp -f -v $WSDLPATH/*.* .
cp -f -v $WSDLPATH/*.* samples/com/vmware/vim/sms


echo "Generating vim.episode from wsdl"
RC=$( source $JAXB_HOME/bin/xjc.sh -episode vim.episode vim-types.xsd -d samples -p com.vmware.vim25 );
echo "$RC"

echo "Generating sms stubs from wsdl"
RC=$( source "$JAXWS_HOME"/bin/wsimport.sh -wsdllocation $WSDL_V2 -b vim.episode -p com.vmware.vim.sms -s samples $WSDL_V2 -verbose  -Xnocompile ) ;
echo "$RC"

LOCALCLASSPATH="$LOCALCLASSPATH":"$SAMPLEJARDIR"

java -classpath $LOCALCLASSPATH FixJaxWsWsdlResource "$PWD/samples/com/vmware/vim/sms/SmsService.java"

echo " Compiling sms stubs."
cd $SAMPLEDIR
echo "In sms-sdk samples directory"
pwd
javac -J-Xms1024M -J-Xmx1024M -classpath "$JAXWS_HOME/lib/*":${LOCALCLASSPATH} -source 8 -target 8 com/vmware/vim/sms/*.java
jar cf ${SAMPLEJARDIR}/sms.jar  com/vmware/vim/sms/*.class com/vmware/vim/sms/*.wsdl com/vmware/vim/sms/*.xsd

rm -f samples/com/vmware/vim/sms/*.wsdl
rm -f samples/com/vmware/vim/sms/*.xsd
rm -f  ./*.wsdl
rm -f ./*.xsd

echo "Done generating sms stubs from wsdl"
find com/vmware/apputils -name *.java > files_src.txt
echo "Compiling apputils"

javac  -J-Xms256M -J-Xmx256M -XDignore.symbol.file -Xlint:unchecked -classpath "$LOCALCLASSPATH" -source 8 -target 8 com/vmware/apputils/*.java @files_src.txt
jar cf "$SAMPLEJARDIR/sms-apputils.jar" com/vmware/apputils/*.class @files_src.txt

find com/vmware/samples  -name *.java >> files_src.txt

echo "Compiling samples"

javac  -classpath "$LOCALCLASSPATH:$SAMPLEJARDIR/sms.jar:$VIMSDKHOME/java/JAXWS/lib/samples-annotations-1.0.0.jar:$SAMPLEJARDIR/sms-apputils.jar:$JAXWS_HOME/lib/*" -source 8 -target 8 com/vmware/samples/sms/*.java @files_src.txt

jar cf "$SAMPLEJARDIR/sms-samples.jar" com/vmware/samples/sms/*.class

javadoc -Xdoclint:none -J-Xms512m -J-Xmx512m  -sourcepath . -classpath  "$JAXWS_HOME"/lib/*:"$SAMPLEJARDIR"/*:"$LOCALCLASSPATH" -d ../../../docs/java/JAXWS/samples/javadoc -public -windowtitle "VMware vSphere SMS SDK JAXWS Java Samples Documentation" -doctitle "<html><body>VMware vSphere SMS SDK JAXWS Java Samples Reference Documentation<a name=topofpage></a>" -overview ../../../docresources/vsphere-ws-sms-jaxws-samples-overview.html -nohelp -subpackages com.vmware.apputils:com.vmware.samples.sms -exclude com.vmware.vim.sms

find com/vmware -type f -name "*.class" -exec rm {} \;
rm -f files_src.txt
rm -rf com/vmware/vim
rm -rf com/vmware/vim25
cd ..
rm -rf com
echo "Done"
