#!/bin/sh

set -e
## You need to set env variables : JAVA_HOME,
## or modify the value here

export SPBM_BUILD_DIR=$PWD
export SAMPLEDIR=${SPBM_BUILD_DIR}/samples
export LIB_DIR=${SPBM_BUILD_DIR}/lib
pushd ../../wsdl
export WSDLDIR=$PWD
popd
export WSDLNAME=pbmService.wsdl
export PRODUCT=pbm
export PRODUCT_DISPLAY=VMware Storage Policy SDK
pushd ../../../libs/jaxws-ri
export JAXWS_HOME=$PWD
popd
pushd ../../../libs/jaxb-ri
export JAXB_HOME=$PWD
popd
pushd ../../../ssoclient/java/JAXWS
export SSO_JAR=$PWD
popd
pushd ../../../vsphere-ws/java/JAXWS
export VIM_JAR=$PWD
popd

cd samples

if [ ! -e ${LIB_DIR} ]; then
   mkdir -p ${LIB_DIR}
fi


# Copying Pre-requisites
echo "Adding ssoclient.jar"
if [ ! -f ${LIB_DIR}/ssoclient.jar ]; then
    if [ ! -f "$SSO_JAR"/lib/ssoclient.jar ]; then
       echo "building ssoclient.jar"
       pushd "$SSO_JAR"
	pwd
	chmod a+x build.sh
	 source  build.sh
	popd
    fi
    # On successful build
    echo "copying ssoclient.jar"
    cp -f "$SSO_JAR"/lib/ssoclient.jar ${LIB_DIR}
fi

echo Adding ssosamples.jar
if [ ! -f ${LIB_DIR}/ssosamples.jar ]; then
    echo copying ssosamples.jar
    cp "$SSO_JAR"/lib/ssosamples.jar ${LIB_DIR}
fi

echo Adding vSphere vim25.jar
if [ ! -f ${LIB_DIR}/vim25.jar ]; then
    if [ ! -f "$VIM_JAR"/lib/vim25.jar ]; then
       echo building vim25.jar
       source build.sh
    fi
    # On successful build
    echo copying vim25.jar
    cp "$VIM_JAR"/lib/vim25.jar ${LIB_DIR}
fi

# Generate PBM Stubs
export LOCALCLASSPATH=${LOCALCLASSPATH}:$SSO_JAR/lib/*:$VIM_JAR/lib/*:$PWD/lib/*
echo Generating $PRODUCT stubs from wsdl
ls "$WSDLDIR"
RC=$( source $JAXB_HOME/bin/xjc.sh -episode vim.episode $WSDLDIR/vim-types.xsd -d . -p com.vmware.vim25 );
echo "$RC"

RC=$( source $JAXWS_HOME/bin/wsimport.sh -wsdllocation $WSDLNAME -b vim.episode  -p com.vmware.$PRODUCT -s . ${WSDLDIR}/${WSDLNAME} -Xnocompile -quiet );
echo "$RC"
echo Applying the FixJaxWsWsdlResource to PbmService.java
java -classpath ${LIB_DIR} FixJaxWsWsdlResource "${SPBM_BUILD_DIR}/samples/com/vmware/${PRODUCT}/PbmService.java" PbmService

echo Compiling $PRODUCT Stubs
javac -classpath ${LIB_DIR}/vim25.jar:"${JAXWS_HOME}/lib/*" -source 8 -target 8 com/vmware/$PRODUCT/*.java

echo Copying the wsdl files
cp ${WSDLDIR}/* com/vmware/$PRODUCT/

echo Jar $PRODUCT Stubs
jar cf ${LIB_DIR}/${PRODUCT}.jar com/vmware/$PRODUCT/*.class com/vmware/$PRODUCT/*.wsdl com/vmware/$PRODUCT/*.xsd
jar cf ${LIB_DIR}/${PRODUCT}-src.jar com/vmware/$PRODUCT/*.java com/vmware/$PRODUCT/*.wsdl com/vmware/$PRODUCT/*.xsd

echo Cleaning generated code
rm -rf com/vmware/$PRODUCT
rm -rf com/vmware/vim25
rm vim.episode

echo Compiling Samples
SAMPLE_SRC_FILES=`find "com/vmware" -depth -name '*.java' -print`
javac -classpath "$JAXWS_HOME/lib/*:$LIB_DIR/*" -source 1.8 -target 1.8 ${SAMPLE_SRC_FILES}

echo Jar Samples
SAMPLE_CLASS_FILES=`find "./com/vmware" -depth -name '*.class' -print`
jar cf ${LIB_DIR}/${PRODUCT}-samples.jar ${SAMPLE_CLASS_FILES}

echo Cleaning sample class files
rm ${SAMPLE_CLASS_FILES}

echo Generating Javadocs for samples
javadoc -classpath "$JAXWS_HOME/lib/*:$LIB_DIR/*" -Xdoclint:none -J-Xms512m -J-Xmx512m -d ../../../docs/java/JAXWS/samples/javadoc -public -windowtitle "${PRODUCT_DISPLAY} Samples Documentation" -doctitle "<html><body>${PRODUCT_DISPLAY} Samples Reference Documentation<a name=topofpage></a>" -nohelp ${SAMPLE_SRC_FILES}

echo Done.
