#!/bin/bash

set -e

pushd ../../../libs/jaxws-ri/
export JAXWS_HOME=$PWD
popd
pushd ../../wsdl
export WSDLLOCATION=$PWD
popd
export LOCALCLASSPATH=$PWD/lib/*:$JAXWS_HOME/lib/*
echo "$LOCALCLASSPATH"
echo $JAVA_HOME

for i in lib/*.jar
 do
    export LOCALCLASSPATH=$LOCALCLASSPATH:$PWD/$i
done

if [ ! -d "../../docs/java/JAXWS/samples/javadoc" ]
then
   mkdir -p ../../docs/java/JAXWS/samples/javadoc
fi

pushd ../../../vsphere-ws/java/JAXWS/lib/
export VIMJAR=$PWD
echo "$VIMJAR"
echo "Adding vim25.jar....."
if [ ! -f "vim25.jar" ]
then
	echo "Missing vim25.jar... Trigerring the vsphere stub generator build to generate one."
	cd ..
	source build.sh -s
	cd -
fi
popd
cp -f $VIMJAR/vim25.jar lib

echo "compiling samples....."

mkdir -p samples/output
cd samples
find "$PWD" -name *.java > fileList.txt
javac -classpath "$LOCALCLASSPATH" -source 8 -target 8 -d output @fileList.txt

echo "Generating compiled samples jar....."
jar cf ../lib/ssosamples.jar -C output/ .

echo "Cleaning up....."
rm  fileList.txt
rm  -rf output/*
rm -rf output
cd ..
echo "Generating javadocs....."
javadoc -sourcepath samples -classpath "$LOCALCLASSPATH" -J-Xms512m -J-Xmx512m -d ../../docs/java/JAXWS/samples/javadoc -public -windowtitle "vCenter Single Sign-On Client Java Samples Documentation" -doctitle "<html><body>vCenter Single Sign-On Client Java Samples Reference Documentation<a name=topofpage></a>" -nohelp -subpackages com.vmware
echo "Build complete....."
