#!/bin/bash

set -e

if [ ! -d "tmp" ]
then
    mkdir -p tmp
fi

if [ ! -d "lib" ]
then
    mkdir -p lib
fi


export PATH=$JAVA_HOME/bin:$PATH
pushd ../../../libs/jaxws-ri
export JAXWS_HOME=$PWD
echo "current directory"$JAXWS_HOME
popd
pushd ../../wsdl
export WSDLLOCATION=$PWD
popd

export LOCALCLASSPATH=${LOCALCLASSPATH}:$PWD/lib/*

echo "Generating stubs....."
RC=$( $JAXWS_HOME/bin/wsimport.sh  -wsdllocation STSService.wsdl -B-XautoNameResolution  -s tmp  $WSDLLOCATION/STSService.wsdl -extension );
echo "$RC"

java -classpath lib/ FixJaxWsWsdlResource "tmp/com/rsa/names/_2009/_12/product/riat/wsdl/STSService.java" STSService


echo "Embedding wsdl....."
cp -R  $WSDLLOCATION/* tmp/com/rsa/names/_2009/_12/product/riat/wsdl

echo "Generating source jar....."
jar cf lib/ssoclient-source.jar -C tmp/ .

echo "Compiling Stubs....."
find tmp -name *.java > fileList.txt
javac -cp "$JAXWS_HOME"/lib/*:"$LOCALCLASSPATH" @fileList.txt -source 8 -target 8
rm fileList.txt
#rm tmp/*.java

echo "Generating compiled jar....."
jar cf lib/ssoclient.jar -C tmp/ .

echo "Cleaning up....."
rm -rf tmp

echo "ssoclient compiled jar done...."
