/* **********************************************************
 * Copyright 2012-2014, 2022 VMware, Inc.  All rights reserved.
 * **********************************************************/
package com.vmware.sso.client.wssecurity;

import java.security.SignatureException;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;

/**
 * Interface used for signing the SOAP requests
 *
 * @author Ecosystem Engineering
 */
public interface WsSecuritySignature {

	/**
	 * Signs the SOAP Message
	 * 
	 * @param message
	 * @return
	 * @throws SignatureException
	 * @throws SOAPException
	 */
	public SOAPMessage sign(SOAPMessage message) throws SignatureException,
			SOAPException;
}
