#!/bin/bash

set -e

#u need to set env variables : JAVA_HOME,
## or modify the value here
export VSLM_BUILD_DIR=$PWD
export SAMPLEDIR=${VSLM_BUILD_DIR}/samples
export LIB_DIR=${VSLM_BUILD_DIR}/lib
pushd ../../../vsphere-ws/java/JAXWS
export VIM_DIR=$PWD
popd
pushd ../../../ssoclient/java/JAXWS
export SSO_DIR=$PWD
popd

if [ ! -d ${LIB_DIR} ]; then
   mkdir -p ${LIB_DIR}
fi

# Check Prerequisites
if [ ! -f ${LIB_DIR}/ssoclient.jar ]; then
    if [ ! -f "$SSO_DIR"/lib/ssoclient.jar ]; then
       echo "building ssoclient.jar"
       pushd "$SSO_DIR"
	pwd
	chmod a+x build.sh
	 source  build.sh
	popd
    fi
    # On successful build
    echo "copying ssoclient.jar"
    cp -f "$SSO_DIR"/lib/ssoclient.jar ${LIB_DIR}
fi

echo Adding ssosamples.jar
if [ ! -f ${LIB_DIR}/ssosamples.jar ]; then
    echo copying ssosamples.jar
    cp "$SSO_DIR"/lib/ssosamples.jar ${LIB_DIR}
fi

echo Adding vSphere vim25.jar
if [ ! -f ${LIB_DIR}/vim25.jar ]; then
    if [ ! -f "$VIM_DIR"/lib/vim25.jar ]; then
       echo building vim25.jar
       source build.sh -s
    fi
    # On successful build
    echo copying vim25.jar
    cp "$VIM_DIR"/lib/vim25.jar ${LIB_DIR}
fi

export SAMPLEDIR=${VSLM_BUILD_DIR}/samples
pushd ../../wsdl
export WSDLDIR=$PWD
popd
export WSDLNAME=vslmService.wsdl
export PRODUCT=vslm
export PRODUCT_DISPLAY=VSLM services
pushd ../../../libs/jaxws-ri
export JAXWS_HOME=$PWD
popd
pushd ../../../libs/jaxb-ri
export JAXB_HOME=$PWD
popd

export LOCALCLASSPATH=${LOCALCLASSPATH}:"$SSO_DIR"/lib/*:"$VIM_DIR"/lib/*:$PWD/lib/*
for i in lib/*.jar
 do
    export LOCALCLASSPATH=$LOCALCLASSPATH:$PWD/$i
done

echo $LOCALCLASSPATH
cd samples

if [ ! -e ${LIB_DIR} ]; then
mkdir ${LIB_DIR}
fi

echo "Generate VSLM Stubs"

echo Generating $PRODUCT stubs from wsdl
RC=$( source $JAXB_HOME/bin/xjc.sh -episode vim.episode $WSDLDIR/vim-types.xsd -d . -p com.vmware.vim25 );
echo "$RC"
RC=$( $JAXWS_HOME/bin/wsimport.sh -wsdllocation $WSDLNAME -b vim.episode -p com.vmware.$PRODUCT -s . ${WSDLDIR}/${WSDLNAME} -Xnocompile -quiet );
echo "$RC"

echo Compiling $PRODUCT Stubs
javac -classpath "${JAXWS_HOME}"/lib/*:"$VIM_DIR"/lib/vim25.jar com/vmware/vslm/*.java
echo Copying the wsdl files
cp -R  ${WSDLDIR}/* com/vmware/$PRODUCT/

echo Jar $PRODUCT Stubs
pwd
jar cf ${LIB_DIR}/${PRODUCT}.jar com/vmware/$PRODUCT/*.class com/vmware/$PRODUCT/*.wsdl com/vmware/$PRODUCT/*.xsd
jar cf ${LIB_DIR}/${PRODUCT}-src.jar com/vmware/$PRODUCT/*.java com/vmware/$PRODUCT/*.wsdl com/vmware/$PRODUCT/*.xsd

echo Cleaning generated code
rm -rf com/vmware/$PRODUCT
rm -rf com/vmware/vim25
rm -f ./vim.episode
rm -f ./vim.episode-e

LOCALCLASSPATH=${LOCALCLASSPATH}:${LIB_DIR}/*
echo Compiling Samples
SAMPLE_SRC_FILES=`find "com/vmware" -depth -name '*.java' -print`
javac -J-Xms1024M -J-Xmx1024M -XDignore.symbol.file -Xlint:unchecked  -classpath ${LOCALCLASSPATH}:"${JAXWS_HOME}"/lib/*  -source 1.8 -target 1.8  ${SAMPLE_SRC_FILES}

echo Jar Samples
SAMPLE_CLASS_FILES=`find "./com/vmware" -depth -name '*.class' -print`
jar cf ${LIB_DIR}/${PRODUCT}-samples.jar ${SAMPLE_CLASS_FILES}

echo Cleaning sample class files
rm ${SAMPLE_CLASS_FILES}

echo Generating Javadocs for samples
javadoc -classpath "$LIB_DIR"/*:${LOCALCLASSPATH}:"${JAXWS_HOME}"/lib/* -Xdoclint:none -J-Xms512m -J-Xmx512m -d ../../../docs/java/JAXWS/samples/javadoc -public -windowtitle "${PRODUCT_DISPLAY} Samples Documentation" -doctitle "<html><body>${PRODUCT_DISPLAY} Samples Reference Documentation<a name=topofpage></a" -nohelp ${SAMPLE_SRC_FILES}

cd ..
echo Done.
