#!/bin/sh
# set to relative path from this script to java libraries to use for classpath
export VSLM_BUILD_DIR=$PWD
export LIB_DIR=${VSLM_BUILD_DIR}/lib
export VSPHERE_LIB_DIR=${VSLM_BUILD_DIR}/../../../vsphere-ws/java/JAXWS/lib
export JAXWS_HOME=${VSLM_BUILD_DIR}/../../../libs/jaxws-ri
export LOCALCLASSPATH=${LIB_DIR}/vslm.jar:${LIB_DIR}/vslm-samples.jar:${VSPHERE_LIB_DIR}/vim25.jar:${VSPHERE_LIB_DIR}/samples-core-1.0.0.jar:${VSPHERE_LIB_DIR}/samples-annotations-1.0.0.jar:${VSPHERE_LIB_DIR}/ssoclient.jar:${VSPHERE_LIB_DIR}/ssosamples.jar:${VSPHERE_LIB_DIR}/wssamples.jar:${VSPHERE_LIB_DIR}/sblim-cim-client2-2.1.1.jar:"$JAXWS_HOME/lib/*":${CLASSPATH}

# export LIBDIR=../lib

# encode non-optional system properties here
# sample.properties.files is a comma delimited list of file names to use
# for additional system properties.
export SAMPLE_PROPERTIES=" -Dsamples.trustAll=true -Djava.util.logging.config.file=logging.properties"


# set max heap size here
export XMX_SIZE=1024M

export MAIN_CLASS=com.vmware.common.Main

# calculates JAVA_HOME
if [ "x${JAVA_HOME}" = "x" ]
then
# some of our samples use JAVAHOME instead of JAVA_HOME allow for both.
if [ "x${JAVAHOME}" = "x" ]
then
echo JAVA_HOME not defined. Must be defined to run java apps.
exit
fi
export JAVA_HOME="${JAVAHOME}"
fi

exec ${JAVA_HOME}/bin/java ${SAMPLE_PROPERTIES} \
-cp ${LOCALCLASSPATH} \
-Xmx$XMX_SIZE \
$MAIN_CLASS "$@"

