#!/bin/bash

set -e

export PATH="$JAVA_HOME"/bin:$PATH

if [[ "$1" =~ ^\? ]];
then
cat <<EOF
   build.sh command line options
   no parameters - full compilation
   -s generate and compile only the client stubs
   -w compile the client application without re-generating the client stubs
EOF
fi

if [ $# -eq 0 ]
then
   echo "Building vim25 stubs and samples..."
   . build_vim25.sh ; . build_samples.sh
fi

if [ "$1" == "-s" ];
then
   echo "Only building vim25 Stubs..."
   . build_vim25.sh
fi

if [ "$1" == "-w" ];
then
   echo "Only building samples..."
   . build_samples.sh
fi

if [ $#  == 2 ]; then
    exit 1
fi
