#!/bin/bash

set -e

VSPHERE_WS_JAXWS_DIR="$PWD"
echo "$VSPHERE_WS_JAXWS_DIR"

echo "Building vSphere web service SDK samples....."

if [ -f "lib/wssamples.jar" ];
then
    echo "remove lib/wssamples.jar"
	rm -f lib/wssamples.jar
else
    echo "lib/ssosamples.jar does not exists"
fi


echo "Adding ssoclient.jar....."
pushd ../../../ssoclient/java/JAXWS/lib
cp  -f ssoclient.jar "$VSPHERE_WS_JAXWS_DIR"/lib

echo "Adding ssosamples.jar....."
if [ ! -f "ssosamples.jar" ];then
	echo "Missing ssosamples.jar... Triggerring the ssoclient build to generate one."
	cd ..
	. build.sh
	cd -
fi
cp -f ssosamples.jar "$VSPHERE_WS_JAXWS_DIR"/lib
popd

ls "$VSPHERE_WS_JAXWS_DIR"/lib

export PATH=$JAVA_HOME/bin:$PATH
echo "$PATH"
pushd ../../../libs/jaxws-ri/
export JAXWS_HOME=$PWD
echo "$JAXWS_HOME"
popd
export LOCALCLASSPATH=$PWD/lib/*:$JAXWS_HOME/lib/*
echo "$LOCALCLASSPATH"

for i in lib/*.jar
 do
    export LOCALCLASSPATH=$LOCALCLASSPATH:$PWD/$i
done

cd samples
find com/vmware -name *.java > java_src.txt

echo "Compiling samples"
javac -cp "$LOCALCLASSPATH" -source 8 -target 8  @java_src.txt

echo "Jarring samples"
jar cf ../lib/wssamples.jar com/vmware/alarms/*.class com/vmware/cim/*.class com/vmware/cim/helpers/*.class com/vmware/connection/*.class com/vmware/connection/helpers/*.class com/vmware/connection/helpers/builders/*.class com/vmware/events/*.class com/vmware/fcd/*.class com/vmware/fcd/helpers/*.class com/vmware/general/*.class com/vmware/guest/*.class com/vmware/host/*.class com/vmware/httpfileaccess/*.class com/vmware/performance/*.class com/vmware/performance/widgets/*.class com/vmware/scheduling/*.class com/vmware/scsilun/*.class com/vmware/security/credstore/*.class com/vmware/simpleagent/*.class com/vmware/storage/*.class com/vmware/vapp/*.class com/vmware/vm/*.class com/vmware/hci/*.class

echo "Generating javadocs for samples"
javadoc -J-Xms512m -J-Xmx512m -Xdoclint:none -sourcepath . -classpath "$LOCALCLASSPATH" -d ../../../docs/java/JAXWS/samples/javadoc -public -windowtitle "VMware vSphere Web Services SDK JAXWS Java Samples Documentation" -doctitle "<html><body>VMware vSphere Web Services SDK JAXWS Java Samples Reference Documentation<a name=topofpage></a>" -overview ../../../docresources/vsphere-ws-jaxws-samples-overview.html -nohelp -subpackages com.vmware -exclude com.vmware.vim25:com.vmware.common:com.vmware.samples:javax.wbem.client:javax.cim

find com/vmware -type f -name "*.class" -exec rm {} \;
rm -f java_*.txt
rm -f *.class
cd ..
rm -rf com
