#!/bin/bash

set -e

if [ -z "$WSDLNAME" ]
then
	export WSDLNAME=vimService.wsdl
else
    echo "${WSDLNAME} is NOT empty"
fi

if [ -z  "$WSDLPATH" ]
then
	pushd ../../wsdl/vim25
	export WSDLPATH=$PWD
	popd
else
    echo "${WSDLPATH} is NOT empty"
fi

pushd ../../../libs/jaxws-ri
export JAXWS_HOME=$PWD

echo "current directory"$JAXWS_HOME

popd

if [[ -d "samples/com/vmware/vim25" ]]
then
	 rm -rf samples/com/vmware/vim25
fi

echo "Creating samples/com/vmware/vim25 directory"
mkdir -p samples/com/vmware/vim25

if [ -f "lib/vim25.jar" ]
then
	rm lib/vim25.jar
fi
echo "Copying the wsdl files"
echo "$WSDLPATH"
cp  -R "$WSDLPATH" samples/com/vmware/

echo "Generating vim25 stubs from wsdl changes is adding smaples."
RC=$(  {  source $JAXWS_HOME/bin/wsimport.sh  -wsdllocation "$WSDLNAME" -p com.vmware.vim25 -s samples "$WSDLPATH/$WSDLNAME" ; })
echo ${RC}

# fix VimService class to get the wsdl from the vim25.jar
echo "Applying the FixJaxWsWsdlResource to VimService.java"
java -classpath lib/ FixJaxWsWsdlResource "$PWD/samples/com/vmware/vim25/VimService.java" VimService

echo "Compiling vim25 Stubs"
javac -cp "$JAXWS_HOME/lib/*" samples/com/vmware/vim25/*.java -source 8 -target 8

echo "Jarring vim25 Stubs"
cd samples
jar cf ../lib/vim25.jar com/vmware/vim25/*.class com/vmware/vim25/*.wsdl com/vmware/vim25/*.xsd
cd ..

echo "Cleaning generated code"
rm -f samples/com/vmware/vim25*.wsdl
rm  -f samples/com/vmware/vim25/*.xsd
rm -f samples/com/vmware/vim25/*.class
rm -f samples/com/vmware/vim25/*.java

echo "Done generating vim25 stubs from wsdl"
