
package com.vmware.vslm;

import java.util.List;
import com.vmware.vim25.CryptoSpec;
import com.vmware.vim25.DiskChangeInfo;
import com.vmware.vim25.DiskCryptoSpec;
import com.vmware.vim25.ID;
import com.vmware.vim25.KeyValue;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VStorageObject;
import com.vmware.vim25.VStorageObjectSnapshotDetails;
import com.vmware.vim25.VStorageObjectSnapshotInfo;
import com.vmware.vim25.VStorageObjectStateInfo;
import com.vmware.vim25.VirtualMachineProfileSpec;
import com.vmware.vim25.VslmCloneSpec;
import com.vmware.vim25.VslmCreateSpec;
import com.vmware.vim25.VslmInfrastructureObjectPolicy;
import com.vmware.vim25.VslmInfrastructureObjectPolicySpec;
import com.vmware.vim25.VslmRelocateSpec;
import com.vmware.vim25.VslmTagEntry;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 3.0.2
 * Generated source version: 3.0
 * 
 */
@WebService(name = "VslmPortType", targetNamespace = "urn:vslm")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface VslmPortType {


    /**
     * 
     * @param _this
     * @return
     *     returns com.vmware.vslm.VslmServiceInstanceContent
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "RetrieveContent", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "RetrieveContent", targetNamespace = "urn:vslm", className = "com.vmware.vslm.RetrieveContentRequestType")
    @ResponseWrapper(localName = "RetrieveContentResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.RetrieveContentResponse")
    public VslmServiceInstanceContent retrieveContent(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param datastoreUrl
     * @param fcdId
     * @param _this
     * @param fullSync
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmSyncFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmSyncDatastore", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmSyncDatastore", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmSyncDatastoreRequestType")
    @ResponseWrapper(localName = "VslmSyncDatastoreResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmSyncDatastoreResponse")
    public void vslmSyncDatastore(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "datastoreUrl", targetNamespace = "urn:vslm")
        String datastoreUrl,
        @WebParam(name = "fullSync", targetNamespace = "urn:vslm")
        boolean fullSync,
        @WebParam(name = "fcdId", targetNamespace = "urn:vslm")
        ID fcdId)
        throws InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg, VslmSyncFaultFaultMsg
    ;

    /**
     * 
     * @param datastoreUrl
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.vslm.VslmQueryDatastoreInfoResult>
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmQueryDatastoreInfo", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmQueryDatastoreInfo", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryDatastoreInfoRequestType")
    @ResponseWrapper(localName = "VslmQueryDatastoreInfoResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryDatastoreInfoResponse")
    public List<VslmQueryDatastoreInfoResult> vslmQueryDatastoreInfo(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "datastoreUrl", targetNamespace = "urn:vslm")
        String datastoreUrl)
        throws NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @return
     *     returns java.lang.Object
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmQueryTaskResult", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmQueryTaskResult", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryTaskResultRequestType")
    @ResponseWrapper(localName = "VslmQueryTaskResultResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryTaskResultResponse")
    public Object vslmQueryTaskResult(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @return
     *     returns com.vmware.vslm.VslmTaskInfo
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmQueryInfo", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmQueryInfo", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryInfoRequestType")
    @ResponseWrapper(localName = "VslmQueryInfoResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryInfoResponse")
    public VslmTaskInfo vslmQueryInfo(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmCancelTask", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmCancelTask", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCancelTaskRequestType")
    @ResponseWrapper(localName = "VslmCancelTaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCancelTaskResponse")
    public void vslmCancelTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this)
        throws InvalidStateFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param delegatedTokenXml
     * @param _this
     * @throws InvalidLoginFaultMsg
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmLoginByToken", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmLoginByToken", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmLoginByTokenRequestType")
    @ResponseWrapper(localName = "VslmLoginByTokenResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmLoginByTokenResponse")
    public void vslmLoginByToken(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "delegatedTokenXml", targetNamespace = "urn:vslm")
        String delegatedTokenXml)
        throws InvalidLoginFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmLogout", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmLogout", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmLogoutRequestType")
    @ResponseWrapper(localName = "VslmLogoutResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmLogoutResponse")
    public void vslmLogout(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @param spec
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmCreateDisk_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmCreateDisk_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCreateDiskRequestType")
    @ResponseWrapper(localName = "VslmCreateDisk_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCreateDiskTaskResponse")
    public ManagedObjectReference vslmCreateDiskTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "spec", targetNamespace = "urn:vslm")
        VslmCreateSpec spec)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param path
     * @param name
     * @param _this
     * @return
     *     returns com.vmware.vim25.VStorageObject
     * @throws RuntimeFaultFaultMsg
     * @throws AlreadyExistsFaultMsg
     * @throws VslmSyncFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRegisterDisk", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRegisterDisk", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRegisterDiskRequestType")
    @ResponseWrapper(localName = "VslmRegisterDiskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRegisterDiskResponse")
    public VStorageObject vslmRegisterDisk(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "path", targetNamespace = "urn:vslm")
        String path,
        @WebParam(name = "name", targetNamespace = "urn:vslm")
        String name)
        throws AlreadyExistsFaultMsg, FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg, VslmSyncFaultFaultMsg
    ;

    /**
     * 
     * @param newCapacityInMB
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws TaskInProgressFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmExtendDisk_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmExtendDisk_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmExtendDiskRequestType")
    @ResponseWrapper(localName = "VslmExtendDisk_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmExtendDiskTaskResponse")
    public ManagedObjectReference vslmExtendDiskTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "newCapacityInMB", targetNamespace = "urn:vslm")
        long newCapacityInMB)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws TaskInProgressFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmInflateDisk_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmInflateDisk_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmInflateDiskRequestType")
    @ResponseWrapper(localName = "VslmInflateDisk_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmInflateDiskTaskResponse")
    public ManagedObjectReference vslmInflateDiskTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param name
     * @param id
     * @param _this
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmSyncFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRenameVStorageObject", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmRenameVStorageObject", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRenameVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmRenameVStorageObjectResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRenameVStorageObjectResponse")
    public void vslmRenameVStorageObject(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "name", targetNamespace = "urn:vslm")
        String name)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg, VslmSyncFaultFaultMsg
    ;

    /**
     * 
     * @param profile
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws TaskInProgressFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmUpdateVstorageObjectPolicy_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmUpdateVstorageObjectPolicy_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVstorageObjectPolicyRequestType")
    @ResponseWrapper(localName = "VslmUpdateVstorageObjectPolicy_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVstorageObjectPolicyTaskResponse")
    public ManagedObjectReference vslmUpdateVstorageObjectPolicyTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "profile", targetNamespace = "urn:vslm")
        List<VirtualMachineProfileSpec> profile)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param disksCrypto
     * @param profile
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws TaskInProgressFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmUpdateVstorageObjectCrypto_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmUpdateVstorageObjectCrypto_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVstorageObjectCryptoRequestType")
    @ResponseWrapper(localName = "VslmUpdateVstorageObjectCrypto_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVstorageObjectCryptoTaskResponse")
    public ManagedObjectReference vslmUpdateVstorageObjectCryptoTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "profile", targetNamespace = "urn:vslm")
        List<VirtualMachineProfileSpec> profile,
        @WebParam(name = "disksCrypto", targetNamespace = "urn:vslm")
        DiskCryptoSpec disksCrypto)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @param spec
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws TaskInProgressFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmUpdateVStorageInfrastructureObjectPolicy_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmUpdateVStorageInfrastructureObjectPolicy_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVStorageInfrastructureObjectPolicyRequestType")
    @ResponseWrapper(localName = "VslmUpdateVStorageInfrastructureObjectPolicy_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVStorageInfrastructureObjectPolicyTaskResponse")
    public ManagedObjectReference vslmUpdateVStorageInfrastructureObjectPolicyTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "spec", targetNamespace = "urn:vslm")
        VslmInfrastructureObjectPolicySpec spec)
        throws InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param datastore
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.vim25.VslmInfrastructureObjectPolicy>
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveVStorageInfrastructureObjectPolicy", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveVStorageInfrastructureObjectPolicy", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageInfrastructureObjectPolicyRequestType")
    @ResponseWrapper(localName = "VslmRetrieveVStorageInfrastructureObjectPolicyResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageInfrastructureObjectPolicyResponse")
    public List<VslmInfrastructureObjectPolicy> vslmRetrieveVStorageInfrastructureObjectPolicy(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "datastore", targetNamespace = "urn:vslm")
        ManagedObjectReference datastore)
        throws InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws TaskInProgressFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmDeleteVStorageObject_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmDeleteVStorageObject_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmDeleteVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmDeleteVStorageObject_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmDeleteVStorageObjectTaskResponse")
    public ManagedObjectReference vslmDeleteVStorageObjectTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.VStorageObject
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveVStorageObject", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveVStorageObject", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmRetrieveVStorageObjectResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectResponse")
    public VStorageObject vslmRetrieveVStorageObject(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.VStorageObjectStateInfo
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveVStorageObjectState", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveVStorageObjectState", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectStateRequestType")
    @ResponseWrapper(localName = "VslmRetrieveVStorageObjectStateResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectStateResponse")
    public VStorageObjectStateInfo vslmRetrieveVStorageObjectState(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param ids
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.vslm.VslmVsoVStorageObjectAssociations>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveVStorageObjectAssociations", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveVStorageObjectAssociations", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectAssociationsRequestType")
    @ResponseWrapper(localName = "VslmRetrieveVStorageObjectAssociationsResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectAssociationsResponse")
    public List<VslmVsoVStorageObjectAssociations> vslmRetrieveVStorageObjectAssociations(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "ids", targetNamespace = "urn:vslm")
        List<ID> ids)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param maxResult
     * @param query
     * @param _this
     * @return
     *     returns com.vmware.vslm.VslmVsoVStorageObjectQueryResult
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmListVStorageObjectForSpec", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmListVStorageObjectForSpec", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmListVStorageObjectForSpecRequestType")
    @ResponseWrapper(localName = "VslmListVStorageObjectForSpecResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmListVStorageObjectForSpecResponse")
    public VslmVsoVStorageObjectQueryResult vslmListVStorageObjectForSpec(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "query", targetNamespace = "urn:vslm")
        List<VslmVsoVStorageObjectQuerySpec> query,
        @WebParam(name = "maxResult", targetNamespace = "urn:vslm")
        int maxResult)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @param spec
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmCloneVStorageObject_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmCloneVStorageObject_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCloneVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmCloneVStorageObject_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCloneVStorageObjectTaskResponse")
    public ManagedObjectReference vslmCloneVStorageObjectTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "spec", targetNamespace = "urn:vslm")
        VslmCloneSpec spec)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @param spec
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRelocateVStorageObject_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRelocateVStorageObject_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRelocateVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmRelocateVStorageObject_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRelocateVStorageObjectTaskResponse")
    public ManagedObjectReference vslmRelocateVStorageObjectTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "spec", targetNamespace = "urn:vslm")
        VslmRelocateSpec spec)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param controlFlags
     * @param id
     * @param _this
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmSetVStorageObjectControlFlags", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmSetVStorageObjectControlFlags", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmSetVStorageObjectControlFlagsRequestType")
    @ResponseWrapper(localName = "VslmSetVStorageObjectControlFlagsResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmSetVStorageObjectControlFlagsResponse")
    public void vslmSetVStorageObjectControlFlags(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "controlFlags", targetNamespace = "urn:vslm")
        List<String> controlFlags)
        throws InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param controlFlags
     * @param id
     * @param _this
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmClearVStorageObjectControlFlags", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmClearVStorageObjectControlFlags", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmClearVStorageObjectControlFlagsRequestType")
    @ResponseWrapper(localName = "VslmClearVStorageObjectControlFlagsResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmClearVStorageObjectControlFlagsResponse")
    public void vslmClearVStorageObjectControlFlags(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "controlFlags", targetNamespace = "urn:vslm")
        List<String> controlFlags)
        throws InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param tag
     * @param _this
     * @param category
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmAttachTagToVStorageObject", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmAttachTagToVStorageObject", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmAttachTagToVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmAttachTagToVStorageObjectResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmAttachTagToVStorageObjectResponse")
    public void vslmAttachTagToVStorageObject(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "category", targetNamespace = "urn:vslm")
        String category,
        @WebParam(name = "tag", targetNamespace = "urn:vslm")
        String tag)
        throws NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param tag
     * @param _this
     * @param category
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmDetachTagFromVStorageObject", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmDetachTagFromVStorageObject", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmDetachTagFromVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmDetachTagFromVStorageObjectResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmDetachTagFromVStorageObjectResponse")
    public void vslmDetachTagFromVStorageObject(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "category", targetNamespace = "urn:vslm")
        String category,
        @WebParam(name = "tag", targetNamespace = "urn:vslm")
        String tag)
        throws NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param tag
     * @param _this
     * @param category
     * @return
     *     returns java.util.List<com.vmware.vim25.ID>
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmListVStorageObjectsAttachedToTag", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmListVStorageObjectsAttachedToTag", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmListVStorageObjectsAttachedToTagRequestType")
    @ResponseWrapper(localName = "VslmListVStorageObjectsAttachedToTagResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmListVStorageObjectsAttachedToTagResponse")
    public List<ID> vslmListVStorageObjectsAttachedToTag(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "category", targetNamespace = "urn:vslm")
        String category,
        @WebParam(name = "tag", targetNamespace = "urn:vslm")
        String tag)
        throws NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.vim25.VslmTagEntry>
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmListTagsAttachedToVStorageObject", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmListTagsAttachedToVStorageObject", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmListTagsAttachedToVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmListTagsAttachedToVStorageObjectResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmListTagsAttachedToVStorageObjectResponse")
    public List<VslmTagEntry> vslmListTagsAttachedToVStorageObject(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id)
        throws NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param datastore
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmReconcileDatastoreInventory_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmReconcileDatastoreInventory_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmReconcileDatastoreInventoryRequestType")
    @ResponseWrapper(localName = "VslmReconcileDatastoreInventory_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmReconcileDatastoreInventoryTaskResponse")
    public ManagedObjectReference vslmReconcileDatastoreInventoryTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "datastore", targetNamespace = "urn:vslm")
        ManagedObjectReference datastore)
        throws InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param datastore
     * @param _this
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmScheduleReconcileDatastoreInventory", action = "urn:vslm/7.0.2.0")
    @RequestWrapper(localName = "VslmScheduleReconcileDatastoreInventory", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmScheduleReconcileDatastoreInventoryRequestType")
    @ResponseWrapper(localName = "VslmScheduleReconcileDatastoreInventoryResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmScheduleReconcileDatastoreInventoryResponse")
    public void vslmScheduleReconcileDatastoreInventory(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "datastore", targetNamespace = "urn:vslm")
        ManagedObjectReference datastore)
        throws InvalidDatastoreFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param description
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmCreateSnapshot_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmCreateSnapshot_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCreateSnapshotRequestType")
    @ResponseWrapper(localName = "VslmCreateSnapshot_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCreateSnapshotTaskResponse")
    public ManagedObjectReference vslmCreateSnapshotTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "description", targetNamespace = "urn:vslm")
        String description)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param snapshotId
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmDeleteSnapshot_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmDeleteSnapshot_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmDeleteSnapshotRequestType")
    @ResponseWrapper(localName = "VslmDeleteSnapshot_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmDeleteSnapshotTaskResponse")
    public ManagedObjectReference vslmDeleteSnapshotTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "snapshotId", targetNamespace = "urn:vslm")
        ID snapshotId)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.VStorageObjectSnapshotInfo
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveSnapshotInfo", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveSnapshotInfo", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveSnapshotInfoRequestType")
    @ResponseWrapper(localName = "VslmRetrieveSnapshotInfoResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveSnapshotInfoResponse")
    public VStorageObjectSnapshotInfo vslmRetrieveSnapshotInfo(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param path
     * @param snapshotId
     * @param profile
     * @param name
     * @param id
     * @param _this
     * @param crypto
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmCreateDiskFromSnapshot_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmCreateDiskFromSnapshot_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCreateDiskFromSnapshotRequestType")
    @ResponseWrapper(localName = "VslmCreateDiskFromSnapshot_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmCreateDiskFromSnapshotTaskResponse")
    public ManagedObjectReference vslmCreateDiskFromSnapshotTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "snapshotId", targetNamespace = "urn:vslm")
        ID snapshotId,
        @WebParam(name = "name", targetNamespace = "urn:vslm")
        String name,
        @WebParam(name = "profile", targetNamespace = "urn:vslm")
        List<VirtualMachineProfileSpec> profile,
        @WebParam(name = "crypto", targetNamespace = "urn:vslm")
        CryptoSpec crypto,
        @WebParam(name = "path", targetNamespace = "urn:vslm")
        String path)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param snapshotId
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRevertVStorageObject_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRevertVStorageObject_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRevertVStorageObjectRequestType")
    @ResponseWrapper(localName = "VslmRevertVStorageObject_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRevertVStorageObjectTaskResponse")
    public ManagedObjectReference vslmRevertVStorageObjectTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "snapshotId", targetNamespace = "urn:vslm")
        ID snapshotId)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param snapshotId
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.VStorageObjectSnapshotDetails
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveSnapshotDetails", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveSnapshotDetails", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveSnapshotDetailsRequestType")
    @ResponseWrapper(localName = "VslmRetrieveSnapshotDetailsResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveSnapshotDetailsResponse")
    public VStorageObjectSnapshotDetails vslmRetrieveSnapshotDetails(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "snapshotId", targetNamespace = "urn:vslm")
        ID snapshotId)
        throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param snapshotId
     * @param startOffset
     * @param id
     * @param changeId
     * @param _this
     * @return
     *     returns com.vmware.vim25.DiskChangeInfo
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidArgumentFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmQueryChangedDiskAreas", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmQueryChangedDiskAreas", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryChangedDiskAreasRequestType")
    @ResponseWrapper(localName = "VslmQueryChangedDiskAreasResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryChangedDiskAreasResponse")
    public DiskChangeInfo vslmQueryChangedDiskAreas(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "snapshotId", targetNamespace = "urn:vslm")
        ID snapshotId,
        @WebParam(name = "startOffset", targetNamespace = "urn:vslm")
        long startOffset,
        @WebParam(name = "changeId", targetNamespace = "urn:vslm")
        String changeId)
        throws FileFaultFaultMsg, InvalidArgumentFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.vslm.VslmDatastoreSyncStatus>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmQueryGlobalCatalogSyncStatus", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmQueryGlobalCatalogSyncStatus", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryGlobalCatalogSyncStatusRequestType")
    @ResponseWrapper(localName = "VslmQueryGlobalCatalogSyncStatusResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryGlobalCatalogSyncStatusResponse")
    public List<VslmDatastoreSyncStatus> vslmQueryGlobalCatalogSyncStatus(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param datastoreURL
     * @param _this
     * @return
     *     returns com.vmware.vslm.VslmDatastoreSyncStatus
     * @throws NotFoundFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmQueryGlobalCatalogSyncStatusForDatastore", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmQueryGlobalCatalogSyncStatusForDatastore", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryGlobalCatalogSyncStatusForDatastoreRequestType")
    @ResponseWrapper(localName = "VslmQueryGlobalCatalogSyncStatusForDatastoreResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmQueryGlobalCatalogSyncStatusForDatastoreResponse")
    public VslmDatastoreSyncStatus vslmQueryGlobalCatalogSyncStatusForDatastore(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "datastoreURL", targetNamespace = "urn:vslm")
        String datastoreURL)
        throws NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param metadata
     * @param deleteKeys
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmUpdateVStorageObjectMetadata_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmUpdateVStorageObjectMetadata_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVStorageObjectMetadataRequestType")
    @ResponseWrapper(localName = "VslmUpdateVStorageObjectMetadata_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmUpdateVStorageObjectMetadataTaskResponse")
    public ManagedObjectReference vslmUpdateVStorageObjectMetadataTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "metadata", targetNamespace = "urn:vslm")
        List<KeyValue> metadata,
        @WebParam(name = "deleteKeys", targetNamespace = "urn:vslm")
        List<String> deleteKeys)
        throws InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param snapshotId
     * @param prefix
     * @param id
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.vim25.KeyValue>
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveVStorageObjectMetadata", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveVStorageObjectMetadata", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectMetadataRequestType")
    @ResponseWrapper(localName = "VslmRetrieveVStorageObjectMetadataResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectMetadataResponse")
    public List<KeyValue> vslmRetrieveVStorageObjectMetadata(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "snapshotId", targetNamespace = "urn:vslm")
        ID snapshotId,
        @WebParam(name = "prefix", targetNamespace = "urn:vslm")
        String prefix)
        throws InvalidDatastoreFaultMsg, InvalidStateFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param snapshotId
     * @param id
     * @param _this
     * @param key
     * @return
     *     returns java.lang.String
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws KeyNotFoundFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveVStorageObjectMetadataValue", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveVStorageObjectMetadataValue", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectMetadataValueRequestType")
    @ResponseWrapper(localName = "VslmRetrieveVStorageObjectMetadataValueResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectMetadataValueResponse")
    public String vslmRetrieveVStorageObjectMetadataValue(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "snapshotId", targetNamespace = "urn:vslm")
        ID snapshotId,
        @WebParam(name = "key", targetNamespace = "urn:vslm")
        String key)
        throws InvalidDatastoreFaultMsg, InvalidStateFaultMsg, KeyNotFoundFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VslmFaultFaultMsg
    ;

    /**
     * 
     * @param ids
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.vslm.VslmVsoVStorageObjectResult>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "VslmRetrieveVStorageObjects", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmRetrieveVStorageObjects", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectsRequestType")
    @ResponseWrapper(localName = "VslmRetrieveVStorageObjectsResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmRetrieveVStorageObjectsResponse")
    public List<VslmVsoVStorageObjectResult> vslmRetrieveVStorageObjects(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "ids", targetNamespace = "urn:vslm")
        List<ID> ids)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param vm
     * @param controllerKey
     * @param unitNumber
     * @param id
     * @param _this
     * @return
     *     returns com.vmware.vim25.ManagedObjectReference
     * @throws NotFoundFaultMsg
     * @throws InvalidStateFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws DeviceUnsupportedForVmVersionFaultMsg
     * @throws InvalidControllerFaultMsg
     * @throws MissingControllerFaultMsg
     * @throws InvalidDatastoreFaultMsg
     * @throws VslmFaultFaultMsg
     * @throws VmConfigFaultFaultMsg
     * @throws FileFaultFaultMsg
     */
    @WebMethod(operationName = "VslmAttachDisk_Task", action = "urn:vslm/7.0.2.0")
    @WebResult(name = "returnval", targetNamespace = "urn:vslm")
    @RequestWrapper(localName = "VslmAttachDisk_Task", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmAttachDiskRequestType")
    @ResponseWrapper(localName = "VslmAttachDisk_TaskResponse", targetNamespace = "urn:vslm", className = "com.vmware.vslm.VslmAttachDiskTaskResponse")
    public ManagedObjectReference vslmAttachDiskTask(
        @WebParam(name = "_this", targetNamespace = "urn:vslm")
        ManagedObjectReference _this,
        @WebParam(name = "id", targetNamespace = "urn:vslm")
        ID id,
        @WebParam(name = "vm", targetNamespace = "urn:vslm")
        ManagedObjectReference vm,
        @WebParam(name = "controllerKey", targetNamespace = "urn:vslm")
        Integer controllerKey,
        @WebParam(name = "unitNumber", targetNamespace = "urn:vslm")
        Integer unitNumber)
        throws DeviceUnsupportedForVmVersionFaultMsg, FileFaultFaultMsg, InvalidControllerFaultMsg, InvalidDatastoreFaultMsg, InvalidStateFaultMsg, MissingControllerFaultMsg, NotFoundFaultMsg, RuntimeFaultFaultMsg, VmConfigFaultFaultMsg, VslmFaultFaultMsg
    ;

}
