
package com.vmware.vslm;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for VslmTaskInfoState.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>
 * &lt;simpleType name="VslmTaskInfoState"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="queued"/&gt;
 *     &lt;enumeration value="running"/&gt;
 *     &lt;enumeration value="success"/&gt;
 *     &lt;enumeration value="error"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "VslmTaskInfoState")
@XmlEnum
public enum VslmTaskInfoState {

    @XmlEnumValue("queued")
    QUEUED("queued"),
    @XmlEnumValue("running")
    RUNNING("running"),
    @XmlEnumValue("success")
    SUCCESS("success"),
    @XmlEnumValue("error")
    ERROR("error");
    private final String value;

    VslmTaskInfoState(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static VslmTaskInfoState fromValue(String v) {
        for (VslmTaskInfoState c: VslmTaskInfoState.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
