
package com.vmware.vslm;

import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import com.vmware.vim25.DynamicData;
import com.vmware.vim25.ID;
import com.vmware.vim25.KeyValue;
import com.vmware.vim25.LocalizedMethodFault;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for VslmVsoVStorageObjectResult complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="VslmVsoVStorageObjectResult"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:vim25}DynamicData"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="id" type="{urn:vim25}ID"/&gt;
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="capacityInMB" type="{http://www.w3.org/2001/XMLSchema}long"/&gt;
 *         &lt;element name="createTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/&gt;
 *         &lt;element name="datastoreUrl" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="diskPath" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="usedCapacityInMB" type="{http://www.w3.org/2001/XMLSchema}long" minOccurs="0"/&gt;
 *         &lt;element name="backingObjectId" type="{urn:vim25}ID" minOccurs="0"/&gt;
 *         &lt;element name="snapshotInfo" type="{urn:vslm}VslmVsoVStorageObjectSnapshotResult" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="metadata" type="{urn:vim25}KeyValue" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="error" type="{urn:vim25}LocalizedMethodFault" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "VslmVsoVStorageObjectResult", propOrder = {
    "id",
    "name",
    "capacityInMB",
    "createTime",
    "datastoreUrl",
    "diskPath",
    "usedCapacityInMB",
    "backingObjectId",
    "snapshotInfo",
    "metadata",
    "error"
})
public class VslmVsoVStorageObjectResult
    extends DynamicData
{

    @XmlElement(required = true)
    protected ID id;
    protected String name;
    protected long capacityInMB;
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar createTime;
    protected String datastoreUrl;
    protected String diskPath;
    protected Long usedCapacityInMB;
    protected ID backingObjectId;
    protected List<VslmVsoVStorageObjectSnapshotResult> snapshotInfo;
    protected List<KeyValue> metadata;
    protected LocalizedMethodFault error;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link ID }
     *     
     */
    public ID getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link ID }
     *     
     */
    public void setId(ID value) {
        this.id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the capacityInMB property.
     * 
     */
    public long getCapacityInMB() {
        return capacityInMB;
    }

    /**
     * Sets the value of the capacityInMB property.
     * 
     */
    public void setCapacityInMB(long value) {
        this.capacityInMB = value;
    }

    /**
     * Gets the value of the createTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCreateTime() {
        return createTime;
    }

    /**
     * Sets the value of the createTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCreateTime(XMLGregorianCalendar value) {
        this.createTime = value;
    }

    /**
     * Gets the value of the datastoreUrl property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDatastoreUrl() {
        return datastoreUrl;
    }

    /**
     * Sets the value of the datastoreUrl property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDatastoreUrl(String value) {
        this.datastoreUrl = value;
    }

    /**
     * Gets the value of the diskPath property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDiskPath() {
        return diskPath;
    }

    /**
     * Sets the value of the diskPath property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDiskPath(String value) {
        this.diskPath = value;
    }

    /**
     * Gets the value of the usedCapacityInMB property.
     * 
     * @return
     *     possible object is
     *     {@link Long }
     *     
     */
    public Long getUsedCapacityInMB() {
        return usedCapacityInMB;
    }

    /**
     * Sets the value of the usedCapacityInMB property.
     * 
     * @param value
     *     allowed object is
     *     {@link Long }
     *     
     */
    public void setUsedCapacityInMB(Long value) {
        this.usedCapacityInMB = value;
    }

    /**
     * Gets the value of the backingObjectId property.
     * 
     * @return
     *     possible object is
     *     {@link ID }
     *     
     */
    public ID getBackingObjectId() {
        return backingObjectId;
    }

    /**
     * Sets the value of the backingObjectId property.
     * 
     * @param value
     *     allowed object is
     *     {@link ID }
     *     
     */
    public void setBackingObjectId(ID value) {
        this.backingObjectId = value;
    }

    /**
     * Gets the value of the snapshotInfo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the snapshotInfo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSnapshotInfo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VslmVsoVStorageObjectSnapshotResult }
     * 
     * 
     */
    public List<VslmVsoVStorageObjectSnapshotResult> getSnapshotInfo() {
        if (snapshotInfo == null) {
            snapshotInfo = new ArrayList<VslmVsoVStorageObjectSnapshotResult>();
        }
        return this.snapshotInfo;
    }

    /**
     * Gets the value of the metadata property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the metadata property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMetadata().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link KeyValue }
     * 
     * 
     */
    public List<KeyValue> getMetadata() {
        if (metadata == null) {
            metadata = new ArrayList<KeyValue>();
        }
        return this.metadata;
    }

    /**
     * Gets the value of the error property.
     * 
     * @return
     *     possible object is
     *     {@link LocalizedMethodFault }
     *     
     */
    public LocalizedMethodFault getError() {
        return error;
    }

    /**
     * Sets the value of the error property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocalizedMethodFault }
     *     
     */
    public void setError(LocalizedMethodFault value) {
        this.error = value;
    }

}
