
package com.vmware.pbm;

import java.util.List;
import com.vmware.vim25.ManagedObjectReference;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 3.0.2
 * Generated source version: 3.0
 * 
 */
@WebService(name = "PbmPortType", targetNamespace = "urn:pbm")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface PbmPortType {


    /**
     * 
     * @param _this
     * @return
     *     returns com.vmware.pbm.PbmServiceInstanceContent
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmRetrieveServiceContent", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmRetrieveServiceContent", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmRetrieveServiceContentRequestType")
    @ResponseWrapper(localName = "PbmRetrieveServiceContentResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmRetrieveServiceContentResponse")
    public PbmServiceInstanceContent pbmRetrieveServiceContent(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param entities
     * @param profile
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmComplianceResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmCheckCompliance", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmCheckCompliance", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckComplianceRequestType")
    @ResponseWrapper(localName = "PbmCheckComplianceResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckComplianceResponse")
    public List<PbmComplianceResult> pbmCheckCompliance(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "entities", targetNamespace = "urn:pbm")
        List<PbmServerObjectRef> entities,
        @WebParam(name = "profile", targetNamespace = "urn:pbm")
        PbmProfileId profile)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param entities
     * @param profile
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmComplianceResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmFetchComplianceResult", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmFetchComplianceResult", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchComplianceResultRequestType")
    @ResponseWrapper(localName = "PbmFetchComplianceResultResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchComplianceResultResponse")
    public List<PbmComplianceResult> pbmFetchComplianceResult(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "entities", targetNamespace = "urn:pbm")
        List<PbmServerObjectRef> entities,
        @WebParam(name = "profile", targetNamespace = "urn:pbm")
        PbmProfileId profile)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @param entity
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmRollupComplianceResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmCheckRollupCompliance", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmCheckRollupCompliance", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckRollupComplianceRequestType")
    @ResponseWrapper(localName = "PbmCheckRollupComplianceResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckRollupComplianceResponse")
    public List<PbmRollupComplianceResult> pbmCheckRollupCompliance(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "entity", targetNamespace = "urn:pbm")
        List<PbmServerObjectRef> entity)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @param entity
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmRollupComplianceResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmFetchRollupComplianceResult", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmFetchRollupComplianceResult", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchRollupComplianceResultRequestType")
    @ResponseWrapper(localName = "PbmFetchRollupComplianceResultResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchRollupComplianceResultResponse")
    public List<PbmRollupComplianceResult> pbmFetchRollupComplianceResult(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "entity", targetNamespace = "urn:pbm")
        List<PbmServerObjectRef> entity)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @param status
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmServerObjectRef>
     * @throws InvalidArgumentFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryByRollupComplianceStatus", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryByRollupComplianceStatus", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryByRollupComplianceStatusRequestType")
    @ResponseWrapper(localName = "PbmQueryByRollupComplianceStatusResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryByRollupComplianceStatusResponse")
    public List<PbmServerObjectRef> pbmQueryByRollupComplianceStatus(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "status", targetNamespace = "urn:pbm")
        String status)
        throws InvalidArgumentFaultMsg, PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param hubsToSearch
     * @param profile
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmPlacementHub>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryMatchingHub", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryMatchingHub", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryMatchingHubRequestType")
    @ResponseWrapper(localName = "PbmQueryMatchingHubResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryMatchingHubResponse")
    public List<PbmPlacementHub> pbmQueryMatchingHub(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "hubsToSearch", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> hubsToSearch,
        @WebParam(name = "profile", targetNamespace = "urn:pbm")
        PbmProfileId profile)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param hubsToSearch
     * @param createSpec
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmPlacementHub>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryMatchingHubWithSpec", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryMatchingHubWithSpec", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryMatchingHubWithSpecRequestType")
    @ResponseWrapper(localName = "PbmQueryMatchingHubWithSpecResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryMatchingHubWithSpecResponse")
    public List<PbmPlacementHub> pbmQueryMatchingHubWithSpec(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "hubsToSearch", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> hubsToSearch,
        @WebParam(name = "createSpec", targetNamespace = "urn:pbm")
        PbmCapabilityProfileCreateSpec createSpec)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param hubsToSearch
     * @param profile
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmPlacementCompatibilityResult>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmCheckCompatibility", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmCheckCompatibility", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckCompatibilityRequestType")
    @ResponseWrapper(localName = "PbmCheckCompatibilityResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckCompatibilityResponse")
    public List<PbmPlacementCompatibilityResult> pbmCheckCompatibility(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "hubsToSearch", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> hubsToSearch,
        @WebParam(name = "profile", targetNamespace = "urn:pbm")
        PbmProfileId profile)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param hubsToSearch
     * @param profileSpec
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmPlacementCompatibilityResult>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmCheckCompatibilityWithSpec", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmCheckCompatibilityWithSpec", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckCompatibilityWithSpecRequestType")
    @ResponseWrapper(localName = "PbmCheckCompatibilityWithSpecResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckCompatibilityWithSpecResponse")
    public List<PbmPlacementCompatibilityResult> pbmCheckCompatibilityWithSpec(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "hubsToSearch", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> hubsToSearch,
        @WebParam(name = "profileSpec", targetNamespace = "urn:pbm")
        PbmCapabilityProfileCreateSpec profileSpec)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param hubsToSearch
     * @param placementSubjectRef
     * @param placementSubjectRequirement
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmPlacementCompatibilityResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmCheckRequirements", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmCheckRequirements", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckRequirementsRequestType")
    @ResponseWrapper(localName = "PbmCheckRequirementsResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCheckRequirementsResponse")
    public List<PbmPlacementCompatibilityResult> pbmCheckRequirements(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "hubsToSearch", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> hubsToSearch,
        @WebParam(name = "placementSubjectRef", targetNamespace = "urn:pbm")
        PbmServerObjectRef placementSubjectRef,
        @WebParam(name = "placementSubjectRequirement", targetNamespace = "urn:pbm")
        List<PbmPlacementRequirement> placementSubjectRequirement)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmProfileResourceType>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmFetchResourceType", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmFetchResourceType", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchResourceTypeRequestType")
    @ResponseWrapper(localName = "PbmFetchResourceTypeResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchResourceTypeResponse")
    public List<PbmProfileResourceType> pbmFetchResourceType(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @param resourceType
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmCapabilityVendorResourceTypeInfo>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmFetchVendorInfo", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmFetchVendorInfo", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchVendorInfoRequestType")
    @ResponseWrapper(localName = "PbmFetchVendorInfoResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchVendorInfoResponse")
    public List<PbmCapabilityVendorResourceTypeInfo> pbmFetchVendorInfo(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "resourceType", targetNamespace = "urn:pbm")
        PbmProfileResourceType resourceType)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param vendorUuid
     * @param _this
     * @param resourceType
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmCapabilityMetadataPerCategory>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmFetchCapabilityMetadata", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmFetchCapabilityMetadata", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchCapabilityMetadataRequestType")
    @ResponseWrapper(localName = "PbmFetchCapabilityMetadataResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchCapabilityMetadataResponse")
    public List<PbmCapabilityMetadataPerCategory> pbmFetchCapabilityMetadata(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "resourceType", targetNamespace = "urn:pbm")
        PbmProfileResourceType resourceType,
        @WebParam(name = "vendorUuid", targetNamespace = "urn:pbm")
        String vendorUuid)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param vendorUuid
     * @param _this
     * @param lineOfService
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmCapabilitySchema>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmFetchCapabilitySchema", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmFetchCapabilitySchema", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchCapabilitySchemaRequestType")
    @ResponseWrapper(localName = "PbmFetchCapabilitySchemaResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFetchCapabilitySchemaResponse")
    public List<PbmCapabilitySchema> pbmFetchCapabilitySchema(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "vendorUuid", targetNamespace = "urn:pbm")
        String vendorUuid,
        @WebParam(name = "lineOfService", targetNamespace = "urn:pbm")
        List<String> lineOfService)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param createSpec
     * @param _this
     * @return
     *     returns com.vmware.pbm.PbmProfileId
     * @throws InvalidArgumentFaultMsg
     * @throws PbmFaultProfileStorageFaultFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws PbmDuplicateNameFaultMsg
     */
    @WebMethod(operationName = "PbmCreate", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmCreate", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCreateRequestType")
    @ResponseWrapper(localName = "PbmCreateResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmCreateResponse")
    public PbmProfileId pbmCreate(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "createSpec", targetNamespace = "urn:pbm")
        PbmCapabilityProfileCreateSpec createSpec)
        throws InvalidArgumentFaultMsg, PbmDuplicateNameFaultMsg, PbmFaultProfileStorageFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param profileId
     * @param updateSpec
     * @param _this
     * @throws InvalidArgumentFaultMsg
     * @throws PbmFaultProfileStorageFaultFaultMsg
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmUpdate", action = "urn:pbm/8.0.1.0")
    @RequestWrapper(localName = "PbmUpdate", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmUpdateRequestType")
    @ResponseWrapper(localName = "PbmUpdateResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmUpdateResponse")
    public void pbmUpdate(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "profileId", targetNamespace = "urn:pbm")
        PbmProfileId profileId,
        @WebParam(name = "updateSpec", targetNamespace = "urn:pbm")
        PbmCapabilityProfileUpdateSpec updateSpec)
        throws InvalidArgumentFaultMsg, PbmFaultProfileStorageFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param profileId
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmProfileOperationOutcome>
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmDelete", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmDelete", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmDeleteRequestType")
    @ResponseWrapper(localName = "PbmDeleteResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmDeleteResponse")
    public List<PbmProfileOperationOutcome> pbmDelete(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "profileId", targetNamespace = "urn:pbm")
        List<PbmProfileId> profileId)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param profileCategory
     * @param _this
     * @param resourceType
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmProfileId>
     * @throws InvalidArgumentFaultMsg
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryProfile", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryProfile", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryProfileRequestType")
    @ResponseWrapper(localName = "PbmQueryProfileResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryProfileResponse")
    public List<PbmProfileId> pbmQueryProfile(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "resourceType", targetNamespace = "urn:pbm")
        PbmProfileResourceType resourceType,
        @WebParam(name = "profileCategory", targetNamespace = "urn:pbm")
        String profileCategory)
        throws InvalidArgumentFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param profileIds
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmProfile>
     * @throws InvalidArgumentFaultMsg
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmRetrieveContent", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmRetrieveContent", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmRetrieveContentRequestType")
    @ResponseWrapper(localName = "PbmRetrieveContentResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmRetrieveContentResponse")
    public List<PbmProfile> pbmRetrieveContent(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "profileIds", targetNamespace = "urn:pbm")
        List<PbmProfileId> profileIds)
        throws InvalidArgumentFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param entities
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmQueryProfileResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryAssociatedProfiles", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryAssociatedProfiles", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedProfilesRequestType")
    @ResponseWrapper(localName = "PbmQueryAssociatedProfilesResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedProfilesResponse")
    public List<PbmQueryProfileResult> pbmQueryAssociatedProfiles(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "entities", targetNamespace = "urn:pbm")
        List<PbmServerObjectRef> entities)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @param entity
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmProfileId>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryAssociatedProfile", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryAssociatedProfile", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedProfileRequestType")
    @ResponseWrapper(localName = "PbmQueryAssociatedProfileResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedProfileResponse")
    public List<PbmProfileId> pbmQueryAssociatedProfile(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "entity", targetNamespace = "urn:pbm")
        PbmServerObjectRef entity)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param entityType
     * @param profile
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmServerObjectRef>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryAssociatedEntity", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryAssociatedEntity", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedEntityRequestType")
    @ResponseWrapper(localName = "PbmQueryAssociatedEntityResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedEntityResponse")
    public List<PbmServerObjectRef> pbmQueryAssociatedEntity(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "profile", targetNamespace = "urn:pbm")
        PbmProfileId profile,
        @WebParam(name = "entityType", targetNamespace = "urn:pbm")
        String entityType)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param hub
     * @param _this
     * @return
     *     returns com.vmware.pbm.PbmProfileId
     * @throws InvalidArgumentFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws PbmNonExistentHubsFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryDefaultRequirementProfile", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryDefaultRequirementProfile", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryDefaultRequirementProfileRequestType")
    @ResponseWrapper(localName = "PbmQueryDefaultRequirementProfileResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryDefaultRequirementProfileResponse")
    public PbmProfileId pbmQueryDefaultRequirementProfile(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "hub", targetNamespace = "urn:pbm")
        PbmPlacementHub hub)
        throws InvalidArgumentFaultMsg, PbmFaultFaultMsg, PbmNonExistentHubsFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param profile
     * @param _this
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmResetDefaultRequirementProfile", action = "urn:pbm/8.0.1.0")
    @RequestWrapper(localName = "PbmResetDefaultRequirementProfile", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmResetDefaultRequirementProfileRequestType")
    @ResponseWrapper(localName = "PbmResetDefaultRequirementProfileResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmResetDefaultRequirementProfileResponse")
    public void pbmResetDefaultRequirementProfile(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "profile", targetNamespace = "urn:pbm")
        PbmProfileId profile)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param profile
     * @param datastores
     * @param _this
     * @throws InvalidArgumentFaultMsg
     * @throws PbmLegacyHubsNotSupportedFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws PbmNonExistentHubsFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmAssignDefaultRequirementProfile", action = "urn:pbm/8.0.1.0")
    @RequestWrapper(localName = "PbmAssignDefaultRequirementProfile", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmAssignDefaultRequirementProfileRequestType")
    @ResponseWrapper(localName = "PbmAssignDefaultRequirementProfileResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmAssignDefaultRequirementProfileResponse")
    public void pbmAssignDefaultRequirementProfile(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "profile", targetNamespace = "urn:pbm")
        PbmProfileId profile,
        @WebParam(name = "datastores", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> datastores)
        throws InvalidArgumentFaultMsg, PbmFaultFaultMsg, PbmLegacyHubsNotSupportedFaultMsg, PbmNonExistentHubsFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param datastores
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmProfile>
     * @throws InvalidArgumentFaultMsg
     * @throws PbmLegacyHubsNotSupportedFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws PbmNonExistentHubsFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmFindApplicableDefaultProfile", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmFindApplicableDefaultProfile", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFindApplicableDefaultProfileRequestType")
    @ResponseWrapper(localName = "PbmFindApplicableDefaultProfileResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmFindApplicableDefaultProfileResponse")
    public List<PbmProfile> pbmFindApplicableDefaultProfile(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "datastores", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> datastores)
        throws InvalidArgumentFaultMsg, PbmFaultFaultMsg, PbmLegacyHubsNotSupportedFaultMsg, PbmNonExistentHubsFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param datastores
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmDefaultProfileInfo>
     * @throws InvalidArgumentFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws PbmNonExistentHubsFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryDefaultRequirementProfiles", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryDefaultRequirementProfiles", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryDefaultRequirementProfilesRequestType")
    @ResponseWrapper(localName = "PbmQueryDefaultRequirementProfilesResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryDefaultRequirementProfilesResponse")
    public List<PbmDefaultProfileInfo> pbmQueryDefaultRequirementProfiles(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "datastores", targetNamespace = "urn:pbm")
        List<PbmPlacementHub> datastores)
        throws InvalidArgumentFaultMsg, PbmFaultFaultMsg, PbmNonExistentHubsFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param _this
     * @throws RuntimeFaultFaultMsg
     */
    @WebMethod(operationName = "PbmResetVSanDefaultProfile", action = "urn:pbm/8.0.1.0")
    @RequestWrapper(localName = "PbmResetVSanDefaultProfile", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmResetVSanDefaultProfileRequestType")
    @ResponseWrapper(localName = "PbmResetVSanDefaultProfileResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmResetVSanDefaultProfileResponse")
    public void pbmResetVSanDefaultProfile(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this)
        throws RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param datastore
     * @param capabilityProfileId
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmDatastoreSpaceStatistics>
     * @throws InvalidArgumentFaultMsg
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQuerySpaceStatsForStorageContainer", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQuerySpaceStatsForStorageContainer", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQuerySpaceStatsForStorageContainerRequestType")
    @ResponseWrapper(localName = "PbmQuerySpaceStatsForStorageContainerResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQuerySpaceStatsForStorageContainerResponse")
    public List<PbmDatastoreSpaceStatistics> pbmQuerySpaceStatsForStorageContainer(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "datastore", targetNamespace = "urn:pbm")
        PbmServerObjectRef datastore,
        @WebParam(name = "capabilityProfileId", targetNamespace = "urn:pbm")
        List<PbmProfileId> capabilityProfileId)
        throws InvalidArgumentFaultMsg, PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param profiles
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmQueryProfileResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryAssociatedEntities", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryAssociatedEntities", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedEntitiesRequestType")
    @ResponseWrapper(localName = "PbmQueryAssociatedEntitiesResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryAssociatedEntitiesResponse")
    public List<PbmQueryProfileResult> pbmQueryAssociatedEntities(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "profiles", targetNamespace = "urn:pbm")
        List<PbmProfileId> profiles)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

    /**
     * 
     * @param entities
     * @param _this
     * @return
     *     returns java.util.List<com.vmware.pbm.PbmQueryReplicationGroupResult>
     * @throws RuntimeFaultFaultMsg
     * @throws PbmFaultFaultMsg
     */
    @WebMethod(operationName = "PbmQueryReplicationGroups", action = "urn:pbm/8.0.1.0")
    @WebResult(name = "returnval", targetNamespace = "urn:pbm")
    @RequestWrapper(localName = "PbmQueryReplicationGroups", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryReplicationGroupsRequestType")
    @ResponseWrapper(localName = "PbmQueryReplicationGroupsResponse", targetNamespace = "urn:pbm", className = "com.vmware.pbm.PbmQueryReplicationGroupsResponse")
    public List<PbmQueryReplicationGroupResult> pbmQueryReplicationGroups(
        @WebParam(name = "_this", targetNamespace = "urn:pbm")
        ManagedObjectReference _this,
        @WebParam(name = "entities", targetNamespace = "urn:pbm")
        List<PbmServerObjectRef> entities)
        throws PbmFaultFaultMsg, RuntimeFaultFaultMsg
    ;

}
