/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.registry;

import com.vmware.common.samples.registry.SampleExecutionRecord;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ActionReference {
    private final Method before;
    private final Method action;
    private final Method after;

    public ActionReference(Method before, Method action, Method after) {
        this.before = before;
        this.action = action;
        this.after = after;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleExecutionRecord action(Object sample) {
        SampleExecutionRecord record = new SampleExecutionRecord(sample);
        Object object = sample;
        synchronized (object) {
            try {
                record.before = this.invokeAction(this.before, sample);
                if (record.before.isGood()) {
                    record.action = this.invokeAction(this.action, sample);
                }
                record.after = this.invokeAction(this.after, sample);
            }
            finally {
                record.hasRun();
            }
        }
        return record;
    }

    public SampleExecutionRecord.InvocationRecord invokeAction(Method method, Object sample) {
        SampleExecutionRecord.InvocationRecord record = new SampleExecutionRecord.InvocationRecord();
        try {
            if (method != null) {
                record.output = this.invoke(method, sample);
            }
        }
        catch (InvocationTargetException e) {
            record.fault = e.getCause();
        }
        catch (IllegalAccessException e) {
            record.fault = e;
        }
        return record;
    }

    private Object invoke(Method method, Object sample) throws InvocationTargetException, IllegalAccessException {
        return method != null && sample != null ? method.invoke(sample, new Object[0]) : null;
    }
}

