/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.connection.helpers;

import com.vmware.spbm.connection.Connection;
import com.vmware.spbm.connection.helpers.builders.ObjectSpecBuilder;
import com.vmware.spbm.connection.helpers.builders.PropertyFilterSpecBuilder;
import com.vmware.spbm.connection.helpers.builders.PropertySpecBuilder;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.WaitOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VCUtil {
    public static Map<String, Object> getEntityProps(Connection connection, ManagedObjectReference managedObjectReference, String[] stringArray) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        VimPortType vimPortType = connection.getVimPort();
        ServiceContent serviceContent = connection.getVimServiceContent();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PropertyFilterSpec[] propertyFilterSpecArray = new PropertyFilterSpec[]{new PropertyFilterSpecBuilder().propSet(new PropertySpecBuilder().all(Boolean.FALSE).type(managedObjectReference.getType()).pathSet(stringArray)).objectSet(new ObjectSpecBuilder().obj(managedObjectReference))};
        List list = vimPortType.retrievePropertiesEx(serviceContent.getPropertyCollector(), Arrays.asList(propertyFilterSpecArray), new RetrieveOptions()).getObjects();
        if (list != null) {
            for (ObjectContent objectContent : list) {
                List list2 = objectContent.getPropSet();
                for (DynamicProperty dynamicProperty : list2) {
                    hashMap.put(dynamicProperty.getName(), dynamicProperty.getVal());
                }
            }
        }
        return hashMap;
    }

    public static Object[] waitForTask(Connection connection, ManagedObjectReference managedObjectReference, String[] stringArray, String[] stringArray2, Object[][] objectArray) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        VimPortType vimPortType = connection.connect().getVimPort();
        ServiceContent serviceContent = connection.connect().getVimServiceContent();
        String string = "";
        Object[] objectArray2 = new Object[stringArray2.length];
        Object[] objectArray3 = new Object[stringArray.length];
        PropertyFilterSpec propertyFilterSpec = VCUtil.propertyFilterSpec(managedObjectReference, stringArray);
        ManagedObjectReference managedObjectReference2 = vimPortType.createFilter(serviceContent.getPropertyCollector(), propertyFilterSpec, true);
        boolean bl = false;
        UpdateSet updateSet = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        while (!bl) {
            updateSet = vimPortType.waitForUpdatesEx(serviceContent.getPropertyCollector(), string, new WaitOptions());
            if (updateSet == null || updateSet.getFilterSet() == null) continue;
            string = updateSet.getVersion();
            list = updateSet.getFilterSet();
            for (PropertyFilterUpdate propertyFilterUpdate : list) {
                list2 = propertyFilterUpdate.getObjectSet();
                for (ObjectUpdate objectUpdate : list2) {
                    if (objectUpdate.getKind() != ObjectUpdateKind.MODIFY && objectUpdate.getKind() != ObjectUpdateKind.ENTER && objectUpdate.getKind() != ObjectUpdateKind.LEAVE) continue;
                    list3 = objectUpdate.getChangeSet();
                    for (PropertyChange propertyChange : list3) {
                        VCUtil.updateValues(stringArray2, objectArray2, propertyChange);
                        VCUtil.updateValues(stringArray, objectArray3, propertyChange);
                    }
                }
            }
            Object object = null;
            for (int i = 0; i < objectArray2.length && !bl; ++i) {
                for (int j = 0; j < objectArray[i].length && !bl; ++j) {
                    object = objectArray[i][j];
                    bl = object.equals(objectArray2[i]) || bl;
                }
            }
        }
        vimPortType.destroyPropertyFilter(managedObjectReference2);
        return objectArray3;
    }

    private static void updateValues(String[] stringArray, Object[] objectArray, PropertyChange propertyChange) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (propertyChange.getName().lastIndexOf(stringArray[i]) < 0) continue;
            objectArray[i] = propertyChange.getOp() == PropertyChangeOp.REMOVE ? "" : propertyChange.getVal();
        }
    }

    private static PropertyFilterSpec propertyFilterSpec(ManagedObjectReference managedObjectReference, String[] stringArray) {
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.FALSE);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.getPathSet().addAll(Arrays.asList(stringArray));
        propertySpec.setType(managedObjectReference.getType());
        propertyFilterSpec.getPropSet().add(propertySpec);
        return propertyFilterSpec;
    }
}

