/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidFolderFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInfoState;
import java.util.Arrays;
import java.util.Map;

@Sample(name="move", description="moves a managed entity from its current location in the inventory to a new location, in a specified folder")
public class Move
extends ConnectedVimServiceBase {
    private String entityname;
    private String foldername;

    @Option(name="entityname", description="name of the inventory object - a managed entity")
    public void setEntityname(String string) {
        this.entityname = string;
    }

    @Option(name="foldername", description="name of folder to move inventory object into")
    public void setFoldername(String string) {
        this.foldername = string;
    }

    public boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    @Action
    public void move() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, DuplicateNameFaultMsg, InvalidFolderFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "ManagedEntity");
        ManagedObjectReference managedObjectReference = map.get(this.entityname);
        if (managedObjectReference == null) {
            System.out.println("Unable to find a managed entity named '" + this.entityname + "' in the Inventory");
            return;
        }
        map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "Folder");
        ManagedObjectReference managedObjectReference2 = map.get(this.foldername);
        if (managedObjectReference2 == null) {
            System.out.println("Unable to find folder '" + this.foldername + "' in the Inventory");
            return;
        }
        ManagedObjectReference managedObjectReference3 = this.vimPort.moveIntoFolderTask(managedObjectReference2, Arrays.asList(managedObjectReference));
        if (this.getTaskResultAfterDone(managedObjectReference3)) {
            System.out.println("ManagedEntity '" + this.entityname + "' moved to folder '" + this.foldername + "' successfully.");
        } else {
            System.out.println("Failure -: Managed Entity cannot be moved");
        }
    }
}

