/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.guest;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.guest.GuestConnection;
import com.vmware.vim25.ArrayOfByte;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.FileTransferInformation;
import com.vmware.vim25.GuestAuthentication;
import com.vmware.vim25.GuestOperationsFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NamePasswordAuthentication;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.VirtualMachinePowerState;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

@Sample(name="download-guest-file", description="This sample downloads a file from the guest to a specified\npath on the host where the client is running. Since vSphere API 5.0")
public class DownloadGuestFile
extends ConnectedVimServiceBase {
    private X509Certificate x509CertificateToTrust;
    private ManagedObjectReference hostMOR;
    private VirtualMachinePowerState powerState;
    private String virtualMachineName;
    GuestConnection guestConnection;
    private String guestFilePath;
    private String localFilePath;

    @Option(name="guestConnection", type=GuestConnection.class)
    public void setGuestConnection(GuestConnection guestConnection) {
        this.guestConnection = guestConnection;
    }

    @Option(name="guestfilepath", description="path of the file in the guest")
    public void setGuestFilePath(String string) {
        this.guestFilePath = string;
    }

    @Option(name="localfilepath", description="local file path to download and store the file")
    public void setLocalFilePath(String string) {
        this.localFilePath = string;
    }

    void getData(String string, String string2) throws IOException {
        HttpURLConnection httpURLConnection = null;
        URL uRL = new URL(string);
        httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        httpURLConnection.setRequestMethod("GET");
        InputStream inputStream = httpURLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        byte[] byArray = new byte[102400];
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        int n2 = httpURLConnection.getResponseCode();
        httpURLConnection.disconnect();
        if (200 != n2) {
            throw new DownloadGuestFileException("File Download is unsuccessful");
        }
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, TaskInProgressFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, GuestOperationsFaultFaultMsg, CertificateException, IOException, RuntimeFaultFaultMsg {
        this.serviceContent.getPropertyCollector();
        this.virtualMachineName = this.guestConnection.vmname;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        ManagedObjectReference managedObjectReference = map.get(this.virtualMachineName);
        if (managedObjectReference != null) {
            System.out.println("Virtual Machine " + this.virtualMachineName + " found");
            this.powerState = (VirtualMachinePowerState)this.getMOREFs.entityProps(managedObjectReference, new String[]{"runtime.powerState"}).get("runtime.powerState");
            if (!this.powerState.equals((Object)VirtualMachinePowerState.POWERED_ON)) {
                System.out.println("VirtualMachine: " + this.virtualMachineName + " needs to be powered on");
                return;
            }
        } else {
            System.out.println("Virtual Machine " + this.virtualMachineName + " not found.");
            return;
        }
        String[] stringArray = new String[]{"guest.guestOperationsReady"};
        String[] stringArray2 = new String[]{"guest.guestOperationsReady"};
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, stringArray, stringArray2, new Object[][]{{true}});
        System.out.println("Guest Operations are ready for the VM");
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getGuestOperationsManager();
        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"fileManager"}).get("fileManager");
        NamePasswordAuthentication namePasswordAuthentication = new NamePasswordAuthentication();
        namePasswordAuthentication.setUsername(this.guestConnection.username);
        namePasswordAuthentication.setPassword(this.guestConnection.password);
        namePasswordAuthentication.setInteractiveSession(false);
        System.out.println("Executing DownloadFile guest operation");
        FileTransferInformation fileTransferInformation = null;
        fileTransferInformation = this.vimPort.initiateFileTransferFromGuest(managedObjectReference3, managedObjectReference, (GuestAuthentication)namePasswordAuthentication, this.guestFilePath);
        URL uRL = new URL(this.connection.getUrl());
        String string = fileTransferInformation.getUrl().replaceAll("\\*", uRL.getHost());
        System.out.println("Downloading the file from :" + string + "");
        if (this.hostMOR != null) {
            stringArray = new String[]{"config.certificate"};
            stringArray2 = new String[]{"config.certificate"};
            objectArray = this.waitForValues.wait(this.hostMOR, stringArray, stringArray2, null);
            List list = ((ArrayOfByte)objectArray[0]).getByte();
            byte[] byArray = new byte[list.size()];
            int n = 0;
            for (Byte by : list) {
                byArray[n++] = by;
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            this.x509CertificateToTrust = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            System.out.println("Certificate of the host is successfully retrieved");
        }
        this.getData(string, this.localFilePath);
        System.out.println("Successfully downloaded the file");
    }

    private class DownloadGuestFileException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DownloadGuestFileException(String string) {
            super(string);
        }
    }
}

