/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.security.credstore;

import com.vmware.security.credstore.CredentialStore;
import com.vmware.security.credstore.CredentialStoreCipher;
import com.vmware.security.credstore.CredentialStoreStorage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

class CredentialStoreImpl
implements CredentialStore {
    private CredentialStoreCipher cypher;
    private File cachePath;
    private boolean defaultCachePath;
    private String vmwareDirName = ".vmware";
    private String credstoreDirName = "credstore";
    private String credstoreFileName = "vicredentials.xml";

    private File getDefaultFilePath() {
        String string;
        if (File.separatorChar == '/') {
            string = System.getenv("HOME");
            if (string == null) {
                throw new IllegalStateException("HOME not set.");
            }
            string = string + "/" + this.vmwareDirName + "/" + this.credstoreDirName + "/" + this.credstoreFileName;
        } else if (File.separatorChar == '\\') {
            string = System.getenv("APPDATA");
            if (string == null) {
                throw new IllegalStateException("APPDATA not set.");
            }
            string = string + "\\VMware\\credstore\\vicredentials.xml";
        } else {
            throw new IllegalStateException("Unknown Operating System");
        }
        return new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialStoreImpl() {
        CredentialStoreImpl credentialStoreImpl = this;
        synchronized (credentialStoreImpl) {
            this.cachePath = this.getDefaultFilePath();
            this.defaultCachePath = true;
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialStoreImpl(File file) {
        CredentialStoreImpl credentialStoreImpl = this;
        synchronized (credentialStoreImpl) {
            if (file == null) {
                this.cachePath = this.getDefaultFilePath();
                this.defaultCachePath = true;
            } else {
                this.cachePath = file;
                this.defaultCachePath = false;
            }
            this.initialize();
        }
    }

    public CredentialStoreCipher initialize() {
        try {
            CredentialStoreStorage.createCache(this.cachePath, this.defaultCachePath);
            SecretKey secretKey = this.initializeSecretKey(this.cachePath);
            this.cypher = new CredentialStoreCipher(secretKey);
        }
        catch (Exception exception) {
            throw new CredentialStoreInitializeException((Throwable)exception);
        }
        return this.cypher;
    }

    public SecretKey initializeSecretKey(File file) {
        SecretKey secretKey;
        File file2 = new File(file.getAbsolutePath() + ".key");
        if (file2.exists()) {
            try {
                secretKey = this.loadSecretKey(file2);
            }
            catch (Exception exception) {
                throw new CredentialStoreInitializeException((Throwable)exception);
            }
        }
        try {
            System.err.println("initializing new secret key for encryption");
            if (!file2.createNewFile()) {
                throw new CredentialStoreInitializeException("could not create the file " + file2.getAbsolutePath());
            }
            secretKey = CredentialStoreCipher.generateSecretKey();
            this.saveSecretKey(secretKey, file2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CredentialStoreInitializeException((Throwable)noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CredentialStoreInitializeException((Throwable)iOException);
        }
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialStoreImpl saveSecretKey(SecretKey secretKey, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(secretKey);
        }
        return this;
    }

    public SecretKey loadSecretKey(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
        SecretKey secretKey = (SecretKey)objectInputStream.readObject();
        objectInputStream.close();
        return secretKey;
    }

    @Override
    public synchronized String getPassword(String string, String string2) throws IOException, IllegalBlockSizeException, BadPaddingException {
        CredentialStoreStorage credentialStoreStorage = new CredentialStoreStorage(this.cachePath, this.defaultCachePath);
        byte[] byArray = credentialStoreStorage.getPassword(string, string2);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.cypher.decrypt(byArray);
        return new String(byArray2, StandardCharsets.UTF_8);
    }

    @Override
    public synchronized boolean addPassword(String string, String string2, String string3) throws IOException {
        CredentialStoreStorage credentialStoreStorage = new CredentialStoreStorage(this.cachePath, this.defaultCachePath);
        byte[] byArray = this.cypher.encrypt(string3.getBytes(StandardCharsets.UTF_8));
        return credentialStoreStorage.addEntry(string, string2, byArray);
    }

    @Override
    public synchronized boolean removePassword(String string, String string2) throws IOException {
        CredentialStoreStorage credentialStoreStorage = new CredentialStoreStorage(this.cachePath, this.defaultCachePath);
        return credentialStoreStorage.deleteEntry(string, string2);
    }

    @Override
    public synchronized void clearPasswords() throws IOException {
        CredentialStoreStorage credentialStoreStorage = new CredentialStoreStorage(this.cachePath, this.defaultCachePath);
        credentialStoreStorage.clearPasswords();
    }

    @Override
    public synchronized Set<String> getHosts() throws IOException {
        CredentialStoreStorage credentialStoreStorage = new CredentialStoreStorage(this.cachePath, this.defaultCachePath);
        return credentialStoreStorage.getHosts();
    }

    @Override
    public synchronized Set<String> getUsernames(String string) throws IOException {
        CredentialStoreStorage credentialStoreStorage = new CredentialStoreStorage(this.cachePath, this.defaultCachePath);
        return credentialStoreStorage.getUserNames(string);
    }

    @Override
    public synchronized void close() {
        this.cachePath = null;
    }

    private class CredentialStoreInitializeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CredentialStoreInitializeException(Throwable throwable) {
            super(throwable.getMessage(), throwable.getCause());
        }

        public CredentialStoreInitializeException(String string) {
            super(string);
        }
    }
}

