/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.util.Vector;
import org.sblim.cimclient.internal.http.HttpHeader;
import org.sblim.cimclient.internal.http.HttpParseException;

public class Challenge {
    private String iScheme;
    private HttpHeader iParams;

    private Challenge() {
    }

    public HttpHeader getParams() {
        return this.iParams;
    }

    public String getScheme() {
        return this.iScheme;
    }

    public String getRealm() {
        return this.iParams.getField("realm");
    }

    public static Challenge[] parseChallenge(String pLine) throws HttpParseException {
        Vector<Challenge> challeges = new Vector<Challenge>();
        if (pLine == null || pLine.length() == 0) {
            throw new IllegalArgumentException("Invalid challenge");
        }
        Challenge challenge = new Challenge();
        challenge.iParams = new HttpHeader();
        char[] buf = pLine.toCharArray();
        try {
            int start = 0;
            int end = 0;
            do {
                String scheme;
                start = Challenge.skipSpaces(buf, start);
                end = Challenge.findEndOfToken(buf, start);
                challenge.iScheme = scheme = pLine.substring(start, end);
                start = end;
                boolean skipComma = true;
                while ((skipComma || (start = Challenge.skipSpaces(buf, start)) < buf.length && buf[start] == ',') && (start = Challenge.skipSpaces(buf, start + 1)) < buf.length) {
                    end = Challenge.findEndOfToken(buf, start);
                    String paramname = pLine.substring(start, end);
                    start = end;
                    if (start >= buf.length || (start = Challenge.skipSpaces(buf, start)) >= buf.length) break;
                    if (buf[start] != '=') {
                        throw new HttpParseException("Invalid challenge");
                    }
                    if (start + 1 >= buf.length || (start = Challenge.skipSpaces(buf, start + 1)) >= buf.length) break;
                    end = Challenge.findEndOfToken(buf, start);
                    String value = pLine.substring(start, end);
                    start = end;
                    if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                        challenge.iParams.addField(paramname, value.substring(1, value.length() - 1));
                    } else {
                        challenge.iParams.addField(paramname, value);
                    }
                    skipComma = false;
                }
                challeges.add(challenge);
            } while (start < buf.length);
        }
        catch (HttpParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpParseException("Invalid challenge");
        }
        return challeges.toArray(new Challenge[challeges.size()]);
    }

    private static int skipSpaces(char[] buf, int pos) {
        while (pos < buf.length && Character.isSpaceChar(buf[pos])) {
            ++pos;
        }
        return pos;
    }

    private static int findEndOfToken(char[] buf, int pos) {
        if (buf[pos] == '\"') {
            while (buf[++pos] != '\"' && pos < buf.length) {
            }
            ++pos;
        } else {
            while (pos < buf.length && !Character.isSpaceChar(buf[pos]) && buf[pos] != ',' && buf[pos] != '=') {
                ++pos;
            }
        }
        return pos;
    }
}

