/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.sblim.cimclient.internal.http.HttpHeader;
import org.sblim.cimclient.internal.http.HttpMethod;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class ChunkedInputStream
extends InputStream {
    private InputStream iIn;
    private long iChunkSize = 0L;
    private boolean iEof = false;
    private HttpHeader iTrailers = new HttpHeader();
    private boolean iClosed = false;
    private byte[] iTmp = new byte[1];

    public ChunkedInputStream(InputStream pStream) {
        this.iIn = pStream;
    }

    public synchronized int read() throws IOException {
        return this.read(this.iTmp, 0, 1) > 0 ? this.iTmp[0] & 0xFF : -1;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int total = 0;
        if (this.iEof || this.iClosed) {
            return -1;
        }
        if (this.iChunkSize == 0L) {
            String line = HttpMethod.readLine(this.iIn);
            if ("".equals(line)) {
                line = HttpMethod.readLine(this.iIn);
            }
            try {
                this.iChunkSize = Long.parseLong(line, 16);
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINER, "Invalid chunk size on HTTP stream", e);
                this.iEof = true;
                throw new IOException("Invalid chunk size");
            }
        }
        if (this.iChunkSize > 0L) {
            total = this.iIn.read(buf, off, this.iChunkSize < (long)len ? (int)this.iChunkSize : len);
            if (total > 0) {
                this.iChunkSize -= (long)total;
            }
            if (total == -1) {
                throw new EOFException("Unexpected EOF");
            }
        } else {
            this.iEof = true;
            this.iTrailers = new HttpHeader(this.iIn);
            this.iTrailers.examineTrailer();
        }
        return total > 0 ? total : -1;
    }

    public synchronized HttpHeader getTrailers() {
        return this.iTrailers;
    }

    public synchronized long skip(long total) throws IOException {
        byte[] tmp = new byte[(int)total];
        return this.read(tmp, 0, (int)total);
    }

    public synchronized int available() {
        return this.iEof ? 0 : (this.iChunkSize > 0L ? (int)this.iChunkSize : 1);
    }

    public void close() throws IOException {
        if (!this.iClosed) {
            this.iClosed = true;
            byte[] buf = new byte[512];
            while (this.read(buf, 0, buf.length) > -1) {
            }
        } else {
            throw new IOException("Error while closing stream");
        }
        this.iIn.close();
    }
}

