/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.tier_0s.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra.tier_0s;

public interface RoutingTable extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.tier_0s.RoutingTableTypes {

    /**
     * Get routing table from tier-0
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param edgeId UUID of edge node (optional)
     * @param edgePath Policy path of edge node (optional)
     * @param enforcementPointPath Enforcement point path (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Filter routes based on the source from which route is learned (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_global_policy.model.RoutingTableListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.RoutingTableListResult list(java.lang.String tier0Id, java.lang.String cursor, java.lang.String edgeId, java.lang.String edgePath, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get routing table from tier-0
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param edgeId UUID of edge node (optional)
     * @param edgePath Policy path of edge node (optional)
     * @param enforcementPointPath Enforcement point path (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Filter routes based on the source from which route is learned (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.RoutingTableListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.RoutingTableListResult list(java.lang.String tier0Id, java.lang.String cursor, java.lang.String edgeId, java.lang.String edgePath, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get routing table from tier-0
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.RoutingTableListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param edgeId UUID of edge node (optional)
     * @param edgePath Policy path of edge node (optional)
     * @param enforcementPointPath Enforcement point path (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Filter routes based on the source from which route is learned (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String cursor, java.lang.String edgeId, java.lang.String edgePath, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.RoutingTableListResult> asyncCallback);

    /**
     * Get routing table from tier-0
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.RoutingTableListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param edgeId UUID of edge node (optional)
     * @param edgePath Policy path of edge node (optional)
     * @param enforcementPointPath Enforcement point path (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param networkPrefix IPAddress or CIDR Block (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routeSource Filter routes based on the source from which route is learned (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String cursor, java.lang.String edgeId, java.lang.String edgePath, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String networkPrefix, java.lang.Long pageSize, java.lang.String routeSource, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.RoutingTableListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
