/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.tier_0s.nat.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra.tier_0s.nat;

public interface NatRules extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.tier_0s.nat.NatRulesTypes {

    /**
     * Delete NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId);

    /**
     * Delete NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT/PATCH API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @return com.vmware.nsx_global_policy.model.PolicyNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRule get(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId);

    /**
     * Get NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT/PATCH API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.PolicyNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRule get(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT/PATCH API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRule> asyncCallback);

    /**
     * Get NAT Rule from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT/PATCH API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List NAT Rules from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PATCH/PUT API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_global_policy.model.PolicyNatRuleListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRuleListResult list(java.lang.String tier0Id, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List NAT Rules from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PATCH/PUT API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.PolicyNatRuleListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRuleListResult list(java.lang.String tier0Id, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List NAT Rules from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PATCH/PUT API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRuleListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRuleListResult> asyncCallback);

    /**
     * List NAT Rules from Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PATCH/PUT API, the path returned in the GET response payload
     * will be a new path instead of the deprecated IPSecVpnSession path Both old and
     * new IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRuleListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String natId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRuleListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If a NAT Rule is not already present on Tier-0 denoted by Tier-0 ID, under NAT
     * section denoted by <nat-id>, create a new NAT Rule. If it already exists, update
     * the NAT Rule. Under tier-0 there will be 3 different NATs(sections). (INTERNAL,
     * USER and DEFAULT) For more details related to NAT section please refer to
     * PolicyNAT schema. Note: IPSecVpnSession as Scope: Please note that old
     * IPSecVpnSession policy path deprecated. If user specifiy old IPSecVpnSession
     * path in the scope property in the PATCH API, the path returned in the GET
     * response payload will be a new path instead of the deprecated IPSecVpnSession
     * path Both old and new IPSecVpnSession path refer to same resource. there is no
     * functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule);

    /**
     * If a NAT Rule is not already present on Tier-0 denoted by Tier-0 ID, under NAT
     * section denoted by <nat-id>, create a new NAT Rule. If it already exists, update
     * the NAT Rule. Under tier-0 there will be 3 different NATs(sections). (INTERNAL,
     * USER and DEFAULT) For more details related to NAT section please refer to
     * PolicyNAT schema. Note: IPSecVpnSession as Scope: Please note that old
     * IPSecVpnSession policy path deprecated. If user specifiy old IPSecVpnSession
     * path in the scope property in the PATCH API, the path returned in the GET
     * response payload will be a new path instead of the deprecated IPSecVpnSession
     * path Both old and new IPSecVpnSession path refer to same resource. there is no
     * functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If a NAT Rule is not already present on Tier-0 denoted by Tier-0 ID, under NAT
     * section denoted by <nat-id>, create a new NAT Rule. If it already exists, update
     * the NAT Rule. Under tier-0 there will be 3 different NATs(sections). (INTERNAL,
     * USER and DEFAULT) For more details related to NAT section please refer to
     * PolicyNAT schema. Note: IPSecVpnSession as Scope: Please note that old
     * IPSecVpnSession policy path deprecated. If user specifiy old IPSecVpnSession
     * path in the scope property in the PATCH API, the path returned in the GET
     * response payload will be a new path instead of the deprecated IPSecVpnSession
     * path Both old and new IPSecVpnSession path refer to same resource. there is no
     * functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If a NAT Rule is not already present on Tier-0 denoted by Tier-0 ID, under NAT
     * section denoted by <nat-id>, create a new NAT Rule. If it already exists, update
     * the NAT Rule. Under tier-0 there will be 3 different NATs(sections). (INTERNAL,
     * USER and DEFAULT) For more details related to NAT section please refer to
     * PolicyNAT schema. Note: IPSecVpnSession as Scope: Please note that old
     * IPSecVpnSession policy path deprecated. If user specifiy old IPSecVpnSession
     * path in the scope property in the PATCH API, the path returned in the GET
     * response payload will be a new path instead of the deprecated IPSecVpnSession
     * path Both old and new IPSecVpnSession path refer to same resource. there is no
     * functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update NAT Rule on Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT API, the path returned in the PUT/GET response payload will
     * be a new path instead of the deprecated IPSecVpnSession path Both old and new
     * IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @return com.vmware.nsx_global_policy.model.PolicyNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRule update(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule);

    /**
     * Update NAT Rule on Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT API, the path returned in the PUT/GET response payload will
     * be a new path instead of the deprecated IPSecVpnSession path Both old and new
     * IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.PolicyNatRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRule update(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update NAT Rule on Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT API, the path returned in the PUT/GET response payload will
     * be a new path instead of the deprecated IPSecVpnSession path Both old and new
     * IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRule> asyncCallback);

    /**
     * Update NAT Rule on Tier-0 denoted by Tier-0 ID, under NAT section denoted by
     * <nat-id>. Under tier-0 there will be 3 different NATs(sections). (INTERNAL, USER
     * and DEFAULT) For more details related to NAT section please refer to PolicyNAT
     * schema. Note: IPSecVpnSession as Scope: Please note that old IPSecVpnSession
     * policy path deprecated. If user specifiy old IPSecVpnSession path in the scope
     * property in the PUT API, the path returned in the PUT/GET response payload will
     * be a new path instead of the deprecated IPSecVpnSession path Both old and new
     * IPSecVpnSession path refer to same resource. there is no functional impact.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param policyNatRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, com.vmware.nsx_global_policy.model.PolicyNatRule policyNatRule, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
