/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer AuthProfileHTTPClientParams object
 */
public final class ALBAuthProfileHTTPClientParams implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long cacheExpirationTime;

    private java.lang.String requestHeader;

    private java.util.List<java.lang.String> requireUserGroups;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBAuthProfileHTTPClientParams() {
    }

    protected ALBAuthProfileHTTPClientParams(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The max allowed length of time a clients authentication is cached. Allowed
     * values are 1-30. Unit is SEC. Default value when not specified in API or module
     * is interpreted by ALB Controller as 5. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCacheExpirationTime() {
        return this.cacheExpirationTime;
    }

    /**
     * The max allowed length of time a clients authentication is cached. Allowed
     * values are 1-30. Unit is SEC. Default value when not specified in API or module
     * is interpreted by ALB Controller as 5. format: int64
     *
     * @param cacheExpirationTime New value for the property.
     */
    public void setCacheExpirationTime(java.lang.Long cacheExpirationTime) {
        this.cacheExpirationTime = cacheExpirationTime;
    }

    /**
     * Insert an HTTP header. This field is used to define the header name. The value
     * of the header is set to the client's HTTP Auth user ID.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestHeader() {
        return this.requestHeader;
    }

    /**
     * Insert an HTTP header. This field is used to define the header name. The value
     * of the header is set to the client's HTTP Auth user ID.
     *
     * @param requestHeader New value for the property.
     */
    public void setRequestHeader(java.lang.String requestHeader) {
        this.requestHeader = requestHeader;
    }

    /**
     * A user should be a member of these groups. Each group is defined by the DN. For
     * example, CN=testgroup,OU=groups,dc=example,dc=avinetworks,DC=com.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getRequireUserGroups() {
        return this.requireUserGroups;
    }

    /**
     * A user should be a member of these groups. Each group is defined by the DN. For
     * example, CN=testgroup,OU=groups,dc=example,dc=avinetworks,DC=com.
     *
     * @param requireUserGroups New value for the property.
     */
    public void setRequireUserGroups(java.util.List<java.lang.String> requireUserGroups) {
        this.requireUserGroups = requireUserGroups;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBAuthProfileHTTPClientParams;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("cache_expiration_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cacheExpirationTime, this._getType().getField("cache_expiration_time")));
        structValue.setField("request_header",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestHeader, this._getType().getField("request_header")));
        structValue.setField("require_user_groups",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requireUserGroups, this._getType().getField("require_user_groups")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBAuthProfileHTTPClientParams;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBAuthProfileHTTPClientParams.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBAuthProfileHTTPClientParams _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBAuthProfileHTTPClientParams(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBAuthProfileHTTPClientParams _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBAuthProfileHTTPClientParams(structValue);
    }

    /**
     * Builder class for {@link ALBAuthProfileHTTPClientParams}.
     */
    public static final class Builder {
        private java.lang.Long cacheExpirationTime;
        private java.lang.String requestHeader;
        private java.util.List<java.lang.String> requireUserGroups;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBAuthProfileHTTPClientParams}.
         */
        public Builder() {
        }

        /**
         * The max allowed length of time a clients authentication is cached. Allowed
         * values are 1-30. Unit is SEC. Default value when not specified in API or module
         * is interpreted by ALB Controller as 5. format: int64
         *
         * @param cacheExpirationTime New value for the property.
         */
        public Builder setCacheExpirationTime(java.lang.Long cacheExpirationTime) {
            this.cacheExpirationTime = cacheExpirationTime;
            return this;
        }

        /**
         * Insert an HTTP header. This field is used to define the header name. The value
         * of the header is set to the client's HTTP Auth user ID.
         *
         * @param requestHeader New value for the property.
         */
        public Builder setRequestHeader(java.lang.String requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        /**
         * A user should be a member of these groups. Each group is defined by the DN. For
         * example, CN=testgroup,OU=groups,dc=example,dc=avinetworks,DC=com.
         *
         * @param requireUserGroups New value for the property.
         */
        public Builder setRequireUserGroups(java.util.List<java.lang.String> requireUserGroups) {
            this.requireUserGroups = requireUserGroups;
            return this;
        }

        public ALBAuthProfileHTTPClientParams build() {
            ALBAuthProfileHTTPClientParams result = new ALBAuthProfileHTTPClientParams();
            result.setCacheExpirationTime(this.cacheExpirationTime);
            result.setRequestHeader(this.requestHeader);
            result.setRequireUserGroups(this.requireUserGroups);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("cache_expiration_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cache_expiration_time",
                                                                                "cacheExpirationTime",
                                                                                "getCacheExpirationTime",
                                                                                "setCacheExpirationTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_header", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_header",
                                                                                "requestHeader",
                                                                                "getRequestHeader",
                                                                                "setRequestHeader");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("require_user_groups", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("require_user_groups",
                                                                                "requireUserGroups",
                                                                                "getRequireUserGroups",
                                                                                "setRequireUserGroups");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_auth_profile_HTTP_client_params",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBAuthProfileHTTPClientParams.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

