/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer CRL object
 */
public final class ALBCRL implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String body;

    private java.lang.String commonName;

    private java.lang.String distinguishedName;

    private java.lang.String etag;

    private java.lang.String fingerprint;

    private java.lang.String lastRefreshed;

    private java.lang.String lastUpdate;

    private java.lang.String nextUpdate;

    private java.lang.String serverUrl;

    private java.lang.String text;

    private java.lang.Long updateInterval;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBCRL() {
    }

    protected ALBCRL(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Certificate Revocation list from a given issuer in PEM format. This can either
     * be configured directly or via the server_url.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBody() {
        return this.body;
    }

    /**
     * Certificate Revocation list from a given issuer in PEM format. This can either
     * be configured directly or via the server_url.
     *
     * @param body New value for the property.
     */
    public void setBody(java.lang.String body) {
        this.body = body;
    }

    /**
     * Common name of the issuer in the Certificate Revocation list.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCommonName() {
        return this.commonName;
    }

    /**
     * Common name of the issuer in the Certificate Revocation list.
     *
     * @param commonName New value for the property.
     */
    public void setCommonName(java.lang.String commonName) {
        this.commonName = commonName;
    }

    /**
     * Distinguished name of the issuer in the Certificate Revocation list.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDistinguishedName() {
        return this.distinguishedName;
    }

    /**
     * Distinguished name of the issuer in the Certificate Revocation list.
     *
     * @param distinguishedName New value for the property.
     */
    public void setDistinguishedName(java.lang.String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    /**
     * Cached etag to optimize the download of the CRL.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEtag() {
        return this.etag;
    }

    /**
     * Cached etag to optimize the download of the CRL.
     *
     * @param etag New value for the property.
     */
    public void setEtag(java.lang.String etag) {
        this.etag = etag;
    }

    /**
     * Fingerprint of the CRL. Used to avoid configuring duplicates.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFingerprint() {
        return this.fingerprint;
    }

    /**
     * Fingerprint of the CRL. Used to avoid configuring duplicates.
     *
     * @param fingerprint New value for the property.
     */
    public void setFingerprint(java.lang.String fingerprint) {
        this.fingerprint = fingerprint;
    }

    /**
     * Last time CRL was refreshed by the system. This is an internal field used by the
     * system.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastRefreshed() {
        return this.lastRefreshed;
    }

    /**
     * Last time CRL was refreshed by the system. This is an internal field used by the
     * system.
     *
     * @param lastRefreshed New value for the property.
     */
    public void setLastRefreshed(java.lang.String lastRefreshed) {
        this.lastRefreshed = lastRefreshed;
    }

    /**
     * The date when this CRL was last issued.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastUpdate() {
        return this.lastUpdate;
    }

    /**
     * The date when this CRL was last issued.
     *
     * @param lastUpdate New value for the property.
     */
    public void setLastUpdate(java.lang.String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    /**
     * The date when a newer CRL will be available. Also conveys the date after which
     * the CRL should be considered obsolete.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNextUpdate() {
        return this.nextUpdate;
    }

    /**
     * The date when a newer CRL will be available. Also conveys the date after which
     * the CRL should be considered obsolete.
     *
     * @param nextUpdate New value for the property.
     */
    public void setNextUpdate(java.lang.String nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    /**
     * URL of a server that issues the Certificate Revocation list. If this is
     * configured, CRL will be periodically downloaded either based on the configured
     * update interval or the next update interval in the CRL. CRL itself is stored in
     * the body.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerUrl() {
        return this.serverUrl;
    }

    /**
     * URL of a server that issues the Certificate Revocation list. If this is
     * configured, CRL will be periodically downloaded either based on the configured
     * update interval or the next update interval in the CRL. CRL itself is stored in
     * the body.
     *
     * @param serverUrl New value for the property.
     */
    public void setServerUrl(java.lang.String serverUrl) {
        this.serverUrl = serverUrl;
    }

    /**
     * Certificate Revocation list in plain text for readability.
     *
     * @return The current value of the property.
     */
    public java.lang.String getText() {
        return this.text;
    }

    /**
     * Certificate Revocation list in plain text for readability.
     *
     * @param text New value for the property.
     */
    public void setText(java.lang.String text) {
        this.text = text;
    }

    /**
     * Interval in minutes to check for CRL update. If not specified, interval will be
     * 1 day. Allowed values are 30-525600. Unit is MIN. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUpdateInterval() {
        return this.updateInterval;
    }

    /**
     * Interval in minutes to check for CRL update. If not specified, interval will be
     * 1 day. Allowed values are 30-525600. Unit is MIN. format: int64
     *
     * @param updateInterval New value for the property.
     */
    public void setUpdateInterval(java.lang.Long updateInterval) {
        this.updateInterval = updateInterval;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBCRL;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("body",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.body, this._getType().getField("body")));
        structValue.setField("common_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.commonName, this._getType().getField("common_name")));
        structValue.setField("distinguished_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.distinguishedName, this._getType().getField("distinguished_name")));
        structValue.setField("etag",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.etag, this._getType().getField("etag")));
        structValue.setField("fingerprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fingerprint, this._getType().getField("fingerprint")));
        structValue.setField("last_refreshed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastRefreshed, this._getType().getField("last_refreshed")));
        structValue.setField("last_update",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastUpdate, this._getType().getField("last_update")));
        structValue.setField("next_update",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nextUpdate, this._getType().getField("next_update")));
        structValue.setField("server_url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverUrl, this._getType().getField("server_url")));
        structValue.setField("text",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.text, this._getType().getField("text")));
        structValue.setField("update_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.updateInterval, this._getType().getField("update_interval")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBCRL;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBCRL.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBCRL _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBCRL(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBCRL _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBCRL(structValue);
    }

    /**
     * Builder class for {@link ALBCRL}.
     */
    public static final class Builder {
        private java.lang.String body;
        private java.lang.String commonName;
        private java.lang.String distinguishedName;
        private java.lang.String etag;
        private java.lang.String fingerprint;
        private java.lang.String lastRefreshed;
        private java.lang.String lastUpdate;
        private java.lang.String nextUpdate;
        private java.lang.String serverUrl;
        private java.lang.String text;
        private java.lang.Long updateInterval;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBCRL}.
         */
        public Builder() {
        }

        /**
         * Certificate Revocation list from a given issuer in PEM format. This can either
         * be configured directly or via the server_url.
         *
         * @param body New value for the property.
         */
        public Builder setBody(java.lang.String body) {
            this.body = body;
            return this;
        }

        /**
         * Common name of the issuer in the Certificate Revocation list.
         *
         * @param commonName New value for the property.
         */
        public Builder setCommonName(java.lang.String commonName) {
            this.commonName = commonName;
            return this;
        }

        /**
         * Distinguished name of the issuer in the Certificate Revocation list.
         *
         * @param distinguishedName New value for the property.
         */
        public Builder setDistinguishedName(java.lang.String distinguishedName) {
            this.distinguishedName = distinguishedName;
            return this;
        }

        /**
         * Cached etag to optimize the download of the CRL.
         *
         * @param etag New value for the property.
         */
        public Builder setEtag(java.lang.String etag) {
            this.etag = etag;
            return this;
        }

        /**
         * Fingerprint of the CRL. Used to avoid configuring duplicates.
         *
         * @param fingerprint New value for the property.
         */
        public Builder setFingerprint(java.lang.String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        /**
         * Last time CRL was refreshed by the system. This is an internal field used by the
         * system.
         *
         * @param lastRefreshed New value for the property.
         */
        public Builder setLastRefreshed(java.lang.String lastRefreshed) {
            this.lastRefreshed = lastRefreshed;
            return this;
        }

        /**
         * The date when this CRL was last issued.
         *
         * @param lastUpdate New value for the property.
         */
        public Builder setLastUpdate(java.lang.String lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        /**
         * The date when a newer CRL will be available. Also conveys the date after which
         * the CRL should be considered obsolete.
         *
         * @param nextUpdate New value for the property.
         */
        public Builder setNextUpdate(java.lang.String nextUpdate) {
            this.nextUpdate = nextUpdate;
            return this;
        }

        /**
         * URL of a server that issues the Certificate Revocation list. If this is
         * configured, CRL will be periodically downloaded either based on the configured
         * update interval or the next update interval in the CRL. CRL itself is stored in
         * the body.
         *
         * @param serverUrl New value for the property.
         */
        public Builder setServerUrl(java.lang.String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        /**
         * Certificate Revocation list in plain text for readability.
         *
         * @param text New value for the property.
         */
        public Builder setText(java.lang.String text) {
            this.text = text;
            return this;
        }

        /**
         * Interval in minutes to check for CRL update. If not specified, interval will be
         * 1 day. Allowed values are 30-525600. Unit is MIN. format: int64
         *
         * @param updateInterval New value for the property.
         */
        public Builder setUpdateInterval(java.lang.Long updateInterval) {
            this.updateInterval = updateInterval;
            return this;
        }

        public ALBCRL build() {
            ALBCRL result = new ALBCRL();
            result.setBody(this.body);
            result.setCommonName(this.commonName);
            result.setDistinguishedName(this.distinguishedName);
            result.setEtag(this.etag);
            result.setFingerprint(this.fingerprint);
            result.setLastRefreshed(this.lastRefreshed);
            result.setLastUpdate(this.lastUpdate);
            result.setNextUpdate(this.nextUpdate);
            result.setServerUrl(this.serverUrl);
            result.setText(this.text);
            result.setUpdateInterval(this.updateInterval);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("body", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("body",
                                                                                "body",
                                                                                "getBody",
                                                                                "setBody");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("common_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("common_name",
                                                                                "commonName",
                                                                                "getCommonName",
                                                                                "setCommonName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("distinguished_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("distinguished_name",
                                                                                "distinguishedName",
                                                                                "getDistinguishedName",
                                                                                "setDistinguishedName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("etag", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("etag",
                                                                                "etag",
                                                                                "getEtag",
                                                                                "setEtag");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fingerprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fingerprint",
                                                                                "fingerprint",
                                                                                "getFingerprint",
                                                                                "setFingerprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_refreshed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_refreshed",
                                                                                "lastRefreshed",
                                                                                "getLastRefreshed",
                                                                                "setLastRefreshed");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_update", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_update",
                                                                                "lastUpdate",
                                                                                "getLastUpdate",
                                                                                "setLastUpdate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("next_update", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("next_update",
                                                                                "nextUpdate",
                                                                                "getNextUpdate",
                                                                                "setNextUpdate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_url",
                                                                                "serverUrl",
                                                                                "getServerUrl",
                                                                                "setServerUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("text", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("text",
                                                                                "text",
                                                                                "getText",
                                                                                "setText");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("update_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("update_interval",
                                                                                "updateInterval",
                                                                                "getUpdateInterval",
                                                                                "setUpdateInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALBCRL",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBCRL.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

