/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer ConnPoolProperties object
 */
public final class ALBConnPoolProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long upstreamConnpoolConnIdleTmo;

    private java.lang.Long upstreamConnpoolConnLifeTmo;

    private java.lang.Long upstreamConnpoolConnMaxReuse;

    private java.lang.Long upstreamConnpoolServerMaxCache;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBConnPoolProperties() {
    }

    protected ALBConnPoolProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Connection idle timeout. Allowed in Basic(Allowed values- 60000) edition,
     * Essentials(Allowed values- 60000) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as 60000.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUpstreamConnpoolConnIdleTmo() {
        return this.upstreamConnpoolConnIdleTmo;
    }

    /**
     * Connection idle timeout. Allowed in Basic(Allowed values- 60000) edition,
     * Essentials(Allowed values- 60000) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as 60000.
     * format: int64
     *
     * @param upstreamConnpoolConnIdleTmo New value for the property.
     */
    public void setUpstreamConnpoolConnIdleTmo(java.lang.Long upstreamConnpoolConnIdleTmo) {
        this.upstreamConnpoolConnIdleTmo = upstreamConnpoolConnIdleTmo;
    }

    /**
     * Connection life timeout. Allowed in Basic(Allowed values- 600000) edition,
     * Essentials(Allowed values- 600000) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as 600000.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUpstreamConnpoolConnLifeTmo() {
        return this.upstreamConnpoolConnLifeTmo;
    }

    /**
     * Connection life timeout. Allowed in Basic(Allowed values- 600000) edition,
     * Essentials(Allowed values- 600000) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as 600000.
     * format: int64
     *
     * @param upstreamConnpoolConnLifeTmo New value for the property.
     */
    public void setUpstreamConnpoolConnLifeTmo(java.lang.Long upstreamConnpoolConnLifeTmo) {
        this.upstreamConnpoolConnLifeTmo = upstreamConnpoolConnLifeTmo;
    }

    /**
     * Maximum number of times a connection can be reused. Special values are 0-
     * 'unlimited'. Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed
     * values- 0) edition, Enterprise edition. Default value when not specified in API
     * or module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUpstreamConnpoolConnMaxReuse() {
        return this.upstreamConnpoolConnMaxReuse;
    }

    /**
     * Maximum number of times a connection can be reused. Special values are 0-
     * 'unlimited'. Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed
     * values- 0) edition, Enterprise edition. Default value when not specified in API
     * or module is interpreted by ALB Controller as 0. format: int64
     *
     * @param upstreamConnpoolConnMaxReuse New value for the property.
     */
    public void setUpstreamConnpoolConnMaxReuse(java.lang.Long upstreamConnpoolConnMaxReuse) {
        this.upstreamConnpoolConnMaxReuse = upstreamConnpoolConnMaxReuse;
    }

    /**
     * Maximum number of connections a server can cache. Special values are 0-
     * 'unlimited'. Default value when not specified in API or module is interpreted by
     * ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUpstreamConnpoolServerMaxCache() {
        return this.upstreamConnpoolServerMaxCache;
    }

    /**
     * Maximum number of connections a server can cache. Special values are 0-
     * 'unlimited'. Default value when not specified in API or module is interpreted by
     * ALB Controller as 0. format: int64
     *
     * @param upstreamConnpoolServerMaxCache New value for the property.
     */
    public void setUpstreamConnpoolServerMaxCache(java.lang.Long upstreamConnpoolServerMaxCache) {
        this.upstreamConnpoolServerMaxCache = upstreamConnpoolServerMaxCache;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBConnPoolProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("upstream_connpool_conn_idle_tmo",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.upstreamConnpoolConnIdleTmo, this._getType().getField("upstream_connpool_conn_idle_tmo")));
        structValue.setField("upstream_connpool_conn_life_tmo",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.upstreamConnpoolConnLifeTmo, this._getType().getField("upstream_connpool_conn_life_tmo")));
        structValue.setField("upstream_connpool_conn_max_reuse",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.upstreamConnpoolConnMaxReuse, this._getType().getField("upstream_connpool_conn_max_reuse")));
        structValue.setField("upstream_connpool_server_max_cache",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.upstreamConnpoolServerMaxCache, this._getType().getField("upstream_connpool_server_max_cache")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBConnPoolProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBConnPoolProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBConnPoolProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBConnPoolProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBConnPoolProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBConnPoolProperties(structValue);
    }

    /**
     * Builder class for {@link ALBConnPoolProperties}.
     */
    public static final class Builder {
        private java.lang.Long upstreamConnpoolConnIdleTmo;
        private java.lang.Long upstreamConnpoolConnLifeTmo;
        private java.lang.Long upstreamConnpoolConnMaxReuse;
        private java.lang.Long upstreamConnpoolServerMaxCache;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBConnPoolProperties}.
         */
        public Builder() {
        }

        /**
         * Connection idle timeout. Allowed in Basic(Allowed values- 60000) edition,
         * Essentials(Allowed values- 60000) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as 60000.
         * format: int64
         *
         * @param upstreamConnpoolConnIdleTmo New value for the property.
         */
        public Builder setUpstreamConnpoolConnIdleTmo(java.lang.Long upstreamConnpoolConnIdleTmo) {
            this.upstreamConnpoolConnIdleTmo = upstreamConnpoolConnIdleTmo;
            return this;
        }

        /**
         * Connection life timeout. Allowed in Basic(Allowed values- 600000) edition,
         * Essentials(Allowed values- 600000) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as 600000.
         * format: int64
         *
         * @param upstreamConnpoolConnLifeTmo New value for the property.
         */
        public Builder setUpstreamConnpoolConnLifeTmo(java.lang.Long upstreamConnpoolConnLifeTmo) {
            this.upstreamConnpoolConnLifeTmo = upstreamConnpoolConnLifeTmo;
            return this;
        }

        /**
         * Maximum number of times a connection can be reused. Special values are 0-
         * 'unlimited'. Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed
         * values- 0) edition, Enterprise edition. Default value when not specified in API
         * or module is interpreted by ALB Controller as 0. format: int64
         *
         * @param upstreamConnpoolConnMaxReuse New value for the property.
         */
        public Builder setUpstreamConnpoolConnMaxReuse(java.lang.Long upstreamConnpoolConnMaxReuse) {
            this.upstreamConnpoolConnMaxReuse = upstreamConnpoolConnMaxReuse;
            return this;
        }

        /**
         * Maximum number of connections a server can cache. Special values are 0-
         * 'unlimited'. Default value when not specified in API or module is interpreted by
         * ALB Controller as 0. format: int64
         *
         * @param upstreamConnpoolServerMaxCache New value for the property.
         */
        public Builder setUpstreamConnpoolServerMaxCache(java.lang.Long upstreamConnpoolServerMaxCache) {
            this.upstreamConnpoolServerMaxCache = upstreamConnpoolServerMaxCache;
            return this;
        }

        public ALBConnPoolProperties build() {
            ALBConnPoolProperties result = new ALBConnPoolProperties();
            result.setUpstreamConnpoolConnIdleTmo(this.upstreamConnpoolConnIdleTmo);
            result.setUpstreamConnpoolConnLifeTmo(this.upstreamConnpoolConnLifeTmo);
            result.setUpstreamConnpoolConnMaxReuse(this.upstreamConnpoolConnMaxReuse);
            result.setUpstreamConnpoolServerMaxCache(this.upstreamConnpoolServerMaxCache);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("upstream_connpool_conn_idle_tmo", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("upstream_connpool_conn_idle_tmo",
                                                                                "upstreamConnpoolConnIdleTmo",
                                                                                "getUpstreamConnpoolConnIdleTmo",
                                                                                "setUpstreamConnpoolConnIdleTmo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("upstream_connpool_conn_life_tmo", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("upstream_connpool_conn_life_tmo",
                                                                                "upstreamConnpoolConnLifeTmo",
                                                                                "getUpstreamConnpoolConnLifeTmo",
                                                                                "setUpstreamConnpoolConnLifeTmo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("upstream_connpool_conn_max_reuse", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("upstream_connpool_conn_max_reuse",
                                                                                "upstreamConnpoolConnMaxReuse",
                                                                                "getUpstreamConnpoolConnMaxReuse",
                                                                                "setUpstreamConnpoolConnMaxReuse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("upstream_connpool_server_max_cache", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("upstream_connpool_server_max_cache",
                                                                                "upstreamConnpoolServerMaxCache",
                                                                                "getUpstreamConnpoolServerMaxCache",
                                                                                "setUpstreamConnpoolServerMaxCache");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_conn_pool_properties",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBConnPoolProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

