/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * ALB Controller Version
 */
public final class ALBControllerVersion implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String albApiVersion;

    private java.lang.String albControllerVersion;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBControllerVersion() {
    }

    protected ALBControllerVersion(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * It is ALB API version supported by NSX-ALB.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAlbApiVersion() {
        return this.albApiVersion;
    }

    /**
     * It is ALB API version supported by NSX-ALB.
     *
     * @param albApiVersion New value for the property.
     */
    public void setAlbApiVersion(java.lang.String albApiVersion) {
        this.albApiVersion = albApiVersion;
    }

    /**
     * It is ALB Controller version deployed by NSX-ALB.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAlbControllerVersion() {
        return this.albControllerVersion;
    }

    /**
     * It is ALB Controller version deployed by NSX-ALB.
     *
     * @param albControllerVersion New value for the property.
     */
    public void setAlbControllerVersion(java.lang.String albControllerVersion) {
        this.albControllerVersion = albControllerVersion;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBControllerVersion;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("alb_api_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.albApiVersion, this._getType().getField("alb_api_version")));
        structValue.setField("alb_controller_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.albControllerVersion, this._getType().getField("alb_controller_version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBControllerVersion;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBControllerVersion.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBControllerVersion _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBControllerVersion(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBControllerVersion _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBControllerVersion(structValue);
    }

    /**
     * Builder class for {@link ALBControllerVersion}.
     */
    public static final class Builder {
        private java.lang.String albApiVersion;
        private java.lang.String albControllerVersion;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBControllerVersion}.
         */
        public Builder() {
        }

        /**
         * It is ALB API version supported by NSX-ALB.
         *
         * @param albApiVersion New value for the property.
         */
        public Builder setAlbApiVersion(java.lang.String albApiVersion) {
            this.albApiVersion = albApiVersion;
            return this;
        }

        /**
         * It is ALB Controller version deployed by NSX-ALB.
         *
         * @param albControllerVersion New value for the property.
         */
        public Builder setAlbControllerVersion(java.lang.String albControllerVersion) {
            this.albControllerVersion = albControllerVersion;
            return this;
        }

        public ALBControllerVersion build() {
            ALBControllerVersion result = new ALBControllerVersion();
            result.setAlbApiVersion(this.albApiVersion);
            result.setAlbControllerVersion(this.albControllerVersion);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("alb_api_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("alb_api_version",
                                                                                "albApiVersion",
                                                                                "getAlbApiVersion",
                                                                                "setAlbApiVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("alb_controller_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("alb_controller_version",
                                                                                "albControllerVersion",
                                                                                "getAlbControllerVersion",
                                                                                "setAlbControllerVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_controller_version",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBControllerVersion.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

