/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer DnsGeoLocationMatch object
 */
public final class ALBDnsGeoLocationMatch implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MATCH_CRITERIA_IN = "IS_IN";

    public static final java.lang.String MATCH_CRITERIA_NOT_IN = "IS_NOT_IN";

    private java.lang.String geolocationName;

    private java.lang.String geolocationTag;

    private java.lang.String matchCriteria;

    private java.lang.Boolean useEdnsClientSubnetIp;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBDnsGeoLocationMatch() {
    }

    protected ALBDnsGeoLocationMatch(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Geographical location of the client IP to be used in the match. This location is
     * of the format Country/State/City e.g. US/CA/Santa Clara.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGeolocationName() {
        return this.geolocationName;
    }

    /**
     * Geographical location of the client IP to be used in the match. This location is
     * of the format Country/State/City e.g. US/CA/Santa Clara.
     *
     * @param geolocationName New value for the property.
     */
    public void setGeolocationName(java.lang.String geolocationName) {
        this.geolocationName = geolocationName;
    }

    /**
     * Geolocation tag for the client IP. This could be any string value for the client
     * IP, e.g. client IPs from US East Coast geolocation would be tagged as 'East
     * Coast'.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGeolocationTag() {
        return this.geolocationTag;
    }

    /**
     * Geolocation tag for the client IP. This could be any string value for the client
     * IP, e.g. client IPs from US East Coast geolocation would be tagged as 'East
     * Coast'.
     *
     * @param geolocationTag New value for the property.
     */
    public void setGeolocationTag(java.lang.String geolocationTag) {
        this.geolocationTag = geolocationTag;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsGeoLocationMatch#MATCH_CRITERIA_IN}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsGeoLocationMatch#MATCH_CRITERIA_NOT_IN}</li>
     * </ul> Criterion to use for matching the client IP's geographical location. Enum
     * options - IS_IN, IS_NOT_IN.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchCriteria() {
        return this.matchCriteria;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsGeoLocationMatch#MATCH_CRITERIA_IN}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsGeoLocationMatch#MATCH_CRITERIA_NOT_IN}</li>
     * </ul> Criterion to use for matching the client IP's geographical location. Enum
     * options - IS_IN, IS_NOT_IN.
     *
     * @param matchCriteria New value for the property.
     */
    public void setMatchCriteria(java.lang.String matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    /**
     * Use the IP address from the EDNS client subnet option, if available, to derive
     * geo location of the DNS query. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUseEdnsClientSubnetIp() {
        return this.useEdnsClientSubnetIp;
    }

    /**
     * Use the IP address from the EDNS client subnet option, if available, to derive
     * geo location of the DNS query. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @param useEdnsClientSubnetIp New value for the property.
     */
    public void setUseEdnsClientSubnetIp(java.lang.Boolean useEdnsClientSubnetIp) {
        this.useEdnsClientSubnetIp = useEdnsClientSubnetIp;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsGeoLocationMatch;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("geolocation_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.geolocationName, this._getType().getField("geolocation_name")));
        structValue.setField("geolocation_tag",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.geolocationTag, this._getType().getField("geolocation_tag")));
        structValue.setField("match_criteria",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchCriteria, this._getType().getField("match_criteria")));
        structValue.setField("use_edns_client_subnet_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.useEdnsClientSubnetIp, this._getType().getField("use_edns_client_subnet_ip")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsGeoLocationMatch;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsGeoLocationMatch.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBDnsGeoLocationMatch _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsGeoLocationMatch(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBDnsGeoLocationMatch _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsGeoLocationMatch(structValue);
    }

    /**
     * Builder class for {@link ALBDnsGeoLocationMatch}.
     */
    public static final class Builder {
        private java.lang.String geolocationName;
        private java.lang.String geolocationTag;
        private java.lang.String matchCriteria;
        private java.lang.Boolean useEdnsClientSubnetIp;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBDnsGeoLocationMatch}.
         */
        public Builder() {
        }

        /**
         * Geographical location of the client IP to be used in the match. This location is
         * of the format Country/State/City e.g. US/CA/Santa Clara.
         *
         * @param geolocationName New value for the property.
         */
        public Builder setGeolocationName(java.lang.String geolocationName) {
            this.geolocationName = geolocationName;
            return this;
        }

        /**
         * Geolocation tag for the client IP. This could be any string value for the client
         * IP, e.g. client IPs from US East Coast geolocation would be tagged as 'East
         * Coast'.
         *
         * @param geolocationTag New value for the property.
         */
        public Builder setGeolocationTag(java.lang.String geolocationTag) {
            this.geolocationTag = geolocationTag;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsGeoLocationMatch#MATCH_CRITERIA_IN}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsGeoLocationMatch#MATCH_CRITERIA_NOT_IN}</li>
         * </ul> Criterion to use for matching the client IP's geographical location. Enum
         * options - IS_IN, IS_NOT_IN.
         *
         * @param matchCriteria New value for the property.
         */
        public Builder setMatchCriteria(java.lang.String matchCriteria) {
            this.matchCriteria = matchCriteria;
            return this;
        }

        /**
         * Use the IP address from the EDNS client subnet option, if available, to derive
         * geo location of the DNS query. Default value when not specified in API or module
         * is interpreted by ALB Controller as true.
         *
         * @param useEdnsClientSubnetIp New value for the property.
         */
        public Builder setUseEdnsClientSubnetIp(java.lang.Boolean useEdnsClientSubnetIp) {
            this.useEdnsClientSubnetIp = useEdnsClientSubnetIp;
            return this;
        }

        public ALBDnsGeoLocationMatch build() {
            ALBDnsGeoLocationMatch result = new ALBDnsGeoLocationMatch();
            result.setGeolocationName(this.geolocationName);
            result.setGeolocationTag(this.geolocationTag);
            result.setMatchCriteria(this.matchCriteria);
            result.setUseEdnsClientSubnetIp(this.useEdnsClientSubnetIp);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("geolocation_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("geolocation_name",
                                                                                "geolocationName",
                                                                                "getGeolocationName",
                                                                                "setGeolocationName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("geolocation_tag", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("geolocation_tag",
                                                                                "geolocationTag",
                                                                                "getGeolocationTag",
                                                                                "setGeolocationTag");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_criteria", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_criteria",
                                                                                "matchCriteria",
                                                                                "getMatchCriteria",
                                                                                "setMatchCriteria");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("use_edns_client_subnet_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("use_edns_client_subnet_ip",
                                                                                "useEdnsClientSubnetIp",
                                                                                "getUseEdnsClientSubnetIp",
                                                                                "setUseEdnsClientSubnetIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_dns_geo_location_match",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBDnsGeoLocationMatch.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

