/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer DnsRecord object
 */
public final class ALBDnsRecord implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ALGORITHM_ROUND_ROBIN = "DNS_RECORD_RESPONSE_ROUND_ROBIN";

    public static final java.lang.String ALGORITHM_CONSISTENT_HASH = "DNS_RECORD_RESPONSE_CONSISTENT_HASH";

    public static final java.lang.String TYPE_OTHER = "DNS_RECORD_OTHER";

    public static final java.lang.String TYPE_A = "DNS_RECORD_A";

    public static final java.lang.String TYPE_NS = "DNS_RECORD_NS";

    public static final java.lang.String TYPE_CNAME = "DNS_RECORD_CNAME";

    public static final java.lang.String TYPE_SOA = "DNS_RECORD_SOA";

    public static final java.lang.String TYPE_PTR = "DNS_RECORD_PTR";

    public static final java.lang.String TYPE_HINFO = "DNS_RECORD_HINFO";

    public static final java.lang.String TYPE_MX = "DNS_RECORD_MX";

    public static final java.lang.String TYPE_TXT = "DNS_RECORD_TXT";

    public static final java.lang.String TYPE_RP = "DNS_RECORD_RP";

    public static final java.lang.String TYPE_DNSKEY = "DNS_RECORD_DNSKEY";

    public static final java.lang.String TYPE_AAAA = "DNS_RECORD_AAAA";

    public static final java.lang.String TYPE_SRV = "DNS_RECORD_SRV";

    public static final java.lang.String TYPE_OPT = "DNS_RECORD_OPT";

    public static final java.lang.String TYPE_RRSIG = "DNS_RECORD_RRSIG";

    public static final java.lang.String TYPE_AXFR = "DNS_RECORD_AXFR";

    public static final java.lang.String TYPE_ANY = "DNS_RECORD_ANY";

    private java.lang.String algorithm;

    private com.vmware.nsx_global_policy.model.ALBDnsCnameRdata cname;

    private java.lang.Boolean delegated;

    private java.lang.String description;

    private java.util.List<java.lang.String> fqdn;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsAAAARdata> ip6Address;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsaRdata> ipAddress;

    private java.lang.String metadata;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsMxRdata> mxRecords;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsNsRdata> ns;

    private java.lang.Long numRecordsInResponse;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsSrvRdata> serviceLocator;

    private java.lang.Long ttl;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsTxtRdata> txtRecords;

    private java.lang.String type;

    private java.lang.Boolean wildcardMatch;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBDnsRecord() {
    }

    protected ALBDnsRecord(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#ALGORITHM_ROUND_ROBIN}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#ALGORITHM_CONSISTENT_HASH}</li>
     * </ul> Specifies the algorithm to pick the IP address(es) to be returned, when
     * multiple entries are configured. This does not apply if num_records_in_response
     * is 0. Default is round-robin. Enum options - DNS_RECORD_RESPONSE_ROUND_ROBIN,
     * DNS_RECORD_RESPONSE_CONSISTENT_HASH. Default value when not specified in API or
     * module is interpreted by ALB Controller as DNS_RECORD_RESPONSE_ROUND_ROBIN.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAlgorithm() {
        return this.algorithm;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#ALGORITHM_ROUND_ROBIN}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#ALGORITHM_CONSISTENT_HASH}</li>
     * </ul> Specifies the algorithm to pick the IP address(es) to be returned, when
     * multiple entries are configured. This does not apply if num_records_in_response
     * is 0. Default is round-robin. Enum options - DNS_RECORD_RESPONSE_ROUND_ROBIN,
     * DNS_RECORD_RESPONSE_CONSISTENT_HASH. Default value when not specified in API or
     * module is interpreted by ALB Controller as DNS_RECORD_RESPONSE_ROUND_ROBIN.
     *
     * @param algorithm New value for the property.
     */
    public void setAlgorithm(java.lang.String algorithm) {
        this.algorithm = algorithm;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBDnsCnameRdata getCname() {
        return this.cname;
    }

    /**
     *
     *
     * @param cname New value for the property.
     */
    public void setCname(com.vmware.nsx_global_policy.model.ALBDnsCnameRdata cname) {
        this.cname = cname;
    }

    /**
     * Configured FQDNs are delegated domains (i.e. they represent a zone cut). Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDelegated() {
        return this.delegated;
    }

    /**
     * Configured FQDNs are delegated domains (i.e. they represent a zone cut). Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @param delegated New value for the property.
     */
    public void setDelegated(java.lang.Boolean delegated) {
        this.delegated = delegated;
    }

    /**
     * Details of DNS record.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Details of DNS record.
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Fully Qualified Domain Name. Minimum of 1 items required.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getFqdn() {
        return this.fqdn;
    }

    /**
     * Fully Qualified Domain Name. Minimum of 1 items required.
     *
     * @param fqdn New value for the property.
     */
    public void setFqdn(java.util.List<java.lang.String> fqdn) {
        this.fqdn = fqdn;
    }

    /**
     * IPv6 address in AAAA record. Maximum of 4 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBDnsAAAARdata> getIp6Address() {
        return this.ip6Address;
    }

    /**
     * IPv6 address in AAAA record. Maximum of 4 items allowed.
     *
     * @param ip6Address New value for the property.
     */
    public void setIp6Address(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsAAAARdata> ip6Address) {
        this.ip6Address = ip6Address;
    }

    /**
     * IP address in A record. Maximum of 4 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBDnsaRdata> getIpAddress() {
        return this.ipAddress;
    }

    /**
     * IP address in A record. Maximum of 4 items allowed.
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsaRdata> ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Internal metadata for the DNS record.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMetadata() {
        return this.metadata;
    }

    /**
     * Internal metadata for the DNS record.
     *
     * @param metadata New value for the property.
     */
    public void setMetadata(java.lang.String metadata) {
        this.metadata = metadata;
    }

    /**
     * MX record. Maximum of 4 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBDnsMxRdata> getMxRecords() {
        return this.mxRecords;
    }

    /**
     * MX record. Maximum of 4 items allowed.
     *
     * @param mxRecords New value for the property.
     */
    public void setMxRecords(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsMxRdata> mxRecords) {
        this.mxRecords = mxRecords;
    }

    /**
     * Name Server information in NS record. Maximum of 13 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBDnsNsRdata> getNs() {
        return this.ns;
    }

    /**
     * Name Server information in NS record. Maximum of 13 items allowed.
     *
     * @param ns New value for the property.
     */
    public void setNs(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsNsRdata> ns) {
        this.ns = ns;
    }

    /**
     * Specifies the number of records returned by the DNS service. Enter 0 to return
     * all records. Default is 0. Allowed values are 0-20. Special values are 0-
     * 'Return all records'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumRecordsInResponse() {
        return this.numRecordsInResponse;
    }

    /**
     * Specifies the number of records returned by the DNS service. Enter 0 to return
     * all records. Default is 0. Allowed values are 0-20. Special values are 0-
     * 'Return all records'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param numRecordsInResponse New value for the property.
     */
    public void setNumRecordsInResponse(java.lang.Long numRecordsInResponse) {
        this.numRecordsInResponse = numRecordsInResponse;
    }

    /**
     * Service locator info in SRV record. Maximum of 4 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBDnsSrvRdata> getServiceLocator() {
        return this.serviceLocator;
    }

    /**
     * Service locator info in SRV record. Maximum of 4 items allowed.
     *
     * @param serviceLocator New value for the property.
     */
    public void setServiceLocator(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsSrvRdata> serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    /**
     * Time To Live for this DNS record. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTtl() {
        return this.ttl;
    }

    /**
     * Time To Live for this DNS record. format: int64
     *
     * @param ttl New value for the property.
     */
    public void setTtl(java.lang.Long ttl) {
        this.ttl = ttl;
    }

    /**
     * Text record. Maximum of 4 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBDnsTxtRdata> getTxtRecords() {
        return this.txtRecords;
    }

    /**
     * Text record. Maximum of 4 items allowed.
     *
     * @param txtRecords New value for the property.
     */
    public void setTxtRecords(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsTxtRdata> txtRecords) {
        this.txtRecords = txtRecords;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_OTHER}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_A}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_NS}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_CNAME}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_SOA}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_PTR}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_HINFO}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_MX}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_TXT}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_RP}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_DNSKEY}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_AAAA}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_SRV}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_OPT}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_RRSIG}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_AXFR}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_ANY}</li> </ul> DNS record
     * type. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A, DNS_RECORD_NS,
     * DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR, DNS_RECORD_HINFO,
     * DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP, DNS_RECORD_DNSKEY,
     * DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT, DNS_RECORD_RRSIG,
     * DNS_RECORD_AXFR, DNS_RECORD_ANY.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_OTHER}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_A}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_NS}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_CNAME}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_SOA}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_PTR}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_HINFO}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_MX}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_TXT}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_RP}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_DNSKEY}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_AAAA}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_SRV}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_OPT}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_RRSIG}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_AXFR}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_ANY}</li> </ul> DNS record
     * type. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A, DNS_RECORD_NS,
     * DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR, DNS_RECORD_HINFO,
     * DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP, DNS_RECORD_DNSKEY,
     * DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT, DNS_RECORD_RRSIG,
     * DNS_RECORD_AXFR, DNS_RECORD_ANY.
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

    /**
     * Enable wild-card match of fqdn if an exact match is not found in the DNS table,
     * the longest match is chosen by wild-carding the fqdn in the DNS request. Default
     * is false. Default value when not specified in API or module is interpreted by
     * ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getWildcardMatch() {
        return this.wildcardMatch;
    }

    /**
     * Enable wild-card match of fqdn if an exact match is not found in the DNS table,
     * the longest match is chosen by wild-carding the fqdn in the DNS request. Default
     * is false. Default value when not specified in API or module is interpreted by
     * ALB Controller as false.
     *
     * @param wildcardMatch New value for the property.
     */
    public void setWildcardMatch(java.lang.Boolean wildcardMatch) {
        this.wildcardMatch = wildcardMatch;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsRecord;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("algorithm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.algorithm, this._getType().getField("algorithm")));
        structValue.setField("cname",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cname, this._getType().getField("cname")));
        structValue.setField("delegated",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.delegated, this._getType().getField("delegated")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("fqdn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fqdn, this._getType().getField("fqdn")));
        structValue.setField("ip6_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ip6Address, this._getType().getField("ip6_address")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("metadata",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.metadata, this._getType().getField("metadata")));
        structValue.setField("mx_records",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mxRecords, this._getType().getField("mx_records")));
        structValue.setField("ns",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ns, this._getType().getField("ns")));
        structValue.setField("num_records_in_response",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numRecordsInResponse, this._getType().getField("num_records_in_response")));
        structValue.setField("service_locator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceLocator, this._getType().getField("service_locator")));
        structValue.setField("ttl",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ttl, this._getType().getField("ttl")));
        structValue.setField("txt_records",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txtRecords, this._getType().getField("txt_records")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
        structValue.setField("wildcard_match",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.wildcardMatch, this._getType().getField("wildcard_match")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsRecord;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsRecord.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBDnsRecord _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsRecord(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBDnsRecord _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsRecord(structValue);
    }

    /**
     * Builder class for {@link ALBDnsRecord}.
     */
    public static final class Builder {
        private java.lang.String algorithm;
        private com.vmware.nsx_global_policy.model.ALBDnsCnameRdata cname;
        private java.lang.Boolean delegated;
        private java.lang.String description;
        private java.util.List<java.lang.String> fqdn;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsAAAARdata> ip6Address;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsaRdata> ipAddress;
        private java.lang.String metadata;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsMxRdata> mxRecords;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsNsRdata> ns;
        private java.lang.Long numRecordsInResponse;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsSrvRdata> serviceLocator;
        private java.lang.Long ttl;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsTxtRdata> txtRecords;
        private java.lang.String type;
        private java.lang.Boolean wildcardMatch;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBDnsRecord}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#ALGORITHM_ROUND_ROBIN}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#ALGORITHM_CONSISTENT_HASH}</li>
         * </ul> Specifies the algorithm to pick the IP address(es) to be returned, when
         * multiple entries are configured. This does not apply if num_records_in_response
         * is 0. Default is round-robin. Enum options - DNS_RECORD_RESPONSE_ROUND_ROBIN,
         * DNS_RECORD_RESPONSE_CONSISTENT_HASH. Default value when not specified in API or
         * module is interpreted by ALB Controller as DNS_RECORD_RESPONSE_ROUND_ROBIN.
         *
         * @param algorithm New value for the property.
         */
        public Builder setAlgorithm(java.lang.String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        /**
         *
         *
         * @param cname New value for the property.
         */
        public Builder setCname(com.vmware.nsx_global_policy.model.ALBDnsCnameRdata cname) {
            this.cname = cname;
            return this;
        }

        /**
         * Configured FQDNs are delegated domains (i.e. they represent a zone cut). Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * false.
         *
         * @param delegated New value for the property.
         */
        public Builder setDelegated(java.lang.Boolean delegated) {
            this.delegated = delegated;
            return this;
        }

        /**
         * Details of DNS record.
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Fully Qualified Domain Name. Minimum of 1 items required.
         *
         * @param fqdn New value for the property.
         */
        public Builder setFqdn(java.util.List<java.lang.String> fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        /**
         * IPv6 address in AAAA record. Maximum of 4 items allowed.
         *
         * @param ip6Address New value for the property.
         */
        public Builder setIp6Address(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsAAAARdata> ip6Address) {
            this.ip6Address = ip6Address;
            return this;
        }

        /**
         * IP address in A record. Maximum of 4 items allowed.
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsaRdata> ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Internal metadata for the DNS record.
         *
         * @param metadata New value for the property.
         */
        public Builder setMetadata(java.lang.String metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * MX record. Maximum of 4 items allowed.
         *
         * @param mxRecords New value for the property.
         */
        public Builder setMxRecords(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsMxRdata> mxRecords) {
            this.mxRecords = mxRecords;
            return this;
        }

        /**
         * Name Server information in NS record. Maximum of 13 items allowed.
         *
         * @param ns New value for the property.
         */
        public Builder setNs(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsNsRdata> ns) {
            this.ns = ns;
            return this;
        }

        /**
         * Specifies the number of records returned by the DNS service. Enter 0 to return
         * all records. Default is 0. Allowed values are 0-20. Special values are 0-
         * 'Return all records'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param numRecordsInResponse New value for the property.
         */
        public Builder setNumRecordsInResponse(java.lang.Long numRecordsInResponse) {
            this.numRecordsInResponse = numRecordsInResponse;
            return this;
        }

        /**
         * Service locator info in SRV record. Maximum of 4 items allowed.
         *
         * @param serviceLocator New value for the property.
         */
        public Builder setServiceLocator(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsSrvRdata> serviceLocator) {
            this.serviceLocator = serviceLocator;
            return this;
        }

        /**
         * Time To Live for this DNS record. format: int64
         *
         * @param ttl New value for the property.
         */
        public Builder setTtl(java.lang.Long ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Text record. Maximum of 4 items allowed.
         *
         * @param txtRecords New value for the property.
         */
        public Builder setTxtRecords(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsTxtRdata> txtRecords) {
            this.txtRecords = txtRecords;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_OTHER}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_A}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_NS}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_CNAME}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_SOA}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_PTR}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_HINFO}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_MX}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_TXT}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_RP}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_DNSKEY}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_AAAA}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_SRV}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_OPT}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_RRSIG}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_AXFR}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsRecord#TYPE_ANY}</li> </ul> DNS record
         * type. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A, DNS_RECORD_NS,
         * DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR, DNS_RECORD_HINFO,
         * DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP, DNS_RECORD_DNSKEY,
         * DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT, DNS_RECORD_RRSIG,
         * DNS_RECORD_AXFR, DNS_RECORD_ANY.
         *
         * @param type New value for the property.
         */
        public Builder setType(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Enable wild-card match of fqdn if an exact match is not found in the DNS table,
         * the longest match is chosen by wild-carding the fqdn in the DNS request. Default
         * is false. Default value when not specified in API or module is interpreted by
         * ALB Controller as false.
         *
         * @param wildcardMatch New value for the property.
         */
        public Builder setWildcardMatch(java.lang.Boolean wildcardMatch) {
            this.wildcardMatch = wildcardMatch;
            return this;
        }

        public ALBDnsRecord build() {
            ALBDnsRecord result = new ALBDnsRecord();
            result.setAlgorithm(this.algorithm);
            result.setCname(this.cname);
            result.setDelegated(this.delegated);
            result.setDescription(this.description);
            result.setFqdn(this.fqdn);
            result.setIp6Address(this.ip6Address);
            result.setIpAddress(this.ipAddress);
            result.setMetadata(this.metadata);
            result.setMxRecords(this.mxRecords);
            result.setNs(this.ns);
            result.setNumRecordsInResponse(this.numRecordsInResponse);
            result.setServiceLocator(this.serviceLocator);
            result.setTtl(this.ttl);
            result.setTxtRecords(this.txtRecords);
            result.setType(this.type);
            result.setWildcardMatch(this.wildcardMatch);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("algorithm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("algorithm",
                                                                                "algorithm",
                                                                                "getAlgorithm",
                                                                                "setAlgorithm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cname", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsCnameRdata; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cname",
                                                                                "cname",
                                                                                "getCname",
                                                                                "setCname");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("delegated", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("delegated",
                                                                                "delegated",
                                                                                "getDelegated",
                                                                                "setDelegated");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fqdn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fqdn",
                                                                                "fqdn",
                                                                                "getFqdn",
                                                                                "setFqdn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip6_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsAAAARdata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip6_address",
                                                                                "ip6Address",
                                                                                "getIp6Address",
                                                                                "setIp6Address");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsaRdata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("metadata", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("metadata",
                                                                                "metadata",
                                                                                "getMetadata",
                                                                                "setMetadata");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mx_records", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsMxRdata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mx_records",
                                                                                "mxRecords",
                                                                                "getMxRecords",
                                                                                "setMxRecords");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ns", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsNsRdata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ns",
                                                                                "ns",
                                                                                "getNs",
                                                                                "setNs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("num_records_in_response", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_records_in_response",
                                                                                "numRecordsInResponse",
                                                                                "getNumRecordsInResponse",
                                                                                "setNumRecordsInResponse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_locator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsSrvRdata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_locator",
                                                                                "serviceLocator",
                                                                                "getServiceLocator",
                                                                                "setServiceLocator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ttl", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ttl",
                                                                                "ttl",
                                                                                "getTtl",
                                                                                "setTtl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("txt_records", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsTxtRdata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("txt_records",
                                                                                "txtRecords",
                                                                                "getTxtRecords",
                                                                                "setTxtRecords");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("wildcard_match", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("wildcard_match",
                                                                                "wildcardMatch",
                                                                                "getWildcardMatch",
                                                                                "setWildcardMatch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_dns_record",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBDnsRecord.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

