/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer DnsServiceApplicationProfile object
 */
public final class ALBDnsServiceApplicationProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ERROR_RESPONSE_ERROR = "DNS_ERROR_RESPONSE_ERROR";

    public static final java.lang.String ERROR_RESPONSE_NONE = "DNS_ERROR_RESPONSE_NONE";

    private java.lang.Boolean aaaaEmptyResponse;

    private java.lang.String adminEmail;

    private java.lang.Boolean dnsOverTcpEnabled;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsZone> dnsZones;

    private java.util.List<java.lang.String> domainNames;

    private java.lang.Boolean ecsStrippingEnabled;

    private java.lang.Boolean edns;

    private java.lang.Long ednsClientSubnetPrefixLen;

    private java.lang.String errorResponse;

    private java.lang.String nameServer;

    private java.lang.Long negativeCachingTtl;

    private java.lang.Long numDnsIp;

    private java.lang.Long ttl;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBDnsServiceApplicationProfile() {
    }

    protected ALBDnsServiceApplicationProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Respond to AAAA queries with empty response when there are only IPV4 records.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAaaaEmptyResponse() {
        return this.aaaaEmptyResponse;
    }

    /**
     * Respond to AAAA queries with empty response when there are only IPV4 records.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @param aaaaEmptyResponse New value for the property.
     */
    public void setAaaaEmptyResponse(java.lang.Boolean aaaaEmptyResponse) {
        this.aaaaEmptyResponse = aaaaEmptyResponse;
    }

    /**
     * Email address of the administrator responsible for this zone. This field is used
     * in SOA records (rname) pertaining to all domain names specified as authoritative
     * domain names. If not configured, the default value 'hostmaster' is used in SOA
     * responses. Default value when not specified in API or module is interpreted by
     * ALB Controller as hostmaster.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminEmail() {
        return this.adminEmail;
    }

    /**
     * Email address of the administrator responsible for this zone. This field is used
     * in SOA records (rname) pertaining to all domain names specified as authoritative
     * domain names. If not configured, the default value 'hostmaster' is used in SOA
     * responses. Default value when not specified in API or module is interpreted by
     * ALB Controller as hostmaster.
     *
     * @param adminEmail New value for the property.
     */
    public void setAdminEmail(java.lang.String adminEmail) {
        this.adminEmail = adminEmail;
    }

    /**
     * Enable DNS query/response over TCP. This enables analytics for pass-through
     * queries as well. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDnsOverTcpEnabled() {
        return this.dnsOverTcpEnabled;
    }

    /**
     * Enable DNS query/response over TCP. This enables analytics for pass-through
     * queries as well. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @param dnsOverTcpEnabled New value for the property.
     */
    public void setDnsOverTcpEnabled(java.lang.Boolean dnsOverTcpEnabled) {
        this.dnsOverTcpEnabled = dnsOverTcpEnabled;
    }

    /**
     * DNS zones hosted on this Virtual Service. Maximum of 100 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBDnsZone> getDnsZones() {
        return this.dnsZones;
    }

    /**
     * DNS zones hosted on this Virtual Service. Maximum of 100 items allowed.
     *
     * @param dnsZones New value for the property.
     */
    public void setDnsZones(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsZone> dnsZones) {
        this.dnsZones = dnsZones;
    }

    /**
     * Subdomain names serviced by this Virtual Service. These are configured as
     * Ends-With semantics. Maximum of 100 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDomainNames() {
        return this.domainNames;
    }

    /**
     * Subdomain names serviced by this Virtual Service. These are configured as
     * Ends-With semantics. Maximum of 100 items allowed.
     *
     * @param domainNames New value for the property.
     */
    public void setDomainNames(java.util.List<java.lang.String> domainNames) {
        this.domainNames = domainNames;
    }

    /**
     * Enable stripping of EDNS client subnet (ecs) option towards client if DNS
     * service inserts ecs option in the DNS query towards upstream servers. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEcsStrippingEnabled() {
        return this.ecsStrippingEnabled;
    }

    /**
     * Enable stripping of EDNS client subnet (ecs) option towards client if DNS
     * service inserts ecs option in the DNS query towards upstream servers. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * true.
     *
     * @param ecsStrippingEnabled New value for the property.
     */
    public void setEcsStrippingEnabled(java.lang.Boolean ecsStrippingEnabled) {
        this.ecsStrippingEnabled = ecsStrippingEnabled;
    }

    /**
     * Enable DNS service to be aware of EDNS (Extension mechanism for DNS). EDNS
     * extensions are parsed and shown in logs. For GSLB services, the EDNS client
     * subnet option can be used to influence Load Balancing. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEdns() {
        return this.edns;
    }

    /**
     * Enable DNS service to be aware of EDNS (Extension mechanism for DNS). EDNS
     * extensions are parsed and shown in logs. For GSLB services, the EDNS client
     * subnet option can be used to influence Load Balancing. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @param edns New value for the property.
     */
    public void setEdns(java.lang.Boolean edns) {
        this.edns = edns;
    }

    /**
     * Specifies the IP address prefix length to use in the EDNS client subnet (ECS)
     * option. When the incoming request does not have any ECS option and the prefix
     * length is specified, an ECS option is inserted in the request passed to upstream
     * server. If the incoming request already has an ECS option, the prefix length
     * (and correspondingly the address) in the ECS option is updated, with the minimum
     * of the prefix length present in the incoming and the configured prefix length,
     * before passing the request to upstream server. Allowed values are 1-32. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEdnsClientSubnetPrefixLen() {
        return this.ednsClientSubnetPrefixLen;
    }

    /**
     * Specifies the IP address prefix length to use in the EDNS client subnet (ECS)
     * option. When the incoming request does not have any ECS option and the prefix
     * length is specified, an ECS option is inserted in the request passed to upstream
     * server. If the incoming request already has an ECS option, the prefix length
     * (and correspondingly the address) in the ECS option is updated, with the minimum
     * of the prefix length present in the incoming and the configured prefix length,
     * before passing the request to upstream server. Allowed values are 1-32. format:
     * int64
     *
     * @param ednsClientSubnetPrefixLen New value for the property.
     */
    public void setEdnsClientSubnetPrefixLen(java.lang.Long ednsClientSubnetPrefixLen) {
        this.ednsClientSubnetPrefixLen = ednsClientSubnetPrefixLen;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsServiceApplicationProfile#ERROR_RESPONSE_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsServiceApplicationProfile#ERROR_RESPONSE_NONE}</li>
     * </ul> Drop or respond to client when the DNS service encounters an error
     * processing a client query. By default, such a request is dropped without any
     * response, or passed through to a passthrough pool, if configured. When set to
     * respond, an appropriate response is sent to client, e.g. NXDOMAIN response for
     * non-existent records, empty NOERROR response for unsupported queries, etc. Enum
     * options - DNS_ERROR_RESPONSE_ERROR, DNS_ERROR_RESPONSE_NONE. Default value when
     * not specified in API or module is interpreted by ALB Controller as
     * DNS_ERROR_RESPONSE_NONE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorResponse() {
        return this.errorResponse;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsServiceApplicationProfile#ERROR_RESPONSE_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBDnsServiceApplicationProfile#ERROR_RESPONSE_NONE}</li>
     * </ul> Drop or respond to client when the DNS service encounters an error
     * processing a client query. By default, such a request is dropped without any
     * response, or passed through to a passthrough pool, if configured. When set to
     * respond, an appropriate response is sent to client, e.g. NXDOMAIN response for
     * non-existent records, empty NOERROR response for unsupported queries, etc. Enum
     * options - DNS_ERROR_RESPONSE_ERROR, DNS_ERROR_RESPONSE_NONE. Default value when
     * not specified in API or module is interpreted by ALB Controller as
     * DNS_ERROR_RESPONSE_NONE.
     *
     * @param errorResponse New value for the property.
     */
    public void setErrorResponse(java.lang.String errorResponse) {
        this.errorResponse = errorResponse;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public java.lang.String getNameServer() {
        return this.nameServer;
    }

    /**
     *
     *
     * @param nameServer New value for the property.
     */
    public void setNameServer(java.lang.String nameServer) {
        this.nameServer = nameServer;
    }

    /**
     * Specifies the TTL value (in seconds) for SOA (Start of Authority) (corresponding
     * to a authoritative domain owned by this DNS Virtual Service) record's minimum
     * TTL served by the DNS Virtual Service. Allowed values are 0-86400. Unit is SEC.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 30. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNegativeCachingTtl() {
        return this.negativeCachingTtl;
    }

    /**
     * Specifies the TTL value (in seconds) for SOA (Start of Authority) (corresponding
     * to a authoritative domain owned by this DNS Virtual Service) record's minimum
     * TTL served by the DNS Virtual Service. Allowed values are 0-86400. Unit is SEC.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 30. format: int64
     *
     * @param negativeCachingTtl New value for the property.
     */
    public void setNegativeCachingTtl(java.lang.Long negativeCachingTtl) {
        this.negativeCachingTtl = negativeCachingTtl;
    }

    /**
     * Specifies the number of IP addresses returned by the DNS Service. Enter 0 to
     * return all IP addresses. Allowed values are 1-20. Special values are 0- 'Return
     * all IP addresses'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumDnsIp() {
        return this.numDnsIp;
    }

    /**
     * Specifies the number of IP addresses returned by the DNS Service. Enter 0 to
     * return all IP addresses. Allowed values are 1-20. Special values are 0- 'Return
     * all IP addresses'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1. format: int64
     *
     * @param numDnsIp New value for the property.
     */
    public void setNumDnsIp(java.lang.Long numDnsIp) {
        this.numDnsIp = numDnsIp;
    }

    /**
     * Specifies the TTL value (in seconds) for records served by DNS Service. Allowed
     * values are 0-86400. Unit is SEC. Default value when not specified in API or
     * module is interpreted by ALB Controller as 30. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTtl() {
        return this.ttl;
    }

    /**
     * Specifies the TTL value (in seconds) for records served by DNS Service. Allowed
     * values are 0-86400. Unit is SEC. Default value when not specified in API or
     * module is interpreted by ALB Controller as 30. format: int64
     *
     * @param ttl New value for the property.
     */
    public void setTtl(java.lang.Long ttl) {
        this.ttl = ttl;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsServiceApplicationProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("aaaa_empty_response",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.aaaaEmptyResponse, this._getType().getField("aaaa_empty_response")));
        structValue.setField("admin_email",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminEmail, this._getType().getField("admin_email")));
        structValue.setField("dns_over_tcp_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsOverTcpEnabled, this._getType().getField("dns_over_tcp_enabled")));
        structValue.setField("dns_zones",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsZones, this._getType().getField("dns_zones")));
        structValue.setField("domain_names",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.domainNames, this._getType().getField("domain_names")));
        structValue.setField("ecs_stripping_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ecsStrippingEnabled, this._getType().getField("ecs_stripping_enabled")));
        structValue.setField("edns",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.edns, this._getType().getField("edns")));
        structValue.setField("edns_client_subnet_prefix_len",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ednsClientSubnetPrefixLen, this._getType().getField("edns_client_subnet_prefix_len")));
        structValue.setField("error_response",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorResponse, this._getType().getField("error_response")));
        structValue.setField("name_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nameServer, this._getType().getField("name_server")));
        structValue.setField("negative_caching_ttl",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.negativeCachingTtl, this._getType().getField("negative_caching_ttl")));
        structValue.setField("num_dns_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numDnsIp, this._getType().getField("num_dns_ip")));
        structValue.setField("ttl",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ttl, this._getType().getField("ttl")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsServiceApplicationProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsServiceApplicationProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBDnsServiceApplicationProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsServiceApplicationProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBDnsServiceApplicationProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBDnsServiceApplicationProfile(structValue);
    }

    /**
     * Builder class for {@link ALBDnsServiceApplicationProfile}.
     */
    public static final class Builder {
        private java.lang.Boolean aaaaEmptyResponse;
        private java.lang.String adminEmail;
        private java.lang.Boolean dnsOverTcpEnabled;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBDnsZone> dnsZones;
        private java.util.List<java.lang.String> domainNames;
        private java.lang.Boolean ecsStrippingEnabled;
        private java.lang.Boolean edns;
        private java.lang.Long ednsClientSubnetPrefixLen;
        private java.lang.String errorResponse;
        private java.lang.String nameServer;
        private java.lang.Long negativeCachingTtl;
        private java.lang.Long numDnsIp;
        private java.lang.Long ttl;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBDnsServiceApplicationProfile}.
         */
        public Builder() {
        }

        /**
         * Respond to AAAA queries with empty response when there are only IPV4 records.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as true.
         *
         * @param aaaaEmptyResponse New value for the property.
         */
        public Builder setAaaaEmptyResponse(java.lang.Boolean aaaaEmptyResponse) {
            this.aaaaEmptyResponse = aaaaEmptyResponse;
            return this;
        }

        /**
         * Email address of the administrator responsible for this zone. This field is used
         * in SOA records (rname) pertaining to all domain names specified as authoritative
         * domain names. If not configured, the default value 'hostmaster' is used in SOA
         * responses. Default value when not specified in API or module is interpreted by
         * ALB Controller as hostmaster.
         *
         * @param adminEmail New value for the property.
         */
        public Builder setAdminEmail(java.lang.String adminEmail) {
            this.adminEmail = adminEmail;
            return this;
        }

        /**
         * Enable DNS query/response over TCP. This enables analytics for pass-through
         * queries as well. Default value when not specified in API or module is
         * interpreted by ALB Controller as true.
         *
         * @param dnsOverTcpEnabled New value for the property.
         */
        public Builder setDnsOverTcpEnabled(java.lang.Boolean dnsOverTcpEnabled) {
            this.dnsOverTcpEnabled = dnsOverTcpEnabled;
            return this;
        }

        /**
         * DNS zones hosted on this Virtual Service. Maximum of 100 items allowed.
         *
         * @param dnsZones New value for the property.
         */
        public Builder setDnsZones(java.util.List<com.vmware.nsx_global_policy.model.ALBDnsZone> dnsZones) {
            this.dnsZones = dnsZones;
            return this;
        }

        /**
         * Subdomain names serviced by this Virtual Service. These are configured as
         * Ends-With semantics. Maximum of 100 items allowed.
         *
         * @param domainNames New value for the property.
         */
        public Builder setDomainNames(java.util.List<java.lang.String> domainNames) {
            this.domainNames = domainNames;
            return this;
        }

        /**
         * Enable stripping of EDNS client subnet (ecs) option towards client if DNS
         * service inserts ecs option in the DNS query towards upstream servers. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * true.
         *
         * @param ecsStrippingEnabled New value for the property.
         */
        public Builder setEcsStrippingEnabled(java.lang.Boolean ecsStrippingEnabled) {
            this.ecsStrippingEnabled = ecsStrippingEnabled;
            return this;
        }

        /**
         * Enable DNS service to be aware of EDNS (Extension mechanism for DNS). EDNS
         * extensions are parsed and shown in logs. For GSLB services, the EDNS client
         * subnet option can be used to influence Load Balancing. Default value when not
         * specified in API or module is interpreted by ALB Controller as true.
         *
         * @param edns New value for the property.
         */
        public Builder setEdns(java.lang.Boolean edns) {
            this.edns = edns;
            return this;
        }

        /**
         * Specifies the IP address prefix length to use in the EDNS client subnet (ECS)
         * option. When the incoming request does not have any ECS option and the prefix
         * length is specified, an ECS option is inserted in the request passed to upstream
         * server. If the incoming request already has an ECS option, the prefix length
         * (and correspondingly the address) in the ECS option is updated, with the minimum
         * of the prefix length present in the incoming and the configured prefix length,
         * before passing the request to upstream server. Allowed values are 1-32. format:
         * int64
         *
         * @param ednsClientSubnetPrefixLen New value for the property.
         */
        public Builder setEdnsClientSubnetPrefixLen(java.lang.Long ednsClientSubnetPrefixLen) {
            this.ednsClientSubnetPrefixLen = ednsClientSubnetPrefixLen;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsServiceApplicationProfile#ERROR_RESPONSE_ERROR}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBDnsServiceApplicationProfile#ERROR_RESPONSE_NONE}</li>
         * </ul> Drop or respond to client when the DNS service encounters an error
         * processing a client query. By default, such a request is dropped without any
         * response, or passed through to a passthrough pool, if configured. When set to
         * respond, an appropriate response is sent to client, e.g. NXDOMAIN response for
         * non-existent records, empty NOERROR response for unsupported queries, etc. Enum
         * options - DNS_ERROR_RESPONSE_ERROR, DNS_ERROR_RESPONSE_NONE. Default value when
         * not specified in API or module is interpreted by ALB Controller as
         * DNS_ERROR_RESPONSE_NONE.
         *
         * @param errorResponse New value for the property.
         */
        public Builder setErrorResponse(java.lang.String errorResponse) {
            this.errorResponse = errorResponse;
            return this;
        }

        /**
         *
         *
         * @param nameServer New value for the property.
         */
        public Builder setNameServer(java.lang.String nameServer) {
            this.nameServer = nameServer;
            return this;
        }

        /**
         * Specifies the TTL value (in seconds) for SOA (Start of Authority) (corresponding
         * to a authoritative domain owned by this DNS Virtual Service) record's minimum
         * TTL served by the DNS Virtual Service. Allowed values are 0-86400. Unit is SEC.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 30. format: int64
         *
         * @param negativeCachingTtl New value for the property.
         */
        public Builder setNegativeCachingTtl(java.lang.Long negativeCachingTtl) {
            this.negativeCachingTtl = negativeCachingTtl;
            return this;
        }

        /**
         * Specifies the number of IP addresses returned by the DNS Service. Enter 0 to
         * return all IP addresses. Allowed values are 1-20. Special values are 0- 'Return
         * all IP addresses'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 1. format: int64
         *
         * @param numDnsIp New value for the property.
         */
        public Builder setNumDnsIp(java.lang.Long numDnsIp) {
            this.numDnsIp = numDnsIp;
            return this;
        }

        /**
         * Specifies the TTL value (in seconds) for records served by DNS Service. Allowed
         * values are 0-86400. Unit is SEC. Default value when not specified in API or
         * module is interpreted by ALB Controller as 30. format: int64
         *
         * @param ttl New value for the property.
         */
        public Builder setTtl(java.lang.Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public ALBDnsServiceApplicationProfile build() {
            ALBDnsServiceApplicationProfile result = new ALBDnsServiceApplicationProfile();
            result.setAaaaEmptyResponse(this.aaaaEmptyResponse);
            result.setAdminEmail(this.adminEmail);
            result.setDnsOverTcpEnabled(this.dnsOverTcpEnabled);
            result.setDnsZones(this.dnsZones);
            result.setDomainNames(this.domainNames);
            result.setEcsStrippingEnabled(this.ecsStrippingEnabled);
            result.setEdns(this.edns);
            result.setEdnsClientSubnetPrefixLen(this.ednsClientSubnetPrefixLen);
            result.setErrorResponse(this.errorResponse);
            result.setNameServer(this.nameServer);
            result.setNegativeCachingTtl(this.negativeCachingTtl);
            result.setNumDnsIp(this.numDnsIp);
            result.setTtl(this.ttl);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("aaaa_empty_response", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("aaaa_empty_response",
                                                                                "aaaaEmptyResponse",
                                                                                "getAaaaEmptyResponse",
                                                                                "setAaaaEmptyResponse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("admin_email", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_email",
                                                                                "adminEmail",
                                                                                "getAdminEmail",
                                                                                "setAdminEmail");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_over_tcp_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_over_tcp_enabled",
                                                                                "dnsOverTcpEnabled",
                                                                                "getDnsOverTcpEnabled",
                                                                                "setDnsOverTcpEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_zones", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBDnsZone; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_zones",
                                                                                "dnsZones",
                                                                                "getDnsZones",
                                                                                "setDnsZones");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("domain_names", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("domain_names",
                                                                                "domainNames",
                                                                                "getDomainNames",
                                                                                "setDomainNames");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ecs_stripping_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ecs_stripping_enabled",
                                                                                "ecsStrippingEnabled",
                                                                                "getEcsStrippingEnabled",
                                                                                "setEcsStrippingEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("edns", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edns",
                                                                                "edns",
                                                                                "getEdns",
                                                                                "setEdns");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("edns_client_subnet_prefix_len", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("edns_client_subnet_prefix_len",
                                                                                "ednsClientSubnetPrefixLen",
                                                                                "getEdnsClientSubnetPrefixLen",
                                                                                "setEdnsClientSubnetPrefixLen");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_response", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_response",
                                                                                "errorResponse",
                                                                                "getErrorResponse",
                                                                                "setErrorResponse");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name_server",
                                                                                "nameServer",
                                                                                "getNameServer",
                                                                                "setNameServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("negative_caching_ttl", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("negative_caching_ttl",
                                                                                "negativeCachingTtl",
                                                                                "getNegativeCachingTtl",
                                                                                "setNegativeCachingTtl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("num_dns_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_dns_ip",
                                                                                "numDnsIp",
                                                                                "getNumDnsIp",
                                                                                "setNumDnsIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ttl", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ttl",
                                                                                "ttl",
                                                                                "getTtl",
                                                                                "setTtl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_dns_service_application_profile",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBDnsServiceApplicationProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

