/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer FullClientLogs object
 */
public final class ALBFullClientLogs implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long duration;

    private java.lang.Boolean enabled;

    private java.lang.Long throttle;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBFullClientLogs() {
    }

    protected ALBFullClientLogs(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * How long should the system capture all logs, measured in minutes. Set to 0 for
     * infinite. Special values are 0 - 'infinite'. Unit is MIN. Default value when not
     * specified in API or module is interpreted by ALB Controller as 30. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDuration() {
        return this.duration;
    }

    /**
     * How long should the system capture all logs, measured in minutes. Set to 0 for
     * infinite. Special values are 0 - 'infinite'. Unit is MIN. Default value when not
     * specified in API or module is interpreted by ALB Controller as 30. format: int64
     *
     * @param duration New value for the property.
     */
    public void setDuration(java.lang.Long duration) {
        this.duration = duration;
    }

    /**
     * Capture all client logs including connections and requests. When deactivated,
     * only errors will be logged. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Special default
     * for Basic edition is false, Essentials edition is false, Enterprise is False.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Capture all client logs including connections and requests. When deactivated,
     * only errors will be logged. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Special default
     * for Basic edition is false, Essentials edition is false, Enterprise is False.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * This setting limits the number of non-significant logs generated per second for
     * this VS on each SE. Default is 10 logs per second. Set it to zero (0) to
     * deactivate throttling. Unit is PER_SECOND. Default value when not specified in
     * API or module is interpreted by ALB Controller as 10. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getThrottle() {
        return this.throttle;
    }

    /**
     * This setting limits the number of non-significant logs generated per second for
     * this VS on each SE. Default is 10 logs per second. Set it to zero (0) to
     * deactivate throttling. Unit is PER_SECOND. Default value when not specified in
     * API or module is interpreted by ALB Controller as 10. format: int64
     *
     * @param throttle New value for the property.
     */
    public void setThrottle(java.lang.Long throttle) {
        this.throttle = throttle;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBFullClientLogs;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("duration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.duration, this._getType().getField("duration")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("throttle",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.throttle, this._getType().getField("throttle")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBFullClientLogs;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBFullClientLogs.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBFullClientLogs _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBFullClientLogs(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBFullClientLogs _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBFullClientLogs(structValue);
    }

    /**
     * Builder class for {@link ALBFullClientLogs}.
     */
    public static final class Builder {
        private java.lang.Long duration;
        private java.lang.Boolean enabled;
        private java.lang.Long throttle;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBFullClientLogs}.
         */
        public Builder() {
        }

        /**
         * How long should the system capture all logs, measured in minutes. Set to 0 for
         * infinite. Special values are 0 - 'infinite'. Unit is MIN. Default value when not
         * specified in API or module is interpreted by ALB Controller as 30. format: int64
         *
         * @param duration New value for the property.
         */
        public Builder setDuration(java.lang.Long duration) {
            this.duration = duration;
            return this;
        }

        /**
         * Capture all client logs including connections and requests. When deactivated,
         * only errors will be logged. Allowed in Basic(Allowed values- false) edition,
         * Essentials(Allowed values- false) edition, Enterprise edition. Special default
         * for Basic edition is false, Essentials edition is false, Enterprise is False.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * This setting limits the number of non-significant logs generated per second for
         * this VS on each SE. Default is 10 logs per second. Set it to zero (0) to
         * deactivate throttling. Unit is PER_SECOND. Default value when not specified in
         * API or module is interpreted by ALB Controller as 10. format: int64
         *
         * @param throttle New value for the property.
         */
        public Builder setThrottle(java.lang.Long throttle) {
            this.throttle = throttle;
            return this;
        }

        public ALBFullClientLogs build() {
            ALBFullClientLogs result = new ALBFullClientLogs();
            result.setDuration(this.duration);
            result.setEnabled(this.enabled);
            result.setThrottle(this.throttle);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("duration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("duration",
                                                                                "duration",
                                                                                "getDuration",
                                                                                "setDuration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("throttle", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("throttle",
                                                                                "throttle",
                                                                                "getThrottle",
                                                                                "setThrottle");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_full_client_logs",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBFullClientLogs.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

