/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer HTTPApplicationProfile object
 */
public final class ALBHTTPApplicationProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SSL_CLIENT_CERTIFICATE_MODE_NONE = "SSL_CLIENT_CERTIFICATE_NONE";

    public static final java.lang.String SSL_CLIENT_CERTIFICATE_MODE_REQUEST = "SSL_CLIENT_CERTIFICATE_REQUEST";

    public static final java.lang.String SSL_CLIENT_CERTIFICATE_MODE_REQUIRE = "SSL_CLIENT_CERTIFICATE_REQUIRE";

    private java.lang.Boolean allowDotsInHeaderName;

    private com.vmware.nsx_global_policy.model.ALBHttpCacheConfig cacheConfig;

    private java.lang.Long clientBodyTimeout;

    private java.lang.Long clientHeaderTimeout;

    private java.lang.Long clientMaxBodySize;

    private java.lang.Long clientMaxHeaderSize;

    private java.lang.Long clientMaxRequestSize;

    private com.vmware.nsx_global_policy.model.ALBCompressionProfile compressionProfile;

    private java.lang.Boolean connectionMultiplexingEnabled;

    private java.lang.Boolean disableKeepalivePostsMsie6;

    private java.lang.Boolean disableSniHostnameCheck;

    private java.lang.Boolean enableChunkMerge;

    private java.lang.Boolean enableFireAndForget;

    private java.lang.Boolean enableRequestBodyBuffering;

    private java.lang.Boolean enableRequestBodyMetrics;

    private java.lang.Boolean fwdCloseHdrForBoundConnections;

    private java.lang.Boolean hstsEnabled;

    private java.lang.Long hstsMaxAge;

    private java.lang.Boolean hstsSubdomainsEnabled;

    private com.vmware.nsx_global_policy.model.ALBHTTP2ApplicationProfile http2Profile;

    private java.lang.Boolean httpToHttps;

    private java.lang.Long httpUpstreamBufferSize;

    private java.lang.Boolean httponlyEnabled;

    private java.lang.Boolean keepaliveHeader;

    private java.lang.Long keepaliveTimeout;

    private java.lang.Long maxBadRpsCip;

    private java.lang.Long maxBadRpsCipUri;

    private java.lang.Long maxBadRpsUri;

    private java.lang.Long maxKeepaliveRequests;

    private java.lang.Long maxResponseHeadersSize;

    private java.lang.Long maxRpsCip;

    private java.lang.Long maxRpsCipUri;

    private java.lang.Long maxRpsUnknownCip;

    private java.lang.Long maxRpsUnknownUri;

    private java.lang.Long maxRpsUri;

    private java.lang.String pkiProfilePath;

    private java.lang.Long postAcceptTimeout;

    private java.lang.Boolean resetConnHttpOnSslPort;

    private java.lang.Boolean respondWith100Continue;

    private java.lang.Boolean secureCookieEnabled;

    private java.lang.Boolean serverSideRedirectToHttps;

    private com.vmware.nsx_global_policy.model.ALBSSLClientCertificateAction sslClientCertificateAction;

    private java.lang.String sslClientCertificateMode;

    private java.lang.Boolean useAppKeepaliveTimeout;

    private java.lang.Boolean websocketsEnabled;

    private java.lang.Boolean xForwardedProtoEnabled;

    private java.lang.String xffAlternateName;

    private java.lang.Boolean xffEnabled;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBHTTPApplicationProfile() {
    }

    protected ALBHTTPApplicationProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Allow use of dot (.) in HTTP header names, for instance Header.app.special
     * PickAppVersionX. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAllowDotsInHeaderName() {
        return this.allowDotsInHeaderName;
    }

    /**
     * Allow use of dot (.) in HTTP header names, for instance Header.app.special
     * PickAppVersionX. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param allowDotsInHeaderName New value for the property.
     */
    public void setAllowDotsInHeaderName(java.lang.Boolean allowDotsInHeaderName) {
        this.allowDotsInHeaderName = allowDotsInHeaderName;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBHttpCacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    /**
     *
     *
     * @param cacheConfig New value for the property.
     */
    public void setCacheConfig(com.vmware.nsx_global_policy.model.ALBHttpCacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    /**
     * The maximum length of time allowed between consecutive read operations for a
     * client request body. The value '0' specifies no timeout. This setting generally
     * impacts the length of time allowed for a client to send a POST. Allowed values
     * are 0-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 30000)
     * edition, Essentials(Allowed values- 30000) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 30000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getClientBodyTimeout() {
        return this.clientBodyTimeout;
    }

    /**
     * The maximum length of time allowed between consecutive read operations for a
     * client request body. The value '0' specifies no timeout. This setting generally
     * impacts the length of time allowed for a client to send a POST. Allowed values
     * are 0-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 30000)
     * edition, Essentials(Allowed values- 30000) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 30000. format: int64
     *
     * @param clientBodyTimeout New value for the property.
     */
    public void setClientBodyTimeout(java.lang.Long clientBodyTimeout) {
        this.clientBodyTimeout = clientBodyTimeout;
    }

    /**
     * The maximum length of time allowed for a client to transmit an entire request
     * header. This helps mitigate various forms of SlowLoris attacks. Allowed values
     * are 10-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 10000)
     * edition, Essentials(Allowed values- 10000) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 10000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getClientHeaderTimeout() {
        return this.clientHeaderTimeout;
    }

    /**
     * The maximum length of time allowed for a client to transmit an entire request
     * header. This helps mitigate various forms of SlowLoris attacks. Allowed values
     * are 10-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 10000)
     * edition, Essentials(Allowed values- 10000) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 10000. format: int64
     *
     * @param clientHeaderTimeout New value for the property.
     */
    public void setClientHeaderTimeout(java.lang.Long clientHeaderTimeout) {
        this.clientHeaderTimeout = clientHeaderTimeout;
    }

    /**
     * Maximum size for the client request body. This limits the size of the client
     * data that can be uploaded/posted as part of a single HTTP Request. Default 0 =>
     * Unlimited. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getClientMaxBodySize() {
        return this.clientMaxBodySize;
    }

    /**
     * Maximum size for the client request body. This limits the size of the client
     * data that can be uploaded/posted as part of a single HTTP Request. Default 0 =>
     * Unlimited. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param clientMaxBodySize New value for the property.
     */
    public void setClientMaxBodySize(java.lang.Long clientMaxBodySize) {
        this.clientMaxBodySize = clientMaxBodySize;
    }

    /**
     * Maximum size in Kbytes of a single HTTP header in the client request. Allowed
     * values are 1-64. Unit is KB. Allowed in Basic(Allowed values- 12) edition,
     * Essentials(Allowed values- 12) edition, Enterprise edition. Default value when
     * not specified in API or module is interpreted by ALB Controller as 12. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getClientMaxHeaderSize() {
        return this.clientMaxHeaderSize;
    }

    /**
     * Maximum size in Kbytes of a single HTTP header in the client request. Allowed
     * values are 1-64. Unit is KB. Allowed in Basic(Allowed values- 12) edition,
     * Essentials(Allowed values- 12) edition, Enterprise edition. Default value when
     * not specified in API or module is interpreted by ALB Controller as 12. format:
     * int64
     *
     * @param clientMaxHeaderSize New value for the property.
     */
    public void setClientMaxHeaderSize(java.lang.Long clientMaxHeaderSize) {
        this.clientMaxHeaderSize = clientMaxHeaderSize;
    }

    /**
     * Maximum size in Kbytes of all the client HTTP request headers. Allowed values
     * are 1-256. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 48. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getClientMaxRequestSize() {
        return this.clientMaxRequestSize;
    }

    /**
     * Maximum size in Kbytes of all the client HTTP request headers. Allowed values
     * are 1-256. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 48. format: int64
     *
     * @param clientMaxRequestSize New value for the property.
     */
    public void setClientMaxRequestSize(java.lang.Long clientMaxRequestSize) {
        this.clientMaxRequestSize = clientMaxRequestSize;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBCompressionProfile getCompressionProfile() {
        return this.compressionProfile;
    }

    /**
     *
     *
     * @param compressionProfile New value for the property.
     */
    public void setCompressionProfile(com.vmware.nsx_global_policy.model.ALBCompressionProfile compressionProfile) {
        this.compressionProfile = compressionProfile;
    }

    /**
     * Allows HTTP requests, not just TCP connections, to be load balanced across
     * servers. Proxied TCP connections to servers may be reused by multiple clients to
     * improve performance. Not compatible with Preserve Client IP. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getConnectionMultiplexingEnabled() {
        return this.connectionMultiplexingEnabled;
    }

    /**
     * Allows HTTP requests, not just TCP connections, to be load balanced across
     * servers. Proxied TCP connections to servers may be reused by multiple clients to
     * improve performance. Not compatible with Preserve Client IP. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @param connectionMultiplexingEnabled New value for the property.
     */
    public void setConnectionMultiplexingEnabled(java.lang.Boolean connectionMultiplexingEnabled) {
        this.connectionMultiplexingEnabled = connectionMultiplexingEnabled;
    }

    /**
     * Disable keep-alive client side connections for older browsers based off MS
     * Internet Explorer 6.0 (MSIE6). For some applications, this might break NTLM
     * authentication for older clients based off MSIE6. For such applications, set
     * this option to false to allow keep-alive connections. Allowed in Basic(Allowed
     * values- true) edition, Essentials(Allowed values- true) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDisableKeepalivePostsMsie6() {
        return this.disableKeepalivePostsMsie6;
    }

    /**
     * Disable keep-alive client side connections for older browsers based off MS
     * Internet Explorer 6.0 (MSIE6). For some applications, this might break NTLM
     * authentication for older clients based off MSIE6. For such applications, set
     * this option to false to allow keep-alive connections. Allowed in Basic(Allowed
     * values- true) edition, Essentials(Allowed values- true) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as true.
     *
     * @param disableKeepalivePostsMsie6 New value for the property.
     */
    public void setDisableKeepalivePostsMsie6(java.lang.Boolean disableKeepalivePostsMsie6) {
        this.disableKeepalivePostsMsie6 = disableKeepalivePostsMsie6;
    }

    /**
     * Disable strict check between TLS servername and HTTP Host name. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDisableSniHostnameCheck() {
        return this.disableSniHostnameCheck;
    }

    /**
     * Disable strict check between TLS servername and HTTP Host name. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param disableSniHostnameCheck New value for the property.
     */
    public void setDisableSniHostnameCheck(java.lang.Boolean disableSniHostnameCheck) {
        this.disableSniHostnameCheck = disableSniHostnameCheck;
    }

    /**
     * Enable chunk body merge for chunked transfer encoding response. Default value
     * when not specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableChunkMerge() {
        return this.enableChunkMerge;
    }

    /**
     * Enable chunk body merge for chunked transfer encoding response. Default value
     * when not specified in API or module is interpreted by ALB Controller as true.
     *
     * @param enableChunkMerge New value for the property.
     */
    public void setEnableChunkMerge(java.lang.Boolean enableChunkMerge) {
        this.enableChunkMerge = enableChunkMerge;
    }

    /**
     * Enable support for fire and forget feature. If enabled, request from client is
     * forwarded to server even if client prematurely closes the connection. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableFireAndForget() {
        return this.enableFireAndForget;
    }

    /**
     * Enable support for fire and forget feature. If enabled, request from client is
     * forwarded to server even if client prematurely closes the connection. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param enableFireAndForget New value for the property.
     */
    public void setEnableFireAndForget(java.lang.Boolean enableFireAndForget) {
        this.enableFireAndForget = enableFireAndForget;
    }

    /**
     * Enable request body buffering for POST requests. If enabled, max buffer size is
     * set to lower of 32M or the value (non-zero) configured in client_max_body_size.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableRequestBodyBuffering() {
        return this.enableRequestBodyBuffering;
    }

    /**
     * Enable request body buffering for POST requests. If enabled, max buffer size is
     * set to lower of 32M or the value (non-zero) configured in client_max_body_size.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param enableRequestBodyBuffering New value for the property.
     */
    public void setEnableRequestBodyBuffering(java.lang.Boolean enableRequestBodyBuffering) {
        this.enableRequestBodyBuffering = enableRequestBodyBuffering;
    }

    /**
     * Enable HTTP request body metrics. If enabled, requests from clients are parsed
     * and relevant statistics about them are gathered. Currently, it processes HTTP
     * POST requests with Content-Type application/x-www-form-urlencoded or
     * multipart/form-data, and adds the number of detected parameters to the
     * l7_client.http_params_count. This is an experimental feature and it may have
     * performance impact. Use it when detailed information about the number of HTTP
     * POST parameters is needed, e.g. for WAF sizing. Allowed in Basic(Allowed values-
     * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableRequestBodyMetrics() {
        return this.enableRequestBodyMetrics;
    }

    /**
     * Enable HTTP request body metrics. If enabled, requests from clients are parsed
     * and relevant statistics about them are gathered. Currently, it processes HTTP
     * POST requests with Content-Type application/x-www-form-urlencoded or
     * multipart/form-data, and adds the number of detected parameters to the
     * l7_client.http_params_count. This is an experimental feature and it may have
     * performance impact. Use it when detailed information about the number of HTTP
     * POST parameters is needed, e.g. for WAF sizing. Allowed in Basic(Allowed values-
     * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param enableRequestBodyMetrics New value for the property.
     */
    public void setEnableRequestBodyMetrics(java.lang.Boolean enableRequestBodyMetrics) {
        this.enableRequestBodyMetrics = enableRequestBodyMetrics;
    }

    /**
     * Forward the Connection Close header coming from backend server to the client if
     * connection-switching is enabled, i.e. front-end and backend connections are
     * bound together. Default value when not specified in API or module is interpreted
     * by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getFwdCloseHdrForBoundConnections() {
        return this.fwdCloseHdrForBoundConnections;
    }

    /**
     * Forward the Connection Close header coming from backend server to the client if
     * connection-switching is enabled, i.e. front-end and backend connections are
     * bound together. Default value when not specified in API or module is interpreted
     * by ALB Controller as true.
     *
     * @param fwdCloseHdrForBoundConnections New value for the property.
     */
    public void setFwdCloseHdrForBoundConnections(java.lang.Boolean fwdCloseHdrForBoundConnections) {
        this.fwdCloseHdrForBoundConnections = fwdCloseHdrForBoundConnections;
    }

    /**
     * Inserts HTTP Strict-Transport-Security header in the HTTPS response. HSTS can
     * help mitigate man-in-the-middle attacks by telling browsers that support HSTS
     * that they should only access this site via HTTPS. Allowed in Basic(Allowed
     * values- false) edition, Essentials(Allowed values- false) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHstsEnabled() {
        return this.hstsEnabled;
    }

    /**
     * Inserts HTTP Strict-Transport-Security header in the HTTPS response. HSTS can
     * help mitigate man-in-the-middle attacks by telling browsers that support HSTS
     * that they should only access this site via HTTPS. Allowed in Basic(Allowed
     * values- false) edition, Essentials(Allowed values- false) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param hstsEnabled New value for the property.
     */
    public void setHstsEnabled(java.lang.Boolean hstsEnabled) {
        this.hstsEnabled = hstsEnabled;
    }

    /**
     * Number of days for which the client should regard this virtual service as a
     * known HSTS host. Allowed values are 0-10000. Allowed in Basic(Allowed values-
     * 365) edition, Essentials(Allowed values- 365) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 365. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getHstsMaxAge() {
        return this.hstsMaxAge;
    }

    /**
     * Number of days for which the client should regard this virtual service as a
     * known HSTS host. Allowed values are 0-10000. Allowed in Basic(Allowed values-
     * 365) edition, Essentials(Allowed values- 365) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 365. format: int64
     *
     * @param hstsMaxAge New value for the property.
     */
    public void setHstsMaxAge(java.lang.Long hstsMaxAge) {
        this.hstsMaxAge = hstsMaxAge;
    }

    /**
     * Insert the 'includeSubdomains' directive in the HTTP Strict-Transport-Security
     * header. Adding the includeSubdomains directive signals the User-Agent that the
     * HSTS Policy applies to this HSTS Host as well as any subdomains of the host's
     * domain name. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Special default for Basic edition is
     * false, Essentials edition is false, Enterprise is True. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHstsSubdomainsEnabled() {
        return this.hstsSubdomainsEnabled;
    }

    /**
     * Insert the 'includeSubdomains' directive in the HTTP Strict-Transport-Security
     * header. Adding the includeSubdomains directive signals the User-Agent that the
     * HSTS Policy applies to this HSTS Host as well as any subdomains of the host's
     * domain name. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Special default for Basic edition is
     * false, Essentials edition is false, Enterprise is True. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @param hstsSubdomainsEnabled New value for the property.
     */
    public void setHstsSubdomainsEnabled(java.lang.Boolean hstsSubdomainsEnabled) {
        this.hstsSubdomainsEnabled = hstsSubdomainsEnabled;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBHTTP2ApplicationProfile getHttp2Profile() {
        return this.http2Profile;
    }

    /**
     *
     *
     * @param http2Profile New value for the property.
     */
    public void setHttp2Profile(com.vmware.nsx_global_policy.model.ALBHTTP2ApplicationProfile http2Profile) {
        this.http2Profile = http2Profile;
    }

    /**
     * Client requests received via HTTP will be redirected to HTTPS. Allowed in
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHttpToHttps() {
        return this.httpToHttps;
    }

    /**
     * Client requests received via HTTP will be redirected to HTTPS. Allowed in
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param httpToHttps New value for the property.
     */
    public void setHttpToHttps(java.lang.Boolean httpToHttps) {
        this.httpToHttps = httpToHttps;
    }

    /**
     * Size of HTTP buffer in kB. Allowed values are 1-256. Special values are 0- 'Auto
     * compute the size of buffer'. Unit is KB. Allowed in Basic(Allowed values- 0)
     * edition, Essentials(Allowed values- 0) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getHttpUpstreamBufferSize() {
        return this.httpUpstreamBufferSize;
    }

    /**
     * Size of HTTP buffer in kB. Allowed values are 1-256. Special values are 0- 'Auto
     * compute the size of buffer'. Unit is KB. Allowed in Basic(Allowed values- 0)
     * edition, Essentials(Allowed values- 0) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @param httpUpstreamBufferSize New value for the property.
     */
    public void setHttpUpstreamBufferSize(java.lang.Long httpUpstreamBufferSize) {
        this.httpUpstreamBufferSize = httpUpstreamBufferSize;
    }

    /**
     * Mark HTTP cookies as HTTPonly. This helps mitigate cross site scripting attacks
     * as browsers will not allow these cookies to be read by third parties, such as
     * javascript. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHttponlyEnabled() {
        return this.httponlyEnabled;
    }

    /**
     * Mark HTTP cookies as HTTPonly. This helps mitigate cross site scripting attacks
     * as browsers will not allow these cookies to be read by third parties, such as
     * javascript. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @param httponlyEnabled New value for the property.
     */
    public void setHttponlyEnabled(java.lang.Boolean httponlyEnabled) {
        this.httponlyEnabled = httponlyEnabled;
    }

    /**
     * Send HTTP 'Keep-Alive' header to the client. By default, the timeout specified
     * in the 'Keep-Alive Timeout' field will be used unless the 'Use App Keepalive
     * Timeout' flag is set, in which case the timeout sent by the application will be
     * honored. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getKeepaliveHeader() {
        return this.keepaliveHeader;
    }

    /**
     * Send HTTP 'Keep-Alive' header to the client. By default, the timeout specified
     * in the 'Keep-Alive Timeout' field will be used unless the 'Use App Keepalive
     * Timeout' flag is set, in which case the timeout sent by the application will be
     * honored. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param keepaliveHeader New value for the property.
     */
    public void setKeepaliveHeader(java.lang.Boolean keepaliveHeader) {
        this.keepaliveHeader = keepaliveHeader;
    }

    /**
     * The max idle time allowed between HTTP requests over a Keep-alive connection.
     * Allowed values are 10-100000000. Unit is MILLISECONDS. Allowed in
     * Essentials(Allowed values- 30000) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as 30000.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getKeepaliveTimeout() {
        return this.keepaliveTimeout;
    }

    /**
     * The max idle time allowed between HTTP requests over a Keep-alive connection.
     * Allowed values are 10-100000000. Unit is MILLISECONDS. Allowed in
     * Essentials(Allowed values- 30000) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as 30000.
     * format: int64
     *
     * @param keepaliveTimeout New value for the property.
     */
    public void setKeepaliveTimeout(java.lang.Long keepaliveTimeout) {
        this.keepaliveTimeout = keepaliveTimeout;
    }

    /**
     * Maximum bad requests per second per client IP. Allowed values are 10-1000.
     * Special values are 0- 'unlimited'. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxBadRpsCip() {
        return this.maxBadRpsCip;
    }

    /**
     * Maximum bad requests per second per client IP. Allowed values are 10-1000.
     * Special values are 0- 'unlimited'. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @param maxBadRpsCip New value for the property.
     */
    public void setMaxBadRpsCip(java.lang.Long maxBadRpsCip) {
        this.maxBadRpsCip = maxBadRpsCip;
    }

    /**
     * Maximum bad requests per second per client IP and URI. Allowed values are
     * 10-1000. Special values are 0- 'unlimited'. Default value when not specified in
     * API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxBadRpsCipUri() {
        return this.maxBadRpsCipUri;
    }

    /**
     * Maximum bad requests per second per client IP and URI. Allowed values are
     * 10-1000. Special values are 0- 'unlimited'. Default value when not specified in
     * API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @param maxBadRpsCipUri New value for the property.
     */
    public void setMaxBadRpsCipUri(java.lang.Long maxBadRpsCipUri) {
        this.maxBadRpsCipUri = maxBadRpsCipUri;
    }

    /**
     * Maximum bad requests per second per URI. Allowed values are 10-1000. Special
     * values are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxBadRpsUri() {
        return this.maxBadRpsUri;
    }

    /**
     * Maximum bad requests per second per URI. Allowed values are 10-1000. Special
     * values are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param maxBadRpsUri New value for the property.
     */
    public void setMaxBadRpsUri(java.lang.Long maxBadRpsUri) {
        this.maxBadRpsUri = maxBadRpsUri;
    }

    /**
     * The max number of HTTP requests that can be sent over a Keep-Alive connection.
     * '0' means unlimited. Allowed values are 0-1000000. Special values are 0-
     * 'Unlimited requests on a connection'. Allowed in Basic(Allowed values- 100)
     * edition, Essentials(Allowed values- 100) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 100. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxKeepaliveRequests() {
        return this.maxKeepaliveRequests;
    }

    /**
     * The max number of HTTP requests that can be sent over a Keep-Alive connection.
     * '0' means unlimited. Allowed values are 0-1000000. Special values are 0-
     * 'Unlimited requests on a connection'. Allowed in Basic(Allowed values- 100)
     * edition, Essentials(Allowed values- 100) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 100. format: int64
     *
     * @param maxKeepaliveRequests New value for the property.
     */
    public void setMaxKeepaliveRequests(java.lang.Long maxKeepaliveRequests) {
        this.maxKeepaliveRequests = maxKeepaliveRequests;
    }

    /**
     * Maximum size in Kbytes of all the HTTP response headers. Allowed values are
     * 1-256. Unit is KB. Allowed in Basic(Allowed values- 48) edition,
     * Essentials(Allowed values- 48) edition, Enterprise edition. Default value when
     * not specified in API or module is interpreted by ALB Controller as 48. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxResponseHeadersSize() {
        return this.maxResponseHeadersSize;
    }

    /**
     * Maximum size in Kbytes of all the HTTP response headers. Allowed values are
     * 1-256. Unit is KB. Allowed in Basic(Allowed values- 48) edition,
     * Essentials(Allowed values- 48) edition, Enterprise edition. Default value when
     * not specified in API or module is interpreted by ALB Controller as 48. format:
     * int64
     *
     * @param maxResponseHeadersSize New value for the property.
     */
    public void setMaxResponseHeadersSize(java.lang.Long maxResponseHeadersSize) {
        this.maxResponseHeadersSize = maxResponseHeadersSize;
    }

    /**
     * Maximum requests per second per client IP. Allowed values are 10-1000. Special
     * values are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxRpsCip() {
        return this.maxRpsCip;
    }

    /**
     * Maximum requests per second per client IP. Allowed values are 10-1000. Special
     * values are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param maxRpsCip New value for the property.
     */
    public void setMaxRpsCip(java.lang.Long maxRpsCip) {
        this.maxRpsCip = maxRpsCip;
    }

    /**
     * Maximum requests per second per client IP and URI. Allowed values are 10-1000.
     * Special values are 0- 'unlimited'. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxRpsCipUri() {
        return this.maxRpsCipUri;
    }

    /**
     * Maximum requests per second per client IP and URI. Allowed values are 10-1000.
     * Special values are 0- 'unlimited'. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @param maxRpsCipUri New value for the property.
     */
    public void setMaxRpsCipUri(java.lang.Long maxRpsCipUri) {
        this.maxRpsCipUri = maxRpsCipUri;
    }

    /**
     * Maximum unknown client IPs per second. Allowed values are 10-1000. Special
     * values are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxRpsUnknownCip() {
        return this.maxRpsUnknownCip;
    }

    /**
     * Maximum unknown client IPs per second. Allowed values are 10-1000. Special
     * values are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param maxRpsUnknownCip New value for the property.
     */
    public void setMaxRpsUnknownCip(java.lang.Long maxRpsUnknownCip) {
        this.maxRpsUnknownCip = maxRpsUnknownCip;
    }

    /**
     * Maximum unknown URIs per second. Allowed values are 10-1000. Special values are
     * 0- 'unlimited'. Default value when not specified in API or module is interpreted
     * by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxRpsUnknownUri() {
        return this.maxRpsUnknownUri;
    }

    /**
     * Maximum unknown URIs per second. Allowed values are 10-1000. Special values are
     * 0- 'unlimited'. Default value when not specified in API or module is interpreted
     * by ALB Controller as 0. format: int64
     *
     * @param maxRpsUnknownUri New value for the property.
     */
    public void setMaxRpsUnknownUri(java.lang.Long maxRpsUnknownUri) {
        this.maxRpsUnknownUri = maxRpsUnknownUri;
    }

    /**
     * Maximum requests per second per URI. Allowed values are 10-1000. Special values
     * are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxRpsUri() {
        return this.maxRpsUri;
    }

    /**
     * Maximum requests per second per URI. Allowed values are 10-1000. Special values
     * are 0- 'unlimited'. Default value when not specified in API or module is
     * interpreted by ALB Controller as 0. format: int64
     *
     * @param maxRpsUri New value for the property.
     */
    public void setMaxRpsUri(java.lang.Long maxRpsUri) {
        this.maxRpsUri = maxRpsUri;
    }

    /**
     * Select the PKI profile to be associated with the Virtual Service. This profile
     * defines the Certificate Authority and Revocation List. It is a reference to an
     * object of type PKIProfile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPkiProfilePath() {
        return this.pkiProfilePath;
    }

    /**
     * Select the PKI profile to be associated with the Virtual Service. This profile
     * defines the Certificate Authority and Revocation List. It is a reference to an
     * object of type PKIProfile.
     *
     * @param pkiProfilePath New value for the property.
     */
    public void setPkiProfilePath(java.lang.String pkiProfilePath) {
        this.pkiProfilePath = pkiProfilePath;
    }

    /**
     * The max allowed length of time between a client establishing a TCP connection
     * and Avi receives the first byte of the client's HTTP request. Allowed values are
     * 10-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 30000)
     * edition, Essentials(Allowed values- 30000) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 30000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPostAcceptTimeout() {
        return this.postAcceptTimeout;
    }

    /**
     * The max allowed length of time between a client establishing a TCP connection
     * and Avi receives the first byte of the client's HTTP request. Allowed values are
     * 10-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 30000)
     * edition, Essentials(Allowed values- 30000) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * 30000. format: int64
     *
     * @param postAcceptTimeout New value for the property.
     */
    public void setPostAcceptTimeout(java.lang.Long postAcceptTimeout) {
        this.postAcceptTimeout = postAcceptTimeout;
    }

    /**
     * If enabled, an HTTP request on an SSL port will result in connection close
     * instead of a 400 response. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getResetConnHttpOnSslPort() {
        return this.resetConnHttpOnSslPort;
    }

    /**
     * If enabled, an HTTP request on an SSL port will result in connection close
     * instead of a 400 response. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param resetConnHttpOnSslPort New value for the property.
     */
    public void setResetConnHttpOnSslPort(java.lang.Boolean resetConnHttpOnSslPort) {
        this.resetConnHttpOnSslPort = resetConnHttpOnSslPort;
    }

    /**
     * Avi will respond with 100-Continue response if Expect 100-Continue header
     * received from client. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRespondWith100Continue() {
        return this.respondWith100Continue;
    }

    /**
     * Avi will respond with 100-Continue response if Expect 100-Continue header
     * received from client. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @param respondWith100Continue New value for the property.
     */
    public void setRespondWith100Continue(java.lang.Boolean respondWith100Continue) {
        this.respondWith100Continue = respondWith100Continue;
    }

    /**
     * Mark server cookies with the 'Secure' attribute. Client browsers will not send a
     * cookie marked as secure over an unencrypted connection. If Avi is terminating
     * SSL from clients and passing it as HTTP to the server, the server may return
     * cookies without the secure flag set. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSecureCookieEnabled() {
        return this.secureCookieEnabled;
    }

    /**
     * Mark server cookies with the 'Secure' attribute. Client browsers will not send a
     * cookie marked as secure over an unencrypted connection. If Avi is terminating
     * SSL from clients and passing it as HTTP to the server, the server may return
     * cookies without the secure flag set. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @param secureCookieEnabled New value for the property.
     */
    public void setSecureCookieEnabled(java.lang.Boolean secureCookieEnabled) {
        this.secureCookieEnabled = secureCookieEnabled;
    }

    /**
     * When terminating client SSL sessions at Avi, servers may incorrectly send
     * redirect to clients as HTTP. This option will rewrite the server's redirect
     * responses for this virtual service from HTTP to HTTPS. Allowed in Basic(Allowed
     * values- false) edition, Essentials(Allowed values- false) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getServerSideRedirectToHttps() {
        return this.serverSideRedirectToHttps;
    }

    /**
     * When terminating client SSL sessions at Avi, servers may incorrectly send
     * redirect to clients as HTTP. This option will rewrite the server's redirect
     * responses for this virtual service from HTTP to HTTPS. Allowed in Basic(Allowed
     * values- false) edition, Essentials(Allowed values- false) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param serverSideRedirectToHttps New value for the property.
     */
    public void setServerSideRedirectToHttps(java.lang.Boolean serverSideRedirectToHttps) {
        this.serverSideRedirectToHttps = serverSideRedirectToHttps;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBSSLClientCertificateAction getSslClientCertificateAction() {
        return this.sslClientCertificateAction;
    }

    /**
     *
     *
     * @param sslClientCertificateAction New value for the property.
     */
    public void setSslClientCertificateAction(com.vmware.nsx_global_policy.model.ALBSSLClientCertificateAction sslClientCertificateAction) {
        this.sslClientCertificateAction = sslClientCertificateAction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUEST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUIRE}</li>
     * </ul> Specifies whether the client side verification is set to none, request or
     * require. Enum options - SSL_CLIENT_CERTIFICATE_NONE,
     * SSL_CLIENT_CERTIFICATE_REQUEST, SSL_CLIENT_CERTIFICATE_REQUIRE. Allowed in
     * Basic(Allowed values-
     * SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE) edition,
     * Essentials(Allowed values-
     * SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as SSL_CLIENT_CERTIFICATE_NONE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSslClientCertificateMode() {
        return this.sslClientCertificateMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUEST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUIRE}</li>
     * </ul> Specifies whether the client side verification is set to none, request or
     * require. Enum options - SSL_CLIENT_CERTIFICATE_NONE,
     * SSL_CLIENT_CERTIFICATE_REQUEST, SSL_CLIENT_CERTIFICATE_REQUIRE. Allowed in
     * Basic(Allowed values-
     * SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE) edition,
     * Essentials(Allowed values-
     * SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE) edition, Enterprise
     * edition. Default value when not specified in API or module is interpreted by ALB
     * Controller as SSL_CLIENT_CERTIFICATE_NONE.
     *
     * @param sslClientCertificateMode New value for the property.
     */
    public void setSslClientCertificateMode(java.lang.String sslClientCertificateMode) {
        this.sslClientCertificateMode = sslClientCertificateMode;
    }

    /**
     * Use 'Keep-Alive' header timeout sent by application instead of sending the HTTP
     * Keep-Alive Timeout. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUseAppKeepaliveTimeout() {
        return this.useAppKeepaliveTimeout;
    }

    /**
     * Use 'Keep-Alive' header timeout sent by application instead of sending the HTTP
     * Keep-Alive Timeout. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param useAppKeepaliveTimeout New value for the property.
     */
    public void setUseAppKeepaliveTimeout(java.lang.Boolean useAppKeepaliveTimeout) {
        this.useAppKeepaliveTimeout = useAppKeepaliveTimeout;
    }

    /**
     * Enable Websockets proxy for traffic from clients to the virtual service.
     * Connections to this VS start in HTTP mode. If the client requests an Upgrade to
     * Websockets, and the server responds back with success, then the connection is
     * upgraded to WebSockets mode. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getWebsocketsEnabled() {
        return this.websocketsEnabled;
    }

    /**
     * Enable Websockets proxy for traffic from clients to the virtual service.
     * Connections to this VS start in HTTP mode. If the client requests an Upgrade to
     * Websockets, and the server responds back with success, then the connection is
     * upgraded to WebSockets mode. Default value when not specified in API or module
     * is interpreted by ALB Controller as true.
     *
     * @param websocketsEnabled New value for the property.
     */
    public void setWebsocketsEnabled(java.lang.Boolean websocketsEnabled) {
        this.websocketsEnabled = websocketsEnabled;
    }

    /**
     * Insert an X-Forwarded-Proto header in the request sent to the server. When the
     * client connects via SSL, Avi terminates the SSL, and then forwards the requests
     * to the servers via HTTP, so the servers can determine the original protocol via
     * this header. In this example, the value will be 'https'. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getxForwardedProtoEnabled() {
        return this.xForwardedProtoEnabled;
    }

    /**
     * Insert an X-Forwarded-Proto header in the request sent to the server. When the
     * client connects via SSL, Avi terminates the SSL, and then forwards the requests
     * to the servers via HTTP, so the servers can determine the original protocol via
     * this header. In this example, the value will be 'https'. Allowed in
     * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param xForwardedProtoEnabled New value for the property.
     */
    public void setxForwardedProtoEnabled(java.lang.Boolean xForwardedProtoEnabled) {
        this.xForwardedProtoEnabled = xForwardedProtoEnabled;
    }

    /**
     * Provide a custom name for the X-Forwarded-For header sent to the servers.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as X-Forwarded-For.
     *
     * @return The current value of the property.
     */
    public java.lang.String getXffAlternateName() {
        return this.xffAlternateName;
    }

    /**
     * Provide a custom name for the X-Forwarded-For header sent to the servers.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as X-Forwarded-For.
     *
     * @param xffAlternateName New value for the property.
     */
    public void setXffAlternateName(java.lang.String xffAlternateName) {
        this.xffAlternateName = xffAlternateName;
    }

    /**
     * The client's original IP address is inserted into an HTTP request header sent to
     * the server. Servers may use this address for logging or other purposes, rather
     * than Avi's source NAT address used in the Avi to server IP connection. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getXffEnabled() {
        return this.xffEnabled;
    }

    /**
     * The client's original IP address is inserted into an HTTP request header sent to
     * the server. Servers may use this address for logging or other purposes, rather
     * than Avi's source NAT address used in the Avi to server IP connection. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * true.
     *
     * @param xffEnabled New value for the property.
     */
    public void setXffEnabled(java.lang.Boolean xffEnabled) {
        this.xffEnabled = xffEnabled;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHTTPApplicationProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allow_dots_in_header_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowDotsInHeaderName, this._getType().getField("allow_dots_in_header_name")));
        structValue.setField("cache_config",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cacheConfig, this._getType().getField("cache_config")));
        structValue.setField("client_body_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientBodyTimeout, this._getType().getField("client_body_timeout")));
        structValue.setField("client_header_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientHeaderTimeout, this._getType().getField("client_header_timeout")));
        structValue.setField("client_max_body_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientMaxBodySize, this._getType().getField("client_max_body_size")));
        structValue.setField("client_max_header_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientMaxHeaderSize, this._getType().getField("client_max_header_size")));
        structValue.setField("client_max_request_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientMaxRequestSize, this._getType().getField("client_max_request_size")));
        structValue.setField("compression_profile",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.compressionProfile, this._getType().getField("compression_profile")));
        structValue.setField("connection_multiplexing_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionMultiplexingEnabled, this._getType().getField("connection_multiplexing_enabled")));
        structValue.setField("disable_keepalive_posts_msie6",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.disableKeepalivePostsMsie6, this._getType().getField("disable_keepalive_posts_msie6")));
        structValue.setField("disable_sni_hostname_check",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.disableSniHostnameCheck, this._getType().getField("disable_sni_hostname_check")));
        structValue.setField("enable_chunk_merge",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableChunkMerge, this._getType().getField("enable_chunk_merge")));
        structValue.setField("enable_fire_and_forget",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableFireAndForget, this._getType().getField("enable_fire_and_forget")));
        structValue.setField("enable_request_body_buffering",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableRequestBodyBuffering, this._getType().getField("enable_request_body_buffering")));
        structValue.setField("enable_request_body_metrics",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableRequestBodyMetrics, this._getType().getField("enable_request_body_metrics")));
        structValue.setField("fwd_close_hdr_for_bound_connections",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fwdCloseHdrForBoundConnections, this._getType().getField("fwd_close_hdr_for_bound_connections")));
        structValue.setField("hsts_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hstsEnabled, this._getType().getField("hsts_enabled")));
        structValue.setField("hsts_max_age",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hstsMaxAge, this._getType().getField("hsts_max_age")));
        structValue.setField("hsts_subdomains_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hstsSubdomainsEnabled, this._getType().getField("hsts_subdomains_enabled")));
        structValue.setField("http2_profile",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.http2Profile, this._getType().getField("http2_profile")));
        structValue.setField("http_to_https",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.httpToHttps, this._getType().getField("http_to_https")));
        structValue.setField("http_upstream_buffer_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.httpUpstreamBufferSize, this._getType().getField("http_upstream_buffer_size")));
        structValue.setField("httponly_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.httponlyEnabled, this._getType().getField("httponly_enabled")));
        structValue.setField("keepalive_header",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keepaliveHeader, this._getType().getField("keepalive_header")));
        structValue.setField("keepalive_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keepaliveTimeout, this._getType().getField("keepalive_timeout")));
        structValue.setField("max_bad_rps_cip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxBadRpsCip, this._getType().getField("max_bad_rps_cip")));
        structValue.setField("max_bad_rps_cip_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxBadRpsCipUri, this._getType().getField("max_bad_rps_cip_uri")));
        structValue.setField("max_bad_rps_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxBadRpsUri, this._getType().getField("max_bad_rps_uri")));
        structValue.setField("max_keepalive_requests",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxKeepaliveRequests, this._getType().getField("max_keepalive_requests")));
        structValue.setField("max_response_headers_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxResponseHeadersSize, this._getType().getField("max_response_headers_size")));
        structValue.setField("max_rps_cip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxRpsCip, this._getType().getField("max_rps_cip")));
        structValue.setField("max_rps_cip_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxRpsCipUri, this._getType().getField("max_rps_cip_uri")));
        structValue.setField("max_rps_unknown_cip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxRpsUnknownCip, this._getType().getField("max_rps_unknown_cip")));
        structValue.setField("max_rps_unknown_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxRpsUnknownUri, this._getType().getField("max_rps_unknown_uri")));
        structValue.setField("max_rps_uri",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxRpsUri, this._getType().getField("max_rps_uri")));
        structValue.setField("pki_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pkiProfilePath, this._getType().getField("pki_profile_path")));
        structValue.setField("post_accept_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.postAcceptTimeout, this._getType().getField("post_accept_timeout")));
        structValue.setField("reset_conn_http_on_ssl_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resetConnHttpOnSslPort, this._getType().getField("reset_conn_http_on_ssl_port")));
        structValue.setField("respond_with_100_continue",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.respondWith100Continue, this._getType().getField("respond_with_100_continue")));
        structValue.setField("secure_cookie_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.secureCookieEnabled, this._getType().getField("secure_cookie_enabled")));
        structValue.setField("server_side_redirect_to_https",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverSideRedirectToHttps, this._getType().getField("server_side_redirect_to_https")));
        structValue.setField("ssl_client_certificate_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslClientCertificateAction, this._getType().getField("ssl_client_certificate_action")));
        structValue.setField("ssl_client_certificate_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslClientCertificateMode, this._getType().getField("ssl_client_certificate_mode")));
        structValue.setField("use_app_keepalive_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.useAppKeepaliveTimeout, this._getType().getField("use_app_keepalive_timeout")));
        structValue.setField("websockets_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.websocketsEnabled, this._getType().getField("websockets_enabled")));
        structValue.setField("x_forwarded_proto_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.xForwardedProtoEnabled, this._getType().getField("x_forwarded_proto_enabled")));
        structValue.setField("xff_alternate_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.xffAlternateName, this._getType().getField("xff_alternate_name")));
        structValue.setField("xff_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.xffEnabled, this._getType().getField("xff_enabled")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHTTPApplicationProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHTTPApplicationProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBHTTPApplicationProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHTTPApplicationProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBHTTPApplicationProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHTTPApplicationProfile(structValue);
    }

    /**
     * Builder class for {@link ALBHTTPApplicationProfile}.
     */
    public static final class Builder {
        private java.lang.Boolean allowDotsInHeaderName;
        private com.vmware.nsx_global_policy.model.ALBHttpCacheConfig cacheConfig;
        private java.lang.Long clientBodyTimeout;
        private java.lang.Long clientHeaderTimeout;
        private java.lang.Long clientMaxBodySize;
        private java.lang.Long clientMaxHeaderSize;
        private java.lang.Long clientMaxRequestSize;
        private com.vmware.nsx_global_policy.model.ALBCompressionProfile compressionProfile;
        private java.lang.Boolean connectionMultiplexingEnabled;
        private java.lang.Boolean disableKeepalivePostsMsie6;
        private java.lang.Boolean disableSniHostnameCheck;
        private java.lang.Boolean enableChunkMerge;
        private java.lang.Boolean enableFireAndForget;
        private java.lang.Boolean enableRequestBodyBuffering;
        private java.lang.Boolean enableRequestBodyMetrics;
        private java.lang.Boolean fwdCloseHdrForBoundConnections;
        private java.lang.Boolean hstsEnabled;
        private java.lang.Long hstsMaxAge;
        private java.lang.Boolean hstsSubdomainsEnabled;
        private com.vmware.nsx_global_policy.model.ALBHTTP2ApplicationProfile http2Profile;
        private java.lang.Boolean httpToHttps;
        private java.lang.Long httpUpstreamBufferSize;
        private java.lang.Boolean httponlyEnabled;
        private java.lang.Boolean keepaliveHeader;
        private java.lang.Long keepaliveTimeout;
        private java.lang.Long maxBadRpsCip;
        private java.lang.Long maxBadRpsCipUri;
        private java.lang.Long maxBadRpsUri;
        private java.lang.Long maxKeepaliveRequests;
        private java.lang.Long maxResponseHeadersSize;
        private java.lang.Long maxRpsCip;
        private java.lang.Long maxRpsCipUri;
        private java.lang.Long maxRpsUnknownCip;
        private java.lang.Long maxRpsUnknownUri;
        private java.lang.Long maxRpsUri;
        private java.lang.String pkiProfilePath;
        private java.lang.Long postAcceptTimeout;
        private java.lang.Boolean resetConnHttpOnSslPort;
        private java.lang.Boolean respondWith100Continue;
        private java.lang.Boolean secureCookieEnabled;
        private java.lang.Boolean serverSideRedirectToHttps;
        private com.vmware.nsx_global_policy.model.ALBSSLClientCertificateAction sslClientCertificateAction;
        private java.lang.String sslClientCertificateMode;
        private java.lang.Boolean useAppKeepaliveTimeout;
        private java.lang.Boolean websocketsEnabled;
        private java.lang.Boolean xForwardedProtoEnabled;
        private java.lang.String xffAlternateName;
        private java.lang.Boolean xffEnabled;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBHTTPApplicationProfile}.
         */
        public Builder() {
        }

        /**
         * Allow use of dot (.) in HTTP header names, for instance Header.app.special
         * PickAppVersionX. Allowed in Basic(Allowed values- false) edition,
         * Essentials(Allowed values- false) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param allowDotsInHeaderName New value for the property.
         */
        public Builder setAllowDotsInHeaderName(java.lang.Boolean allowDotsInHeaderName) {
            this.allowDotsInHeaderName = allowDotsInHeaderName;
            return this;
        }

        /**
         *
         *
         * @param cacheConfig New value for the property.
         */
        public Builder setCacheConfig(com.vmware.nsx_global_policy.model.ALBHttpCacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        /**
         * The maximum length of time allowed between consecutive read operations for a
         * client request body. The value '0' specifies no timeout. This setting generally
         * impacts the length of time allowed for a client to send a POST. Allowed values
         * are 0-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 30000)
         * edition, Essentials(Allowed values- 30000) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * 30000. format: int64
         *
         * @param clientBodyTimeout New value for the property.
         */
        public Builder setClientBodyTimeout(java.lang.Long clientBodyTimeout) {
            this.clientBodyTimeout = clientBodyTimeout;
            return this;
        }

        /**
         * The maximum length of time allowed for a client to transmit an entire request
         * header. This helps mitigate various forms of SlowLoris attacks. Allowed values
         * are 10-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 10000)
         * edition, Essentials(Allowed values- 10000) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * 10000. format: int64
         *
         * @param clientHeaderTimeout New value for the property.
         */
        public Builder setClientHeaderTimeout(java.lang.Long clientHeaderTimeout) {
            this.clientHeaderTimeout = clientHeaderTimeout;
            return this;
        }

        /**
         * Maximum size for the client request body. This limits the size of the client
         * data that can be uploaded/posted as part of a single HTTP Request. Default 0 =>
         * Unlimited. Unit is KB. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param clientMaxBodySize New value for the property.
         */
        public Builder setClientMaxBodySize(java.lang.Long clientMaxBodySize) {
            this.clientMaxBodySize = clientMaxBodySize;
            return this;
        }

        /**
         * Maximum size in Kbytes of a single HTTP header in the client request. Allowed
         * values are 1-64. Unit is KB. Allowed in Basic(Allowed values- 12) edition,
         * Essentials(Allowed values- 12) edition, Enterprise edition. Default value when
         * not specified in API or module is interpreted by ALB Controller as 12. format:
         * int64
         *
         * @param clientMaxHeaderSize New value for the property.
         */
        public Builder setClientMaxHeaderSize(java.lang.Long clientMaxHeaderSize) {
            this.clientMaxHeaderSize = clientMaxHeaderSize;
            return this;
        }

        /**
         * Maximum size in Kbytes of all the client HTTP request headers. Allowed values
         * are 1-256. Unit is KB. Default value when not specified in API or module is
         * interpreted by ALB Controller as 48. format: int64
         *
         * @param clientMaxRequestSize New value for the property.
         */
        public Builder setClientMaxRequestSize(java.lang.Long clientMaxRequestSize) {
            this.clientMaxRequestSize = clientMaxRequestSize;
            return this;
        }

        /**
         *
         *
         * @param compressionProfile New value for the property.
         */
        public Builder setCompressionProfile(com.vmware.nsx_global_policy.model.ALBCompressionProfile compressionProfile) {
            this.compressionProfile = compressionProfile;
            return this;
        }

        /**
         * Allows HTTP requests, not just TCP connections, to be load balanced across
         * servers. Proxied TCP connections to servers may be reused by multiple clients to
         * improve performance. Not compatible with Preserve Client IP. Default value when
         * not specified in API or module is interpreted by ALB Controller as true.
         *
         * @param connectionMultiplexingEnabled New value for the property.
         */
        public Builder setConnectionMultiplexingEnabled(java.lang.Boolean connectionMultiplexingEnabled) {
            this.connectionMultiplexingEnabled = connectionMultiplexingEnabled;
            return this;
        }

        /**
         * Disable keep-alive client side connections for older browsers based off MS
         * Internet Explorer 6.0 (MSIE6). For some applications, this might break NTLM
         * authentication for older clients based off MSIE6. For such applications, set
         * this option to false to allow keep-alive connections. Allowed in Basic(Allowed
         * values- true) edition, Essentials(Allowed values- true) edition, Enterprise
         * edition. Default value when not specified in API or module is interpreted by ALB
         * Controller as true.
         *
         * @param disableKeepalivePostsMsie6 New value for the property.
         */
        public Builder setDisableKeepalivePostsMsie6(java.lang.Boolean disableKeepalivePostsMsie6) {
            this.disableKeepalivePostsMsie6 = disableKeepalivePostsMsie6;
            return this;
        }

        /**
         * Disable strict check between TLS servername and HTTP Host name. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param disableSniHostnameCheck New value for the property.
         */
        public Builder setDisableSniHostnameCheck(java.lang.Boolean disableSniHostnameCheck) {
            this.disableSniHostnameCheck = disableSniHostnameCheck;
            return this;
        }

        /**
         * Enable chunk body merge for chunked transfer encoding response. Default value
         * when not specified in API or module is interpreted by ALB Controller as true.
         *
         * @param enableChunkMerge New value for the property.
         */
        public Builder setEnableChunkMerge(java.lang.Boolean enableChunkMerge) {
            this.enableChunkMerge = enableChunkMerge;
            return this;
        }

        /**
         * Enable support for fire and forget feature. If enabled, request from client is
         * forwarded to server even if client prematurely closes the connection. Allowed in
         * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
         * Enterprise edition. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param enableFireAndForget New value for the property.
         */
        public Builder setEnableFireAndForget(java.lang.Boolean enableFireAndForget) {
            this.enableFireAndForget = enableFireAndForget;
            return this;
        }

        /**
         * Enable request body buffering for POST requests. If enabled, max buffer size is
         * set to lower of 32M or the value (non-zero) configured in client_max_body_size.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param enableRequestBodyBuffering New value for the property.
         */
        public Builder setEnableRequestBodyBuffering(java.lang.Boolean enableRequestBodyBuffering) {
            this.enableRequestBodyBuffering = enableRequestBodyBuffering;
            return this;
        }

        /**
         * Enable HTTP request body metrics. If enabled, requests from clients are parsed
         * and relevant statistics about them are gathered. Currently, it processes HTTP
         * POST requests with Content-Type application/x-www-form-urlencoded or
         * multipart/form-data, and adds the number of detected parameters to the
         * l7_client.http_params_count. This is an experimental feature and it may have
         * performance impact. Use it when detailed information about the number of HTTP
         * POST parameters is needed, e.g. for WAF sizing. Allowed in Basic(Allowed values-
         * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param enableRequestBodyMetrics New value for the property.
         */
        public Builder setEnableRequestBodyMetrics(java.lang.Boolean enableRequestBodyMetrics) {
            this.enableRequestBodyMetrics = enableRequestBodyMetrics;
            return this;
        }

        /**
         * Forward the Connection Close header coming from backend server to the client if
         * connection-switching is enabled, i.e. front-end and backend connections are
         * bound together. Default value when not specified in API or module is interpreted
         * by ALB Controller as true.
         *
         * @param fwdCloseHdrForBoundConnections New value for the property.
         */
        public Builder setFwdCloseHdrForBoundConnections(java.lang.Boolean fwdCloseHdrForBoundConnections) {
            this.fwdCloseHdrForBoundConnections = fwdCloseHdrForBoundConnections;
            return this;
        }

        /**
         * Inserts HTTP Strict-Transport-Security header in the HTTPS response. HSTS can
         * help mitigate man-in-the-middle attacks by telling browsers that support HSTS
         * that they should only access this site via HTTPS. Allowed in Basic(Allowed
         * values- false) edition, Essentials(Allowed values- false) edition, Enterprise
         * edition. Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param hstsEnabled New value for the property.
         */
        public Builder setHstsEnabled(java.lang.Boolean hstsEnabled) {
            this.hstsEnabled = hstsEnabled;
            return this;
        }

        /**
         * Number of days for which the client should regard this virtual service as a
         * known HSTS host. Allowed values are 0-10000. Allowed in Basic(Allowed values-
         * 365) edition, Essentials(Allowed values- 365) edition, Enterprise edition.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 365. format: int64
         *
         * @param hstsMaxAge New value for the property.
         */
        public Builder setHstsMaxAge(java.lang.Long hstsMaxAge) {
            this.hstsMaxAge = hstsMaxAge;
            return this;
        }

        /**
         * Insert the 'includeSubdomains' directive in the HTTP Strict-Transport-Security
         * header. Adding the includeSubdomains directive signals the User-Agent that the
         * HSTS Policy applies to this HSTS Host as well as any subdomains of the host's
         * domain name. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
         * values- false) edition, Enterprise edition. Special default for Basic edition is
         * false, Essentials edition is false, Enterprise is True. Default value when not
         * specified in API or module is interpreted by ALB Controller as false.
         *
         * @param hstsSubdomainsEnabled New value for the property.
         */
        public Builder setHstsSubdomainsEnabled(java.lang.Boolean hstsSubdomainsEnabled) {
            this.hstsSubdomainsEnabled = hstsSubdomainsEnabled;
            return this;
        }

        /**
         *
         *
         * @param http2Profile New value for the property.
         */
        public Builder setHttp2Profile(com.vmware.nsx_global_policy.model.ALBHTTP2ApplicationProfile http2Profile) {
            this.http2Profile = http2Profile;
            return this;
        }

        /**
         * Client requests received via HTTP will be redirected to HTTPS. Allowed in
         * Essentials(Allowed values- false) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param httpToHttps New value for the property.
         */
        public Builder setHttpToHttps(java.lang.Boolean httpToHttps) {
            this.httpToHttps = httpToHttps;
            return this;
        }

        /**
         * Size of HTTP buffer in kB. Allowed values are 1-256. Special values are 0- 'Auto
         * compute the size of buffer'. Unit is KB. Allowed in Basic(Allowed values- 0)
         * edition, Essentials(Allowed values- 0) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as 0.
         * format: int64
         *
         * @param httpUpstreamBufferSize New value for the property.
         */
        public Builder setHttpUpstreamBufferSize(java.lang.Long httpUpstreamBufferSize) {
            this.httpUpstreamBufferSize = httpUpstreamBufferSize;
            return this;
        }

        /**
         * Mark HTTP cookies as HTTPonly. This helps mitigate cross site scripting attacks
         * as browsers will not allow these cookies to be read by third parties, such as
         * javascript. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
         * values- false) edition, Enterprise edition. Default value when not specified in
         * API or module is interpreted by ALB Controller as false.
         *
         * @param httponlyEnabled New value for the property.
         */
        public Builder setHttponlyEnabled(java.lang.Boolean httponlyEnabled) {
            this.httponlyEnabled = httponlyEnabled;
            return this;
        }

        /**
         * Send HTTP 'Keep-Alive' header to the client. By default, the timeout specified
         * in the 'Keep-Alive Timeout' field will be used unless the 'Use App Keepalive
         * Timeout' flag is set, in which case the timeout sent by the application will be
         * honored. Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param keepaliveHeader New value for the property.
         */
        public Builder setKeepaliveHeader(java.lang.Boolean keepaliveHeader) {
            this.keepaliveHeader = keepaliveHeader;
            return this;
        }

        /**
         * The max idle time allowed between HTTP requests over a Keep-alive connection.
         * Allowed values are 10-100000000. Unit is MILLISECONDS. Allowed in
         * Essentials(Allowed values- 30000) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as 30000.
         * format: int64
         *
         * @param keepaliveTimeout New value for the property.
         */
        public Builder setKeepaliveTimeout(java.lang.Long keepaliveTimeout) {
            this.keepaliveTimeout = keepaliveTimeout;
            return this;
        }

        /**
         * Maximum bad requests per second per client IP. Allowed values are 10-1000.
         * Special values are 0- 'unlimited'. Default value when not specified in API or
         * module is interpreted by ALB Controller as 0. format: int64
         *
         * @param maxBadRpsCip New value for the property.
         */
        public Builder setMaxBadRpsCip(java.lang.Long maxBadRpsCip) {
            this.maxBadRpsCip = maxBadRpsCip;
            return this;
        }

        /**
         * Maximum bad requests per second per client IP and URI. Allowed values are
         * 10-1000. Special values are 0- 'unlimited'. Default value when not specified in
         * API or module is interpreted by ALB Controller as 0. format: int64
         *
         * @param maxBadRpsCipUri New value for the property.
         */
        public Builder setMaxBadRpsCipUri(java.lang.Long maxBadRpsCipUri) {
            this.maxBadRpsCipUri = maxBadRpsCipUri;
            return this;
        }

        /**
         * Maximum bad requests per second per URI. Allowed values are 10-1000. Special
         * values are 0- 'unlimited'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param maxBadRpsUri New value for the property.
         */
        public Builder setMaxBadRpsUri(java.lang.Long maxBadRpsUri) {
            this.maxBadRpsUri = maxBadRpsUri;
            return this;
        }

        /**
         * The max number of HTTP requests that can be sent over a Keep-Alive connection.
         * '0' means unlimited. Allowed values are 0-1000000. Special values are 0-
         * 'Unlimited requests on a connection'. Allowed in Basic(Allowed values- 100)
         * edition, Essentials(Allowed values- 100) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * 100. format: int64
         *
         * @param maxKeepaliveRequests New value for the property.
         */
        public Builder setMaxKeepaliveRequests(java.lang.Long maxKeepaliveRequests) {
            this.maxKeepaliveRequests = maxKeepaliveRequests;
            return this;
        }

        /**
         * Maximum size in Kbytes of all the HTTP response headers. Allowed values are
         * 1-256. Unit is KB. Allowed in Basic(Allowed values- 48) edition,
         * Essentials(Allowed values- 48) edition, Enterprise edition. Default value when
         * not specified in API or module is interpreted by ALB Controller as 48. format:
         * int64
         *
         * @param maxResponseHeadersSize New value for the property.
         */
        public Builder setMaxResponseHeadersSize(java.lang.Long maxResponseHeadersSize) {
            this.maxResponseHeadersSize = maxResponseHeadersSize;
            return this;
        }

        /**
         * Maximum requests per second per client IP. Allowed values are 10-1000. Special
         * values are 0- 'unlimited'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param maxRpsCip New value for the property.
         */
        public Builder setMaxRpsCip(java.lang.Long maxRpsCip) {
            this.maxRpsCip = maxRpsCip;
            return this;
        }

        /**
         * Maximum requests per second per client IP and URI. Allowed values are 10-1000.
         * Special values are 0- 'unlimited'. Default value when not specified in API or
         * module is interpreted by ALB Controller as 0. format: int64
         *
         * @param maxRpsCipUri New value for the property.
         */
        public Builder setMaxRpsCipUri(java.lang.Long maxRpsCipUri) {
            this.maxRpsCipUri = maxRpsCipUri;
            return this;
        }

        /**
         * Maximum unknown client IPs per second. Allowed values are 10-1000. Special
         * values are 0- 'unlimited'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param maxRpsUnknownCip New value for the property.
         */
        public Builder setMaxRpsUnknownCip(java.lang.Long maxRpsUnknownCip) {
            this.maxRpsUnknownCip = maxRpsUnknownCip;
            return this;
        }

        /**
         * Maximum unknown URIs per second. Allowed values are 10-1000. Special values are
         * 0- 'unlimited'. Default value when not specified in API or module is interpreted
         * by ALB Controller as 0. format: int64
         *
         * @param maxRpsUnknownUri New value for the property.
         */
        public Builder setMaxRpsUnknownUri(java.lang.Long maxRpsUnknownUri) {
            this.maxRpsUnknownUri = maxRpsUnknownUri;
            return this;
        }

        /**
         * Maximum requests per second per URI. Allowed values are 10-1000. Special values
         * are 0- 'unlimited'. Default value when not specified in API or module is
         * interpreted by ALB Controller as 0. format: int64
         *
         * @param maxRpsUri New value for the property.
         */
        public Builder setMaxRpsUri(java.lang.Long maxRpsUri) {
            this.maxRpsUri = maxRpsUri;
            return this;
        }

        /**
         * Select the PKI profile to be associated with the Virtual Service. This profile
         * defines the Certificate Authority and Revocation List. It is a reference to an
         * object of type PKIProfile.
         *
         * @param pkiProfilePath New value for the property.
         */
        public Builder setPkiProfilePath(java.lang.String pkiProfilePath) {
            this.pkiProfilePath = pkiProfilePath;
            return this;
        }

        /**
         * The max allowed length of time between a client establishing a TCP connection
         * and Avi receives the first byte of the client's HTTP request. Allowed values are
         * 10-100000000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 30000)
         * edition, Essentials(Allowed values- 30000) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * 30000. format: int64
         *
         * @param postAcceptTimeout New value for the property.
         */
        public Builder setPostAcceptTimeout(java.lang.Long postAcceptTimeout) {
            this.postAcceptTimeout = postAcceptTimeout;
            return this;
        }

        /**
         * If enabled, an HTTP request on an SSL port will result in connection close
         * instead of a 400 response. Allowed in Basic(Allowed values- false) edition,
         * Essentials(Allowed values- false) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param resetConnHttpOnSslPort New value for the property.
         */
        public Builder setResetConnHttpOnSslPort(java.lang.Boolean resetConnHttpOnSslPort) {
            this.resetConnHttpOnSslPort = resetConnHttpOnSslPort;
            return this;
        }

        /**
         * Avi will respond with 100-Continue response if Expect 100-Continue header
         * received from client. Default value when not specified in API or module is
         * interpreted by ALB Controller as true.
         *
         * @param respondWith100Continue New value for the property.
         */
        public Builder setRespondWith100Continue(java.lang.Boolean respondWith100Continue) {
            this.respondWith100Continue = respondWith100Continue;
            return this;
        }

        /**
         * Mark server cookies with the 'Secure' attribute. Client browsers will not send a
         * cookie marked as secure over an unencrypted connection. If Avi is terminating
         * SSL from clients and passing it as HTTP to the server, the server may return
         * cookies without the secure flag set. Allowed in Basic(Allowed values- false)
         * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * false.
         *
         * @param secureCookieEnabled New value for the property.
         */
        public Builder setSecureCookieEnabled(java.lang.Boolean secureCookieEnabled) {
            this.secureCookieEnabled = secureCookieEnabled;
            return this;
        }

        /**
         * When terminating client SSL sessions at Avi, servers may incorrectly send
         * redirect to clients as HTTP. This option will rewrite the server's redirect
         * responses for this virtual service from HTTP to HTTPS. Allowed in Basic(Allowed
         * values- false) edition, Essentials(Allowed values- false) edition, Enterprise
         * edition. Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param serverSideRedirectToHttps New value for the property.
         */
        public Builder setServerSideRedirectToHttps(java.lang.Boolean serverSideRedirectToHttps) {
            this.serverSideRedirectToHttps = serverSideRedirectToHttps;
            return this;
        }

        /**
         *
         *
         * @param sslClientCertificateAction New value for the property.
         */
        public Builder setSslClientCertificateAction(com.vmware.nsx_global_policy.model.ALBSSLClientCertificateAction sslClientCertificateAction) {
            this.sslClientCertificateAction = sslClientCertificateAction;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUEST}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUIRE}</li>
         * </ul> Specifies whether the client side verification is set to none, request or
         * require. Enum options - SSL_CLIENT_CERTIFICATE_NONE,
         * SSL_CLIENT_CERTIFICATE_REQUEST, SSL_CLIENT_CERTIFICATE_REQUIRE. Allowed in
         * Basic(Allowed values-
         * SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE) edition,
         * Essentials(Allowed values-
         * SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE) edition, Enterprise
         * edition. Default value when not specified in API or module is interpreted by ALB
         * Controller as SSL_CLIENT_CERTIFICATE_NONE.
         *
         * @param sslClientCertificateMode New value for the property.
         */
        public Builder setSslClientCertificateMode(java.lang.String sslClientCertificateMode) {
            this.sslClientCertificateMode = sslClientCertificateMode;
            return this;
        }

        /**
         * Use 'Keep-Alive' header timeout sent by application instead of sending the HTTP
         * Keep-Alive Timeout. Allowed in Basic(Allowed values- false) edition,
         * Essentials(Allowed values- false) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param useAppKeepaliveTimeout New value for the property.
         */
        public Builder setUseAppKeepaliveTimeout(java.lang.Boolean useAppKeepaliveTimeout) {
            this.useAppKeepaliveTimeout = useAppKeepaliveTimeout;
            return this;
        }

        /**
         * Enable Websockets proxy for traffic from clients to the virtual service.
         * Connections to this VS start in HTTP mode. If the client requests an Upgrade to
         * Websockets, and the server responds back with success, then the connection is
         * upgraded to WebSockets mode. Default value when not specified in API or module
         * is interpreted by ALB Controller as true.
         *
         * @param websocketsEnabled New value for the property.
         */
        public Builder setWebsocketsEnabled(java.lang.Boolean websocketsEnabled) {
            this.websocketsEnabled = websocketsEnabled;
            return this;
        }

        /**
         * Insert an X-Forwarded-Proto header in the request sent to the server. When the
         * client connects via SSL, Avi terminates the SSL, and then forwards the requests
         * to the servers via HTTP, so the servers can determine the original protocol via
         * this header. In this example, the value will be 'https'. Allowed in
         * Basic(Allowed values- false) edition, Essentials(Allowed values- false) edition,
         * Enterprise edition. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param xForwardedProtoEnabled New value for the property.
         */
        public Builder setxForwardedProtoEnabled(java.lang.Boolean xForwardedProtoEnabled) {
            this.xForwardedProtoEnabled = xForwardedProtoEnabled;
            return this;
        }

        /**
         * Provide a custom name for the X-Forwarded-For header sent to the servers.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as X-Forwarded-For.
         *
         * @param xffAlternateName New value for the property.
         */
        public Builder setXffAlternateName(java.lang.String xffAlternateName) {
            this.xffAlternateName = xffAlternateName;
            return this;
        }

        /**
         * The client's original IP address is inserted into an HTTP request header sent to
         * the server. Servers may use this address for logging or other purposes, rather
         * than Avi's source NAT address used in the Avi to server IP connection. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * true.
         *
         * @param xffEnabled New value for the property.
         */
        public Builder setXffEnabled(java.lang.Boolean xffEnabled) {
            this.xffEnabled = xffEnabled;
            return this;
        }

        public ALBHTTPApplicationProfile build() {
            ALBHTTPApplicationProfile result = new ALBHTTPApplicationProfile();
            result.setAllowDotsInHeaderName(this.allowDotsInHeaderName);
            result.setCacheConfig(this.cacheConfig);
            result.setClientBodyTimeout(this.clientBodyTimeout);
            result.setClientHeaderTimeout(this.clientHeaderTimeout);
            result.setClientMaxBodySize(this.clientMaxBodySize);
            result.setClientMaxHeaderSize(this.clientMaxHeaderSize);
            result.setClientMaxRequestSize(this.clientMaxRequestSize);
            result.setCompressionProfile(this.compressionProfile);
            result.setConnectionMultiplexingEnabled(this.connectionMultiplexingEnabled);
            result.setDisableKeepalivePostsMsie6(this.disableKeepalivePostsMsie6);
            result.setDisableSniHostnameCheck(this.disableSniHostnameCheck);
            result.setEnableChunkMerge(this.enableChunkMerge);
            result.setEnableFireAndForget(this.enableFireAndForget);
            result.setEnableRequestBodyBuffering(this.enableRequestBodyBuffering);
            result.setEnableRequestBodyMetrics(this.enableRequestBodyMetrics);
            result.setFwdCloseHdrForBoundConnections(this.fwdCloseHdrForBoundConnections);
            result.setHstsEnabled(this.hstsEnabled);
            result.setHstsMaxAge(this.hstsMaxAge);
            result.setHstsSubdomainsEnabled(this.hstsSubdomainsEnabled);
            result.setHttp2Profile(this.http2Profile);
            result.setHttpToHttps(this.httpToHttps);
            result.setHttpUpstreamBufferSize(this.httpUpstreamBufferSize);
            result.setHttponlyEnabled(this.httponlyEnabled);
            result.setKeepaliveHeader(this.keepaliveHeader);
            result.setKeepaliveTimeout(this.keepaliveTimeout);
            result.setMaxBadRpsCip(this.maxBadRpsCip);
            result.setMaxBadRpsCipUri(this.maxBadRpsCipUri);
            result.setMaxBadRpsUri(this.maxBadRpsUri);
            result.setMaxKeepaliveRequests(this.maxKeepaliveRequests);
            result.setMaxResponseHeadersSize(this.maxResponseHeadersSize);
            result.setMaxRpsCip(this.maxRpsCip);
            result.setMaxRpsCipUri(this.maxRpsCipUri);
            result.setMaxRpsUnknownCip(this.maxRpsUnknownCip);
            result.setMaxRpsUnknownUri(this.maxRpsUnknownUri);
            result.setMaxRpsUri(this.maxRpsUri);
            result.setPkiProfilePath(this.pkiProfilePath);
            result.setPostAcceptTimeout(this.postAcceptTimeout);
            result.setResetConnHttpOnSslPort(this.resetConnHttpOnSslPort);
            result.setRespondWith100Continue(this.respondWith100Continue);
            result.setSecureCookieEnabled(this.secureCookieEnabled);
            result.setServerSideRedirectToHttps(this.serverSideRedirectToHttps);
            result.setSslClientCertificateAction(this.sslClientCertificateAction);
            result.setSslClientCertificateMode(this.sslClientCertificateMode);
            result.setUseAppKeepaliveTimeout(this.useAppKeepaliveTimeout);
            result.setWebsocketsEnabled(this.websocketsEnabled);
            result.setxForwardedProtoEnabled(this.xForwardedProtoEnabled);
            result.setXffAlternateName(this.xffAlternateName);
            result.setXffEnabled(this.xffEnabled);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allow_dots_in_header_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allow_dots_in_header_name",
                                                                                "allowDotsInHeaderName",
                                                                                "getAllowDotsInHeaderName",
                                                                                "setAllowDotsInHeaderName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cache_config", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHttpCacheConfig; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cache_config",
                                                                                "cacheConfig",
                                                                                "getCacheConfig",
                                                                                "setCacheConfig");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_body_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_body_timeout",
                                                                                "clientBodyTimeout",
                                                                                "getClientBodyTimeout",
                                                                                "setClientBodyTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_header_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_header_timeout",
                                                                                "clientHeaderTimeout",
                                                                                "getClientHeaderTimeout",
                                                                                "setClientHeaderTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_max_body_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_max_body_size",
                                                                                "clientMaxBodySize",
                                                                                "getClientMaxBodySize",
                                                                                "setClientMaxBodySize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_max_header_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_max_header_size",
                                                                                "clientMaxHeaderSize",
                                                                                "getClientMaxHeaderSize",
                                                                                "setClientMaxHeaderSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_max_request_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_max_request_size",
                                                                                "clientMaxRequestSize",
                                                                                "getClientMaxRequestSize",
                                                                                "setClientMaxRequestSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("compression_profile", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBCompressionProfile; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("compression_profile",
                                                                                "compressionProfile",
                                                                                "getCompressionProfile",
                                                                                "setCompressionProfile");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_multiplexing_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_multiplexing_enabled",
                                                                                "connectionMultiplexingEnabled",
                                                                                "getConnectionMultiplexingEnabled",
                                                                                "setConnectionMultiplexingEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("disable_keepalive_posts_msie6", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("disable_keepalive_posts_msie6",
                                                                                "disableKeepalivePostsMsie6",
                                                                                "getDisableKeepalivePostsMsie6",
                                                                                "setDisableKeepalivePostsMsie6");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("disable_sni_hostname_check", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("disable_sni_hostname_check",
                                                                                "disableSniHostnameCheck",
                                                                                "getDisableSniHostnameCheck",
                                                                                "setDisableSniHostnameCheck");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_chunk_merge", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_chunk_merge",
                                                                                "enableChunkMerge",
                                                                                "getEnableChunkMerge",
                                                                                "setEnableChunkMerge");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_fire_and_forget", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_fire_and_forget",
                                                                                "enableFireAndForget",
                                                                                "getEnableFireAndForget",
                                                                                "setEnableFireAndForget");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_request_body_buffering", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_request_body_buffering",
                                                                                "enableRequestBodyBuffering",
                                                                                "getEnableRequestBodyBuffering",
                                                                                "setEnableRequestBodyBuffering");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_request_body_metrics", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_request_body_metrics",
                                                                                "enableRequestBodyMetrics",
                                                                                "getEnableRequestBodyMetrics",
                                                                                "setEnableRequestBodyMetrics");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fwd_close_hdr_for_bound_connections", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fwd_close_hdr_for_bound_connections",
                                                                                "fwdCloseHdrForBoundConnections",
                                                                                "getFwdCloseHdrForBoundConnections",
                                                                                "setFwdCloseHdrForBoundConnections");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hsts_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hsts_enabled",
                                                                                "hstsEnabled",
                                                                                "getHstsEnabled",
                                                                                "setHstsEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hsts_max_age", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hsts_max_age",
                                                                                "hstsMaxAge",
                                                                                "getHstsMaxAge",
                                                                                "setHstsMaxAge");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hsts_subdomains_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hsts_subdomains_enabled",
                                                                                "hstsSubdomainsEnabled",
                                                                                "getHstsSubdomainsEnabled",
                                                                                "setHstsSubdomainsEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("http2_profile", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHTTP2ApplicationProfile; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("http2_profile",
                                                                                "http2Profile",
                                                                                "getHttp2Profile",
                                                                                "setHttp2Profile");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("http_to_https", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("http_to_https",
                                                                                "httpToHttps",
                                                                                "getHttpToHttps",
                                                                                "setHttpToHttps");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("http_upstream_buffer_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("http_upstream_buffer_size",
                                                                                "httpUpstreamBufferSize",
                                                                                "getHttpUpstreamBufferSize",
                                                                                "setHttpUpstreamBufferSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("httponly_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("httponly_enabled",
                                                                                "httponlyEnabled",
                                                                                "getHttponlyEnabled",
                                                                                "setHttponlyEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("keepalive_header", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keepalive_header",
                                                                                "keepaliveHeader",
                                                                                "getKeepaliveHeader",
                                                                                "setKeepaliveHeader");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("keepalive_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keepalive_timeout",
                                                                                "keepaliveTimeout",
                                                                                "getKeepaliveTimeout",
                                                                                "setKeepaliveTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_bad_rps_cip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_bad_rps_cip",
                                                                                "maxBadRpsCip",
                                                                                "getMaxBadRpsCip",
                                                                                "setMaxBadRpsCip");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_bad_rps_cip_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_bad_rps_cip_uri",
                                                                                "maxBadRpsCipUri",
                                                                                "getMaxBadRpsCipUri",
                                                                                "setMaxBadRpsCipUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_bad_rps_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_bad_rps_uri",
                                                                                "maxBadRpsUri",
                                                                                "getMaxBadRpsUri",
                                                                                "setMaxBadRpsUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_keepalive_requests", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_keepalive_requests",
                                                                                "maxKeepaliveRequests",
                                                                                "getMaxKeepaliveRequests",
                                                                                "setMaxKeepaliveRequests");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_response_headers_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_response_headers_size",
                                                                                "maxResponseHeadersSize",
                                                                                "getMaxResponseHeadersSize",
                                                                                "setMaxResponseHeadersSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_rps_cip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_rps_cip",
                                                                                "maxRpsCip",
                                                                                "getMaxRpsCip",
                                                                                "setMaxRpsCip");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_rps_cip_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_rps_cip_uri",
                                                                                "maxRpsCipUri",
                                                                                "getMaxRpsCipUri",
                                                                                "setMaxRpsCipUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_rps_unknown_cip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_rps_unknown_cip",
                                                                                "maxRpsUnknownCip",
                                                                                "getMaxRpsUnknownCip",
                                                                                "setMaxRpsUnknownCip");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_rps_unknown_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_rps_unknown_uri",
                                                                                "maxRpsUnknownUri",
                                                                                "getMaxRpsUnknownUri",
                                                                                "setMaxRpsUnknownUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_rps_uri", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_rps_uri",
                                                                                "maxRpsUri",
                                                                                "getMaxRpsUri",
                                                                                "setMaxRpsUri");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pki_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pki_profile_path",
                                                                                "pkiProfilePath",
                                                                                "getPkiProfilePath",
                                                                                "setPkiProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("post_accept_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("post_accept_timeout",
                                                                                "postAcceptTimeout",
                                                                                "getPostAcceptTimeout",
                                                                                "setPostAcceptTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reset_conn_http_on_ssl_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reset_conn_http_on_ssl_port",
                                                                                "resetConnHttpOnSslPort",
                                                                                "getResetConnHttpOnSslPort",
                                                                                "setResetConnHttpOnSslPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("respond_with_100_continue", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("respond_with_100_continue",
                                                                                "respondWith100Continue",
                                                                                "getRespondWith100Continue",
                                                                                "setRespondWith100Continue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("secure_cookie_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("secure_cookie_enabled",
                                                                                "secureCookieEnabled",
                                                                                "getSecureCookieEnabled",
                                                                                "setSecureCookieEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_side_redirect_to_https", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_side_redirect_to_https",
                                                                                "serverSideRedirectToHttps",
                                                                                "getServerSideRedirectToHttps",
                                                                                "setServerSideRedirectToHttps");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_client_certificate_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBSSLClientCertificateAction; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_client_certificate_action",
                                                                                "sslClientCertificateAction",
                                                                                "getSslClientCertificateAction",
                                                                                "setSslClientCertificateAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_client_certificate_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_client_certificate_mode",
                                                                                "sslClientCertificateMode",
                                                                                "getSslClientCertificateMode",
                                                                                "setSslClientCertificateMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("use_app_keepalive_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("use_app_keepalive_timeout",
                                                                                "useAppKeepaliveTimeout",
                                                                                "getUseAppKeepaliveTimeout",
                                                                                "setUseAppKeepaliveTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("websockets_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("websockets_enabled",
                                                                                "websocketsEnabled",
                                                                                "getWebsocketsEnabled",
                                                                                "setWebsocketsEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("x_forwarded_proto_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("x_forwarded_proto_enabled",
                                                                                "xForwardedProtoEnabled",
                                                                                "getxForwardedProtoEnabled",
                                                                                "setxForwardedProtoEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("xff_alternate_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("xff_alternate_name",
                                                                                "xffAlternateName",
                                                                                "getXffAlternateName",
                                                                                "setXffAlternateName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("xff_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("xff_enabled",
                                                                                "xffEnabled",
                                                                                "getXffEnabled",
                                                                                "setXffEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALBHTTP_application_profile",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBHTTPApplicationProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

