/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer HttpCacheConfig object
 */
public final class ALBHttpCacheConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean ageHeader;

    private java.lang.Boolean aggressive;

    private java.lang.Boolean dateHeader;

    private java.lang.Long defaultExpire;

    private java.lang.Boolean enabled;

    private java.lang.Boolean heuristicExpire;

    private java.lang.Boolean ignoreRequestCacheControl;

    private java.lang.Long maxCacheSize;

    private java.lang.Long maxObjectSize;

    private java.util.List<java.lang.String> mimeTypesBlockGroupPaths;

    private java.util.List<java.lang.String> mimeTypesBlockLists;

    private java.util.List<java.lang.String> mimeTypesGroupPaths;

    private java.util.List<java.lang.String> mimeTypesList;

    private java.lang.Long minObjectSize;

    private java.lang.Boolean queryCacheable;

    private com.vmware.nsx_global_policy.model.ALBPathMatch uriNonCacheable;

    private java.lang.Boolean xcacheHeader;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBHttpCacheConfig() {
    }

    protected ALBHttpCacheConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Add an Age header to content served from cache, which indicates to the client
     * the number of seconds the object has been in the cache. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAgeHeader() {
        return this.ageHeader;
    }

    /**
     * Add an Age header to content served from cache, which indicates to the client
     * the number of seconds the object has been in the cache. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @param ageHeader New value for the property.
     */
    public void setAgeHeader(java.lang.Boolean ageHeader) {
        this.ageHeader = ageHeader;
    }

    /**
     * Enable/disable caching objects without Cache-Control headers. Default value when
     * not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAggressive() {
        return this.aggressive;
    }

    /**
     * Enable/disable caching objects without Cache-Control headers. Default value when
     * not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param aggressive New value for the property.
     */
    public void setAggressive(java.lang.Boolean aggressive) {
        this.aggressive = aggressive;
    }

    /**
     * If a Date header was not added by the server, add a Date header to the object
     * served from cache. This indicates to the client when the object was originally
     * sent by the server to the cache. Default value when not specified in API or
     * module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDateHeader() {
        return this.dateHeader;
    }

    /**
     * If a Date header was not added by the server, add a Date header to the object
     * served from cache. This indicates to the client when the object was originally
     * sent by the server to the cache. Default value when not specified in API or
     * module is interpreted by ALB Controller as true.
     *
     * @param dateHeader New value for the property.
     */
    public void setDateHeader(java.lang.Boolean dateHeader) {
        this.dateHeader = dateHeader;
    }

    /**
     * Default expiration time of cache objects received from the server without a
     * Cache-Control expiration header. This value may be overwritten by the Heuristic
     * Expire setting. Default value when not specified in API or module is interpreted
     * by ALB Controller as 600. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDefaultExpire() {
        return this.defaultExpire;
    }

    /**
     * Default expiration time of cache objects received from the server without a
     * Cache-Control expiration header. This value may be overwritten by the Heuristic
     * Expire setting. Default value when not specified in API or module is interpreted
     * by ALB Controller as 600. format: int64
     *
     * @param defaultExpire New value for the property.
     */
    public void setDefaultExpire(java.lang.Long defaultExpire) {
        this.defaultExpire = defaultExpire;
    }

    /**
     * Enable/disable HTTP object caching.When enabling caching for the first time, SE
     * Group app_cache_percent must be set to allocate shared memory required for
     * caching (A service engine restart is needed after setting/resetting the SE group
     * value). Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Enable/disable HTTP object caching.When enabling caching for the first time, SE
     * Group app_cache_percent must be set to allocate shared memory required for
     * caching (A service engine restart is needed after setting/resetting the SE group
     * value). Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * If a response object from the server does not include the Cache-Control header,
     * but does include a Last-Modified header, the system will use this time to
     * calculate the Cache-Control expiration. If unable to solicit an Last-Modified
     * header, then the system will fall back to the Cache Expire Time value. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHeuristicExpire() {
        return this.heuristicExpire;
    }

    /**
     * If a response object from the server does not include the Cache-Control header,
     * but does include a Last-Modified header, the system will use this time to
     * calculate the Cache-Control expiration. If unable to solicit an Last-Modified
     * header, then the system will fall back to the Cache Expire Time value. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @param heuristicExpire New value for the property.
     */
    public void setHeuristicExpire(java.lang.Boolean heuristicExpire) {
        this.heuristicExpire = heuristicExpire;
    }

    /**
     * Ignore client's cache control headers when fetching or storing from and to the
     * cache. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIgnoreRequestCacheControl() {
        return this.ignoreRequestCacheControl;
    }

    /**
     * Ignore client's cache control headers when fetching or storing from and to the
     * cache. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param ignoreRequestCacheControl New value for the property.
     */
    public void setIgnoreRequestCacheControl(java.lang.Boolean ignoreRequestCacheControl) {
        this.ignoreRequestCacheControl = ignoreRequestCacheControl;
    }

    /**
     * Max size, in bytes, of the cache. The default, zero, indicates auto
     * configuration. Default value when not specified in API or module is interpreted
     * by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    /**
     * Max size, in bytes, of the cache. The default, zero, indicates auto
     * configuration. Default value when not specified in API or module is interpreted
     * by ALB Controller as 0. format: int64
     *
     * @param maxCacheSize New value for the property.
     */
    public void setMaxCacheSize(java.lang.Long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    /**
     * Maximum size of an object to store in the cache. Default value when not
     * specified in API or module is interpreted by ALB Controller as 4194304. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxObjectSize() {
        return this.maxObjectSize;
    }

    /**
     * Maximum size of an object to store in the cache. Default value when not
     * specified in API or module is interpreted by ALB Controller as 4194304. format:
     * int64
     *
     * @param maxObjectSize New value for the property.
     */
    public void setMaxObjectSize(java.lang.Long maxObjectSize) {
        this.maxObjectSize = maxObjectSize;
    }

    /**
     * Blocklist string group of non-cacheable mime types. It is a reference to an
     * object of type StringGroup.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getMimeTypesBlockGroupPaths() {
        return this.mimeTypesBlockGroupPaths;
    }

    /**
     * Blocklist string group of non-cacheable mime types. It is a reference to an
     * object of type StringGroup.
     *
     * @param mimeTypesBlockGroupPaths New value for the property.
     */
    public void setMimeTypesBlockGroupPaths(java.util.List<java.lang.String> mimeTypesBlockGroupPaths) {
        this.mimeTypesBlockGroupPaths = mimeTypesBlockGroupPaths;
    }

    /**
     * Blocklist of non-cacheable mime types.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getMimeTypesBlockLists() {
        return this.mimeTypesBlockLists;
    }

    /**
     * Blocklist of non-cacheable mime types.
     *
     * @param mimeTypesBlockLists New value for the property.
     */
    public void setMimeTypesBlockLists(java.util.List<java.lang.String> mimeTypesBlockLists) {
        this.mimeTypesBlockLists = mimeTypesBlockLists;
    }

    /**
     * Allowlist string group of cacheable mime types. If both Cacheable Mime Types
     * string list and string group are empty, this defaults to (STAR)/(STAR). It is a
     * reference to an object of type StringGroup.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getMimeTypesGroupPaths() {
        return this.mimeTypesGroupPaths;
    }

    /**
     * Allowlist string group of cacheable mime types. If both Cacheable Mime Types
     * string list and string group are empty, this defaults to (STAR)/(STAR). It is a
     * reference to an object of type StringGroup.
     *
     * @param mimeTypesGroupPaths New value for the property.
     */
    public void setMimeTypesGroupPaths(java.util.List<java.lang.String> mimeTypesGroupPaths) {
        this.mimeTypesGroupPaths = mimeTypesGroupPaths;
    }

    /**
     * Allowlist of cacheable mime types. If both Cacheable Mime Types string list and
     * string group are empty, this defaults to (STAR)/(STAR).
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getMimeTypesList() {
        return this.mimeTypesList;
    }

    /**
     * Allowlist of cacheable mime types. If both Cacheable Mime Types string list and
     * string group are empty, this defaults to (STAR)/(STAR).
     *
     * @param mimeTypesList New value for the property.
     */
    public void setMimeTypesList(java.util.List<java.lang.String> mimeTypesList) {
        this.mimeTypesList = mimeTypesList;
    }

    /**
     * Minimum size of an object to store in the cache. Default value when not
     * specified in API or module is interpreted by ALB Controller as 100. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMinObjectSize() {
        return this.minObjectSize;
    }

    /**
     * Minimum size of an object to store in the cache. Default value when not
     * specified in API or module is interpreted by ALB Controller as 100. format:
     * int64
     *
     * @param minObjectSize New value for the property.
     */
    public void setMinObjectSize(java.lang.Long minObjectSize) {
        this.minObjectSize = minObjectSize;
    }

    /**
     * Allow caching of objects whose URI included a query argument. When disabled,
     * these objects are not cached. When enabled, the request must match the URI query
     * to be considered a hit. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getQueryCacheable() {
        return this.queryCacheable;
    }

    /**
     * Allow caching of objects whose URI included a query argument. When disabled,
     * these objects are not cached. When enabled, the request must match the URI query
     * to be considered a hit. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param queryCacheable New value for the property.
     */
    public void setQueryCacheable(java.lang.Boolean queryCacheable) {
        this.queryCacheable = queryCacheable;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBPathMatch getUriNonCacheable() {
        return this.uriNonCacheable;
    }

    /**
     *
     *
     * @param uriNonCacheable New value for the property.
     */
    public void setUriNonCacheable(com.vmware.nsx_global_policy.model.ALBPathMatch uriNonCacheable) {
        this.uriNonCacheable = uriNonCacheable;
    }

    /**
     * Add an X-Cache header to content served from cache, which indicates to the
     * client that the object was served from an intermediate cache. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getXcacheHeader() {
        return this.xcacheHeader;
    }

    /**
     * Add an X-Cache header to content served from cache, which indicates to the
     * client that the object was served from an intermediate cache. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @param xcacheHeader New value for the property.
     */
    public void setXcacheHeader(java.lang.Boolean xcacheHeader) {
        this.xcacheHeader = xcacheHeader;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHttpCacheConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("age_header",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ageHeader, this._getType().getField("age_header")));
        structValue.setField("aggressive",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.aggressive, this._getType().getField("aggressive")));
        structValue.setField("date_header",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dateHeader, this._getType().getField("date_header")));
        structValue.setField("default_expire",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultExpire, this._getType().getField("default_expire")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("heuristic_expire",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.heuristicExpire, this._getType().getField("heuristic_expire")));
        structValue.setField("ignore_request_cache_control",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ignoreRequestCacheControl, this._getType().getField("ignore_request_cache_control")));
        structValue.setField("max_cache_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxCacheSize, this._getType().getField("max_cache_size")));
        structValue.setField("max_object_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxObjectSize, this._getType().getField("max_object_size")));
        structValue.setField("mime_types_block_group_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mimeTypesBlockGroupPaths, this._getType().getField("mime_types_block_group_paths")));
        structValue.setField("mime_types_block_lists",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mimeTypesBlockLists, this._getType().getField("mime_types_block_lists")));
        structValue.setField("mime_types_group_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mimeTypesGroupPaths, this._getType().getField("mime_types_group_paths")));
        structValue.setField("mime_types_list",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.mimeTypesList, this._getType().getField("mime_types_list")));
        structValue.setField("min_object_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minObjectSize, this._getType().getField("min_object_size")));
        structValue.setField("query_cacheable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.queryCacheable, this._getType().getField("query_cacheable")));
        structValue.setField("uri_non_cacheable",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uriNonCacheable, this._getType().getField("uri_non_cacheable")));
        structValue.setField("xcache_header",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.xcacheHeader, this._getType().getField("xcache_header")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHttpCacheConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHttpCacheConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBHttpCacheConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHttpCacheConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBHttpCacheConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBHttpCacheConfig(structValue);
    }

    /**
     * Builder class for {@link ALBHttpCacheConfig}.
     */
    public static final class Builder {
        private java.lang.Boolean ageHeader;
        private java.lang.Boolean aggressive;
        private java.lang.Boolean dateHeader;
        private java.lang.Long defaultExpire;
        private java.lang.Boolean enabled;
        private java.lang.Boolean heuristicExpire;
        private java.lang.Boolean ignoreRequestCacheControl;
        private java.lang.Long maxCacheSize;
        private java.lang.Long maxObjectSize;
        private java.util.List<java.lang.String> mimeTypesBlockGroupPaths;
        private java.util.List<java.lang.String> mimeTypesBlockLists;
        private java.util.List<java.lang.String> mimeTypesGroupPaths;
        private java.util.List<java.lang.String> mimeTypesList;
        private java.lang.Long minObjectSize;
        private java.lang.Boolean queryCacheable;
        private com.vmware.nsx_global_policy.model.ALBPathMatch uriNonCacheable;
        private java.lang.Boolean xcacheHeader;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBHttpCacheConfig}.
         */
        public Builder() {
        }

        /**
         * Add an Age header to content served from cache, which indicates to the client
         * the number of seconds the object has been in the cache. Default value when not
         * specified in API or module is interpreted by ALB Controller as true.
         *
         * @param ageHeader New value for the property.
         */
        public Builder setAgeHeader(java.lang.Boolean ageHeader) {
            this.ageHeader = ageHeader;
            return this;
        }

        /**
         * Enable/disable caching objects without Cache-Control headers. Default value when
         * not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param aggressive New value for the property.
         */
        public Builder setAggressive(java.lang.Boolean aggressive) {
            this.aggressive = aggressive;
            return this;
        }

        /**
         * If a Date header was not added by the server, add a Date header to the object
         * served from cache. This indicates to the client when the object was originally
         * sent by the server to the cache. Default value when not specified in API or
         * module is interpreted by ALB Controller as true.
         *
         * @param dateHeader New value for the property.
         */
        public Builder setDateHeader(java.lang.Boolean dateHeader) {
            this.dateHeader = dateHeader;
            return this;
        }

        /**
         * Default expiration time of cache objects received from the server without a
         * Cache-Control expiration header. This value may be overwritten by the Heuristic
         * Expire setting. Default value when not specified in API or module is interpreted
         * by ALB Controller as 600. format: int64
         *
         * @param defaultExpire New value for the property.
         */
        public Builder setDefaultExpire(java.lang.Long defaultExpire) {
            this.defaultExpire = defaultExpire;
            return this;
        }

        /**
         * Enable/disable HTTP object caching.When enabling caching for the first time, SE
         * Group app_cache_percent must be set to allocate shared memory required for
         * caching (A service engine restart is needed after setting/resetting the SE group
         * value). Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * If a response object from the server does not include the Cache-Control header,
         * but does include a Last-Modified header, the system will use this time to
         * calculate the Cache-Control expiration. If unable to solicit an Last-Modified
         * header, then the system will fall back to the Cache Expire Time value. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * false.
         *
         * @param heuristicExpire New value for the property.
         */
        public Builder setHeuristicExpire(java.lang.Boolean heuristicExpire) {
            this.heuristicExpire = heuristicExpire;
            return this;
        }

        /**
         * Ignore client's cache control headers when fetching or storing from and to the
         * cache. Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param ignoreRequestCacheControl New value for the property.
         */
        public Builder setIgnoreRequestCacheControl(java.lang.Boolean ignoreRequestCacheControl) {
            this.ignoreRequestCacheControl = ignoreRequestCacheControl;
            return this;
        }

        /**
         * Max size, in bytes, of the cache. The default, zero, indicates auto
         * configuration. Default value when not specified in API or module is interpreted
         * by ALB Controller as 0. format: int64
         *
         * @param maxCacheSize New value for the property.
         */
        public Builder setMaxCacheSize(java.lang.Long maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        /**
         * Maximum size of an object to store in the cache. Default value when not
         * specified in API or module is interpreted by ALB Controller as 4194304. format:
         * int64
         *
         * @param maxObjectSize New value for the property.
         */
        public Builder setMaxObjectSize(java.lang.Long maxObjectSize) {
            this.maxObjectSize = maxObjectSize;
            return this;
        }

        /**
         * Blocklist string group of non-cacheable mime types. It is a reference to an
         * object of type StringGroup.
         *
         * @param mimeTypesBlockGroupPaths New value for the property.
         */
        public Builder setMimeTypesBlockGroupPaths(java.util.List<java.lang.String> mimeTypesBlockGroupPaths) {
            this.mimeTypesBlockGroupPaths = mimeTypesBlockGroupPaths;
            return this;
        }

        /**
         * Blocklist of non-cacheable mime types.
         *
         * @param mimeTypesBlockLists New value for the property.
         */
        public Builder setMimeTypesBlockLists(java.util.List<java.lang.String> mimeTypesBlockLists) {
            this.mimeTypesBlockLists = mimeTypesBlockLists;
            return this;
        }

        /**
         * Allowlist string group of cacheable mime types. If both Cacheable Mime Types
         * string list and string group are empty, this defaults to (STAR)/(STAR). It is a
         * reference to an object of type StringGroup.
         *
         * @param mimeTypesGroupPaths New value for the property.
         */
        public Builder setMimeTypesGroupPaths(java.util.List<java.lang.String> mimeTypesGroupPaths) {
            this.mimeTypesGroupPaths = mimeTypesGroupPaths;
            return this;
        }

        /**
         * Allowlist of cacheable mime types. If both Cacheable Mime Types string list and
         * string group are empty, this defaults to (STAR)/(STAR).
         *
         * @param mimeTypesList New value for the property.
         */
        public Builder setMimeTypesList(java.util.List<java.lang.String> mimeTypesList) {
            this.mimeTypesList = mimeTypesList;
            return this;
        }

        /**
         * Minimum size of an object to store in the cache. Default value when not
         * specified in API or module is interpreted by ALB Controller as 100. format:
         * int64
         *
         * @param minObjectSize New value for the property.
         */
        public Builder setMinObjectSize(java.lang.Long minObjectSize) {
            this.minObjectSize = minObjectSize;
            return this;
        }

        /**
         * Allow caching of objects whose URI included a query argument. When disabled,
         * these objects are not cached. When enabled, the request must match the URI query
         * to be considered a hit. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param queryCacheable New value for the property.
         */
        public Builder setQueryCacheable(java.lang.Boolean queryCacheable) {
            this.queryCacheable = queryCacheable;
            return this;
        }

        /**
         *
         *
         * @param uriNonCacheable New value for the property.
         */
        public Builder setUriNonCacheable(com.vmware.nsx_global_policy.model.ALBPathMatch uriNonCacheable) {
            this.uriNonCacheable = uriNonCacheable;
            return this;
        }

        /**
         * Add an X-Cache header to content served from cache, which indicates to the
         * client that the object was served from an intermediate cache. Default value when
         * not specified in API or module is interpreted by ALB Controller as true.
         *
         * @param xcacheHeader New value for the property.
         */
        public Builder setXcacheHeader(java.lang.Boolean xcacheHeader) {
            this.xcacheHeader = xcacheHeader;
            return this;
        }

        public ALBHttpCacheConfig build() {
            ALBHttpCacheConfig result = new ALBHttpCacheConfig();
            result.setAgeHeader(this.ageHeader);
            result.setAggressive(this.aggressive);
            result.setDateHeader(this.dateHeader);
            result.setDefaultExpire(this.defaultExpire);
            result.setEnabled(this.enabled);
            result.setHeuristicExpire(this.heuristicExpire);
            result.setIgnoreRequestCacheControl(this.ignoreRequestCacheControl);
            result.setMaxCacheSize(this.maxCacheSize);
            result.setMaxObjectSize(this.maxObjectSize);
            result.setMimeTypesBlockGroupPaths(this.mimeTypesBlockGroupPaths);
            result.setMimeTypesBlockLists(this.mimeTypesBlockLists);
            result.setMimeTypesGroupPaths(this.mimeTypesGroupPaths);
            result.setMimeTypesList(this.mimeTypesList);
            result.setMinObjectSize(this.minObjectSize);
            result.setQueryCacheable(this.queryCacheable);
            result.setUriNonCacheable(this.uriNonCacheable);
            result.setXcacheHeader(this.xcacheHeader);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("age_header", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("age_header",
                                                                                "ageHeader",
                                                                                "getAgeHeader",
                                                                                "setAgeHeader");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("aggressive", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("aggressive",
                                                                                "aggressive",
                                                                                "getAggressive",
                                                                                "setAggressive");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("date_header", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("date_header",
                                                                                "dateHeader",
                                                                                "getDateHeader",
                                                                                "setDateHeader");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_expire", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_expire",
                                                                                "defaultExpire",
                                                                                "getDefaultExpire",
                                                                                "setDefaultExpire");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("heuristic_expire", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("heuristic_expire",
                                                                                "heuristicExpire",
                                                                                "getHeuristicExpire",
                                                                                "setHeuristicExpire");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ignore_request_cache_control", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ignore_request_cache_control",
                                                                                "ignoreRequestCacheControl",
                                                                                "getIgnoreRequestCacheControl",
                                                                                "setIgnoreRequestCacheControl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_cache_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_cache_size",
                                                                                "maxCacheSize",
                                                                                "getMaxCacheSize",
                                                                                "setMaxCacheSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_object_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_object_size",
                                                                                "maxObjectSize",
                                                                                "getMaxObjectSize",
                                                                                "setMaxObjectSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mime_types_block_group_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mime_types_block_group_paths",
                                                                                "mimeTypesBlockGroupPaths",
                                                                                "getMimeTypesBlockGroupPaths",
                                                                                "setMimeTypesBlockGroupPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mime_types_block_lists", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mime_types_block_lists",
                                                                                "mimeTypesBlockLists",
                                                                                "getMimeTypesBlockLists",
                                                                                "setMimeTypesBlockLists");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mime_types_group_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mime_types_group_paths",
                                                                                "mimeTypesGroupPaths",
                                                                                "getMimeTypesGroupPaths",
                                                                                "setMimeTypesGroupPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mime_types_list", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mime_types_list",
                                                                                "mimeTypesList",
                                                                                "getMimeTypesList",
                                                                                "setMimeTypesList");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_object_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_object_size",
                                                                                "minObjectSize",
                                                                                "getMinObjectSize",
                                                                                "setMinObjectSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("query_cacheable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("query_cacheable",
                                                                                "queryCacheable",
                                                                                "getQueryCacheable",
                                                                                "setQueryCacheable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("uri_non_cacheable", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPathMatch; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("uri_non_cacheable",
                                                                                "uriNonCacheable",
                                                                                "getUriNonCacheable",
                                                                                "setUriNonCacheable");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("xcache_header", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("xcache_header",
                                                                                "xcacheHeader",
                                                                                "getXcacheHeader",
                                                                                "setXcacheHeader");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_http_cache_config",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBHttpCacheConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

