/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer IPPersistenceProfile object
 */
public final class ALBIPPersistenceProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long ipMask;

    private java.lang.Long ipPersistentTimeout;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBIPPersistenceProfile() {
    }

    protected ALBIPPersistenceProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Mask to be applied on client IP. This may be used to persist clients from a
     * subnet to the same server. When set to 0, all requests are sent to the same
     * server. Allowed values are 0-128. Allowed in Basic edition, Essentials edition,
     * Enterprise edition. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIpMask() {
        return this.ipMask;
    }

    /**
     * Mask to be applied on client IP. This may be used to persist clients from a
     * subnet to the same server. When set to 0, all requests are sent to the same
     * server. Allowed values are 0-128. Allowed in Basic edition, Essentials edition,
     * Enterprise edition. format: int64
     *
     * @param ipMask New value for the property.
     */
    public void setIpMask(java.lang.Long ipMask) {
        this.ipMask = ipMask;
    }

    /**
     * The length of time after a client's connections have closed before expiring the
     * client's persistence to a server. Allowed values are 1-720. Unit is MIN. Default
     * value when not specified in API or module is interpreted by ALB Controller as 5.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIpPersistentTimeout() {
        return this.ipPersistentTimeout;
    }

    /**
     * The length of time after a client's connections have closed before expiring the
     * client's persistence to a server. Allowed values are 1-720. Unit is MIN. Default
     * value when not specified in API or module is interpreted by ALB Controller as 5.
     * format: int64
     *
     * @param ipPersistentTimeout New value for the property.
     */
    public void setIpPersistentTimeout(java.lang.Long ipPersistentTimeout) {
        this.ipPersistentTimeout = ipPersistentTimeout;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBIPPersistenceProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("ip_mask",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipMask, this._getType().getField("ip_mask")));
        structValue.setField("ip_persistent_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipPersistentTimeout, this._getType().getField("ip_persistent_timeout")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBIPPersistenceProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBIPPersistenceProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBIPPersistenceProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBIPPersistenceProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBIPPersistenceProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBIPPersistenceProfile(structValue);
    }

    /**
     * Builder class for {@link ALBIPPersistenceProfile}.
     */
    public static final class Builder {
        private java.lang.Long ipMask;
        private java.lang.Long ipPersistentTimeout;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBIPPersistenceProfile}.
         */
        public Builder() {
        }

        /**
         * Mask to be applied on client IP. This may be used to persist clients from a
         * subnet to the same server. When set to 0, all requests are sent to the same
         * server. Allowed values are 0-128. Allowed in Basic edition, Essentials edition,
         * Enterprise edition. format: int64
         *
         * @param ipMask New value for the property.
         */
        public Builder setIpMask(java.lang.Long ipMask) {
            this.ipMask = ipMask;
            return this;
        }

        /**
         * The length of time after a client's connections have closed before expiring the
         * client's persistence to a server. Allowed values are 1-720. Unit is MIN. Default
         * value when not specified in API or module is interpreted by ALB Controller as 5.
         * format: int64
         *
         * @param ipPersistentTimeout New value for the property.
         */
        public Builder setIpPersistentTimeout(java.lang.Long ipPersistentTimeout) {
            this.ipPersistentTimeout = ipPersistentTimeout;
            return this;
        }

        public ALBIPPersistenceProfile build() {
            ALBIPPersistenceProfile result = new ALBIPPersistenceProfile();
            result.setIpMask(this.ipMask);
            result.setIpPersistentTimeout(this.ipPersistentTimeout);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("ip_mask", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_mask",
                                                                                "ipMask",
                                                                                "getIpMask",
                                                                                "setIpMask");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_persistent_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_persistent_timeout",
                                                                                "ipPersistentTimeout",
                                                                                "getIpPersistentTimeout",
                                                                                "setIpPersistentTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALBIP_persistence_profile",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBIPPersistenceProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

