/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer LdapAuthSettings object
 */
public final class ALBLdapAuthSettings implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SECURITY_MODE_NONE = "AUTH_LDAP_SECURE_NONE";

    public static final java.lang.String SECURITY_MODE_USE_LDAPS = "AUTH_LDAP_SECURE_USE_LDAPS";

    private java.lang.String baseDn;

    private java.lang.Boolean bindAsAdministrator;

    private java.lang.String emailAttribute;

    private java.lang.String fullNameAttribute;

    private java.lang.Long port;

    private java.lang.String securityMode;

    private java.util.List<java.lang.String> server;

    private com.vmware.nsx_global_policy.model.ALBLdapDirectorySettings settings;

    private com.vmware.nsx_global_policy.model.ALBLdapUserBindSettings userBind;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBLdapAuthSettings() {
    }

    protected ALBLdapAuthSettings(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The LDAP base DN. For example, avinetworks.com would be DC=avinetworks,DC=com.
     *
     * @return The current value of the property.
     */
    public java.lang.String getBaseDn() {
        return this.baseDn;
    }

    /**
     * The LDAP base DN. For example, avinetworks.com would be DC=avinetworks,DC=com.
     *
     * @param baseDn New value for the property.
     */
    public void setBaseDn(java.lang.String baseDn) {
        this.baseDn = baseDn;
    }

    /**
     * LDAP administrator credentials are used to search for users and group
     * memberships. Default value when not specified in API or module is interpreted by
     * ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getBindAsAdministrator() {
        return this.bindAsAdministrator;
    }

    /**
     * LDAP administrator credentials are used to search for users and group
     * memberships. Default value when not specified in API or module is interpreted by
     * ALB Controller as true.
     *
     * @param bindAsAdministrator New value for the property.
     */
    public void setBindAsAdministrator(java.lang.Boolean bindAsAdministrator) {
        this.bindAsAdministrator = bindAsAdministrator;
    }

    /**
     * LDAP attribute that refers to user email. Default value when not specified in
     * API or module is interpreted by ALB Controller as email.
     *
     * @return The current value of the property.
     */
    public java.lang.String getEmailAttribute() {
        return this.emailAttribute;
    }

    /**
     * LDAP attribute that refers to user email. Default value when not specified in
     * API or module is interpreted by ALB Controller as email.
     *
     * @param emailAttribute New value for the property.
     */
    public void setEmailAttribute(java.lang.String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    /**
     * LDAP attribute that refers to user's full name. Default value when not specified
     * in API or module is interpreted by ALB Controller as name.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    /**
     * LDAP attribute that refers to user's full name. Default value when not specified
     * in API or module is interpreted by ALB Controller as name.
     *
     * @param fullNameAttribute New value for the property.
     */
    public void setFullNameAttribute(java.lang.String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    /**
     * Query the LDAP servers on this port. Default value when not specified in API or
     * module is interpreted by ALB Controller as 389. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * Query the LDAP servers on this port. Default value when not specified in API or
     * module is interpreted by ALB Controller as 389. format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBLdapAuthSettings#SECURITY_MODE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBLdapAuthSettings#SECURITY_MODE_USE_LDAPS}</li>
     * </ul> LDAP connection security mode. Enum options - AUTH_LDAP_SECURE_NONE,
     * AUTH_LDAP_SECURE_USE_LDAPS.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSecurityMode() {
        return this.securityMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBLdapAuthSettings#SECURITY_MODE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBLdapAuthSettings#SECURITY_MODE_USE_LDAPS}</li>
     * </ul> LDAP connection security mode. Enum options - AUTH_LDAP_SECURE_NONE,
     * AUTH_LDAP_SECURE_USE_LDAPS.
     *
     * @param securityMode New value for the property.
     */
    public void setSecurityMode(java.lang.String securityMode) {
        this.securityMode = securityMode;
    }

    /**
     * LDAP server IP address or Hostname. Use IP address if an auth profile is used to
     * configure Virtual Service. Minimum of 1 items required.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getServer() {
        return this.server;
    }

    /**
     * LDAP server IP address or Hostname. Use IP address if an auth profile is used to
     * configure Virtual Service. Minimum of 1 items required.
     *
     * @param server New value for the property.
     */
    public void setServer(java.util.List<java.lang.String> server) {
        this.server = server;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBLdapDirectorySettings getSettings() {
        return this.settings;
    }

    /**
     *
     *
     * @param settings New value for the property.
     */
    public void setSettings(com.vmware.nsx_global_policy.model.ALBLdapDirectorySettings settings) {
        this.settings = settings;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBLdapUserBindSettings getUserBind() {
        return this.userBind;
    }

    /**
     *
     *
     * @param userBind New value for the property.
     */
    public void setUserBind(com.vmware.nsx_global_policy.model.ALBLdapUserBindSettings userBind) {
        this.userBind = userBind;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBLdapAuthSettings;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("base_dn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.baseDn, this._getType().getField("base_dn")));
        structValue.setField("bind_as_administrator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.bindAsAdministrator, this._getType().getField("bind_as_administrator")));
        structValue.setField("email_attribute",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.emailAttribute, this._getType().getField("email_attribute")));
        structValue.setField("full_name_attribute",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fullNameAttribute, this._getType().getField("full_name_attribute")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("security_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.securityMode, this._getType().getField("security_mode")));
        structValue.setField("server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.server, this._getType().getField("server")));
        structValue.setField("settings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.settings, this._getType().getField("settings")));
        structValue.setField("user_bind",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.userBind, this._getType().getField("user_bind")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBLdapAuthSettings;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBLdapAuthSettings.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBLdapAuthSettings _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBLdapAuthSettings(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBLdapAuthSettings _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBLdapAuthSettings(structValue);
    }

    /**
     * Builder class for {@link ALBLdapAuthSettings}.
     */
    public static final class Builder {
        private java.lang.String baseDn;
        private java.lang.Boolean bindAsAdministrator;
        private java.lang.String emailAttribute;
        private java.lang.String fullNameAttribute;
        private java.lang.Long port;
        private java.lang.String securityMode;
        private java.util.List<java.lang.String> server;
        private com.vmware.nsx_global_policy.model.ALBLdapDirectorySettings settings;
        private com.vmware.nsx_global_policy.model.ALBLdapUserBindSettings userBind;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBLdapAuthSettings}.
         */
        public Builder() {
        }

        /**
         * The LDAP base DN. For example, avinetworks.com would be DC=avinetworks,DC=com.
         *
         * @param baseDn New value for the property.
         */
        public Builder setBaseDn(java.lang.String baseDn) {
            this.baseDn = baseDn;
            return this;
        }

        /**
         * LDAP administrator credentials are used to search for users and group
         * memberships. Default value when not specified in API or module is interpreted by
         * ALB Controller as true.
         *
         * @param bindAsAdministrator New value for the property.
         */
        public Builder setBindAsAdministrator(java.lang.Boolean bindAsAdministrator) {
            this.bindAsAdministrator = bindAsAdministrator;
            return this;
        }

        /**
         * LDAP attribute that refers to user email. Default value when not specified in
         * API or module is interpreted by ALB Controller as email.
         *
         * @param emailAttribute New value for the property.
         */
        public Builder setEmailAttribute(java.lang.String emailAttribute) {
            this.emailAttribute = emailAttribute;
            return this;
        }

        /**
         * LDAP attribute that refers to user's full name. Default value when not specified
         * in API or module is interpreted by ALB Controller as name.
         *
         * @param fullNameAttribute New value for the property.
         */
        public Builder setFullNameAttribute(java.lang.String fullNameAttribute) {
            this.fullNameAttribute = fullNameAttribute;
            return this;
        }

        /**
         * Query the LDAP servers on this port. Default value when not specified in API or
         * module is interpreted by ALB Controller as 389. format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBLdapAuthSettings#SECURITY_MODE_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBLdapAuthSettings#SECURITY_MODE_USE_LDAPS}</li>
         * </ul> LDAP connection security mode. Enum options - AUTH_LDAP_SECURE_NONE,
         * AUTH_LDAP_SECURE_USE_LDAPS.
         *
         * @param securityMode New value for the property.
         */
        public Builder setSecurityMode(java.lang.String securityMode) {
            this.securityMode = securityMode;
            return this;
        }

        /**
         * LDAP server IP address or Hostname. Use IP address if an auth profile is used to
         * configure Virtual Service. Minimum of 1 items required.
         *
         * @param server New value for the property.
         */
        public Builder setServer(java.util.List<java.lang.String> server) {
            this.server = server;
            return this;
        }

        /**
         *
         *
         * @param settings New value for the property.
         */
        public Builder setSettings(com.vmware.nsx_global_policy.model.ALBLdapDirectorySettings settings) {
            this.settings = settings;
            return this;
        }

        /**
         *
         *
         * @param userBind New value for the property.
         */
        public Builder setUserBind(com.vmware.nsx_global_policy.model.ALBLdapUserBindSettings userBind) {
            this.userBind = userBind;
            return this;
        }

        public ALBLdapAuthSettings build() {
            ALBLdapAuthSettings result = new ALBLdapAuthSettings();
            result.setBaseDn(this.baseDn);
            result.setBindAsAdministrator(this.bindAsAdministrator);
            result.setEmailAttribute(this.emailAttribute);
            result.setFullNameAttribute(this.fullNameAttribute);
            result.setPort(this.port);
            result.setSecurityMode(this.securityMode);
            result.setServer(this.server);
            result.setSettings(this.settings);
            result.setUserBind(this.userBind);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("base_dn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("base_dn",
                                                                                "baseDn",
                                                                                "getBaseDn",
                                                                                "setBaseDn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("bind_as_administrator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("bind_as_administrator",
                                                                                "bindAsAdministrator",
                                                                                "getBindAsAdministrator",
                                                                                "setBindAsAdministrator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("email_attribute", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("email_attribute",
                                                                                "emailAttribute",
                                                                                "getEmailAttribute",
                                                                                "setEmailAttribute");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("full_name_attribute", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("full_name_attribute",
                                                                                "fullNameAttribute",
                                                                                "getFullNameAttribute",
                                                                                "setFullNameAttribute");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("security_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("security_mode",
                                                                                "securityMode",
                                                                                "getSecurityMode",
                                                                                "setSecurityMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server",
                                                                                "server",
                                                                                "getServer",
                                                                                "setServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("settings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBLdapDirectorySettings; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("settings",
                                                                                "settings",
                                                                                "getSettings",
                                                                                "setSettings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user_bind", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBLdapUserBindSettings; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user_bind",
                                                                                "userBind",
                                                                                "getUserBind",
                                                                                "setUserBind");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_ldap_auth_settings",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBLdapAuthSettings.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

