/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer Pool object
 */
public final class ALBPool implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String LB_ALGORITHM_LEAST_CONNECTIONS = "LB_ALGORITHM_LEAST_CONNECTIONS";

    public static final java.lang.String LB_ALGORITHM_ROUND_ROBIN = "LB_ALGORITHM_ROUND_ROBIN";

    public static final java.lang.String LB_ALGORITHM_FASTEST_RESPONSE = "LB_ALGORITHM_FASTEST_RESPONSE";

    public static final java.lang.String LB_ALGORITHM_CONSISTENT_HASH = "LB_ALGORITHM_CONSISTENT_HASH";

    public static final java.lang.String LB_ALGORITHM_LEAST_LOAD = "LB_ALGORITHM_LEAST_LOAD";

    public static final java.lang.String LB_ALGORITHM_FEWEST_SERVERS = "LB_ALGORITHM_FEWEST_SERVERS";

    public static final java.lang.String LB_ALGORITHM_RANDOM = "LB_ALGORITHM_RANDOM";

    public static final java.lang.String LB_ALGORITHM_FEWEST_TASKS = "LB_ALGORITHM_FEWEST_TASKS";

    public static final java.lang.String LB_ALGORITHM_NEAREST_SERVER = "LB_ALGORITHM_NEAREST_SERVER";

    public static final java.lang.String LB_ALGORITHM_CORE_AFFINITY = "LB_ALGORITHM_CORE_AFFINITY";

    public static final java.lang.String LB_ALGORITHM_TOPOLOGY = "LB_ALGORITHM_TOPOLOGY";

    public static final java.lang.String LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS = "LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS";

    public static final java.lang.String LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS_AND_PORT = "LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS_AND_PORT";

    public static final java.lang.String LB_ALGORITHM_HASH_URI = "LB_ALGORITHM_CONSISTENT_HASH_URI";

    public static final java.lang.String LB_ALGORITHM_HASH_CUSTOM_HEADER = "LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_HEADER";

    public static final java.lang.String LB_ALGORITHM_HASH_CUSTOM_STRING = "LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_STRING";

    public static final java.lang.String LB_ALGORITHM_HASH_CALLID = "LB_ALGORITHM_CONSISTENT_HASH_CALLID";

    private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_global_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;

    private java.lang.String originSiteId;

    private java.lang.String ownerId;

    private java.lang.String parentPath;

    private java.lang.String path;

    private java.lang.String realizationId;

    private java.lang.String relativePath;

    private java.lang.String remotePath;

    private java.lang.String uniqueId;

    private java.util.List<com.vmware.vapi.bindings.Structure> children;

    private java.lang.Boolean markedForDelete;

    private java.lang.Boolean overridden;

    private com.vmware.nsx_global_policy.model.ALBPoolAnalyticsPolicy analyticsPolicy;

    private java.lang.String analyticsProfilePath;

    private java.lang.String apicEpgName;

    private java.lang.String applicationPersistenceProfilePath;

    private java.lang.String autoscaleLaunchConfigPath;

    private java.util.List<java.lang.String> autoscaleNetworks;

    private java.lang.String autoscalePolicyPath;

    private java.lang.Boolean capacityEstimation;

    private java.lang.Long capacityEstimationTtfbThresh;

    private java.lang.String cloudConfigCksum;

    private java.lang.String cloudName;

    private com.vmware.nsx_global_policy.model.ALBConnPoolProperties connPoolProperties;

    private java.lang.Long connectionRampDuration;

    private java.lang.String createdBy;

    private java.lang.Long defaultServerPort;

    private java.lang.Boolean deleteServerOnDnsRefresh;

    private java.util.List<java.lang.String> domainName;

    private java.lang.Boolean eastWest;

    private java.lang.Boolean enableHttp2;

    private java.lang.Boolean enabled;

    private java.util.List<java.lang.String> externalAutoscaleGroups;

    private com.vmware.nsx_global_policy.model.ALBFailAction failAction;

    private java.lang.Long fewestTasksFeedbackDelay;

    private java.lang.Long gracefulDisableTimeout;

    private java.util.List<java.lang.String> groupPaths;

    private java.lang.Boolean gslbSpEnabled;

    private java.util.List<java.lang.String> healthMonitorPaths;

    private java.lang.Boolean hostCheckEnabled;

    private java.lang.Boolean ignoreServerPort;

    private java.lang.Boolean inlineHealthMonitor;

    private java.lang.String ipaddrgroupPath;

    private java.lang.String lbAlgorithm;

    private java.lang.String lbAlgorithmConsistentHashHdr;

    private java.lang.Long lbAlgorithmCoreNonaffinity;

    private java.lang.String lbAlgorithmHash;

    private java.lang.Boolean lookupServerByName;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers;

    private java.lang.Long maxConcurrentConnectionsPerServer;

    private com.vmware.nsx_global_policy.model.ALBRateProfile maxConnRatePerServer;

    private java.lang.Long minHealthMonitorsUp;

    private java.lang.Long minServersUp;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBNetworkFilter> networks;

    private java.lang.String pkiProfilePath;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBPlacementNetwork> placementNetworks;

    private java.lang.Long requestQueueDepth;

    private java.lang.Boolean requestQueueEnabled;

    private java.lang.Boolean rewriteHostHeaderToServerName;

    private java.lang.Boolean rewriteHostHeaderToSni;

    private java.lang.Boolean routingPool;

    private java.lang.String serverName;

    private com.vmware.nsx_global_policy.model.ALBHTTPServerReselect serverReselect;

    private java.lang.Long serverTimeout;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBServer> servers;

    private java.lang.String serviceMetadata;

    private java.lang.Boolean sniEnabled;

    private java.lang.String sslKeyAndCertificatePath;

    private java.lang.String sslProfilePath;

    private java.lang.String tier1Path;

    private java.lang.Boolean useServicePort;

    private java.lang.String vrfName;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBPool() {
    }

    protected ALBPool(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginSiteId() {
        return this.originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originSiteId New value for the property.
     */
    public void setOriginSiteId(java.lang.String originSiteId) {
        this.originSiteId = originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnerId() {
        return this.ownerId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ownerId New value for the property.
     */
    public void setOwnerId(java.lang.String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentPath() {
        return this.parentPath;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param parentPath New value for the property.
     */
    public void setParentPath(java.lang.String parentPath) {
        this.parentPath = parentPath;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPath() {
        return this.path;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param path New value for the property.
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealizationId() {
        return this.realizationId;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param realizationId New value for the property.
     */
    public void setRealizationId(java.lang.String realizationId) {
        this.realizationId = realizationId;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param relativePath New value for the property.
     */
    public void setRelativePath(java.lang.String relativePath) {
        this.relativePath = relativePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePath New value for the property.
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUniqueId() {
        return this.uniqueId;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param uniqueId New value for the property.
     */
    public void setUniqueId(java.lang.String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getChildren() {
        return this.children;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @param children New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
     */
    public void setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
        this.children = children;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMarkedForDelete() {
        return this.markedForDelete;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param markedForDelete New value for the property.
     */
    public void setMarkedForDelete(java.lang.Boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOverridden() {
        return this.overridden;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overridden New value for the property.
     */
    public void setOverridden(java.lang.Boolean overridden) {
        this.overridden = overridden;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBPoolAnalyticsPolicy getAnalyticsPolicy() {
        return this.analyticsPolicy;
    }

    /**
     *
     *
     * @param analyticsPolicy New value for the property.
     */
    public void setAnalyticsPolicy(com.vmware.nsx_global_policy.model.ALBPoolAnalyticsPolicy analyticsPolicy) {
        this.analyticsPolicy = analyticsPolicy;
    }

    /**
     * Specifies settings related to analytics. It is a reference to an object of type
     * AnalyticsProfile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAnalyticsProfilePath() {
        return this.analyticsProfilePath;
    }

    /**
     * Specifies settings related to analytics. It is a reference to an object of type
     * AnalyticsProfile.
     *
     * @param analyticsProfilePath New value for the property.
     */
    public void setAnalyticsProfilePath(java.lang.String analyticsProfilePath) {
        this.analyticsProfilePath = analyticsProfilePath;
    }

    /**
     * Synchronize Cisco APIC EPG members with pool servers.
     *
     * @return The current value of the property.
     */
    public java.lang.String getApicEpgName() {
        return this.apicEpgName;
    }

    /**
     * Synchronize Cisco APIC EPG members with pool servers.
     *
     * @param apicEpgName New value for the property.
     */
    public void setApicEpgName(java.lang.String apicEpgName) {
        this.apicEpgName = apicEpgName;
    }

    /**
     * Persistence will ensure the same user sticks to the same server for a desired
     * duration of time. It is a reference to an object of type
     * ApplicationPersistenceProfile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getApplicationPersistenceProfilePath() {
        return this.applicationPersistenceProfilePath;
    }

    /**
     * Persistence will ensure the same user sticks to the same server for a desired
     * duration of time. It is a reference to an object of type
     * ApplicationPersistenceProfile.
     *
     * @param applicationPersistenceProfilePath New value for the property.
     */
    public void setApplicationPersistenceProfilePath(java.lang.String applicationPersistenceProfilePath) {
        this.applicationPersistenceProfilePath = applicationPersistenceProfilePath;
    }

    /**
     * If configured then Avi will trigger orchestration of pool server creation and
     * deletion. It is a reference to an object of type AutoScaleLaunchConfig.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAutoscaleLaunchConfigPath() {
        return this.autoscaleLaunchConfigPath;
    }

    /**
     * If configured then Avi will trigger orchestration of pool server creation and
     * deletion. It is a reference to an object of type AutoScaleLaunchConfig.
     *
     * @param autoscaleLaunchConfigPath New value for the property.
     */
    public void setAutoscaleLaunchConfigPath(java.lang.String autoscaleLaunchConfigPath) {
        this.autoscaleLaunchConfigPath = autoscaleLaunchConfigPath;
    }

    /**
     * Network Ids for the launch configuration.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAutoscaleNetworks() {
        return this.autoscaleNetworks;
    }

    /**
     * Network Ids for the launch configuration.
     *
     * @param autoscaleNetworks New value for the property.
     */
    public void setAutoscaleNetworks(java.util.List<java.lang.String> autoscaleNetworks) {
        this.autoscaleNetworks = autoscaleNetworks;
    }

    /**
     * Reference to Server Autoscale Policy. It is a reference to an object of type
     * ServerAutoScalePolicy.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAutoscalePolicyPath() {
        return this.autoscalePolicyPath;
    }

    /**
     * Reference to Server Autoscale Policy. It is a reference to an object of type
     * ServerAutoScalePolicy.
     *
     * @param autoscalePolicyPath New value for the property.
     */
    public void setAutoscalePolicyPath(java.lang.String autoscalePolicyPath) {
        this.autoscalePolicyPath = autoscalePolicyPath;
    }

    /**
     * Inline estimation of capacity of servers. Allowed in Basic(Allowed values-
     * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getCapacityEstimation() {
        return this.capacityEstimation;
    }

    /**
     * Inline estimation of capacity of servers. Allowed in Basic(Allowed values-
     * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param capacityEstimation New value for the property.
     */
    public void setCapacityEstimation(java.lang.Boolean capacityEstimation) {
        this.capacityEstimation = capacityEstimation;
    }

    /**
     * The maximum time-to-first-byte of a server. Allowed values are 1-5000. Special
     * values are 0 - 'Automatic'. Unit is MILLISECONDS. Allowed in Basic(Allowed
     * values- 0) edition, Essentials(Allowed values- 0) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCapacityEstimationTtfbThresh() {
        return this.capacityEstimationTtfbThresh;
    }

    /**
     * The maximum time-to-first-byte of a server. Allowed values are 1-5000. Special
     * values are 0 - 'Automatic'. Unit is MILLISECONDS. Allowed in Basic(Allowed
     * values- 0) edition, Essentials(Allowed values- 0) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 0. format: int64
     *
     * @param capacityEstimationTtfbThresh New value for the property.
     */
    public void setCapacityEstimationTtfbThresh(java.lang.Long capacityEstimationTtfbThresh) {
        this.capacityEstimationTtfbThresh = capacityEstimationTtfbThresh;
    }

    /**
     * Checksum of cloud configuration for Pool. Internally set by cloud connector.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCloudConfigCksum() {
        return this.cloudConfigCksum;
    }

    /**
     * Checksum of cloud configuration for Pool. Internally set by cloud connector.
     *
     * @param cloudConfigCksum New value for the property.
     */
    public void setCloudConfigCksum(java.lang.String cloudConfigCksum) {
        this.cloudConfigCksum = cloudConfigCksum;
    }

    /**
     * It is a reference to an object of type Cloud.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCloudName() {
        return this.cloudName;
    }

    /**
     * It is a reference to an object of type Cloud.
     *
     * @param cloudName New value for the property.
     */
    public void setCloudName(java.lang.String cloudName) {
        this.cloudName = cloudName;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBConnPoolProperties getConnPoolProperties() {
        return this.connPoolProperties;
    }

    /**
     *
     *
     * @param connPoolProperties New value for the property.
     */
    public void setConnPoolProperties(com.vmware.nsx_global_policy.model.ALBConnPoolProperties connPoolProperties) {
        this.connPoolProperties = connPoolProperties;
    }

    /**
     * Duration for which new connections will be gradually ramped up to a server
     * recently brought online. Useful for LB algorithms that are least connection
     * based. Allowed values are 1-300. Special values are 0 - 'Immediate'. Unit is
     * MIN. Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed values- 0)
     * edition, Enterprise edition. Special default for Basic edition is 0, Essentials
     * edition is 0, Enterprise is 10. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getConnectionRampDuration() {
        return this.connectionRampDuration;
    }

    /**
     * Duration for which new connections will be gradually ramped up to a server
     * recently brought online. Useful for LB algorithms that are least connection
     * based. Allowed values are 1-300. Special values are 0 - 'Immediate'. Unit is
     * MIN. Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed values- 0)
     * edition, Enterprise edition. Special default for Basic edition is 0, Essentials
     * edition is 0, Enterprise is 10. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @param connectionRampDuration New value for the property.
     */
    public void setConnectionRampDuration(java.lang.Long connectionRampDuration) {
        this.connectionRampDuration = connectionRampDuration;
    }

    /**
     * Creator name.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * Creator name.
     *
     * @param createdBy New value for the property.
     */
    public void setCreatedBy(java.lang.String createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * Traffic sent to servers will use this destination server port unless overridden
     * by the server's specific port attribute. The SSL checkbox enables Avi to server
     * encryption. Allowed values are 1-65535. Default value when not specified in API
     * or module is interpreted by ALB Controller as 80. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDefaultServerPort() {
        return this.defaultServerPort;
    }

    /**
     * Traffic sent to servers will use this destination server port unless overridden
     * by the server's specific port attribute. The SSL checkbox enables Avi to server
     * encryption. Allowed values are 1-65535. Default value when not specified in API
     * or module is interpreted by ALB Controller as 80. format: int64
     *
     * @param defaultServerPort New value for the property.
     */
    public void setDefaultServerPort(java.lang.Long defaultServerPort) {
        this.defaultServerPort = defaultServerPort;
    }

    /**
     * Indicates whether existing IPs are disabled(false) or deleted(true) on dns
     * hostname refreshDetail -- On a dns refresh, some IPs set on pool may no longer
     * be returned by the resolver. These IPs are deleted from the pool when this knob
     * is set to true. They are disabled, if the knob is set to false. Allowed in
     * Basic(Allowed values- true) edition, Essentials(Allowed values- true) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDeleteServerOnDnsRefresh() {
        return this.deleteServerOnDnsRefresh;
    }

    /**
     * Indicates whether existing IPs are disabled(false) or deleted(true) on dns
     * hostname refreshDetail -- On a dns refresh, some IPs set on pool may no longer
     * be returned by the resolver. These IPs are deleted from the pool when this knob
     * is set to true. They are disabled, if the knob is set to false. Allowed in
     * Basic(Allowed values- true) edition, Essentials(Allowed values- true) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @param deleteServerOnDnsRefresh New value for the property.
     */
    public void setDeleteServerOnDnsRefresh(java.lang.Boolean deleteServerOnDnsRefresh) {
        this.deleteServerOnDnsRefresh = deleteServerOnDnsRefresh;
    }

    /**
     * Comma separated list of domain names which will be used to verify the common
     * names or subject alternative names presented by server certificates. It is
     * performed only when common name check host_check_enabled is enabled.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDomainName() {
        return this.domainName;
    }

    /**
     * Comma separated list of domain names which will be used to verify the common
     * names or subject alternative names presented by server certificates. It is
     * performed only when common name check host_check_enabled is enabled.
     *
     * @param domainName New value for the property.
     */
    public void setDomainName(java.util.List<java.lang.String> domainName) {
        this.domainName = domainName;
    }

    /**
     * Inherited config from VirtualService.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEastWest() {
        return this.eastWest;
    }

    /**
     * Inherited config from VirtualService.
     *
     * @param eastWest New value for the property.
     */
    public void setEastWest(java.lang.Boolean eastWest) {
        this.eastWest = eastWest;
    }

    /**
     * Enable HTTP/2 for traffic from VirtualService to all backend servers in this
     * pool. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableHttp2() {
        return this.enableHttp2;
    }

    /**
     * Enable HTTP/2 for traffic from VirtualService to all backend servers in this
     * pool. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @param enableHttp2 New value for the property.
     */
    public void setEnableHttp2(java.lang.Boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    /**
     * Enable or disable the pool. Disabling will terminate all open connections and
     * pause health monitors. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Enable or disable the pool. Disabling will terminate all open connections and
     * pause health monitors. Default value when not specified in API or module is
     * interpreted by ALB Controller as true.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Names of external auto-scale groups for pool servers. Currently available only
     * for AWS and Azure.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getExternalAutoscaleGroups() {
        return this.externalAutoscaleGroups;
    }

    /**
     * Names of external auto-scale groups for pool servers. Currently available only
     * for AWS and Azure.
     *
     * @param externalAutoscaleGroups New value for the property.
     */
    public void setExternalAutoscaleGroups(java.util.List<java.lang.String> externalAutoscaleGroups) {
        this.externalAutoscaleGroups = externalAutoscaleGroups;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBFailAction getFailAction() {
        return this.failAction;
    }

    /**
     *
     *
     * @param failAction New value for the property.
     */
    public void setFailAction(com.vmware.nsx_global_policy.model.ALBFailAction failAction) {
        this.failAction = failAction;
    }

    /**
     * Periodicity of feedback for fewest tasks server selection algorithm. Allowed
     * values are 1-300. Unit is SEC. Default value when not specified in API or module
     * is interpreted by ALB Controller as 10. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getFewestTasksFeedbackDelay() {
        return this.fewestTasksFeedbackDelay;
    }

    /**
     * Periodicity of feedback for fewest tasks server selection algorithm. Allowed
     * values are 1-300. Unit is SEC. Default value when not specified in API or module
     * is interpreted by ALB Controller as 10. format: int64
     *
     * @param fewestTasksFeedbackDelay New value for the property.
     */
    public void setFewestTasksFeedbackDelay(java.lang.Long fewestTasksFeedbackDelay) {
        this.fewestTasksFeedbackDelay = fewestTasksFeedbackDelay;
    }

    /**
     * Used to gracefully disable a server. Virtual service waits for the specified
     * time before terminating the existing connections to the servers that are
     * disabled. Allowed values are 1-7200. Special values are 0 - 'Immediate', -1 -
     * 'Infinite'. Unit is MIN. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getGracefulDisableTimeout() {
        return this.gracefulDisableTimeout;
    }

    /**
     * Used to gracefully disable a server. Virtual service waits for the specified
     * time before terminating the existing connections to the servers that are
     * disabled. Allowed values are 1-7200. Special values are 0 - 'Immediate', -1 -
     * 'Infinite'. Unit is MIN. Default value when not specified in API or module is
     * interpreted by ALB Controller as 1. format: int64
     *
     * @param gracefulDisableTimeout New value for the property.
     */
    public void setGracefulDisableTimeout(java.lang.Long gracefulDisableTimeout) {
        this.gracefulDisableTimeout = gracefulDisableTimeout;
    }

    /**
     * A list of NSX Groups where the Servers for the Pool are created .
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getGroupPaths() {
        return this.groupPaths;
    }

    /**
     * A list of NSX Groups where the Servers for the Pool are created .
     *
     * @param groupPaths New value for the property.
     */
    public void setGroupPaths(java.util.List<java.lang.String> groupPaths) {
        this.groupPaths = groupPaths;
    }

    /**
     * Indicates if the pool is a site-persistence pool. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getGslbSpEnabled() {
        return this.gslbSpEnabled;
    }

    /**
     * Indicates if the pool is a site-persistence pool. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @param gslbSpEnabled New value for the property.
     */
    public void setGslbSpEnabled(java.lang.Boolean gslbSpEnabled) {
        this.gslbSpEnabled = gslbSpEnabled;
    }

    /**
     * Verify server health by applying one or more health monitors. Active monitors
     * generate synthetic traffic from each Service Engine and mark a server up or down
     * based on the response. The Passive monitor listens only to client to server
     * communication. It raises or lowers the ratio of traffic destined to a server
     * based on successful responses. It is a reference to an object of type
     * HealthMonitor. Maximum of 50 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getHealthMonitorPaths() {
        return this.healthMonitorPaths;
    }

    /**
     * Verify server health by applying one or more health monitors. Active monitors
     * generate synthetic traffic from each Service Engine and mark a server up or down
     * based on the response. The Passive monitor listens only to client to server
     * communication. It raises or lowers the ratio of traffic destined to a server
     * based on successful responses. It is a reference to an object of type
     * HealthMonitor. Maximum of 50 items allowed.
     *
     * @param healthMonitorPaths New value for the property.
     */
    public void setHealthMonitorPaths(java.util.List<java.lang.String> healthMonitorPaths) {
        this.healthMonitorPaths = healthMonitorPaths;
    }

    /**
     * Enable common name check for server certificate. If enabled and no explicit
     * domain name is specified, Avi will use the incoming host header to do the match.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getHostCheckEnabled() {
        return this.hostCheckEnabled;
    }

    /**
     * Enable common name check for server certificate. If enabled and no explicit
     * domain name is specified, Avi will use the incoming host header to do the match.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param hostCheckEnabled New value for the property.
     */
    public void setHostCheckEnabled(java.lang.Boolean hostCheckEnabled) {
        this.hostCheckEnabled = hostCheckEnabled;
    }

    /**
     * Ignore the server port in building the load balancing state.Applicable only for
     * consistent hash load balancing algorithm or Disable Port translation
     * (use_service_port) use cases. Default value when not specified in API or module
     * is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIgnoreServerPort() {
        return this.ignoreServerPort;
    }

    /**
     * Ignore the server port in building the load balancing state.Applicable only for
     * consistent hash load balancing algorithm or Disable Port translation
     * (use_service_port) use cases. Default value when not specified in API or module
     * is interpreted by ALB Controller as false.
     *
     * @param ignoreServerPort New value for the property.
     */
    public void setIgnoreServerPort(java.lang.Boolean ignoreServerPort) {
        this.ignoreServerPort = ignoreServerPort;
    }

    /**
     * The Passive monitor will monitor client to server connections and requests and
     * adjust traffic load to servers based on successful responses. This may alter the
     * expected behavior of the LB method, such as Round Robin. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getInlineHealthMonitor() {
        return this.inlineHealthMonitor;
    }

    /**
     * The Passive monitor will monitor client to server connections and requests and
     * adjust traffic load to servers based on successful responses. This may alter the
     * expected behavior of the LB method, such as Round Robin. Default value when not
     * specified in API or module is interpreted by ALB Controller as true.
     *
     * @param inlineHealthMonitor New value for the property.
     */
    public void setInlineHealthMonitor(java.lang.Boolean inlineHealthMonitor) {
        this.inlineHealthMonitor = inlineHealthMonitor;
    }

    /**
     * Use list of servers from Ip Address Group. It is a reference to an object of
     * type IpAddrGroup.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpaddrgroupPath() {
        return this.ipaddrgroupPath;
    }

    /**
     * Use list of servers from Ip Address Group. It is a reference to an object of
     * type IpAddrGroup.
     *
     * @param ipaddrgroupPath New value for the property.
     */
    public void setIpaddrgroupPath(java.lang.String ipaddrgroupPath) {
        this.ipaddrgroupPath = ipaddrgroupPath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_LEAST_CONNECTIONS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_ROUND_ROBIN}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FASTEST_RESPONSE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_CONSISTENT_HASH}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_LEAST_LOAD}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FEWEST_SERVERS}</li>
     * <li> {@link com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_RANDOM}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FEWEST_TASKS}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_NEAREST_SERVER}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_CORE_AFFINITY}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_TOPOLOGY}</li>
     * </ul> The load balancing algorithm will pick a server within the pool's list of
     * available servers. Values LB_ALGORITHM_NEAREST_SERVER and LB_ALGORITHM_TOPOLOGY
     * are only allowed for GSLB pool. Enum options - LB_ALGORITHM_LEAST_CONNECTIONS,
     * LB_ALGORITHM_ROUND_ROBIN, LB_ALGORITHM_FASTEST_RESPONSE,
     * LB_ALGORITHM_CONSISTENT_HASH, LB_ALGORITHM_LEAST_LOAD,
     * LB_ALGORITHM_FEWEST_SERVERS, LB_ALGORITHM_RANDOM, LB_ALGORITHM_FEWEST_TASKS,
     * LB_ALGORITHM_NEAREST_SERVER, LB_ALGORITHM_CORE_AFFINITY, LB_ALGORITHM_TOPOLOGY.
     * Allowed in Basic(Allowed values-
     * LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
     * edition, Essentials(Allowed values-
     * LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
     * edition, Enterprise edition. Default value when not specified in API or module
     * is interpreted by ALB Controller as LB_ALGORITHM_LEAST_CONNECTIONS.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLbAlgorithm() {
        return this.lbAlgorithm;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_LEAST_CONNECTIONS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_ROUND_ROBIN}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FASTEST_RESPONSE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_CONSISTENT_HASH}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_LEAST_LOAD}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FEWEST_SERVERS}</li>
     * <li> {@link com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_RANDOM}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FEWEST_TASKS}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_NEAREST_SERVER}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_CORE_AFFINITY}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_TOPOLOGY}</li>
     * </ul> The load balancing algorithm will pick a server within the pool's list of
     * available servers. Values LB_ALGORITHM_NEAREST_SERVER and LB_ALGORITHM_TOPOLOGY
     * are only allowed for GSLB pool. Enum options - LB_ALGORITHM_LEAST_CONNECTIONS,
     * LB_ALGORITHM_ROUND_ROBIN, LB_ALGORITHM_FASTEST_RESPONSE,
     * LB_ALGORITHM_CONSISTENT_HASH, LB_ALGORITHM_LEAST_LOAD,
     * LB_ALGORITHM_FEWEST_SERVERS, LB_ALGORITHM_RANDOM, LB_ALGORITHM_FEWEST_TASKS,
     * LB_ALGORITHM_NEAREST_SERVER, LB_ALGORITHM_CORE_AFFINITY, LB_ALGORITHM_TOPOLOGY.
     * Allowed in Basic(Allowed values-
     * LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
     * edition, Essentials(Allowed values-
     * LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
     * edition, Enterprise edition. Default value when not specified in API or module
     * is interpreted by ALB Controller as LB_ALGORITHM_LEAST_CONNECTIONS.
     *
     * @param lbAlgorithm New value for the property.
     */
    public void setLbAlgorithm(java.lang.String lbAlgorithm) {
        this.lbAlgorithm = lbAlgorithm;
    }

    /**
     * HTTP header name to be used for the hash key.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLbAlgorithmConsistentHashHdr() {
        return this.lbAlgorithmConsistentHashHdr;
    }

    /**
     * HTTP header name to be used for the hash key.
     *
     * @param lbAlgorithmConsistentHashHdr New value for the property.
     */
    public void setLbAlgorithmConsistentHashHdr(java.lang.String lbAlgorithmConsistentHashHdr) {
        this.lbAlgorithmConsistentHashHdr = lbAlgorithmConsistentHashHdr;
    }

    /**
     * Degree of non-affinity for core affinity based server selection. Allowed values
     * are 1-65535. Allowed in Basic(Allowed values- 2) edition, Essentials(Allowed
     * values- 2) edition, Enterprise edition. Default value when not specified in API
     * or module is interpreted by ALB Controller as 2. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLbAlgorithmCoreNonaffinity() {
        return this.lbAlgorithmCoreNonaffinity;
    }

    /**
     * Degree of non-affinity for core affinity based server selection. Allowed values
     * are 1-65535. Allowed in Basic(Allowed values- 2) edition, Essentials(Allowed
     * values- 2) edition, Enterprise edition. Default value when not specified in API
     * or module is interpreted by ALB Controller as 2. format: int64
     *
     * @param lbAlgorithmCoreNonaffinity New value for the property.
     */
    public void setLbAlgorithmCoreNonaffinity(java.lang.Long lbAlgorithmCoreNonaffinity) {
        this.lbAlgorithmCoreNonaffinity = lbAlgorithmCoreNonaffinity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS_AND_PORT}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_URI}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CUSTOM_HEADER}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CUSTOM_STRING}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CALLID}</li> </ul>
     * Criteria used as a key for determining the hash between the client and server.
     * Enum options - LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS,
     * LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS_AND_PORT,
     * LB_ALGORITHM_CONSISTENT_HASH_URI, LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_HEADER,
     * LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_STRING, LB_ALGORITHM_CONSISTENT_HASH_CALLID.
     * Allowed in Basic(Allowed values- LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS)
     * edition, Essentials(Allowed values-
     * LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLbAlgorithmHash() {
        return this.lbAlgorithmHash;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS_AND_PORT}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_URI}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CUSTOM_HEADER}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CUSTOM_STRING}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CALLID}</li> </ul>
     * Criteria used as a key for determining the hash between the client and server.
     * Enum options - LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS,
     * LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS_AND_PORT,
     * LB_ALGORITHM_CONSISTENT_HASH_URI, LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_HEADER,
     * LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_STRING, LB_ALGORITHM_CONSISTENT_HASH_CALLID.
     * Allowed in Basic(Allowed values- LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS)
     * edition, Essentials(Allowed values-
     * LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS.
     *
     * @param lbAlgorithmHash New value for the property.
     */
    public void setLbAlgorithmHash(java.lang.String lbAlgorithmHash) {
        this.lbAlgorithmHash = lbAlgorithmHash;
    }

    /**
     * Allow server lookup by name. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getLookupServerByName() {
        return this.lookupServerByName;
    }

    /**
     * Allow server lookup by name. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param lookupServerByName New value for the property.
     */
    public void setLookupServerByName(java.lang.Boolean lookupServerByName) {
        this.lookupServerByName = lookupServerByName;
    }

    /**
     * List of labels to be used for granular RBAC. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> getMarkers() {
        return this.markers;
    }

    /**
     * List of labels to be used for granular RBAC. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @param markers New value for the property.
     */
    public void setMarkers(java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers) {
        this.markers = markers;
    }

    /**
     * The maximum number of concurrent connections allowed to each server within the
     * pool. NOTE applied value will be no less than the number of service engines that
     * the pool is placed on. If set to 0, no limit is applied. Default value when not
     * specified in API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxConcurrentConnectionsPerServer() {
        return this.maxConcurrentConnectionsPerServer;
    }

    /**
     * The maximum number of concurrent connections allowed to each server within the
     * pool. NOTE applied value will be no less than the number of service engines that
     * the pool is placed on. If set to 0, no limit is applied. Default value when not
     * specified in API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @param maxConcurrentConnectionsPerServer New value for the property.
     */
    public void setMaxConcurrentConnectionsPerServer(java.lang.Long maxConcurrentConnectionsPerServer) {
        this.maxConcurrentConnectionsPerServer = maxConcurrentConnectionsPerServer;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBRateProfile getMaxConnRatePerServer() {
        return this.maxConnRatePerServer;
    }

    /**
     *
     *
     * @param maxConnRatePerServer New value for the property.
     */
    public void setMaxConnRatePerServer(com.vmware.nsx_global_policy.model.ALBRateProfile maxConnRatePerServer) {
        this.maxConnRatePerServer = maxConnRatePerServer;
    }

    /**
     * Minimum number of health monitors in UP state to mark server UP. Allowed in
     * Basic edition, Essentials edition, Enterprise edition. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMinHealthMonitorsUp() {
        return this.minHealthMonitorsUp;
    }

    /**
     * Minimum number of health monitors in UP state to mark server UP. Allowed in
     * Basic edition, Essentials edition, Enterprise edition. format: int64
     *
     * @param minHealthMonitorsUp New value for the property.
     */
    public void setMinHealthMonitorsUp(java.lang.Long minHealthMonitorsUp) {
        this.minHealthMonitorsUp = minHealthMonitorsUp;
    }

    /**
     * Minimum number of servers in UP state for marking the pool UP. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMinServersUp() {
        return this.minServersUp;
    }

    /**
     * Minimum number of servers in UP state for marking the pool UP. format: int64
     *
     * @param minServersUp New value for the property.
     */
    public void setMinServersUp(java.lang.Long minServersUp) {
        this.minServersUp = minServersUp;
    }

    /**
     * (internal-use) Networks designated as containing servers for this pool. The
     * servers may be further narrowed down by a filter. This field is used internally
     * by Avi, not editable by the user.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBNetworkFilter> getNetworks() {
        return this.networks;
    }

    /**
     * (internal-use) Networks designated as containing servers for this pool. The
     * servers may be further narrowed down by a filter. This field is used internally
     * by Avi, not editable by the user.
     *
     * @param networks New value for the property.
     */
    public void setNetworks(java.util.List<com.vmware.nsx_global_policy.model.ALBNetworkFilter> networks) {
        this.networks = networks;
    }

    /**
     * Avi will validate the SSL certificate present by a server against the selected
     * PKI Profile. It is a reference to an object of type PKIProfile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPkiProfilePath() {
        return this.pkiProfilePath;
    }

    /**
     * Avi will validate the SSL certificate present by a server against the selected
     * PKI Profile. It is a reference to an object of type PKIProfile.
     *
     * @param pkiProfilePath New value for the property.
     */
    public void setPkiProfilePath(java.lang.String pkiProfilePath) {
        this.pkiProfilePath = pkiProfilePath;
    }

    /**
     * Manually select the networks and subnets used to provide reachability to the
     * pool's servers. Specify the Subnet using the following syntax 10-1-1-0/24. Use
     * static routes in VRF configuration when pool servers are not directly connected
     * but routable from the service engine.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBPlacementNetwork> getPlacementNetworks() {
        return this.placementNetworks;
    }

    /**
     * Manually select the networks and subnets used to provide reachability to the
     * pool's servers. Specify the Subnet using the following syntax 10-1-1-0/24. Use
     * static routes in VRF configuration when pool servers are not directly connected
     * but routable from the service engine.
     *
     * @param placementNetworks New value for the property.
     */
    public void setPlacementNetworks(java.util.List<com.vmware.nsx_global_policy.model.ALBPlacementNetwork> placementNetworks) {
        this.placementNetworks = placementNetworks;
    }

    /**
     * Minimum number of requests to be queued when pool is full. Allowed in
     * Basic(Allowed values- 128) edition, Essentials(Allowed values- 128) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as 128. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRequestQueueDepth() {
        return this.requestQueueDepth;
    }

    /**
     * Minimum number of requests to be queued when pool is full. Allowed in
     * Basic(Allowed values- 128) edition, Essentials(Allowed values- 128) edition,
     * Enterprise edition. Default value when not specified in API or module is
     * interpreted by ALB Controller as 128. format: int64
     *
     * @param requestQueueDepth New value for the property.
     */
    public void setRequestQueueDepth(java.lang.Long requestQueueDepth) {
        this.requestQueueDepth = requestQueueDepth;
    }

    /**
     * Enable request queue when pool is full. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRequestQueueEnabled() {
        return this.requestQueueEnabled;
    }

    /**
     * Enable request queue when pool is full. Allowed in Basic(Allowed values- false)
     * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as
     * false.
     *
     * @param requestQueueEnabled New value for the property.
     */
    public void setRequestQueueEnabled(java.lang.Boolean requestQueueEnabled) {
        this.requestQueueEnabled = requestQueueEnabled;
    }

    /**
     * Rewrite incoming Host Header to server name of the server to which the request
     * is proxied. Enabling this feature rewrites Host Header for requests to all
     * servers in the pool. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRewriteHostHeaderToServerName() {
        return this.rewriteHostHeaderToServerName;
    }

    /**
     * Rewrite incoming Host Header to server name of the server to which the request
     * is proxied. Enabling this feature rewrites Host Header for requests to all
     * servers in the pool. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param rewriteHostHeaderToServerName New value for the property.
     */
    public void setRewriteHostHeaderToServerName(java.lang.Boolean rewriteHostHeaderToServerName) {
        this.rewriteHostHeaderToServerName = rewriteHostHeaderToServerName;
    }

    /**
     * If SNI server name is specified, rewrite incoming host header to the SNI server
     * name. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRewriteHostHeaderToSni() {
        return this.rewriteHostHeaderToSni;
    }

    /**
     * If SNI server name is specified, rewrite incoming host header to the SNI server
     * name. Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param rewriteHostHeaderToSni New value for the property.
     */
    public void setRewriteHostHeaderToSni(java.lang.Boolean rewriteHostHeaderToSni) {
        this.rewriteHostHeaderToSni = rewriteHostHeaderToSni;
    }

    /**
     * Enable to do routing when this pool is selected to send traffic. No servers
     * present in routing pool. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getRoutingPool() {
        return this.routingPool;
    }

    /**
     * Enable to do routing when this pool is selected to send traffic. No servers
     * present in routing pool. Default value when not specified in API or module is
     * interpreted by ALB Controller as false.
     *
     * @param routingPool New value for the property.
     */
    public void setRoutingPool(java.lang.Boolean routingPool) {
        this.routingPool = routingPool;
    }

    /**
     * Fully qualified DNS hostname which will be used in the TLS SNI extension in
     * server connections if SNI is enabled. If no value is specified, Avi will use the
     * incoming host header instead.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServerName() {
        return this.serverName;
    }

    /**
     * Fully qualified DNS hostname which will be used in the TLS SNI extension in
     * server connections if SNI is enabled. If no value is specified, Avi will use the
     * incoming host header instead.
     *
     * @param serverName New value for the property.
     */
    public void setServerName(java.lang.String serverName) {
        this.serverName = serverName;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBHTTPServerReselect getServerReselect() {
        return this.serverReselect;
    }

    /**
     *
     *
     * @param serverReselect New value for the property.
     */
    public void setServerReselect(com.vmware.nsx_global_policy.model.ALBHTTPServerReselect serverReselect) {
        this.serverReselect = serverReselect;
    }

    /**
     * Server timeout value specifies the time within which a server connection needs
     * to be established and a request-response exchange completes between AVI and the
     * server. Value of 0 results in using default timeout of 60 minutes. Allowed
     * values are 0-21600000. Unit is MILLISECONDS. Default value when not specified in
     * API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getServerTimeout() {
        return this.serverTimeout;
    }

    /**
     * Server timeout value specifies the time within which a server connection needs
     * to be established and a request-response exchange completes between AVI and the
     * server. Value of 0 results in using default timeout of 60 minutes. Allowed
     * values are 0-21600000. Unit is MILLISECONDS. Default value when not specified in
     * API or module is interpreted by ALB Controller as 0. format: int64
     *
     * @param serverTimeout New value for the property.
     */
    public void setServerTimeout(java.lang.Long serverTimeout) {
        this.serverTimeout = serverTimeout;
    }

    /**
     * The pool directs load balanced traffic to this list of destination servers. The
     * servers can be configured by IP address, name, network or via IP Address Group.
     * Maximum of 5000 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBServer> getServers() {
        return this.servers;
    }

    /**
     * The pool directs load balanced traffic to this list of destination servers. The
     * servers can be configured by IP address, name, network or via IP Address Group.
     * Maximum of 5000 items allowed.
     *
     * @param servers New value for the property.
     */
    public void setServers(java.util.List<com.vmware.nsx_global_policy.model.ALBServer> servers) {
        this.servers = servers;
    }

    /**
     * Metadata pertaining to the service provided by this Pool. In
     * Openshift/Kubernetes environments, app metadata info is stored. Any user input
     * to this field will be overwritten by Avi Vantage.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceMetadata() {
        return this.serviceMetadata;
    }

    /**
     * Metadata pertaining to the service provided by this Pool. In
     * Openshift/Kubernetes environments, app metadata info is stored. Any user input
     * to this field will be overwritten by Avi Vantage.
     *
     * @param serviceMetadata New value for the property.
     */
    public void setServiceMetadata(java.lang.String serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    /**
     * Enable TLS SNI for server connections. If disabled, Avi will not send the SNI
     * extension as part of the handshake. Default value when not specified in API or
     * module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSniEnabled() {
        return this.sniEnabled;
    }

    /**
     * Enable TLS SNI for server connections. If disabled, Avi will not send the SNI
     * extension as part of the handshake. Default value when not specified in API or
     * module is interpreted by ALB Controller as true.
     *
     * @param sniEnabled New value for the property.
     */
    public void setSniEnabled(java.lang.Boolean sniEnabled) {
        this.sniEnabled = sniEnabled;
    }

    /**
     * Service Engines will present a client SSL certificate to the server. It is a
     * reference to an object of type SSLKeyAndCertificate.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSslKeyAndCertificatePath() {
        return this.sslKeyAndCertificatePath;
    }

    /**
     * Service Engines will present a client SSL certificate to the server. It is a
     * reference to an object of type SSLKeyAndCertificate.
     *
     * @param sslKeyAndCertificatePath New value for the property.
     */
    public void setSslKeyAndCertificatePath(java.lang.String sslKeyAndCertificatePath) {
        this.sslKeyAndCertificatePath = sslKeyAndCertificatePath;
    }

    /**
     * When enabled, Avi re-encrypts traffic to the backend servers. The specific SSL
     * profile defines which ciphers and SSL versions will be supported. It is a
     * reference to an object of type SSLProfile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSslProfilePath() {
        return this.sslProfilePath;
    }

    /**
     * When enabled, Avi re-encrypts traffic to the backend servers. The specific SSL
     * profile defines which ciphers and SSL versions will be supported. It is a
     * reference to an object of type SSLProfile.
     *
     * @param sslProfilePath New value for the property.
     */
    public void setSslProfilePath(java.lang.String sslProfilePath) {
        this.sslProfilePath = sslProfilePath;
    }

    /**
     * This tier1_lr field should be set same as VirtualService associated for NSX-T.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTier1Path() {
        return this.tier1Path;
    }

    /**
     * This tier1_lr field should be set same as VirtualService associated for NSX-T.
     *
     * @param tier1Path New value for the property.
     */
    public void setTier1Path(java.lang.String tier1Path) {
        this.tier1Path = tier1Path;
    }

    /**
     * Do not translate the client's destination port when sending the connection to
     * the server. The pool or servers specified service port will still be used for
     * health monitoring. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getUseServicePort() {
        return this.useServicePort;
    }

    /**
     * Do not translate the client's destination port when sending the connection to
     * the server. The pool or servers specified service port will still be used for
     * health monitoring. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param useServicePort New value for the property.
     */
    public void setUseServicePort(java.lang.Boolean useServicePort) {
        this.useServicePort = useServicePort;
    }

    /**
     * Virtual Routing Context that the pool is bound to. This is used to provide the
     * isolation of the set of networks the pool is attached to. The pool inherits the
     * Virtual Routing Conext of the Virtual Service, and this field is used only
     * internally, and is set by pb-transform. It is a reference to an object of type
     * VrfContext.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVrfName() {
        return this.vrfName;
    }

    /**
     * Virtual Routing Context that the pool is bound to. This is used to provide the
     * isolation of the set of networks the pool is attached to. The pool inherits the
     * Virtual Routing Conext of the Virtual Service, and this field is used only
     * internally, and is set by pb-transform. It is a reference to an object of type
     * VrfContext.
     *
     * @param vrfName New value for the property.
     */
    public void setVrfName(java.lang.String vrfName) {
        this.vrfName = vrfName;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPool;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("origin_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originSiteId, this._getType().getField("origin_site_id")));
        structValue.setField("owner_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownerId, this._getType().getField("owner_id")));
        structValue.setField("parent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentPath, this._getType().getField("parent_path")));
        structValue.setField("path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.path, this._getType().getField("path")));
        structValue.setField("realization_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizationId, this._getType().getField("realization_id")));
        structValue.setField("relative_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.relativePath, this._getType().getField("relative_path")));
        structValue.setField("remote_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePath, this._getType().getField("remote_path")));
        structValue.setField("unique_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uniqueId, this._getType().getField("unique_id")));
        structValue.setField("children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.children, this._getType().getField("children")));
        structValue.setField("marked_for_delete",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markedForDelete, this._getType().getField("marked_for_delete")));
        structValue.setField("overridden",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overridden, this._getType().getField("overridden")));
        structValue.setField("analytics_policy",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.analyticsPolicy, this._getType().getField("analytics_policy")));
        structValue.setField("analytics_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.analyticsProfilePath, this._getType().getField("analytics_profile_path")));
        structValue.setField("apic_epg_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.apicEpgName, this._getType().getField("apic_epg_name")));
        structValue.setField("application_persistence_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.applicationPersistenceProfilePath, this._getType().getField("application_persistence_profile_path")));
        structValue.setField("autoscale_launch_config_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoscaleLaunchConfigPath, this._getType().getField("autoscale_launch_config_path")));
        structValue.setField("autoscale_networks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoscaleNetworks, this._getType().getField("autoscale_networks")));
        structValue.setField("autoscale_policy_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.autoscalePolicyPath, this._getType().getField("autoscale_policy_path")));
        structValue.setField("capacity_estimation",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capacityEstimation, this._getType().getField("capacity_estimation")));
        structValue.setField("capacity_estimation_ttfb_thresh",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capacityEstimationTtfbThresh, this._getType().getField("capacity_estimation_ttfb_thresh")));
        structValue.setField("cloud_config_cksum",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cloudConfigCksum, this._getType().getField("cloud_config_cksum")));
        structValue.setField("cloud_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cloudName, this._getType().getField("cloud_name")));
        structValue.setField("conn_pool_properties",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connPoolProperties, this._getType().getField("conn_pool_properties")));
        structValue.setField("connection_ramp_duration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionRampDuration, this._getType().getField("connection_ramp_duration")));
        structValue.setField("created_by",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createdBy, this._getType().getField("created_by")));
        structValue.setField("default_server_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultServerPort, this._getType().getField("default_server_port")));
        structValue.setField("delete_server_on_dns_refresh",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deleteServerOnDnsRefresh, this._getType().getField("delete_server_on_dns_refresh")));
        structValue.setField("domain_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.domainName, this._getType().getField("domain_name")));
        structValue.setField("east_west",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.eastWest, this._getType().getField("east_west")));
        structValue.setField("enable_http2",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableHttp2, this._getType().getField("enable_http2")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("external_autoscale_groups",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.externalAutoscaleGroups, this._getType().getField("external_autoscale_groups")));
        structValue.setField("fail_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.failAction, this._getType().getField("fail_action")));
        structValue.setField("fewest_tasks_feedback_delay",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fewestTasksFeedbackDelay, this._getType().getField("fewest_tasks_feedback_delay")));
        structValue.setField("graceful_disable_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gracefulDisableTimeout, this._getType().getField("graceful_disable_timeout")));
        structValue.setField("group_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupPaths, this._getType().getField("group_paths")));
        structValue.setField("gslb_sp_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gslbSpEnabled, this._getType().getField("gslb_sp_enabled")));
        structValue.setField("health_monitor_paths",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.healthMonitorPaths, this._getType().getField("health_monitor_paths")));
        structValue.setField("host_check_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostCheckEnabled, this._getType().getField("host_check_enabled")));
        structValue.setField("ignore_server_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ignoreServerPort, this._getType().getField("ignore_server_port")));
        structValue.setField("inline_health_monitor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.inlineHealthMonitor, this._getType().getField("inline_health_monitor")));
        structValue.setField("ipaddrgroup_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipaddrgroupPath, this._getType().getField("ipaddrgroup_path")));
        structValue.setField("lb_algorithm",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lbAlgorithm, this._getType().getField("lb_algorithm")));
        structValue.setField("lb_algorithm_consistent_hash_hdr",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lbAlgorithmConsistentHashHdr, this._getType().getField("lb_algorithm_consistent_hash_hdr")));
        structValue.setField("lb_algorithm_core_nonaffinity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lbAlgorithmCoreNonaffinity, this._getType().getField("lb_algorithm_core_nonaffinity")));
        structValue.setField("lb_algorithm_hash",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lbAlgorithmHash, this._getType().getField("lb_algorithm_hash")));
        structValue.setField("lookup_server_by_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lookupServerByName, this._getType().getField("lookup_server_by_name")));
        structValue.setField("markers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markers, this._getType().getField("markers")));
        structValue.setField("max_concurrent_connections_per_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxConcurrentConnectionsPerServer, this._getType().getField("max_concurrent_connections_per_server")));
        structValue.setField("max_conn_rate_per_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxConnRatePerServer, this._getType().getField("max_conn_rate_per_server")));
        structValue.setField("min_health_monitors_up",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minHealthMonitorsUp, this._getType().getField("min_health_monitors_up")));
        structValue.setField("min_servers_up",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minServersUp, this._getType().getField("min_servers_up")));
        structValue.setField("networks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.networks, this._getType().getField("networks")));
        structValue.setField("pki_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pkiProfilePath, this._getType().getField("pki_profile_path")));
        structValue.setField("placement_networks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.placementNetworks, this._getType().getField("placement_networks")));
        structValue.setField("request_queue_depth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestQueueDepth, this._getType().getField("request_queue_depth")));
        structValue.setField("request_queue_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestQueueEnabled, this._getType().getField("request_queue_enabled")));
        structValue.setField("rewrite_host_header_to_server_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rewriteHostHeaderToServerName, this._getType().getField("rewrite_host_header_to_server_name")));
        structValue.setField("rewrite_host_header_to_sni",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rewriteHostHeaderToSni, this._getType().getField("rewrite_host_header_to_sni")));
        structValue.setField("routing_pool",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.routingPool, this._getType().getField("routing_pool")));
        structValue.setField("server_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverName, this._getType().getField("server_name")));
        structValue.setField("server_reselect",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverReselect, this._getType().getField("server_reselect")));
        structValue.setField("server_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverTimeout, this._getType().getField("server_timeout")));
        structValue.setField("servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.servers, this._getType().getField("servers")));
        structValue.setField("service_metadata",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceMetadata, this._getType().getField("service_metadata")));
        structValue.setField("sni_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sniEnabled, this._getType().getField("sni_enabled")));
        structValue.setField("ssl_key_and_certificate_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslKeyAndCertificatePath, this._getType().getField("ssl_key_and_certificate_path")));
        structValue.setField("ssl_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslProfilePath, this._getType().getField("ssl_profile_path")));
        structValue.setField("tier1_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tier1Path, this._getType().getField("tier1_path")));
        structValue.setField("use_service_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.useServicePort, this._getType().getField("use_service_port")));
        structValue.setField("vrf_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vrfName, this._getType().getField("vrf_name")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPool;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPool.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBPool _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBPool(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBPool _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBPool(structValue);
    }

    /**
     * Builder class for {@link ALBPool}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_global_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;
        private java.lang.String originSiteId;
        private java.lang.String ownerId;
        private java.lang.String parentPath;
        private java.lang.String path;
        private java.lang.String realizationId;
        private java.lang.String relativePath;
        private java.lang.String remotePath;
        private java.lang.String uniqueId;
        private java.util.List<com.vmware.vapi.bindings.Structure> children;
        private java.lang.Boolean markedForDelete;
        private java.lang.Boolean overridden;
        private com.vmware.nsx_global_policy.model.ALBPoolAnalyticsPolicy analyticsPolicy;
        private java.lang.String analyticsProfilePath;
        private java.lang.String apicEpgName;
        private java.lang.String applicationPersistenceProfilePath;
        private java.lang.String autoscaleLaunchConfigPath;
        private java.util.List<java.lang.String> autoscaleNetworks;
        private java.lang.String autoscalePolicyPath;
        private java.lang.Boolean capacityEstimation;
        private java.lang.Long capacityEstimationTtfbThresh;
        private java.lang.String cloudConfigCksum;
        private java.lang.String cloudName;
        private com.vmware.nsx_global_policy.model.ALBConnPoolProperties connPoolProperties;
        private java.lang.Long connectionRampDuration;
        private java.lang.String createdBy;
        private java.lang.Long defaultServerPort;
        private java.lang.Boolean deleteServerOnDnsRefresh;
        private java.util.List<java.lang.String> domainName;
        private java.lang.Boolean eastWest;
        private java.lang.Boolean enableHttp2;
        private java.lang.Boolean enabled;
        private java.util.List<java.lang.String> externalAutoscaleGroups;
        private com.vmware.nsx_global_policy.model.ALBFailAction failAction;
        private java.lang.Long fewestTasksFeedbackDelay;
        private java.lang.Long gracefulDisableTimeout;
        private java.util.List<java.lang.String> groupPaths;
        private java.lang.Boolean gslbSpEnabled;
        private java.util.List<java.lang.String> healthMonitorPaths;
        private java.lang.Boolean hostCheckEnabled;
        private java.lang.Boolean ignoreServerPort;
        private java.lang.Boolean inlineHealthMonitor;
        private java.lang.String ipaddrgroupPath;
        private java.lang.String lbAlgorithm;
        private java.lang.String lbAlgorithmConsistentHashHdr;
        private java.lang.Long lbAlgorithmCoreNonaffinity;
        private java.lang.String lbAlgorithmHash;
        private java.lang.Boolean lookupServerByName;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers;
        private java.lang.Long maxConcurrentConnectionsPerServer;
        private com.vmware.nsx_global_policy.model.ALBRateProfile maxConnRatePerServer;
        private java.lang.Long minHealthMonitorsUp;
        private java.lang.Long minServersUp;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBNetworkFilter> networks;
        private java.lang.String pkiProfilePath;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBPlacementNetwork> placementNetworks;
        private java.lang.Long requestQueueDepth;
        private java.lang.Boolean requestQueueEnabled;
        private java.lang.Boolean rewriteHostHeaderToServerName;
        private java.lang.Boolean rewriteHostHeaderToSni;
        private java.lang.Boolean routingPool;
        private java.lang.String serverName;
        private com.vmware.nsx_global_policy.model.ALBHTTPServerReselect serverReselect;
        private java.lang.Long serverTimeout;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBServer> servers;
        private java.lang.String serviceMetadata;
        private java.lang.Boolean sniEnabled;
        private java.lang.String sslKeyAndCertificatePath;
        private java.lang.String sslProfilePath;
        private java.lang.String tier1Path;
        private java.lang.Boolean useServicePort;
        private java.lang.String vrfName;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBPool}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing which site owns an object.
         * This is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originSiteId New value for the property.
         */
        public Builder setOriginSiteId(java.lang.String originSiteId) {
            this.originSiteId = originSiteId;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing whoes owns this object. This
         * is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ownerId New value for the property.
         */
        public Builder setOwnerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Path of its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param parentPath New value for the property.
         */
        public Builder setParentPath(java.lang.String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        /**
         * Absolute path of this object
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param path New value for the property.
         */
        public Builder setPath(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * This is a UUID generated by the system for realizing the entity object. In most
         * cases this should be same as 'unique_id' of the entity. However, in some cases
         * this can be different because of entities have migrated thier unique identifier
         * to NSX Policy intent objects later in the timeline and did not use unique_id for
         * realization. Realization id is helpful for users to debug data path to correlate
         * the configuration with corresponding intent.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param realizationId New value for the property.
         */
        public Builder setRealizationId(java.lang.String realizationId) {
            this.realizationId = realizationId;
            return this;
        }

        /**
         * Path relative from its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param relativePath New value for the property.
         */
        public Builder setRelativePath(java.lang.String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        /**
         * This is the path of the object on the local managers when queried on the PMaaS
         * service, and path of the object on PMaaS service when queried from the local
         * managers.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePath New value for the property.
         */
        public Builder setRemotePath(java.lang.String remotePath) {
            this.remotePath = remotePath;
            return this;
        }

        /**
         * This is a UUID generated by the GM/LM to uniquely identify entites in a
         * federated environment. For entities that are stretched across multiple sites,
         * the same ID will be used on all the stretched sites.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param uniqueId New value for the property.
         */
        public Builder setUniqueId(java.lang.String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        /**
         * Subtree for this type within policy tree containing nested elements. Note that
         * this type is applicable to be used in Hierarchical API only.
         *
         * @param children New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
         * return a value of this class as a return value, the property will contain all
         * the properties defined in {@link
         * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
         */
        public Builder setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
            this.children = children;
            return this;
        }

        /**
         * Intent objects are not directly deleted from the system when a delete is invoked
         * on them. They are marked for deletion and only when all the realized entities
         * for that intent object gets deleted, the intent object is deleted. Objects that
         * are marked for deletion are not returned in GET call. One can use the search API
         * to get these objects.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param markedForDelete New value for the property.
         */
        public Builder setMarkedForDelete(java.lang.Boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
            return this;
        }

        /**
         * Global intent objects cannot be modified by the user. However, certain global
         * intent objects can be overridden locally by use of this property. In such cases,
         * the overridden local values take precedence over the globally defined values for
         * the properties.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overridden New value for the property.
         */
        public Builder setOverridden(java.lang.Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        /**
         *
         *
         * @param analyticsPolicy New value for the property.
         */
        public Builder setAnalyticsPolicy(com.vmware.nsx_global_policy.model.ALBPoolAnalyticsPolicy analyticsPolicy) {
            this.analyticsPolicy = analyticsPolicy;
            return this;
        }

        /**
         * Specifies settings related to analytics. It is a reference to an object of type
         * AnalyticsProfile.
         *
         * @param analyticsProfilePath New value for the property.
         */
        public Builder setAnalyticsProfilePath(java.lang.String analyticsProfilePath) {
            this.analyticsProfilePath = analyticsProfilePath;
            return this;
        }

        /**
         * Synchronize Cisco APIC EPG members with pool servers.
         *
         * @param apicEpgName New value for the property.
         */
        public Builder setApicEpgName(java.lang.String apicEpgName) {
            this.apicEpgName = apicEpgName;
            return this;
        }

        /**
         * Persistence will ensure the same user sticks to the same server for a desired
         * duration of time. It is a reference to an object of type
         * ApplicationPersistenceProfile.
         *
         * @param applicationPersistenceProfilePath New value for the property.
         */
        public Builder setApplicationPersistenceProfilePath(java.lang.String applicationPersistenceProfilePath) {
            this.applicationPersistenceProfilePath = applicationPersistenceProfilePath;
            return this;
        }

        /**
         * If configured then Avi will trigger orchestration of pool server creation and
         * deletion. It is a reference to an object of type AutoScaleLaunchConfig.
         *
         * @param autoscaleLaunchConfigPath New value for the property.
         */
        public Builder setAutoscaleLaunchConfigPath(java.lang.String autoscaleLaunchConfigPath) {
            this.autoscaleLaunchConfigPath = autoscaleLaunchConfigPath;
            return this;
        }

        /**
         * Network Ids for the launch configuration.
         *
         * @param autoscaleNetworks New value for the property.
         */
        public Builder setAutoscaleNetworks(java.util.List<java.lang.String> autoscaleNetworks) {
            this.autoscaleNetworks = autoscaleNetworks;
            return this;
        }

        /**
         * Reference to Server Autoscale Policy. It is a reference to an object of type
         * ServerAutoScalePolicy.
         *
         * @param autoscalePolicyPath New value for the property.
         */
        public Builder setAutoscalePolicyPath(java.lang.String autoscalePolicyPath) {
            this.autoscalePolicyPath = autoscalePolicyPath;
            return this;
        }

        /**
         * Inline estimation of capacity of servers. Allowed in Basic(Allowed values-
         * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param capacityEstimation New value for the property.
         */
        public Builder setCapacityEstimation(java.lang.Boolean capacityEstimation) {
            this.capacityEstimation = capacityEstimation;
            return this;
        }

        /**
         * The maximum time-to-first-byte of a server. Allowed values are 1-5000. Special
         * values are 0 - 'Automatic'. Unit is MILLISECONDS. Allowed in Basic(Allowed
         * values- 0) edition, Essentials(Allowed values- 0) edition, Enterprise edition.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 0. format: int64
         *
         * @param capacityEstimationTtfbThresh New value for the property.
         */
        public Builder setCapacityEstimationTtfbThresh(java.lang.Long capacityEstimationTtfbThresh) {
            this.capacityEstimationTtfbThresh = capacityEstimationTtfbThresh;
            return this;
        }

        /**
         * Checksum of cloud configuration for Pool. Internally set by cloud connector.
         *
         * @param cloudConfigCksum New value for the property.
         */
        public Builder setCloudConfigCksum(java.lang.String cloudConfigCksum) {
            this.cloudConfigCksum = cloudConfigCksum;
            return this;
        }

        /**
         * It is a reference to an object of type Cloud.
         *
         * @param cloudName New value for the property.
         */
        public Builder setCloudName(java.lang.String cloudName) {
            this.cloudName = cloudName;
            return this;
        }

        /**
         *
         *
         * @param connPoolProperties New value for the property.
         */
        public Builder setConnPoolProperties(com.vmware.nsx_global_policy.model.ALBConnPoolProperties connPoolProperties) {
            this.connPoolProperties = connPoolProperties;
            return this;
        }

        /**
         * Duration for which new connections will be gradually ramped up to a server
         * recently brought online. Useful for LB algorithms that are least connection
         * based. Allowed values are 1-300. Special values are 0 - 'Immediate'. Unit is
         * MIN. Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed values- 0)
         * edition, Enterprise edition. Special default for Basic edition is 0, Essentials
         * edition is 0, Enterprise is 10. Default value when not specified in API or
         * module is interpreted by ALB Controller as 0. format: int64
         *
         * @param connectionRampDuration New value for the property.
         */
        public Builder setConnectionRampDuration(java.lang.Long connectionRampDuration) {
            this.connectionRampDuration = connectionRampDuration;
            return this;
        }

        /**
         * Creator name.
         *
         * @param createdBy New value for the property.
         */
        public Builder setCreatedBy(java.lang.String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Traffic sent to servers will use this destination server port unless overridden
         * by the server's specific port attribute. The SSL checkbox enables Avi to server
         * encryption. Allowed values are 1-65535. Default value when not specified in API
         * or module is interpreted by ALB Controller as 80. format: int64
         *
         * @param defaultServerPort New value for the property.
         */
        public Builder setDefaultServerPort(java.lang.Long defaultServerPort) {
            this.defaultServerPort = defaultServerPort;
            return this;
        }

        /**
         * Indicates whether existing IPs are disabled(false) or deleted(true) on dns
         * hostname refreshDetail -- On a dns refresh, some IPs set on pool may no longer
         * be returned by the resolver. These IPs are deleted from the pool when this knob
         * is set to true. They are disabled, if the knob is set to false. Allowed in
         * Basic(Allowed values- true) edition, Essentials(Allowed values- true) edition,
         * Enterprise edition. Default value when not specified in API or module is
         * interpreted by ALB Controller as true.
         *
         * @param deleteServerOnDnsRefresh New value for the property.
         */
        public Builder setDeleteServerOnDnsRefresh(java.lang.Boolean deleteServerOnDnsRefresh) {
            this.deleteServerOnDnsRefresh = deleteServerOnDnsRefresh;
            return this;
        }

        /**
         * Comma separated list of domain names which will be used to verify the common
         * names or subject alternative names presented by server certificates. It is
         * performed only when common name check host_check_enabled is enabled.
         *
         * @param domainName New value for the property.
         */
        public Builder setDomainName(java.util.List<java.lang.String> domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Inherited config from VirtualService.
         *
         * @param eastWest New value for the property.
         */
        public Builder setEastWest(java.lang.Boolean eastWest) {
            this.eastWest = eastWest;
            return this;
        }

        /**
         * Enable HTTP/2 for traffic from VirtualService to all backend servers in this
         * pool. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
         * values- false) edition, Enterprise edition. Default value when not specified in
         * API or module is interpreted by ALB Controller as false.
         *
         * @param enableHttp2 New value for the property.
         */
        public Builder setEnableHttp2(java.lang.Boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return this;
        }

        /**
         * Enable or disable the pool. Disabling will terminate all open connections and
         * pause health monitors. Default value when not specified in API or module is
         * interpreted by ALB Controller as true.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Names of external auto-scale groups for pool servers. Currently available only
         * for AWS and Azure.
         *
         * @param externalAutoscaleGroups New value for the property.
         */
        public Builder setExternalAutoscaleGroups(java.util.List<java.lang.String> externalAutoscaleGroups) {
            this.externalAutoscaleGroups = externalAutoscaleGroups;
            return this;
        }

        /**
         *
         *
         * @param failAction New value for the property.
         */
        public Builder setFailAction(com.vmware.nsx_global_policy.model.ALBFailAction failAction) {
            this.failAction = failAction;
            return this;
        }

        /**
         * Periodicity of feedback for fewest tasks server selection algorithm. Allowed
         * values are 1-300. Unit is SEC. Default value when not specified in API or module
         * is interpreted by ALB Controller as 10. format: int64
         *
         * @param fewestTasksFeedbackDelay New value for the property.
         */
        public Builder setFewestTasksFeedbackDelay(java.lang.Long fewestTasksFeedbackDelay) {
            this.fewestTasksFeedbackDelay = fewestTasksFeedbackDelay;
            return this;
        }

        /**
         * Used to gracefully disable a server. Virtual service waits for the specified
         * time before terminating the existing connections to the servers that are
         * disabled. Allowed values are 1-7200. Special values are 0 - 'Immediate', -1 -
         * 'Infinite'. Unit is MIN. Default value when not specified in API or module is
         * interpreted by ALB Controller as 1. format: int64
         *
         * @param gracefulDisableTimeout New value for the property.
         */
        public Builder setGracefulDisableTimeout(java.lang.Long gracefulDisableTimeout) {
            this.gracefulDisableTimeout = gracefulDisableTimeout;
            return this;
        }

        /**
         * A list of NSX Groups where the Servers for the Pool are created .
         *
         * @param groupPaths New value for the property.
         */
        public Builder setGroupPaths(java.util.List<java.lang.String> groupPaths) {
            this.groupPaths = groupPaths;
            return this;
        }

        /**
         * Indicates if the pool is a site-persistence pool. Allowed in Basic edition,
         * Essentials edition, Enterprise edition.
         *
         * @param gslbSpEnabled New value for the property.
         */
        public Builder setGslbSpEnabled(java.lang.Boolean gslbSpEnabled) {
            this.gslbSpEnabled = gslbSpEnabled;
            return this;
        }

        /**
         * Verify server health by applying one or more health monitors. Active monitors
         * generate synthetic traffic from each Service Engine and mark a server up or down
         * based on the response. The Passive monitor listens only to client to server
         * communication. It raises or lowers the ratio of traffic destined to a server
         * based on successful responses. It is a reference to an object of type
         * HealthMonitor. Maximum of 50 items allowed.
         *
         * @param healthMonitorPaths New value for the property.
         */
        public Builder setHealthMonitorPaths(java.util.List<java.lang.String> healthMonitorPaths) {
            this.healthMonitorPaths = healthMonitorPaths;
            return this;
        }

        /**
         * Enable common name check for server certificate. If enabled and no explicit
         * domain name is specified, Avi will use the incoming host header to do the match.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param hostCheckEnabled New value for the property.
         */
        public Builder setHostCheckEnabled(java.lang.Boolean hostCheckEnabled) {
            this.hostCheckEnabled = hostCheckEnabled;
            return this;
        }

        /**
         * Ignore the server port in building the load balancing state.Applicable only for
         * consistent hash load balancing algorithm or Disable Port translation
         * (use_service_port) use cases. Default value when not specified in API or module
         * is interpreted by ALB Controller as false.
         *
         * @param ignoreServerPort New value for the property.
         */
        public Builder setIgnoreServerPort(java.lang.Boolean ignoreServerPort) {
            this.ignoreServerPort = ignoreServerPort;
            return this;
        }

        /**
         * The Passive monitor will monitor client to server connections and requests and
         * adjust traffic load to servers based on successful responses. This may alter the
         * expected behavior of the LB method, such as Round Robin. Default value when not
         * specified in API or module is interpreted by ALB Controller as true.
         *
         * @param inlineHealthMonitor New value for the property.
         */
        public Builder setInlineHealthMonitor(java.lang.Boolean inlineHealthMonitor) {
            this.inlineHealthMonitor = inlineHealthMonitor;
            return this;
        }

        /**
         * Use list of servers from Ip Address Group. It is a reference to an object of
         * type IpAddrGroup.
         *
         * @param ipaddrgroupPath New value for the property.
         */
        public Builder setIpaddrgroupPath(java.lang.String ipaddrgroupPath) {
            this.ipaddrgroupPath = ipaddrgroupPath;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_LEAST_CONNECTIONS}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_ROUND_ROBIN}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FASTEST_RESPONSE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_CONSISTENT_HASH}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_LEAST_LOAD}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FEWEST_SERVERS}</li>
         * <li> {@link com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_RANDOM}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_FEWEST_TASKS}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_NEAREST_SERVER}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_CORE_AFFINITY}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_TOPOLOGY}</li>
         * </ul> The load balancing algorithm will pick a server within the pool's list of
         * available servers. Values LB_ALGORITHM_NEAREST_SERVER and LB_ALGORITHM_TOPOLOGY
         * are only allowed for GSLB pool. Enum options - LB_ALGORITHM_LEAST_CONNECTIONS,
         * LB_ALGORITHM_ROUND_ROBIN, LB_ALGORITHM_FASTEST_RESPONSE,
         * LB_ALGORITHM_CONSISTENT_HASH, LB_ALGORITHM_LEAST_LOAD,
         * LB_ALGORITHM_FEWEST_SERVERS, LB_ALGORITHM_RANDOM, LB_ALGORITHM_FEWEST_TASKS,
         * LB_ALGORITHM_NEAREST_SERVER, LB_ALGORITHM_CORE_AFFINITY, LB_ALGORITHM_TOPOLOGY.
         * Allowed in Basic(Allowed values-
         * LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
         * edition, Essentials(Allowed values-
         * LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
         * edition, Enterprise edition. Default value when not specified in API or module
         * is interpreted by ALB Controller as LB_ALGORITHM_LEAST_CONNECTIONS.
         *
         * @param lbAlgorithm New value for the property.
         */
        public Builder setLbAlgorithm(java.lang.String lbAlgorithm) {
            this.lbAlgorithm = lbAlgorithm;
            return this;
        }

        /**
         * HTTP header name to be used for the hash key.
         *
         * @param lbAlgorithmConsistentHashHdr New value for the property.
         */
        public Builder setLbAlgorithmConsistentHashHdr(java.lang.String lbAlgorithmConsistentHashHdr) {
            this.lbAlgorithmConsistentHashHdr = lbAlgorithmConsistentHashHdr;
            return this;
        }

        /**
         * Degree of non-affinity for core affinity based server selection. Allowed values
         * are 1-65535. Allowed in Basic(Allowed values- 2) edition, Essentials(Allowed
         * values- 2) edition, Enterprise edition. Default value when not specified in API
         * or module is interpreted by ALB Controller as 2. format: int64
         *
         * @param lbAlgorithmCoreNonaffinity New value for the property.
         */
        public Builder setLbAlgorithmCoreNonaffinity(java.lang.Long lbAlgorithmCoreNonaffinity) {
            this.lbAlgorithmCoreNonaffinity = lbAlgorithmCoreNonaffinity;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS_AND_PORT}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_URI}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CUSTOM_HEADER}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CUSTOM_STRING}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBPool#LB_ALGORITHM_HASH_CALLID}</li> </ul>
         * Criteria used as a key for determining the hash between the client and server.
         * Enum options - LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS,
         * LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS_AND_PORT,
         * LB_ALGORITHM_CONSISTENT_HASH_URI, LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_HEADER,
         * LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_STRING, LB_ALGORITHM_CONSISTENT_HASH_CALLID.
         * Allowed in Basic(Allowed values- LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS)
         * edition, Essentials(Allowed values-
         * LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS) edition, Enterprise edition.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS.
         *
         * @param lbAlgorithmHash New value for the property.
         */
        public Builder setLbAlgorithmHash(java.lang.String lbAlgorithmHash) {
            this.lbAlgorithmHash = lbAlgorithmHash;
            return this;
        }

        /**
         * Allow server lookup by name. Allowed in Basic(Allowed values- false) edition,
         * Essentials(Allowed values- false) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param lookupServerByName New value for the property.
         */
        public Builder setLookupServerByName(java.lang.Boolean lookupServerByName) {
            this.lookupServerByName = lookupServerByName;
            return this;
        }

        /**
         * List of labels to be used for granular RBAC. Allowed in Basic edition,
         * Essentials edition, Enterprise edition.
         *
         * @param markers New value for the property.
         */
        public Builder setMarkers(java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers) {
            this.markers = markers;
            return this;
        }

        /**
         * The maximum number of concurrent connections allowed to each server within the
         * pool. NOTE applied value will be no less than the number of service engines that
         * the pool is placed on. If set to 0, no limit is applied. Default value when not
         * specified in API or module is interpreted by ALB Controller as 0. format: int64
         *
         * @param maxConcurrentConnectionsPerServer New value for the property.
         */
        public Builder setMaxConcurrentConnectionsPerServer(java.lang.Long maxConcurrentConnectionsPerServer) {
            this.maxConcurrentConnectionsPerServer = maxConcurrentConnectionsPerServer;
            return this;
        }

        /**
         *
         *
         * @param maxConnRatePerServer New value for the property.
         */
        public Builder setMaxConnRatePerServer(com.vmware.nsx_global_policy.model.ALBRateProfile maxConnRatePerServer) {
            this.maxConnRatePerServer = maxConnRatePerServer;
            return this;
        }

        /**
         * Minimum number of health monitors in UP state to mark server UP. Allowed in
         * Basic edition, Essentials edition, Enterprise edition. format: int64
         *
         * @param minHealthMonitorsUp New value for the property.
         */
        public Builder setMinHealthMonitorsUp(java.lang.Long minHealthMonitorsUp) {
            this.minHealthMonitorsUp = minHealthMonitorsUp;
            return this;
        }

        /**
         * Minimum number of servers in UP state for marking the pool UP. format: int64
         *
         * @param minServersUp New value for the property.
         */
        public Builder setMinServersUp(java.lang.Long minServersUp) {
            this.minServersUp = minServersUp;
            return this;
        }

        /**
         * (internal-use) Networks designated as containing servers for this pool. The
         * servers may be further narrowed down by a filter. This field is used internally
         * by Avi, not editable by the user.
         *
         * @param networks New value for the property.
         */
        public Builder setNetworks(java.util.List<com.vmware.nsx_global_policy.model.ALBNetworkFilter> networks) {
            this.networks = networks;
            return this;
        }

        /**
         * Avi will validate the SSL certificate present by a server against the selected
         * PKI Profile. It is a reference to an object of type PKIProfile.
         *
         * @param pkiProfilePath New value for the property.
         */
        public Builder setPkiProfilePath(java.lang.String pkiProfilePath) {
            this.pkiProfilePath = pkiProfilePath;
            return this;
        }

        /**
         * Manually select the networks and subnets used to provide reachability to the
         * pool's servers. Specify the Subnet using the following syntax 10-1-1-0/24. Use
         * static routes in VRF configuration when pool servers are not directly connected
         * but routable from the service engine.
         *
         * @param placementNetworks New value for the property.
         */
        public Builder setPlacementNetworks(java.util.List<com.vmware.nsx_global_policy.model.ALBPlacementNetwork> placementNetworks) {
            this.placementNetworks = placementNetworks;
            return this;
        }

        /**
         * Minimum number of requests to be queued when pool is full. Allowed in
         * Basic(Allowed values- 128) edition, Essentials(Allowed values- 128) edition,
         * Enterprise edition. Default value when not specified in API or module is
         * interpreted by ALB Controller as 128. format: int64
         *
         * @param requestQueueDepth New value for the property.
         */
        public Builder setRequestQueueDepth(java.lang.Long requestQueueDepth) {
            this.requestQueueDepth = requestQueueDepth;
            return this;
        }

        /**
         * Enable request queue when pool is full. Allowed in Basic(Allowed values- false)
         * edition, Essentials(Allowed values- false) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as
         * false.
         *
         * @param requestQueueEnabled New value for the property.
         */
        public Builder setRequestQueueEnabled(java.lang.Boolean requestQueueEnabled) {
            this.requestQueueEnabled = requestQueueEnabled;
            return this;
        }

        /**
         * Rewrite incoming Host Header to server name of the server to which the request
         * is proxied. Enabling this feature rewrites Host Header for requests to all
         * servers in the pool. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param rewriteHostHeaderToServerName New value for the property.
         */
        public Builder setRewriteHostHeaderToServerName(java.lang.Boolean rewriteHostHeaderToServerName) {
            this.rewriteHostHeaderToServerName = rewriteHostHeaderToServerName;
            return this;
        }

        /**
         * If SNI server name is specified, rewrite incoming host header to the SNI server
         * name. Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param rewriteHostHeaderToSni New value for the property.
         */
        public Builder setRewriteHostHeaderToSni(java.lang.Boolean rewriteHostHeaderToSni) {
            this.rewriteHostHeaderToSni = rewriteHostHeaderToSni;
            return this;
        }

        /**
         * Enable to do routing when this pool is selected to send traffic. No servers
         * present in routing pool. Default value when not specified in API or module is
         * interpreted by ALB Controller as false.
         *
         * @param routingPool New value for the property.
         */
        public Builder setRoutingPool(java.lang.Boolean routingPool) {
            this.routingPool = routingPool;
            return this;
        }

        /**
         * Fully qualified DNS hostname which will be used in the TLS SNI extension in
         * server connections if SNI is enabled. If no value is specified, Avi will use the
         * incoming host header instead.
         *
         * @param serverName New value for the property.
         */
        public Builder setServerName(java.lang.String serverName) {
            this.serverName = serverName;
            return this;
        }

        /**
         *
         *
         * @param serverReselect New value for the property.
         */
        public Builder setServerReselect(com.vmware.nsx_global_policy.model.ALBHTTPServerReselect serverReselect) {
            this.serverReselect = serverReselect;
            return this;
        }

        /**
         * Server timeout value specifies the time within which a server connection needs
         * to be established and a request-response exchange completes between AVI and the
         * server. Value of 0 results in using default timeout of 60 minutes. Allowed
         * values are 0-21600000. Unit is MILLISECONDS. Default value when not specified in
         * API or module is interpreted by ALB Controller as 0. format: int64
         *
         * @param serverTimeout New value for the property.
         */
        public Builder setServerTimeout(java.lang.Long serverTimeout) {
            this.serverTimeout = serverTimeout;
            return this;
        }

        /**
         * The pool directs load balanced traffic to this list of destination servers. The
         * servers can be configured by IP address, name, network or via IP Address Group.
         * Maximum of 5000 items allowed.
         *
         * @param servers New value for the property.
         */
        public Builder setServers(java.util.List<com.vmware.nsx_global_policy.model.ALBServer> servers) {
            this.servers = servers;
            return this;
        }

        /**
         * Metadata pertaining to the service provided by this Pool. In
         * Openshift/Kubernetes environments, app metadata info is stored. Any user input
         * to this field will be overwritten by Avi Vantage.
         *
         * @param serviceMetadata New value for the property.
         */
        public Builder setServiceMetadata(java.lang.String serviceMetadata) {
            this.serviceMetadata = serviceMetadata;
            return this;
        }

        /**
         * Enable TLS SNI for server connections. If disabled, Avi will not send the SNI
         * extension as part of the handshake. Default value when not specified in API or
         * module is interpreted by ALB Controller as true.
         *
         * @param sniEnabled New value for the property.
         */
        public Builder setSniEnabled(java.lang.Boolean sniEnabled) {
            this.sniEnabled = sniEnabled;
            return this;
        }

        /**
         * Service Engines will present a client SSL certificate to the server. It is a
         * reference to an object of type SSLKeyAndCertificate.
         *
         * @param sslKeyAndCertificatePath New value for the property.
         */
        public Builder setSslKeyAndCertificatePath(java.lang.String sslKeyAndCertificatePath) {
            this.sslKeyAndCertificatePath = sslKeyAndCertificatePath;
            return this;
        }

        /**
         * When enabled, Avi re-encrypts traffic to the backend servers. The specific SSL
         * profile defines which ciphers and SSL versions will be supported. It is a
         * reference to an object of type SSLProfile.
         *
         * @param sslProfilePath New value for the property.
         */
        public Builder setSslProfilePath(java.lang.String sslProfilePath) {
            this.sslProfilePath = sslProfilePath;
            return this;
        }

        /**
         * This tier1_lr field should be set same as VirtualService associated for NSX-T.
         *
         * @param tier1Path New value for the property.
         */
        public Builder setTier1Path(java.lang.String tier1Path) {
            this.tier1Path = tier1Path;
            return this;
        }

        /**
         * Do not translate the client's destination port when sending the connection to
         * the server. The pool or servers specified service port will still be used for
         * health monitoring. Allowed in Basic(Allowed values- false) edition,
         * Essentials(Allowed values- false) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param useServicePort New value for the property.
         */
        public Builder setUseServicePort(java.lang.Boolean useServicePort) {
            this.useServicePort = useServicePort;
            return this;
        }

        /**
         * Virtual Routing Context that the pool is bound to. This is used to provide the
         * isolation of the set of networks the pool is attached to. The pool inherits the
         * Virtual Routing Conext of the Virtual Service, and this field is used only
         * internally, and is set by pb-transform. It is a reference to an object of type
         * VrfContext.
         *
         * @param vrfName New value for the property.
         */
        public Builder setVrfName(java.lang.String vrfName) {
            this.vrfName = vrfName;
            return this;
        }

        public ALBPool build() {
            ALBPool result = new ALBPool();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setOriginSiteId(this.originSiteId);
            result.setOwnerId(this.ownerId);
            result.setParentPath(this.parentPath);
            result.setPath(this.path);
            result.setRealizationId(this.realizationId);
            result.setRelativePath(this.relativePath);
            result.setRemotePath(this.remotePath);
            result.setUniqueId(this.uniqueId);
            result.setChildren(this.children);
            result.setMarkedForDelete(this.markedForDelete);
            result.setOverridden(this.overridden);
            result.setAnalyticsPolicy(this.analyticsPolicy);
            result.setAnalyticsProfilePath(this.analyticsProfilePath);
            result.setApicEpgName(this.apicEpgName);
            result.setApplicationPersistenceProfilePath(this.applicationPersistenceProfilePath);
            result.setAutoscaleLaunchConfigPath(this.autoscaleLaunchConfigPath);
            result.setAutoscaleNetworks(this.autoscaleNetworks);
            result.setAutoscalePolicyPath(this.autoscalePolicyPath);
            result.setCapacityEstimation(this.capacityEstimation);
            result.setCapacityEstimationTtfbThresh(this.capacityEstimationTtfbThresh);
            result.setCloudConfigCksum(this.cloudConfigCksum);
            result.setCloudName(this.cloudName);
            result.setConnPoolProperties(this.connPoolProperties);
            result.setConnectionRampDuration(this.connectionRampDuration);
            result.setCreatedBy(this.createdBy);
            result.setDefaultServerPort(this.defaultServerPort);
            result.setDeleteServerOnDnsRefresh(this.deleteServerOnDnsRefresh);
            result.setDomainName(this.domainName);
            result.setEastWest(this.eastWest);
            result.setEnableHttp2(this.enableHttp2);
            result.setEnabled(this.enabled);
            result.setExternalAutoscaleGroups(this.externalAutoscaleGroups);
            result.setFailAction(this.failAction);
            result.setFewestTasksFeedbackDelay(this.fewestTasksFeedbackDelay);
            result.setGracefulDisableTimeout(this.gracefulDisableTimeout);
            result.setGroupPaths(this.groupPaths);
            result.setGslbSpEnabled(this.gslbSpEnabled);
            result.setHealthMonitorPaths(this.healthMonitorPaths);
            result.setHostCheckEnabled(this.hostCheckEnabled);
            result.setIgnoreServerPort(this.ignoreServerPort);
            result.setInlineHealthMonitor(this.inlineHealthMonitor);
            result.setIpaddrgroupPath(this.ipaddrgroupPath);
            result.setLbAlgorithm(this.lbAlgorithm);
            result.setLbAlgorithmConsistentHashHdr(this.lbAlgorithmConsistentHashHdr);
            result.setLbAlgorithmCoreNonaffinity(this.lbAlgorithmCoreNonaffinity);
            result.setLbAlgorithmHash(this.lbAlgorithmHash);
            result.setLookupServerByName(this.lookupServerByName);
            result.setMarkers(this.markers);
            result.setMaxConcurrentConnectionsPerServer(this.maxConcurrentConnectionsPerServer);
            result.setMaxConnRatePerServer(this.maxConnRatePerServer);
            result.setMinHealthMonitorsUp(this.minHealthMonitorsUp);
            result.setMinServersUp(this.minServersUp);
            result.setNetworks(this.networks);
            result.setPkiProfilePath(this.pkiProfilePath);
            result.setPlacementNetworks(this.placementNetworks);
            result.setRequestQueueDepth(this.requestQueueDepth);
            result.setRequestQueueEnabled(this.requestQueueEnabled);
            result.setRewriteHostHeaderToServerName(this.rewriteHostHeaderToServerName);
            result.setRewriteHostHeaderToSni(this.rewriteHostHeaderToSni);
            result.setRoutingPool(this.routingPool);
            result.setServerName(this.serverName);
            result.setServerReselect(this.serverReselect);
            result.setServerTimeout(this.serverTimeout);
            result.setServers(this.servers);
            result.setServiceMetadata(this.serviceMetadata);
            result.setSniEnabled(this.sniEnabled);
            result.setSslKeyAndCertificatePath(this.sslKeyAndCertificatePath);
            result.setSslProfilePath(this.sslProfilePath);
            result.setTier1Path(this.tier1Path);
            result.setUseServicePort(this.useServicePort);
            result.setVrfName(this.vrfName);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_site_id",
                                                                                "originSiteId",
                                                                                "getOriginSiteId",
                                                                                "setOriginSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owner_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owner_id",
                                                                                "ownerId",
                                                                                "getOwnerId",
                                                                                "setOwnerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_path",
                                                                                "parentPath",
                                                                                "getParentPath",
                                                                                "setParentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path",
                                                                                "path",
                                                                                "getPath",
                                                                                "setPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realization_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realization_id",
                                                                                "realizationId",
                                                                                "getRealizationId",
                                                                                "setRealizationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("relative_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("relative_path",
                                                                                "relativePath",
                                                                                "getRelativePath",
                                                                                "setRelativePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_path",
                                                                                "remotePath",
                                                                                "getRemotePath",
                                                                                "setRemotePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unique_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unique_id",
                                                                                "uniqueId",
                                                                                "getUniqueId",
                                                                                "setUniqueId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyConfigResource; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("children",
                                                                                "children",
                                                                                "getChildren",
                                                                                "setChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("marked_for_delete", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("marked_for_delete",
                                                                                "markedForDelete",
                                                                                "getMarkedForDelete",
                                                                                "setMarkedForDelete");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overridden", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overridden",
                                                                                "overridden",
                                                                                "getOverridden",
                                                                                "setOverridden");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("analytics_policy", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPoolAnalyticsPolicy; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("analytics_policy",
                                                                                "analyticsPolicy",
                                                                                "getAnalyticsPolicy",
                                                                                "setAnalyticsPolicy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("analytics_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("analytics_profile_path",
                                                                                "analyticsProfilePath",
                                                                                "getAnalyticsProfilePath",
                                                                                "setAnalyticsProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("apic_epg_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("apic_epg_name",
                                                                                "apicEpgName",
                                                                                "getApicEpgName",
                                                                                "setApicEpgName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("application_persistence_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("application_persistence_profile_path",
                                                                                "applicationPersistenceProfilePath",
                                                                                "getApplicationPersistenceProfilePath",
                                                                                "setApplicationPersistenceProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("autoscale_launch_config_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("autoscale_launch_config_path",
                                                                                "autoscaleLaunchConfigPath",
                                                                                "getAutoscaleLaunchConfigPath",
                                                                                "setAutoscaleLaunchConfigPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("autoscale_networks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("autoscale_networks",
                                                                                "autoscaleNetworks",
                                                                                "getAutoscaleNetworks",
                                                                                "setAutoscaleNetworks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("autoscale_policy_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("autoscale_policy_path",
                                                                                "autoscalePolicyPath",
                                                                                "getAutoscalePolicyPath",
                                                                                "setAutoscalePolicyPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capacity_estimation", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capacity_estimation",
                                                                                "capacityEstimation",
                                                                                "getCapacityEstimation",
                                                                                "setCapacityEstimation");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capacity_estimation_ttfb_thresh", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capacity_estimation_ttfb_thresh",
                                                                                "capacityEstimationTtfbThresh",
                                                                                "getCapacityEstimationTtfbThresh",
                                                                                "setCapacityEstimationTtfbThresh");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cloud_config_cksum", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cloud_config_cksum",
                                                                                "cloudConfigCksum",
                                                                                "getCloudConfigCksum",
                                                                                "setCloudConfigCksum");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cloud_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cloud_name",
                                                                                "cloudName",
                                                                                "getCloudName",
                                                                                "setCloudName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("conn_pool_properties", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBConnPoolProperties; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("conn_pool_properties",
                                                                                "connPoolProperties",
                                                                                "getConnPoolProperties",
                                                                                "setConnPoolProperties");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_ramp_duration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_ramp_duration",
                                                                                "connectionRampDuration",
                                                                                "getConnectionRampDuration",
                                                                                "setConnectionRampDuration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("created_by", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("created_by",
                                                                                "createdBy",
                                                                                "getCreatedBy",
                                                                                "setCreatedBy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_server_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_server_port",
                                                                                "defaultServerPort",
                                                                                "getDefaultServerPort",
                                                                                "setDefaultServerPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("delete_server_on_dns_refresh", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("delete_server_on_dns_refresh",
                                                                                "deleteServerOnDnsRefresh",
                                                                                "getDeleteServerOnDnsRefresh",
                                                                                "setDeleteServerOnDnsRefresh");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("domain_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("domain_name",
                                                                                "domainName",
                                                                                "getDomainName",
                                                                                "setDomainName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("east_west", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("east_west",
                                                                                "eastWest",
                                                                                "getEastWest",
                                                                                "setEastWest");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_http2", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_http2",
                                                                                "enableHttp2",
                                                                                "getEnableHttp2",
                                                                                "setEnableHttp2");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("external_autoscale_groups", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("external_autoscale_groups",
                                                                                "externalAutoscaleGroups",
                                                                                "getExternalAutoscaleGroups",
                                                                                "setExternalAutoscaleGroups");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fail_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBFailAction; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fail_action",
                                                                                "failAction",
                                                                                "getFailAction",
                                                                                "setFailAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fewest_tasks_feedback_delay", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fewest_tasks_feedback_delay",
                                                                                "fewestTasksFeedbackDelay",
                                                                                "getFewestTasksFeedbackDelay",
                                                                                "setFewestTasksFeedbackDelay");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("graceful_disable_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("graceful_disable_timeout",
                                                                                "gracefulDisableTimeout",
                                                                                "getGracefulDisableTimeout",
                                                                                "setGracefulDisableTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_paths",
                                                                                "groupPaths",
                                                                                "getGroupPaths",
                                                                                "setGroupPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("gslb_sp_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("gslb_sp_enabled",
                                                                                "gslbSpEnabled",
                                                                                "getGslbSpEnabled",
                                                                                "setGslbSpEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("health_monitor_paths", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("health_monitor_paths",
                                                                                "healthMonitorPaths",
                                                                                "getHealthMonitorPaths",
                                                                                "setHealthMonitorPaths");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_check_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_check_enabled",
                                                                                "hostCheckEnabled",
                                                                                "getHostCheckEnabled",
                                                                                "setHostCheckEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ignore_server_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ignore_server_port",
                                                                                "ignoreServerPort",
                                                                                "getIgnoreServerPort",
                                                                                "setIgnoreServerPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("inline_health_monitor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inline_health_monitor",
                                                                                "inlineHealthMonitor",
                                                                                "getInlineHealthMonitor",
                                                                                "setInlineHealthMonitor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ipaddrgroup_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ipaddrgroup_path",
                                                                                "ipaddrgroupPath",
                                                                                "getIpaddrgroupPath",
                                                                                "setIpaddrgroupPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lb_algorithm", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lb_algorithm",
                                                                                "lbAlgorithm",
                                                                                "getLbAlgorithm",
                                                                                "setLbAlgorithm");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lb_algorithm_consistent_hash_hdr", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lb_algorithm_consistent_hash_hdr",
                                                                                "lbAlgorithmConsistentHashHdr",
                                                                                "getLbAlgorithmConsistentHashHdr",
                                                                                "setLbAlgorithmConsistentHashHdr");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lb_algorithm_core_nonaffinity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lb_algorithm_core_nonaffinity",
                                                                                "lbAlgorithmCoreNonaffinity",
                                                                                "getLbAlgorithmCoreNonaffinity",
                                                                                "setLbAlgorithmCoreNonaffinity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lb_algorithm_hash", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lb_algorithm_hash",
                                                                                "lbAlgorithmHash",
                                                                                "getLbAlgorithmHash",
                                                                                "setLbAlgorithmHash");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lookup_server_by_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lookup_server_by_name",
                                                                                "lookupServerByName",
                                                                                "getLookupServerByName",
                                                                                "setLookupServerByName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("markers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBRoleFilterMatchLabel; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("markers",
                                                                                "markers",
                                                                                "getMarkers",
                                                                                "setMarkers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_concurrent_connections_per_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_concurrent_connections_per_server",
                                                                                "maxConcurrentConnectionsPerServer",
                                                                                "getMaxConcurrentConnectionsPerServer",
                                                                                "setMaxConcurrentConnectionsPerServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_conn_rate_per_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBRateProfile; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_conn_rate_per_server",
                                                                                "maxConnRatePerServer",
                                                                                "getMaxConnRatePerServer",
                                                                                "setMaxConnRatePerServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_health_monitors_up", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_health_monitors_up",
                                                                                "minHealthMonitorsUp",
                                                                                "getMinHealthMonitorsUp",
                                                                                "setMinHealthMonitorsUp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_servers_up", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_servers_up",
                                                                                "minServersUp",
                                                                                "getMinServersUp",
                                                                                "setMinServersUp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("networks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBNetworkFilter; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("networks",
                                                                                "networks",
                                                                                "getNetworks",
                                                                                "setNetworks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pki_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pki_profile_path",
                                                                                "pkiProfilePath",
                                                                                "getPkiProfilePath",
                                                                                "setPkiProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("placement_networks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPlacementNetwork; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("placement_networks",
                                                                                "placementNetworks",
                                                                                "getPlacementNetworks",
                                                                                "setPlacementNetworks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_queue_depth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_queue_depth",
                                                                                "requestQueueDepth",
                                                                                "getRequestQueueDepth",
                                                                                "setRequestQueueDepth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_queue_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_queue_enabled",
                                                                                "requestQueueEnabled",
                                                                                "getRequestQueueEnabled",
                                                                                "setRequestQueueEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rewrite_host_header_to_server_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rewrite_host_header_to_server_name",
                                                                                "rewriteHostHeaderToServerName",
                                                                                "getRewriteHostHeaderToServerName",
                                                                                "setRewriteHostHeaderToServerName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rewrite_host_header_to_sni", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rewrite_host_header_to_sni",
                                                                                "rewriteHostHeaderToSni",
                                                                                "getRewriteHostHeaderToSni",
                                                                                "setRewriteHostHeaderToSni");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("routing_pool", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("routing_pool",
                                                                                "routingPool",
                                                                                "getRoutingPool",
                                                                                "setRoutingPool");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_name",
                                                                                "serverName",
                                                                                "getServerName",
                                                                                "setServerName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_reselect", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBHTTPServerReselect; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_reselect",
                                                                                "serverReselect",
                                                                                "getServerReselect",
                                                                                "setServerReselect");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_timeout",
                                                                                "serverTimeout",
                                                                                "getServerTimeout",
                                                                                "setServerTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBServer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("servers",
                                                                                "servers",
                                                                                "getServers",
                                                                                "setServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_metadata", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_metadata",
                                                                                "serviceMetadata",
                                                                                "getServiceMetadata",
                                                                                "setServiceMetadata");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sni_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sni_enabled",
                                                                                "sniEnabled",
                                                                                "getSniEnabled",
                                                                                "setSniEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_key_and_certificate_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_key_and_certificate_path",
                                                                                "sslKeyAndCertificatePath",
                                                                                "getSslKeyAndCertificatePath",
                                                                                "setSslKeyAndCertificatePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_profile_path",
                                                                                "sslProfilePath",
                                                                                "getSslProfilePath",
                                                                                "setSslProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tier1_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tier1_path",
                                                                                "tier1Path",
                                                                                "getTier1Path",
                                                                                "setTier1Path");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("use_service_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("use_service_port",
                                                                                "useServicePort",
                                                                                "getUseServicePort",
                                                                                "setUseServicePort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vrf_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vrf_name",
                                                                                "vrfName",
                                                                                "getVrfName",
                                                                                "setVrfName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_pool",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBPool.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

