/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer PoolGroup object
 */
public final class ALBPoolGroup implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_global_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;

    private java.lang.String originSiteId;

    private java.lang.String ownerId;

    private java.lang.String parentPath;

    private java.lang.String path;

    private java.lang.String realizationId;

    private java.lang.String relativePath;

    private java.lang.String remotePath;

    private java.lang.String uniqueId;

    private java.util.List<com.vmware.vapi.bindings.Structure> children;

    private java.lang.Boolean markedForDelete;

    private java.lang.Boolean overridden;

    private java.lang.String cloudConfigCksum;

    private java.lang.String cloudName;

    private java.lang.String createdBy;

    private java.lang.Boolean deactivatePrimaryPoolOnDown;

    private java.lang.String deploymentPolicyPath;

    private java.lang.Boolean enableHttp2;

    private com.vmware.nsx_global_policy.model.ALBFailAction failAction;

    private java.lang.Boolean implicitPriorityLabels;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers;

    private java.util.List<com.vmware.nsx_global_policy.model.ALBPoolGroupMember> members;

    private java.lang.Long minServers;

    private java.lang.String priorityLabelsPath;

    private java.lang.String serviceMetadata;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBPoolGroup() {
    }

    protected ALBPoolGroup(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginSiteId() {
        return this.originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originSiteId New value for the property.
     */
    public void setOriginSiteId(java.lang.String originSiteId) {
        this.originSiteId = originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnerId() {
        return this.ownerId;
    }

    /**
     * This is a UUID generated by the system for knowing whoes owns this object. This
     * is used in Pmaas
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ownerId New value for the property.
     */
    public void setOwnerId(java.lang.String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentPath() {
        return this.parentPath;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param parentPath New value for the property.
     */
    public void setParentPath(java.lang.String parentPath) {
        this.parentPath = parentPath;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPath() {
        return this.path;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param path New value for the property.
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealizationId() {
        return this.realizationId;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated thier unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param realizationId New value for the property.
     */
    public void setRealizationId(java.lang.String realizationId) {
        this.realizationId = realizationId;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param relativePath New value for the property.
     */
    public void setRelativePath(java.lang.String relativePath) {
        this.relativePath = relativePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the PMaaS
     * service, and path of the object on PMaaS service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePath New value for the property.
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUniqueId() {
        return this.uniqueId;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entites in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param uniqueId New value for the property.
     */
    public void setUniqueId(java.lang.String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getChildren() {
        return this.children;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @param children New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
     * return a value of this class as a return value, the property will contain all
     * the properties defined in {@link
     * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
     */
    public void setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
        this.children = children;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMarkedForDelete() {
        return this.markedForDelete;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param markedForDelete New value for the property.
     */
    public void setMarkedForDelete(java.lang.Boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOverridden() {
        return this.overridden;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overridden New value for the property.
     */
    public void setOverridden(java.lang.Boolean overridden) {
        this.overridden = overridden;
    }

    /**
     * Checksum of cloud configuration for PoolGroup. Internally set by cloud
     * connector.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCloudConfigCksum() {
        return this.cloudConfigCksum;
    }

    /**
     * Checksum of cloud configuration for PoolGroup. Internally set by cloud
     * connector.
     *
     * @param cloudConfigCksum New value for the property.
     */
    public void setCloudConfigCksum(java.lang.String cloudConfigCksum) {
        this.cloudConfigCksum = cloudConfigCksum;
    }

    /**
     * It is a reference to an object of type Cloud.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCloudName() {
        return this.cloudName;
    }

    /**
     * It is a reference to an object of type Cloud.
     *
     * @param cloudName New value for the property.
     */
    public void setCloudName(java.lang.String cloudName) {
        this.cloudName = cloudName;
    }

    /**
     * Name of the user who created the object.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * Name of the user who created the object.
     *
     * @param createdBy New value for the property.
     */
    public void setCreatedBy(java.lang.String createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * Deactivate primary pool for selection when down until it is activated by user
     * via clear poolgroup command. Default value when not specified in API or module
     * is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getDeactivatePrimaryPoolOnDown() {
        return this.deactivatePrimaryPoolOnDown;
    }

    /**
     * Deactivate primary pool for selection when down until it is activated by user
     * via clear poolgroup command. Default value when not specified in API or module
     * is interpreted by ALB Controller as false.
     *
     * @param deactivatePrimaryPoolOnDown New value for the property.
     */
    public void setDeactivatePrimaryPoolOnDown(java.lang.Boolean deactivatePrimaryPoolOnDown) {
        this.deactivatePrimaryPoolOnDown = deactivatePrimaryPoolOnDown;
    }

    /**
     * When setup autoscale manager will automatically promote new pools into
     * production when deployment goals are met. It is a reference to an object of type
     * PoolGroupDeploymentPolicy.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDeploymentPolicyPath() {
        return this.deploymentPolicyPath;
    }

    /**
     * When setup autoscale manager will automatically promote new pools into
     * production when deployment goals are met. It is a reference to an object of type
     * PoolGroupDeploymentPolicy.
     *
     * @param deploymentPolicyPath New value for the property.
     */
    public void setDeploymentPolicyPath(java.lang.String deploymentPolicyPath) {
        this.deploymentPolicyPath = deploymentPolicyPath;
    }

    /**
     * Enable HTTP/2 for traffic from VirtualService to all the backend servers in all
     * the pools configured under this PoolGroup. Allowed in Basic(Allowed values-
     * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableHttp2() {
        return this.enableHttp2;
    }

    /**
     * Enable HTTP/2 for traffic from VirtualService to all the backend servers in all
     * the pools configured under this PoolGroup. Allowed in Basic(Allowed values-
     * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as false.
     *
     * @param enableHttp2 New value for the property.
     */
    public void setEnableHttp2(java.lang.Boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ALBFailAction getFailAction() {
        return this.failAction;
    }

    /**
     *
     *
     * @param failAction New value for the property.
     */
    public void setFailAction(com.vmware.nsx_global_policy.model.ALBFailAction failAction) {
        this.failAction = failAction;
    }

    /**
     * Whether an implicit set of priority labels is generated. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getImplicitPriorityLabels() {
        return this.implicitPriorityLabels;
    }

    /**
     * Whether an implicit set of priority labels is generated. Default value when not
     * specified in API or module is interpreted by ALB Controller as false.
     *
     * @param implicitPriorityLabels New value for the property.
     */
    public void setImplicitPriorityLabels(java.lang.Boolean implicitPriorityLabels) {
        this.implicitPriorityLabels = implicitPriorityLabels;
    }

    /**
     * List of labels to be used for granular RBAC. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> getMarkers() {
        return this.markers;
    }

    /**
     * List of labels to be used for granular RBAC. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @param markers New value for the property.
     */
    public void setMarkers(java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers) {
        this.markers = markers;
    }

    /**
     * List of pool group members object of type PoolGroupMember.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ALBPoolGroupMember> getMembers() {
        return this.members;
    }

    /**
     * List of pool group members object of type PoolGroupMember.
     *
     * @param members New value for the property.
     */
    public void setMembers(java.util.List<com.vmware.nsx_global_policy.model.ALBPoolGroupMember> members) {
        this.members = members;
    }

    /**
     * The minimum number of servers to distribute traffic to. Allowed values are
     * 1-65535. Special values are 0 - 'Disable'. Allowed in Basic(Allowed values- 0)
     * edition, Essentials(Allowed values- 0) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMinServers() {
        return this.minServers;
    }

    /**
     * The minimum number of servers to distribute traffic to. Allowed values are
     * 1-65535. Special values are 0 - 'Disable'. Allowed in Basic(Allowed values- 0)
     * edition, Essentials(Allowed values- 0) edition, Enterprise edition. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @param minServers New value for the property.
     */
    public void setMinServers(java.lang.Long minServers) {
        this.minServers = minServers;
    }

    /**
     * path of the priority labels. If not provided, pool group member priority label
     * will be interpreted as a number with a larger number considered higher priority.
     * It is a reference to an object of type PriorityLabels.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPriorityLabelsPath() {
        return this.priorityLabelsPath;
    }

    /**
     * path of the priority labels. If not provided, pool group member priority label
     * will be interpreted as a number with a larger number considered higher priority.
     * It is a reference to an object of type PriorityLabels.
     *
     * @param priorityLabelsPath New value for the property.
     */
    public void setPriorityLabelsPath(java.lang.String priorityLabelsPath) {
        this.priorityLabelsPath = priorityLabelsPath;
    }

    /**
     * Metadata pertaining to the service provided by this PoolGroup. In
     * Openshift/Kubernetes environments, app metadata info is stored. Any user input
     * to this field will be overwritten by Avi Vantage.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceMetadata() {
        return this.serviceMetadata;
    }

    /**
     * Metadata pertaining to the service provided by this PoolGroup. In
     * Openshift/Kubernetes environments, app metadata info is stored. Any user input
     * to this field will be overwritten by Avi Vantage.
     *
     * @param serviceMetadata New value for the property.
     */
    public void setServiceMetadata(java.lang.String serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPoolGroup;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("origin_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originSiteId, this._getType().getField("origin_site_id")));
        structValue.setField("owner_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownerId, this._getType().getField("owner_id")));
        structValue.setField("parent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentPath, this._getType().getField("parent_path")));
        structValue.setField("path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.path, this._getType().getField("path")));
        structValue.setField("realization_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizationId, this._getType().getField("realization_id")));
        structValue.setField("relative_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.relativePath, this._getType().getField("relative_path")));
        structValue.setField("remote_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePath, this._getType().getField("remote_path")));
        structValue.setField("unique_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uniqueId, this._getType().getField("unique_id")));
        structValue.setField("children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.children, this._getType().getField("children")));
        structValue.setField("marked_for_delete",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markedForDelete, this._getType().getField("marked_for_delete")));
        structValue.setField("overridden",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overridden, this._getType().getField("overridden")));
        structValue.setField("cloud_config_cksum",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cloudConfigCksum, this._getType().getField("cloud_config_cksum")));
        structValue.setField("cloud_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cloudName, this._getType().getField("cloud_name")));
        structValue.setField("created_by",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createdBy, this._getType().getField("created_by")));
        structValue.setField("deactivate_primary_pool_on_down",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deactivatePrimaryPoolOnDown, this._getType().getField("deactivate_primary_pool_on_down")));
        structValue.setField("deployment_policy_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deploymentPolicyPath, this._getType().getField("deployment_policy_path")));
        structValue.setField("enable_http2",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableHttp2, this._getType().getField("enable_http2")));
        structValue.setField("fail_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.failAction, this._getType().getField("fail_action")));
        structValue.setField("implicit_priority_labels",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.implicitPriorityLabels, this._getType().getField("implicit_priority_labels")));
        structValue.setField("markers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markers, this._getType().getField("markers")));
        structValue.setField("members",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.members, this._getType().getField("members")));
        structValue.setField("min_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.minServers, this._getType().getField("min_servers")));
        structValue.setField("priority_labels_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.priorityLabelsPath, this._getType().getField("priority_labels_path")));
        structValue.setField("service_metadata",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceMetadata, this._getType().getField("service_metadata")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPoolGroup;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPoolGroup.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBPoolGroup _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBPoolGroup(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBPoolGroup _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBPoolGroup(structValue);
    }

    /**
     * Builder class for {@link ALBPoolGroup}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_global_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;
        private java.lang.String originSiteId;
        private java.lang.String ownerId;
        private java.lang.String parentPath;
        private java.lang.String path;
        private java.lang.String realizationId;
        private java.lang.String relativePath;
        private java.lang.String remotePath;
        private java.lang.String uniqueId;
        private java.util.List<com.vmware.vapi.bindings.Structure> children;
        private java.lang.Boolean markedForDelete;
        private java.lang.Boolean overridden;
        private java.lang.String cloudConfigCksum;
        private java.lang.String cloudName;
        private java.lang.String createdBy;
        private java.lang.Boolean deactivatePrimaryPoolOnDown;
        private java.lang.String deploymentPolicyPath;
        private java.lang.Boolean enableHttp2;
        private com.vmware.nsx_global_policy.model.ALBFailAction failAction;
        private java.lang.Boolean implicitPriorityLabels;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers;
        private java.util.List<com.vmware.nsx_global_policy.model.ALBPoolGroupMember> members;
        private java.lang.Long minServers;
        private java.lang.String priorityLabelsPath;
        private java.lang.String serviceMetadata;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBPoolGroup}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing which site owns an object.
         * This is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originSiteId New value for the property.
         */
        public Builder setOriginSiteId(java.lang.String originSiteId) {
            this.originSiteId = originSiteId;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing whoes owns this object. This
         * is used in Pmaas
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ownerId New value for the property.
         */
        public Builder setOwnerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Path of its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param parentPath New value for the property.
         */
        public Builder setParentPath(java.lang.String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        /**
         * Absolute path of this object
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param path New value for the property.
         */
        public Builder setPath(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * This is a UUID generated by the system for realizing the entity object. In most
         * cases this should be same as 'unique_id' of the entity. However, in some cases
         * this can be different because of entities have migrated thier unique identifier
         * to NSX Policy intent objects later in the timeline and did not use unique_id for
         * realization. Realization id is helpful for users to debug data path to correlate
         * the configuration with corresponding intent.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param realizationId New value for the property.
         */
        public Builder setRealizationId(java.lang.String realizationId) {
            this.realizationId = realizationId;
            return this;
        }

        /**
         * Path relative from its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param relativePath New value for the property.
         */
        public Builder setRelativePath(java.lang.String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        /**
         * This is the path of the object on the local managers when queried on the PMaaS
         * service, and path of the object on PMaaS service when queried from the local
         * managers.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePath New value for the property.
         */
        public Builder setRemotePath(java.lang.String remotePath) {
            this.remotePath = remotePath;
            return this;
        }

        /**
         * This is a UUID generated by the GM/LM to uniquely identify entites in a
         * federated environment. For entities that are stretched across multiple sites,
         * the same ID will be used on all the stretched sites.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param uniqueId New value for the property.
         */
        public Builder setUniqueId(java.lang.String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        /**
         * Subtree for this type within policy tree containing nested elements. Note that
         * this type is applicable to be used in Hierarchical API only.
         *
         * @param children New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}. When methods
         * return a value of this class as a return value, the property will contain all
         * the properties defined in {@link
         * com.vmware.nsx_global_policy.model.ChildPolicyConfigResource}.
         */
        public Builder setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
            this.children = children;
            return this;
        }

        /**
         * Intent objects are not directly deleted from the system when a delete is invoked
         * on them. They are marked for deletion and only when all the realized entities
         * for that intent object gets deleted, the intent object is deleted. Objects that
         * are marked for deletion are not returned in GET call. One can use the search API
         * to get these objects.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param markedForDelete New value for the property.
         */
        public Builder setMarkedForDelete(java.lang.Boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
            return this;
        }

        /**
         * Global intent objects cannot be modified by the user. However, certain global
         * intent objects can be overridden locally by use of this property. In such cases,
         * the overridden local values take precedence over the globally defined values for
         * the properties.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overridden New value for the property.
         */
        public Builder setOverridden(java.lang.Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        /**
         * Checksum of cloud configuration for PoolGroup. Internally set by cloud
         * connector.
         *
         * @param cloudConfigCksum New value for the property.
         */
        public Builder setCloudConfigCksum(java.lang.String cloudConfigCksum) {
            this.cloudConfigCksum = cloudConfigCksum;
            return this;
        }

        /**
         * It is a reference to an object of type Cloud.
         *
         * @param cloudName New value for the property.
         */
        public Builder setCloudName(java.lang.String cloudName) {
            this.cloudName = cloudName;
            return this;
        }

        /**
         * Name of the user who created the object.
         *
         * @param createdBy New value for the property.
         */
        public Builder setCreatedBy(java.lang.String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Deactivate primary pool for selection when down until it is activated by user
         * via clear poolgroup command. Default value when not specified in API or module
         * is interpreted by ALB Controller as false.
         *
         * @param deactivatePrimaryPoolOnDown New value for the property.
         */
        public Builder setDeactivatePrimaryPoolOnDown(java.lang.Boolean deactivatePrimaryPoolOnDown) {
            this.deactivatePrimaryPoolOnDown = deactivatePrimaryPoolOnDown;
            return this;
        }

        /**
         * When setup autoscale manager will automatically promote new pools into
         * production when deployment goals are met. It is a reference to an object of type
         * PoolGroupDeploymentPolicy.
         *
         * @param deploymentPolicyPath New value for the property.
         */
        public Builder setDeploymentPolicyPath(java.lang.String deploymentPolicyPath) {
            this.deploymentPolicyPath = deploymentPolicyPath;
            return this;
        }

        /**
         * Enable HTTP/2 for traffic from VirtualService to all the backend servers in all
         * the pools configured under this PoolGroup. Allowed in Basic(Allowed values-
         * false) edition, Essentials(Allowed values- false) edition, Enterprise edition.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as false.
         *
         * @param enableHttp2 New value for the property.
         */
        public Builder setEnableHttp2(java.lang.Boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return this;
        }

        /**
         *
         *
         * @param failAction New value for the property.
         */
        public Builder setFailAction(com.vmware.nsx_global_policy.model.ALBFailAction failAction) {
            this.failAction = failAction;
            return this;
        }

        /**
         * Whether an implicit set of priority labels is generated. Default value when not
         * specified in API or module is interpreted by ALB Controller as false.
         *
         * @param implicitPriorityLabels New value for the property.
         */
        public Builder setImplicitPriorityLabels(java.lang.Boolean implicitPriorityLabels) {
            this.implicitPriorityLabels = implicitPriorityLabels;
            return this;
        }

        /**
         * List of labels to be used for granular RBAC. Allowed in Basic edition,
         * Essentials edition, Enterprise edition.
         *
         * @param markers New value for the property.
         */
        public Builder setMarkers(java.util.List<com.vmware.nsx_global_policy.model.ALBRoleFilterMatchLabel> markers) {
            this.markers = markers;
            return this;
        }

        /**
         * List of pool group members object of type PoolGroupMember.
         *
         * @param members New value for the property.
         */
        public Builder setMembers(java.util.List<com.vmware.nsx_global_policy.model.ALBPoolGroupMember> members) {
            this.members = members;
            return this;
        }

        /**
         * The minimum number of servers to distribute traffic to. Allowed values are
         * 1-65535. Special values are 0 - 'Disable'. Allowed in Basic(Allowed values- 0)
         * edition, Essentials(Allowed values- 0) edition, Enterprise edition. Default
         * value when not specified in API or module is interpreted by ALB Controller as 0.
         * format: int64
         *
         * @param minServers New value for the property.
         */
        public Builder setMinServers(java.lang.Long minServers) {
            this.minServers = minServers;
            return this;
        }

        /**
         * path of the priority labels. If not provided, pool group member priority label
         * will be interpreted as a number with a larger number considered higher priority.
         * It is a reference to an object of type PriorityLabels.
         *
         * @param priorityLabelsPath New value for the property.
         */
        public Builder setPriorityLabelsPath(java.lang.String priorityLabelsPath) {
            this.priorityLabelsPath = priorityLabelsPath;
            return this;
        }

        /**
         * Metadata pertaining to the service provided by this PoolGroup. In
         * Openshift/Kubernetes environments, app metadata info is stored. Any user input
         * to this field will be overwritten by Avi Vantage.
         *
         * @param serviceMetadata New value for the property.
         */
        public Builder setServiceMetadata(java.lang.String serviceMetadata) {
            this.serviceMetadata = serviceMetadata;
            return this;
        }

        public ALBPoolGroup build() {
            ALBPoolGroup result = new ALBPoolGroup();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setOriginSiteId(this.originSiteId);
            result.setOwnerId(this.ownerId);
            result.setParentPath(this.parentPath);
            result.setPath(this.path);
            result.setRealizationId(this.realizationId);
            result.setRelativePath(this.relativePath);
            result.setRemotePath(this.remotePath);
            result.setUniqueId(this.uniqueId);
            result.setChildren(this.children);
            result.setMarkedForDelete(this.markedForDelete);
            result.setOverridden(this.overridden);
            result.setCloudConfigCksum(this.cloudConfigCksum);
            result.setCloudName(this.cloudName);
            result.setCreatedBy(this.createdBy);
            result.setDeactivatePrimaryPoolOnDown(this.deactivatePrimaryPoolOnDown);
            result.setDeploymentPolicyPath(this.deploymentPolicyPath);
            result.setEnableHttp2(this.enableHttp2);
            result.setFailAction(this.failAction);
            result.setImplicitPriorityLabels(this.implicitPriorityLabels);
            result.setMarkers(this.markers);
            result.setMembers(this.members);
            result.setMinServers(this.minServers);
            result.setPriorityLabelsPath(this.priorityLabelsPath);
            result.setServiceMetadata(this.serviceMetadata);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_site_id",
                                                                                "originSiteId",
                                                                                "getOriginSiteId",
                                                                                "setOriginSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owner_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owner_id",
                                                                                "ownerId",
                                                                                "getOwnerId",
                                                                                "setOwnerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_path",
                                                                                "parentPath",
                                                                                "getParentPath",
                                                                                "setParentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path",
                                                                                "path",
                                                                                "getPath",
                                                                                "setPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realization_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realization_id",
                                                                                "realizationId",
                                                                                "getRealizationId",
                                                                                "setRealizationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("relative_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("relative_path",
                                                                                "relativePath",
                                                                                "getRelativePath",
                                                                                "setRelativePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_path",
                                                                                "remotePath",
                                                                                "getRemotePath",
                                                                                "setRemotePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unique_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unique_id",
                                                                                "uniqueId",
                                                                                "getUniqueId",
                                                                                "setUniqueId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.childPolicyConfigResource; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("children",
                                                                                "children",
                                                                                "getChildren",
                                                                                "setChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("marked_for_delete", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("marked_for_delete",
                                                                                "markedForDelete",
                                                                                "getMarkedForDelete",
                                                                                "setMarkedForDelete");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overridden", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overridden",
                                                                                "overridden",
                                                                                "getOverridden",
                                                                                "setOverridden");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cloud_config_cksum", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cloud_config_cksum",
                                                                                "cloudConfigCksum",
                                                                                "getCloudConfigCksum",
                                                                                "setCloudConfigCksum");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cloud_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cloud_name",
                                                                                "cloudName",
                                                                                "getCloudName",
                                                                                "setCloudName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("created_by", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("created_by",
                                                                                "createdBy",
                                                                                "getCreatedBy",
                                                                                "setCreatedBy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("deactivate_primary_pool_on_down", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("deactivate_primary_pool_on_down",
                                                                                "deactivatePrimaryPoolOnDown",
                                                                                "getDeactivatePrimaryPoolOnDown",
                                                                                "setDeactivatePrimaryPoolOnDown");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("deployment_policy_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("deployment_policy_path",
                                                                                "deploymentPolicyPath",
                                                                                "getDeploymentPolicyPath",
                                                                                "setDeploymentPolicyPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_http2", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_http2",
                                                                                "enableHttp2",
                                                                                "getEnableHttp2",
                                                                                "setEnableHttp2");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fail_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBFailAction; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fail_action",
                                                                                "failAction",
                                                                                "getFailAction",
                                                                                "setFailAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("implicit_priority_labels", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("implicit_priority_labels",
                                                                                "implicitPriorityLabels",
                                                                                "getImplicitPriorityLabels",
                                                                                "setImplicitPriorityLabels");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("markers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBRoleFilterMatchLabel; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("markers",
                                                                                "markers",
                                                                                "getMarkers",
                                                                                "setMarkers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("members", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.ALBPoolGroupMember; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("members",
                                                                                "members",
                                                                                "getMembers",
                                                                                "setMembers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("min_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("min_servers",
                                                                                "minServers",
                                                                                "getMinServers",
                                                                                "setMinServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("priority_labels_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("priority_labels_path",
                                                                                "priorityLabelsPath",
                                                                                "getPriorityLabelsPath",
                                                                                "setPriorityLabelsPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_metadata", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_metadata",
                                                                                "serviceMetadata",
                                                                                "getServiceMetadata",
                                                                                "setServiceMetadata");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_pool_group",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBPoolGroup.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

