/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer Service object
 */
public final class ALBService implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean enableHttp2;

    private java.lang.Boolean enableSsl;

    private java.lang.String overrideApplicationProfilePath;

    private java.lang.String overrideNetworkProfilePath;

    private java.lang.Long port;

    private java.lang.Long portRangeEnd;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBService() {
    }

    protected ALBService(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Enable HTTP2 on this port. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableHttp2() {
        return this.enableHttp2;
    }

    /**
     * Enable HTTP2 on this port. Allowed in Basic(Allowed values- false) edition,
     * Essentials(Allowed values- false) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param enableHttp2 New value for the property.
     */
    public void setEnableHttp2(java.lang.Boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    /**
     * Enable SSL termination and offload for traffic from clients. Default value when
     * not specified in API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableSsl() {
        return this.enableSsl;
    }

    /**
     * Enable SSL termination and offload for traffic from clients. Default value when
     * not specified in API or module is interpreted by ALB Controller as false.
     *
     * @param enableSsl New value for the property.
     */
    public void setEnableSsl(java.lang.Boolean enableSsl) {
        this.enableSsl = enableSsl;
    }

    /**
     * Enable application layer specific features for the this specific service. It is
     * a reference to an object of type ApplicationProfile. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOverrideApplicationProfilePath() {
        return this.overrideApplicationProfilePath;
    }

    /**
     * Enable application layer specific features for the this specific service. It is
     * a reference to an object of type ApplicationProfile. Allowed in Basic edition,
     * Essentials edition, Enterprise edition.
     *
     * @param overrideApplicationProfilePath New value for the property.
     */
    public void setOverrideApplicationProfilePath(java.lang.String overrideApplicationProfilePath) {
        this.overrideApplicationProfilePath = overrideApplicationProfilePath;
    }

    /**
     * Override the network profile for this specific service port. It is a reference
     * to an object of type NetworkProfile.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOverrideNetworkProfilePath() {
        return this.overrideNetworkProfilePath;
    }

    /**
     * Override the network profile for this specific service port. It is a reference
     * to an object of type NetworkProfile.
     *
     * @param overrideNetworkProfilePath New value for the property.
     */
    public void setOverrideNetworkProfilePath(java.lang.String overrideNetworkProfilePath) {
        this.overrideNetworkProfilePath = overrideNetworkProfilePath;
    }

    /**
     * The Virtual Service's port number. Allowed values are 0-65535. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * The Virtual Service's port number. Allowed values are 0-65535. format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * The end of the Virtual Service's port number range. Allowed values are 1-65535.
     * Special values are 0- 'single port'. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPortRangeEnd() {
        return this.portRangeEnd;
    }

    /**
     * The end of the Virtual Service's port number range. Allowed values are 1-65535.
     * Special values are 0- 'single port'. Default value when not specified in API or
     * module is interpreted by ALB Controller as 0. format: int64
     *
     * @param portRangeEnd New value for the property.
     */
    public void setPortRangeEnd(java.lang.Long portRangeEnd) {
        this.portRangeEnd = portRangeEnd;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBService;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("enable_http2",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableHttp2, this._getType().getField("enable_http2")));
        structValue.setField("enable_ssl",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableSsl, this._getType().getField("enable_ssl")));
        structValue.setField("override_application_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overrideApplicationProfilePath, this._getType().getField("override_application_profile_path")));
        structValue.setField("override_network_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overrideNetworkProfilePath, this._getType().getField("override_network_profile_path")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("port_range_end",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.portRangeEnd, this._getType().getField("port_range_end")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBService;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBService.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBService _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBService(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBService _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBService(structValue);
    }

    /**
     * Builder class for {@link ALBService}.
     */
    public static final class Builder {
        private java.lang.Boolean enableHttp2;
        private java.lang.Boolean enableSsl;
        private java.lang.String overrideApplicationProfilePath;
        private java.lang.String overrideNetworkProfilePath;
        private java.lang.Long port;
        private java.lang.Long portRangeEnd;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBService}.
         */
        public Builder() {
        }

        /**
         * Enable HTTP2 on this port. Allowed in Basic(Allowed values- false) edition,
         * Essentials(Allowed values- false) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param enableHttp2 New value for the property.
         */
        public Builder setEnableHttp2(java.lang.Boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return this;
        }

        /**
         * Enable SSL termination and offload for traffic from clients. Default value when
         * not specified in API or module is interpreted by ALB Controller as false.
         *
         * @param enableSsl New value for the property.
         */
        public Builder setEnableSsl(java.lang.Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        /**
         * Enable application layer specific features for the this specific service. It is
         * a reference to an object of type ApplicationProfile. Allowed in Basic edition,
         * Essentials edition, Enterprise edition.
         *
         * @param overrideApplicationProfilePath New value for the property.
         */
        public Builder setOverrideApplicationProfilePath(java.lang.String overrideApplicationProfilePath) {
            this.overrideApplicationProfilePath = overrideApplicationProfilePath;
            return this;
        }

        /**
         * Override the network profile for this specific service port. It is a reference
         * to an object of type NetworkProfile.
         *
         * @param overrideNetworkProfilePath New value for the property.
         */
        public Builder setOverrideNetworkProfilePath(java.lang.String overrideNetworkProfilePath) {
            this.overrideNetworkProfilePath = overrideNetworkProfilePath;
            return this;
        }

        /**
         * The Virtual Service's port number. Allowed values are 0-65535. format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * The end of the Virtual Service's port number range. Allowed values are 1-65535.
         * Special values are 0- 'single port'. Default value when not specified in API or
         * module is interpreted by ALB Controller as 0. format: int64
         *
         * @param portRangeEnd New value for the property.
         */
        public Builder setPortRangeEnd(java.lang.Long portRangeEnd) {
            this.portRangeEnd = portRangeEnd;
            return this;
        }

        public ALBService build() {
            ALBService result = new ALBService();
            result.setEnableHttp2(this.enableHttp2);
            result.setEnableSsl(this.enableSsl);
            result.setOverrideApplicationProfilePath(this.overrideApplicationProfilePath);
            result.setOverrideNetworkProfilePath(this.overrideNetworkProfilePath);
            result.setPort(this.port);
            result.setPortRangeEnd(this.portRangeEnd);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("enable_http2", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_http2",
                                                                                "enableHttp2",
                                                                                "getEnableHttp2",
                                                                                "setEnableHttp2");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_ssl", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_ssl",
                                                                                "enableSsl",
                                                                                "getEnableSsl",
                                                                                "setEnableSsl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("override_application_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("override_application_profile_path",
                                                                                "overrideApplicationProfilePath",
                                                                                "getOverrideApplicationProfilePath",
                                                                                "setOverrideApplicationProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("override_network_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("override_network_profile_path",
                                                                                "overrideNetworkProfilePath",
                                                                                "getOverrideNetworkProfilePath",
                                                                                "setOverrideNetworkProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port_range_end", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port_range_end",
                                                                                "portRangeEnd",
                                                                                "getPortRangeEnd",
                                                                                "setPortRangeEnd");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_service",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBService.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

