/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer TCPApplicationProfile object
 */
public final class ALBTCPApplicationProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PROXY_PROTOCOL_VERSION_1 = "PROXY_PROTOCOL_VERSION_1";

    public static final java.lang.String PROXY_PROTOCOL_VERSION_2 = "PROXY_PROTOCOL_VERSION_2";

    public static final java.lang.String SSL_CLIENT_CERTIFICATE_MODE_NONE = "SSL_CLIENT_CERTIFICATE_NONE";

    public static final java.lang.String SSL_CLIENT_CERTIFICATE_MODE_REQUEST = "SSL_CLIENT_CERTIFICATE_REQUEST";

    public static final java.lang.String SSL_CLIENT_CERTIFICATE_MODE_REQUIRE = "SSL_CLIENT_CERTIFICATE_REQUIRE";

    private java.lang.String pkiProfilePath;

    private java.lang.Boolean proxyProtocolEnabled;

    private java.lang.String proxyProtocolVersion;

    private java.lang.String sslClientCertificateMode;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBTCPApplicationProfile() {
    }

    protected ALBTCPApplicationProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Select the PKI profile to be associated with the Virtual Service. This profile
     * defines the Certificate Authority and Revocation List. It is a reference to an
     * object of type PKIProfile. Allowed in Basic edition, Essentials edition,
     * Enterprise edition.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPkiProfilePath() {
        return this.pkiProfilePath;
    }

    /**
     * Select the PKI profile to be associated with the Virtual Service. This profile
     * defines the Certificate Authority and Revocation List. It is a reference to an
     * object of type PKIProfile. Allowed in Basic edition, Essentials edition,
     * Enterprise edition.
     *
     * @param pkiProfilePath New value for the property.
     */
    public void setPkiProfilePath(java.lang.String pkiProfilePath) {
        this.pkiProfilePath = pkiProfilePath;
    }

    /**
     * Enable/Disable the usage of proxy protocol to convey client connection
     * information to the back-end servers. Valid only for L4 application profiles and
     * TCP proxy. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getProxyProtocolEnabled() {
        return this.proxyProtocolEnabled;
    }

    /**
     * Enable/Disable the usage of proxy protocol to convey client connection
     * information to the back-end servers. Valid only for L4 application profiles and
     * TCP proxy. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
     * values- false) edition, Enterprise edition. Default value when not specified in
     * API or module is interpreted by ALB Controller as false.
     *
     * @param proxyProtocolEnabled New value for the property.
     */
    public void setProxyProtocolEnabled(java.lang.Boolean proxyProtocolEnabled) {
        this.proxyProtocolEnabled = proxyProtocolEnabled;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#PROXY_PROTOCOL_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#PROXY_PROTOCOL_VERSION_2}</li>
     * </ul> Version of proxy protocol to be used to convey client connection
     * information to the back-end servers. Enum options - PROXY_PROTOCOL_VERSION_1,
     * PROXY_PROTOCOL_VERSION_2. Allowed in Basic(Allowed values-
     * PROXY_PROTOCOL_VERSION_1) edition, Essentials(Allowed values-
     * PROXY_PROTOCOL_VERSION_1) edition, Enterprise edition. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * PROXY_PROTOCOL_VERSION_1.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProxyProtocolVersion() {
        return this.proxyProtocolVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#PROXY_PROTOCOL_VERSION_1}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#PROXY_PROTOCOL_VERSION_2}</li>
     * </ul> Version of proxy protocol to be used to convey client connection
     * information to the back-end servers. Enum options - PROXY_PROTOCOL_VERSION_1,
     * PROXY_PROTOCOL_VERSION_2. Allowed in Basic(Allowed values-
     * PROXY_PROTOCOL_VERSION_1) edition, Essentials(Allowed values-
     * PROXY_PROTOCOL_VERSION_1) edition, Enterprise edition. Default value when not
     * specified in API or module is interpreted by ALB Controller as
     * PROXY_PROTOCOL_VERSION_1.
     *
     * @param proxyProtocolVersion New value for the property.
     */
    public void setProxyProtocolVersion(java.lang.String proxyProtocolVersion) {
        this.proxyProtocolVersion = proxyProtocolVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUEST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUIRE}</li>
     * </ul> Specifies whether the client side verification is set to none, request or
     * require. Enum options - SSL_CLIENT_CERTIFICATE_NONE,
     * SSL_CLIENT_CERTIFICATE_REQUEST, SSL_CLIENT_CERTIFICATE_REQUIRE. Allowed in
     * Basic(Allowed values- SSL_CLIENT_CERTIFICATE_NONE) edition, Essentials(Allowed
     * values- SSL_CLIENT_CERTIFICATE_NONE) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as
     * SSL_CLIENT_CERTIFICATE_NONE.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSslClientCertificateMode() {
        return this.sslClientCertificateMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUEST}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUIRE}</li>
     * </ul> Specifies whether the client side verification is set to none, request or
     * require. Enum options - SSL_CLIENT_CERTIFICATE_NONE,
     * SSL_CLIENT_CERTIFICATE_REQUEST, SSL_CLIENT_CERTIFICATE_REQUIRE. Allowed in
     * Basic(Allowed values- SSL_CLIENT_CERTIFICATE_NONE) edition, Essentials(Allowed
     * values- SSL_CLIENT_CERTIFICATE_NONE) edition, Enterprise edition. Default value
     * when not specified in API or module is interpreted by ALB Controller as
     * SSL_CLIENT_CERTIFICATE_NONE.
     *
     * @param sslClientCertificateMode New value for the property.
     */
    public void setSslClientCertificateMode(java.lang.String sslClientCertificateMode) {
        this.sslClientCertificateMode = sslClientCertificateMode;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBTCPApplicationProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("pki_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pkiProfilePath, this._getType().getField("pki_profile_path")));
        structValue.setField("proxy_protocol_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.proxyProtocolEnabled, this._getType().getField("proxy_protocol_enabled")));
        structValue.setField("proxy_protocol_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.proxyProtocolVersion, this._getType().getField("proxy_protocol_version")));
        structValue.setField("ssl_client_certificate_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslClientCertificateMode, this._getType().getField("ssl_client_certificate_mode")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBTCPApplicationProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBTCPApplicationProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBTCPApplicationProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBTCPApplicationProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBTCPApplicationProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBTCPApplicationProfile(structValue);
    }

    /**
     * Builder class for {@link ALBTCPApplicationProfile}.
     */
    public static final class Builder {
        private java.lang.String pkiProfilePath;
        private java.lang.Boolean proxyProtocolEnabled;
        private java.lang.String proxyProtocolVersion;
        private java.lang.String sslClientCertificateMode;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBTCPApplicationProfile}.
         */
        public Builder() {
        }

        /**
         * Select the PKI profile to be associated with the Virtual Service. This profile
         * defines the Certificate Authority and Revocation List. It is a reference to an
         * object of type PKIProfile. Allowed in Basic edition, Essentials edition,
         * Enterprise edition.
         *
         * @param pkiProfilePath New value for the property.
         */
        public Builder setPkiProfilePath(java.lang.String pkiProfilePath) {
            this.pkiProfilePath = pkiProfilePath;
            return this;
        }

        /**
         * Enable/Disable the usage of proxy protocol to convey client connection
         * information to the back-end servers. Valid only for L4 application profiles and
         * TCP proxy. Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
         * values- false) edition, Enterprise edition. Default value when not specified in
         * API or module is interpreted by ALB Controller as false.
         *
         * @param proxyProtocolEnabled New value for the property.
         */
        public Builder setProxyProtocolEnabled(java.lang.Boolean proxyProtocolEnabled) {
            this.proxyProtocolEnabled = proxyProtocolEnabled;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#PROXY_PROTOCOL_VERSION_1}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#PROXY_PROTOCOL_VERSION_2}</li>
         * </ul> Version of proxy protocol to be used to convey client connection
         * information to the back-end servers. Enum options - PROXY_PROTOCOL_VERSION_1,
         * PROXY_PROTOCOL_VERSION_2. Allowed in Basic(Allowed values-
         * PROXY_PROTOCOL_VERSION_1) edition, Essentials(Allowed values-
         * PROXY_PROTOCOL_VERSION_1) edition, Enterprise edition. Default value when not
         * specified in API or module is interpreted by ALB Controller as
         * PROXY_PROTOCOL_VERSION_1.
         *
         * @param proxyProtocolVersion New value for the property.
         */
        public Builder setProxyProtocolVersion(java.lang.String proxyProtocolVersion) {
            this.proxyProtocolVersion = proxyProtocolVersion;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUEST}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile#SSL_CLIENT_CERTIFICATE_MODE_REQUIRE}</li>
         * </ul> Specifies whether the client side verification is set to none, request or
         * require. Enum options - SSL_CLIENT_CERTIFICATE_NONE,
         * SSL_CLIENT_CERTIFICATE_REQUEST, SSL_CLIENT_CERTIFICATE_REQUIRE. Allowed in
         * Basic(Allowed values- SSL_CLIENT_CERTIFICATE_NONE) edition, Essentials(Allowed
         * values- SSL_CLIENT_CERTIFICATE_NONE) edition, Enterprise edition. Default value
         * when not specified in API or module is interpreted by ALB Controller as
         * SSL_CLIENT_CERTIFICATE_NONE.
         *
         * @param sslClientCertificateMode New value for the property.
         */
        public Builder setSslClientCertificateMode(java.lang.String sslClientCertificateMode) {
            this.sslClientCertificateMode = sslClientCertificateMode;
            return this;
        }

        public ALBTCPApplicationProfile build() {
            ALBTCPApplicationProfile result = new ALBTCPApplicationProfile();
            result.setPkiProfilePath(this.pkiProfilePath);
            result.setProxyProtocolEnabled(this.proxyProtocolEnabled);
            result.setProxyProtocolVersion(this.proxyProtocolVersion);
            result.setSslClientCertificateMode(this.sslClientCertificateMode);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("pki_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pki_profile_path",
                                                                                "pkiProfilePath",
                                                                                "getPkiProfilePath",
                                                                                "setPkiProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("proxy_protocol_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("proxy_protocol_enabled",
                                                                                "proxyProtocolEnabled",
                                                                                "getProxyProtocolEnabled",
                                                                                "setProxyProtocolEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("proxy_protocol_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("proxy_protocol_version",
                                                                                "proxyProtocolVersion",
                                                                                "getProxyProtocolVersion",
                                                                                "setProxyProtocolVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_client_certificate_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_client_certificate_mode",
                                                                                "sslClientCertificateMode",
                                                                                "getSslClientCertificateMode",
                                                                                "setSslClientCertificateMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALBTCP_application_profile",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBTCPApplicationProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

