/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Advanced load balancer WafConfig object
 */
public final class ALBWafConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ALLOWED_HTTP_VERSIONS_ZERO_NINE = "ZERO_NINE";

    public static final java.lang.String ALLOWED_HTTP_VERSIONS_ONE_ZERO = "ONE_ZERO";

    public static final java.lang.String ALLOWED_HTTP_VERSIONS_ONE_ONE = "ONE_ONE";

    public static final java.lang.String ALLOWED_HTTP_VERSIONS_TWO_ZERO = "TWO_ZERO";

    public static final java.lang.String ALLOWED_METHODS_GET = "HTTP_METHOD_GET";

    public static final java.lang.String ALLOWED_METHODS_HEAD = "HTTP_METHOD_HEAD";

    public static final java.lang.String ALLOWED_METHODS_PUT = "HTTP_METHOD_PUT";

    public static final java.lang.String ALLOWED_METHODS_DELETE = "HTTP_METHOD_DELETE";

    public static final java.lang.String ALLOWED_METHODS_POST = "HTTP_METHOD_POST";

    public static final java.lang.String ALLOWED_METHODS_OPTIONS = "HTTP_METHOD_OPTIONS";

    public static final java.lang.String ALLOWED_METHODS_TRACE = "HTTP_METHOD_TRACE";

    public static final java.lang.String ALLOWED_METHODS_CONNECT = "HTTP_METHOD_CONNECT";

    public static final java.lang.String ALLOWED_METHODS_PATCH = "HTTP_METHOD_PATCH";

    public static final java.lang.String ALLOWED_METHODS_PROPFIND = "HTTP_METHOD_PROPFIND";

    public static final java.lang.String ALLOWED_METHODS_PROPPATCH = "HTTP_METHOD_PROPPATCH";

    public static final java.lang.String ALLOWED_METHODS_MKCOL = "HTTP_METHOD_MKCOL";

    public static final java.lang.String ALLOWED_METHODS_COPY = "HTTP_METHOD_COPY";

    public static final java.lang.String ALLOWED_METHODS_MOVE = "HTTP_METHOD_MOVE";

    public static final java.lang.String ALLOWED_METHODS_LOCK = "HTTP_METHOD_LOCK";

    public static final java.lang.String ALLOWED_METHODS_UNLOCK = "HTTP_METHOD_UNLOCK";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_0 = "HTTP_RESPONSE_CODE_0";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_100 = "HTTP_RESPONSE_CODE_100";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_101 = "HTTP_RESPONSE_CODE_101";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_200 = "HTTP_RESPONSE_CODE_200";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_201 = "HTTP_RESPONSE_CODE_201";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_202 = "HTTP_RESPONSE_CODE_202";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_203 = "HTTP_RESPONSE_CODE_203";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_204 = "HTTP_RESPONSE_CODE_204";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_205 = "HTTP_RESPONSE_CODE_205";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_206 = "HTTP_RESPONSE_CODE_206";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_300 = "HTTP_RESPONSE_CODE_300";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_301 = "HTTP_RESPONSE_CODE_301";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_302 = "HTTP_RESPONSE_CODE_302";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_303 = "HTTP_RESPONSE_CODE_303";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_304 = "HTTP_RESPONSE_CODE_304";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_305 = "HTTP_RESPONSE_CODE_305";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_307 = "HTTP_RESPONSE_CODE_307";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_400 = "HTTP_RESPONSE_CODE_400";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_401 = "HTTP_RESPONSE_CODE_401";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_402 = "HTTP_RESPONSE_CODE_402";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_403 = "HTTP_RESPONSE_CODE_403";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_404 = "HTTP_RESPONSE_CODE_404";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_405 = "HTTP_RESPONSE_CODE_405";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_406 = "HTTP_RESPONSE_CODE_406";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_407 = "HTTP_RESPONSE_CODE_407";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_408 = "HTTP_RESPONSE_CODE_408";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_409 = "HTTP_RESPONSE_CODE_409";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_410 = "HTTP_RESPONSE_CODE_410";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_411 = "HTTP_RESPONSE_CODE_411";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_412 = "HTTP_RESPONSE_CODE_412";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_413 = "HTTP_RESPONSE_CODE_413";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_414 = "HTTP_RESPONSE_CODE_414";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_415 = "HTTP_RESPONSE_CODE_415";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_416 = "HTTP_RESPONSE_CODE_416";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_417 = "HTTP_RESPONSE_CODE_417";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_426 = "HTTP_RESPONSE_CODE_426";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_470 = "HTTP_RESPONSE_CODE_470";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_475 = "HTTP_RESPONSE_CODE_475";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_500 = "HTTP_RESPONSE_CODE_500";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_501 = "HTTP_RESPONSE_CODE_501";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_502 = "HTTP_RESPONSE_CODE_502";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_503 = "HTTP_RESPONSE_CODE_503";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_504 = "HTTP_RESPONSE_CODE_504";

    public static final java.lang.String STATUS_CODE_FOR_REJECTED_REQUESTS_505 = "HTTP_RESPONSE_CODE_505";

    private java.util.List<java.lang.String> allowedHttpVersions;

    private java.util.List<java.lang.String> allowedMethods;

    private java.util.List<java.lang.String> allowedRequestContentTypes;

    private java.lang.String argumentSeparator;

    private java.lang.Long clientRequestMaxBodySize;

    private java.lang.Long cookieFormatVersion;

    private java.lang.Boolean ignoreIncompleteRequestBodyError;

    private java.lang.Long maxExecutionTime;

    private java.lang.Long regexMatchLimit;

    private java.lang.Long regexRecursionLimit;

    private java.lang.String requestBodyDefaultAction;

    private java.lang.String requestHdrDefaultAction;

    private java.lang.String responseBodyDefaultAction;

    private java.lang.String responseHdrDefaultAction;

    private java.util.List<java.lang.String> restrictedExtensions;

    private java.util.List<java.lang.String> restrictedHeaders;

    private java.lang.Long serverResponseMaxBodySize;

    private java.util.List<java.lang.String> staticExtensions;

    private java.lang.String statusCodeForRejectedRequests;

    private java.lang.Boolean xmlXxeProtection;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ALBWafConfig() {
    }

    protected ALBWafConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ZERO_NINE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ONE_ZERO}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ONE_ONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_TWO_ZERO}</li>
     * </ul> WAF allowed HTTP Versions. Enum options - ZERO_NINE, ONE_ZERO, ONE_ONE,
     * TWO_ZERO. Maximum of 8 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAllowedHttpVersions() {
        return this.allowedHttpVersions;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ZERO_NINE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ONE_ZERO}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ONE_ONE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_TWO_ZERO}</li>
     * </ul> WAF allowed HTTP Versions. Enum options - ZERO_NINE, ONE_ZERO, ONE_ONE,
     * TWO_ZERO. Maximum of 8 items allowed.
     *
     * @param allowedHttpVersions New value for the property.
     */
    public void setAllowedHttpVersions(java.util.List<java.lang.String> allowedHttpVersions) {
        this.allowedHttpVersions = allowedHttpVersions;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_GET}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_HEAD}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PUT}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_DELETE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_POST}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_OPTIONS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_TRACE}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_CONNECT}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PATCH}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PROPFIND}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PROPPATCH}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_MKCOL}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_COPY}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_MOVE}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_LOCK}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_UNLOCK}</li>
     * </ul> WAF allowed HTTP methods. Enum options - HTTP_METHOD_GET,
     * HTTP_METHOD_HEAD, HTTP_METHOD_PUT, HTTP_METHOD_DELETE, HTTP_METHOD_POST,
     * HTTP_METHOD_OPTIONS, HTTP_METHOD_TRACE, HTTP_METHOD_CONNECT, HTTP_METHOD_PATCH,
     * HTTP_METHOD_PROPFIND, HTTP_METHOD_PROPPATCH, HTTP_METHOD_MKCOL,
     * HTTP_METHOD_COPY, HTTP_METHOD_MOVE, HTTP_METHOD_LOCK, HTTP_METHOD_UNLOCK.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAllowedMethods() {
        return this.allowedMethods;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_GET}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_HEAD}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PUT}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_DELETE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_POST}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_OPTIONS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_TRACE}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_CONNECT}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PATCH}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PROPFIND}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PROPPATCH}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_MKCOL}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_COPY}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_MOVE}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_LOCK}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_UNLOCK}</li>
     * </ul> WAF allowed HTTP methods. Enum options - HTTP_METHOD_GET,
     * HTTP_METHOD_HEAD, HTTP_METHOD_PUT, HTTP_METHOD_DELETE, HTTP_METHOD_POST,
     * HTTP_METHOD_OPTIONS, HTTP_METHOD_TRACE, HTTP_METHOD_CONNECT, HTTP_METHOD_PATCH,
     * HTTP_METHOD_PROPFIND, HTTP_METHOD_PROPPATCH, HTTP_METHOD_MKCOL,
     * HTTP_METHOD_COPY, HTTP_METHOD_MOVE, HTTP_METHOD_LOCK, HTTP_METHOD_UNLOCK.
     *
     * @param allowedMethods New value for the property.
     */
    public void setAllowedMethods(java.util.List<java.lang.String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    /**
     * WAF allowed Content Types. Maximum of 64 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getAllowedRequestContentTypes() {
        return this.allowedRequestContentTypes;
    }

    /**
     * WAF allowed Content Types. Maximum of 64 items allowed.
     *
     * @param allowedRequestContentTypes New value for the property.
     */
    public void setAllowedRequestContentTypes(java.util.List<java.lang.String> allowedRequestContentTypes) {
        this.allowedRequestContentTypes = allowedRequestContentTypes;
    }

    /**
     * Argument seperator. Default value when not specified in API or module is
     * interpreted by ALB Controller as &.
     *
     * @return The current value of the property.
     */
    public java.lang.String getArgumentSeparator() {
        return this.argumentSeparator;
    }

    /**
     * Argument seperator. Default value when not specified in API or module is
     * interpreted by ALB Controller as &.
     *
     * @param argumentSeparator New value for the property.
     */
    public void setArgumentSeparator(java.lang.String argumentSeparator) {
        this.argumentSeparator = argumentSeparator;
    }

    /**
     * Maximum size for the client request body scanned by WAF. Allowed values are
     * 1-32768. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 32. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getClientRequestMaxBodySize() {
        return this.clientRequestMaxBodySize;
    }

    /**
     * Maximum size for the client request body scanned by WAF. Allowed values are
     * 1-32768. Unit is KB. Default value when not specified in API or module is
     * interpreted by ALB Controller as 32. format: int64
     *
     * @param clientRequestMaxBodySize New value for the property.
     */
    public void setClientRequestMaxBodySize(java.lang.Long clientRequestMaxBodySize) {
        this.clientRequestMaxBodySize = clientRequestMaxBodySize;
    }

    /**
     * 0 For Netscape Cookies. 1 For version 1 cookies. Allowed values are 0-1. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCookieFormatVersion() {
        return this.cookieFormatVersion;
    }

    /**
     * 0 For Netscape Cookies. 1 For version 1 cookies. Allowed values are 0-1. Default
     * value when not specified in API or module is interpreted by ALB Controller as 0.
     * format: int64
     *
     * @param cookieFormatVersion New value for the property.
     */
    public void setCookieFormatVersion(java.lang.Long cookieFormatVersion) {
        this.cookieFormatVersion = cookieFormatVersion;
    }

    /**
     * Ignore request body parsing errors due to partial scanning. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIgnoreIncompleteRequestBodyError() {
        return this.ignoreIncompleteRequestBodyError;
    }

    /**
     * Ignore request body parsing errors due to partial scanning. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @param ignoreIncompleteRequestBodyError New value for the property.
     */
    public void setIgnoreIncompleteRequestBodyError(java.lang.Boolean ignoreIncompleteRequestBodyError) {
        this.ignoreIncompleteRequestBodyError = ignoreIncompleteRequestBodyError;
    }

    /**
     * The maximum period of time WAF processing is allowed to take for a single
     * request. A value of 0 (zero) means no limit and should not be chosen in
     * production deployments. It is only used for exceptional situations where crashes
     * of se_dp processes are acceptable. The behavior of the system if this time is
     * exceeded depends on two other configuration settings, the WAF policy mode and
     * the WAF failure mode. In WAF policy mode 'Detection', the request is allowed and
     * flagged for both failure mode 'Closed' and 'Open'. In enforcement node, 'Closed'
     * means the request is rejected, 'Open' means the request is allowed and flagged.
     * Irrespective of these settings, no subsequent WAF rules of this or other phases
     * will be executed once the maximum execution time has been exceeded. Allowed
     * values are 0-5000. Unit is MILLISECONDS. Default value when not specified in API
     * or module is interpreted by ALB Controller as 50. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    /**
     * The maximum period of time WAF processing is allowed to take for a single
     * request. A value of 0 (zero) means no limit and should not be chosen in
     * production deployments. It is only used for exceptional situations where crashes
     * of se_dp processes are acceptable. The behavior of the system if this time is
     * exceeded depends on two other configuration settings, the WAF policy mode and
     * the WAF failure mode. In WAF policy mode 'Detection', the request is allowed and
     * flagged for both failure mode 'Closed' and 'Open'. In enforcement node, 'Closed'
     * means the request is rejected, 'Open' means the request is allowed and flagged.
     * Irrespective of these settings, no subsequent WAF rules of this or other phases
     * will be executed once the maximum execution time has been exceeded. Allowed
     * values are 0-5000. Unit is MILLISECONDS. Default value when not specified in API
     * or module is interpreted by ALB Controller as 50. format: int64
     *
     * @param maxExecutionTime New value for the property.
     */
    public void setMaxExecutionTime(java.lang.Long maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    /**
     * Limit CPU utilization for each regular expression match when processing rules.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 30000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRegexMatchLimit() {
        return this.regexMatchLimit;
    }

    /**
     * Limit CPU utilization for each regular expression match when processing rules.
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as 30000. format: int64
     *
     * @param regexMatchLimit New value for the property.
     */
    public void setRegexMatchLimit(java.lang.Long regexMatchLimit) {
        this.regexMatchLimit = regexMatchLimit;
    }

    /**
     * Limit depth of recursion for each regular expression match when processing
     * rules. Default value when not specified in API or module is interpreted by ALB
     * Controller as 10000. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRegexRecursionLimit() {
        return this.regexRecursionLimit;
    }

    /**
     * Limit depth of recursion for each regular expression match when processing
     * rules. Default value when not specified in API or module is interpreted by ALB
     * Controller as 10000. format: int64
     *
     * @param regexRecursionLimit New value for the property.
     */
    public void setRegexRecursionLimit(java.lang.Long regexRecursionLimit) {
        this.regexRecursionLimit = regexRecursionLimit;
    }

    /**
     * WAF default action for Request Body Phase. Default value when not specified in
     * API or module is interpreted by ALB Controller as
     * phase:2,deny,status:403,log,auditlog.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestBodyDefaultAction() {
        return this.requestBodyDefaultAction;
    }

    /**
     * WAF default action for Request Body Phase. Default value when not specified in
     * API or module is interpreted by ALB Controller as
     * phase:2,deny,status:403,log,auditlog.
     *
     * @param requestBodyDefaultAction New value for the property.
     */
    public void setRequestBodyDefaultAction(java.lang.String requestBodyDefaultAction) {
        this.requestBodyDefaultAction = requestBodyDefaultAction;
    }

    /**
     * WAF default action for Request Header Phase. Default value when not specified in
     * API or module is interpreted by ALB Controller as
     * phase:1,deny,status:403,log,auditlog.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestHdrDefaultAction() {
        return this.requestHdrDefaultAction;
    }

    /**
     * WAF default action for Request Header Phase. Default value when not specified in
     * API or module is interpreted by ALB Controller as
     * phase:1,deny,status:403,log,auditlog.
     *
     * @param requestHdrDefaultAction New value for the property.
     */
    public void setRequestHdrDefaultAction(java.lang.String requestHdrDefaultAction) {
        this.requestHdrDefaultAction = requestHdrDefaultAction;
    }

    /**
     * WAF default action for Response Body Phase. Default value when not specified in
     * API or module is interpreted by ALB Controller as
     * phase:4,deny,status:403,log,auditlog.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResponseBodyDefaultAction() {
        return this.responseBodyDefaultAction;
    }

    /**
     * WAF default action for Response Body Phase. Default value when not specified in
     * API or module is interpreted by ALB Controller as
     * phase:4,deny,status:403,log,auditlog.
     *
     * @param responseBodyDefaultAction New value for the property.
     */
    public void setResponseBodyDefaultAction(java.lang.String responseBodyDefaultAction) {
        this.responseBodyDefaultAction = responseBodyDefaultAction;
    }

    /**
     * WAF default action for Response Header Phase. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * phase:3,deny,status:403,log,auditlog.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResponseHdrDefaultAction() {
        return this.responseHdrDefaultAction;
    }

    /**
     * WAF default action for Response Header Phase. Default value when not specified
     * in API or module is interpreted by ALB Controller as
     * phase:3,deny,status:403,log,auditlog.
     *
     * @param responseHdrDefaultAction New value for the property.
     */
    public void setResponseHdrDefaultAction(java.lang.String responseHdrDefaultAction) {
        this.responseHdrDefaultAction = responseHdrDefaultAction;
    }

    /**
     * WAF Restricted File Extensions. Maximum of 256 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getRestrictedExtensions() {
        return this.restrictedExtensions;
    }

    /**
     * WAF Restricted File Extensions. Maximum of 256 items allowed.
     *
     * @param restrictedExtensions New value for the property.
     */
    public void setRestrictedExtensions(java.util.List<java.lang.String> restrictedExtensions) {
        this.restrictedExtensions = restrictedExtensions;
    }

    /**
     * WAF Restricted HTTP Headers. Maximum of 64 items allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getRestrictedHeaders() {
        return this.restrictedHeaders;
    }

    /**
     * WAF Restricted HTTP Headers. Maximum of 64 items allowed.
     *
     * @param restrictedHeaders New value for the property.
     */
    public void setRestrictedHeaders(java.util.List<java.lang.String> restrictedHeaders) {
        this.restrictedHeaders = restrictedHeaders;
    }

    /**
     * Maximum size for response body scanned by WAF. Allowed values are 1-32768. Unit
     * is KB. Default value when not specified in API or module is interpreted by ALB
     * Controller as 128. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getServerResponseMaxBodySize() {
        return this.serverResponseMaxBodySize;
    }

    /**
     * Maximum size for response body scanned by WAF. Allowed values are 1-32768. Unit
     * is KB. Default value when not specified in API or module is interpreted by ALB
     * Controller as 128. format: int64
     *
     * @param serverResponseMaxBodySize New value for the property.
     */
    public void setServerResponseMaxBodySize(java.lang.Long serverResponseMaxBodySize) {
        this.serverResponseMaxBodySize = serverResponseMaxBodySize;
    }

    /**
     * WAF Static File Extensions. GET and HEAD requests with no query args and one of
     * these extensions are allowed and not checked by the ruleset. Maximum of 64 items
     * allowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getStaticExtensions() {
        return this.staticExtensions;
    }

    /**
     * WAF Static File Extensions. GET and HEAD requests with no query args and one of
     * these extensions are allowed and not checked by the ruleset. Maximum of 64 items
     * allowed.
     *
     * @param staticExtensions New value for the property.
     */
    public void setStaticExtensions(java.util.List<java.lang.String> staticExtensions) {
        this.staticExtensions = staticExtensions;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_0}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_100}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_101}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_200}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_201}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_202}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_203}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_204}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_205}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_206}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_300}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_301}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_302}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_303}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_304}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_305}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_307}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_400}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_401}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_402}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_403}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_404}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_405}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_406}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_407}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_408}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_409}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_410}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_411}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_412}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_413}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_414}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_415}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_416}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_417}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_426}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_470}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_475}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_500}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_501}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_502}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_503}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_504}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_505}</li>
     * </ul> HTTP status code used by WAF Positive Security Model when rejecting a
     * request. Enum options - HTTP_RESPONSE_CODE_0, HTTP_RESPONSE_CODE_100,
     * HTTP_RESPONSE_CODE_101, HTTP_RESPONSE_CODE_200, HTTP_RESPONSE_CODE_201,
     * HTTP_RESPONSE_CODE_202, HTTP_RESPONSE_CODE_203, HTTP_RESPONSE_CODE_204,
     * HTTP_RESPONSE_CODE_205, HTTP_RESPONSE_CODE_206, HTTP_RESPONSE_CODE_300,
     * HTTP_RESPONSE_CODE_301, HTTP_RESPONSE_CODE_302, HTTP_RESPONSE_CODE_303,
     * HTTP_RESPONSE_CODE_304, HTTP_RESPONSE_CODE_305, HTTP_RESPONSE_CODE_307,
     * HTTP_RESPONSE_CODE_400, HTTP_RESPONSE_CODE_401, HTTP_RESPONSE_CODE_402...
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as HTTP_RESPONSE_CODE_403.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatusCodeForRejectedRequests() {
        return this.statusCodeForRejectedRequests;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_0}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_100}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_101}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_200}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_201}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_202}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_203}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_204}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_205}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_206}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_300}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_301}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_302}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_303}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_304}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_305}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_307}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_400}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_401}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_402}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_403}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_404}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_405}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_406}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_407}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_408}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_409}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_410}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_411}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_412}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_413}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_414}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_415}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_416}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_417}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_426}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_470}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_475}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_500}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_501}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_502}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_503}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_504}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_505}</li>
     * </ul> HTTP status code used by WAF Positive Security Model when rejecting a
     * request. Enum options - HTTP_RESPONSE_CODE_0, HTTP_RESPONSE_CODE_100,
     * HTTP_RESPONSE_CODE_101, HTTP_RESPONSE_CODE_200, HTTP_RESPONSE_CODE_201,
     * HTTP_RESPONSE_CODE_202, HTTP_RESPONSE_CODE_203, HTTP_RESPONSE_CODE_204,
     * HTTP_RESPONSE_CODE_205, HTTP_RESPONSE_CODE_206, HTTP_RESPONSE_CODE_300,
     * HTTP_RESPONSE_CODE_301, HTTP_RESPONSE_CODE_302, HTTP_RESPONSE_CODE_303,
     * HTTP_RESPONSE_CODE_304, HTTP_RESPONSE_CODE_305, HTTP_RESPONSE_CODE_307,
     * HTTP_RESPONSE_CODE_400, HTTP_RESPONSE_CODE_401, HTTP_RESPONSE_CODE_402...
     * Default value when not specified in API or module is interpreted by ALB
     * Controller as HTTP_RESPONSE_CODE_403.
     *
     * @param statusCodeForRejectedRequests New value for the property.
     */
    public void setStatusCodeForRejectedRequests(java.lang.String statusCodeForRejectedRequests) {
        this.statusCodeForRejectedRequests = statusCodeForRejectedRequests;
    }

    /**
     * Block or flag XML requests referring to External Entities. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getXmlXxeProtection() {
        return this.xmlXxeProtection;
    }

    /**
     * Block or flag XML requests referring to External Entities. Default value when
     * not specified in API or module is interpreted by ALB Controller as true.
     *
     * @param xmlXxeProtection New value for the property.
     */
    public void setXmlXxeProtection(java.lang.Boolean xmlXxeProtection) {
        this.xmlXxeProtection = xmlXxeProtection;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBWafConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allowed_http_versions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowedHttpVersions, this._getType().getField("allowed_http_versions")));
        structValue.setField("allowed_methods",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowedMethods, this._getType().getField("allowed_methods")));
        structValue.setField("allowed_request_content_types",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowedRequestContentTypes, this._getType().getField("allowed_request_content_types")));
        structValue.setField("argument_separator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.argumentSeparator, this._getType().getField("argument_separator")));
        structValue.setField("client_request_max_body_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientRequestMaxBodySize, this._getType().getField("client_request_max_body_size")));
        structValue.setField("cookie_format_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cookieFormatVersion, this._getType().getField("cookie_format_version")));
        structValue.setField("ignore_incomplete_request_body_error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ignoreIncompleteRequestBodyError, this._getType().getField("ignore_incomplete_request_body_error")));
        structValue.setField("max_execution_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxExecutionTime, this._getType().getField("max_execution_time")));
        structValue.setField("regex_match_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.regexMatchLimit, this._getType().getField("regex_match_limit")));
        structValue.setField("regex_recursion_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.regexRecursionLimit, this._getType().getField("regex_recursion_limit")));
        structValue.setField("request_body_default_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestBodyDefaultAction, this._getType().getField("request_body_default_action")));
        structValue.setField("request_hdr_default_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestHdrDefaultAction, this._getType().getField("request_hdr_default_action")));
        structValue.setField("response_body_default_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseBodyDefaultAction, this._getType().getField("response_body_default_action")));
        structValue.setField("response_hdr_default_action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.responseHdrDefaultAction, this._getType().getField("response_hdr_default_action")));
        structValue.setField("restricted_extensions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.restrictedExtensions, this._getType().getField("restricted_extensions")));
        structValue.setField("restricted_headers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.restrictedHeaders, this._getType().getField("restricted_headers")));
        structValue.setField("server_response_max_body_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverResponseMaxBodySize, this._getType().getField("server_response_max_body_size")));
        structValue.setField("static_extensions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.staticExtensions, this._getType().getField("static_extensions")));
        structValue.setField("status_code_for_rejected_requests",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.statusCodeForRejectedRequests, this._getType().getField("status_code_for_rejected_requests")));
        structValue.setField("xml_xxe_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.xmlXxeProtection, this._getType().getField("xml_xxe_protection")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBWafConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.ALBWafConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ALBWafConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ALBWafConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ALBWafConfig(structValue);
    }

    /**
     * Builder class for {@link ALBWafConfig}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> allowedHttpVersions;
        private java.util.List<java.lang.String> allowedMethods;
        private java.util.List<java.lang.String> allowedRequestContentTypes;
        private java.lang.String argumentSeparator;
        private java.lang.Long clientRequestMaxBodySize;
        private java.lang.Long cookieFormatVersion;
        private java.lang.Boolean ignoreIncompleteRequestBodyError;
        private java.lang.Long maxExecutionTime;
        private java.lang.Long regexMatchLimit;
        private java.lang.Long regexRecursionLimit;
        private java.lang.String requestBodyDefaultAction;
        private java.lang.String requestHdrDefaultAction;
        private java.lang.String responseBodyDefaultAction;
        private java.lang.String responseHdrDefaultAction;
        private java.util.List<java.lang.String> restrictedExtensions;
        private java.util.List<java.lang.String> restrictedHeaders;
        private java.lang.Long serverResponseMaxBodySize;
        private java.util.List<java.lang.String> staticExtensions;
        private java.lang.String statusCodeForRejectedRequests;
        private java.lang.Boolean xmlXxeProtection;

        /**
         * Constructor with parameters for the required properties of
         * {@link ALBWafConfig}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ZERO_NINE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ONE_ZERO}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_ONE_ONE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_HTTP_VERSIONS_TWO_ZERO}</li>
         * </ul> WAF allowed HTTP Versions. Enum options - ZERO_NINE, ONE_ZERO, ONE_ONE,
         * TWO_ZERO. Maximum of 8 items allowed.
         *
         * @param allowedHttpVersions New value for the property.
         */
        public Builder setAllowedHttpVersions(java.util.List<java.lang.String> allowedHttpVersions) {
            this.allowedHttpVersions = allowedHttpVersions;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_GET}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_HEAD}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PUT}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_DELETE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_POST}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_OPTIONS}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_TRACE}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_CONNECT}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PATCH}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PROPFIND}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_PROPPATCH}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_MKCOL}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_COPY}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_MOVE}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_LOCK}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#ALLOWED_METHODS_UNLOCK}</li>
         * </ul> WAF allowed HTTP methods. Enum options - HTTP_METHOD_GET,
         * HTTP_METHOD_HEAD, HTTP_METHOD_PUT, HTTP_METHOD_DELETE, HTTP_METHOD_POST,
         * HTTP_METHOD_OPTIONS, HTTP_METHOD_TRACE, HTTP_METHOD_CONNECT, HTTP_METHOD_PATCH,
         * HTTP_METHOD_PROPFIND, HTTP_METHOD_PROPPATCH, HTTP_METHOD_MKCOL,
         * HTTP_METHOD_COPY, HTTP_METHOD_MOVE, HTTP_METHOD_LOCK, HTTP_METHOD_UNLOCK.
         *
         * @param allowedMethods New value for the property.
         */
        public Builder setAllowedMethods(java.util.List<java.lang.String> allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * WAF allowed Content Types. Maximum of 64 items allowed.
         *
         * @param allowedRequestContentTypes New value for the property.
         */
        public Builder setAllowedRequestContentTypes(java.util.List<java.lang.String> allowedRequestContentTypes) {
            this.allowedRequestContentTypes = allowedRequestContentTypes;
            return this;
        }

        /**
         * Argument seperator. Default value when not specified in API or module is
         * interpreted by ALB Controller as &.
         *
         * @param argumentSeparator New value for the property.
         */
        public Builder setArgumentSeparator(java.lang.String argumentSeparator) {
            this.argumentSeparator = argumentSeparator;
            return this;
        }

        /**
         * Maximum size for the client request body scanned by WAF. Allowed values are
         * 1-32768. Unit is KB. Default value when not specified in API or module is
         * interpreted by ALB Controller as 32. format: int64
         *
         * @param clientRequestMaxBodySize New value for the property.
         */
        public Builder setClientRequestMaxBodySize(java.lang.Long clientRequestMaxBodySize) {
            this.clientRequestMaxBodySize = clientRequestMaxBodySize;
            return this;
        }

        /**
         * 0 For Netscape Cookies. 1 For version 1 cookies. Allowed values are 0-1. Default
         * value when not specified in API or module is interpreted by ALB Controller as 0.
         * format: int64
         *
         * @param cookieFormatVersion New value for the property.
         */
        public Builder setCookieFormatVersion(java.lang.Long cookieFormatVersion) {
            this.cookieFormatVersion = cookieFormatVersion;
            return this;
        }

        /**
         * Ignore request body parsing errors due to partial scanning. Default value when
         * not specified in API or module is interpreted by ALB Controller as true.
         *
         * @param ignoreIncompleteRequestBodyError New value for the property.
         */
        public Builder setIgnoreIncompleteRequestBodyError(java.lang.Boolean ignoreIncompleteRequestBodyError) {
            this.ignoreIncompleteRequestBodyError = ignoreIncompleteRequestBodyError;
            return this;
        }

        /**
         * The maximum period of time WAF processing is allowed to take for a single
         * request. A value of 0 (zero) means no limit and should not be chosen in
         * production deployments. It is only used for exceptional situations where crashes
         * of se_dp processes are acceptable. The behavior of the system if this time is
         * exceeded depends on two other configuration settings, the WAF policy mode and
         * the WAF failure mode. In WAF policy mode 'Detection', the request is allowed and
         * flagged for both failure mode 'Closed' and 'Open'. In enforcement node, 'Closed'
         * means the request is rejected, 'Open' means the request is allowed and flagged.
         * Irrespective of these settings, no subsequent WAF rules of this or other phases
         * will be executed once the maximum execution time has been exceeded. Allowed
         * values are 0-5000. Unit is MILLISECONDS. Default value when not specified in API
         * or module is interpreted by ALB Controller as 50. format: int64
         *
         * @param maxExecutionTime New value for the property.
         */
        public Builder setMaxExecutionTime(java.lang.Long maxExecutionTime) {
            this.maxExecutionTime = maxExecutionTime;
            return this;
        }

        /**
         * Limit CPU utilization for each regular expression match when processing rules.
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as 30000. format: int64
         *
         * @param regexMatchLimit New value for the property.
         */
        public Builder setRegexMatchLimit(java.lang.Long regexMatchLimit) {
            this.regexMatchLimit = regexMatchLimit;
            return this;
        }

        /**
         * Limit depth of recursion for each regular expression match when processing
         * rules. Default value when not specified in API or module is interpreted by ALB
         * Controller as 10000. format: int64
         *
         * @param regexRecursionLimit New value for the property.
         */
        public Builder setRegexRecursionLimit(java.lang.Long regexRecursionLimit) {
            this.regexRecursionLimit = regexRecursionLimit;
            return this;
        }

        /**
         * WAF default action for Request Body Phase. Default value when not specified in
         * API or module is interpreted by ALB Controller as
         * phase:2,deny,status:403,log,auditlog.
         *
         * @param requestBodyDefaultAction New value for the property.
         */
        public Builder setRequestBodyDefaultAction(java.lang.String requestBodyDefaultAction) {
            this.requestBodyDefaultAction = requestBodyDefaultAction;
            return this;
        }

        /**
         * WAF default action for Request Header Phase. Default value when not specified in
         * API or module is interpreted by ALB Controller as
         * phase:1,deny,status:403,log,auditlog.
         *
         * @param requestHdrDefaultAction New value for the property.
         */
        public Builder setRequestHdrDefaultAction(java.lang.String requestHdrDefaultAction) {
            this.requestHdrDefaultAction = requestHdrDefaultAction;
            return this;
        }

        /**
         * WAF default action for Response Body Phase. Default value when not specified in
         * API or module is interpreted by ALB Controller as
         * phase:4,deny,status:403,log,auditlog.
         *
         * @param responseBodyDefaultAction New value for the property.
         */
        public Builder setResponseBodyDefaultAction(java.lang.String responseBodyDefaultAction) {
            this.responseBodyDefaultAction = responseBodyDefaultAction;
            return this;
        }

        /**
         * WAF default action for Response Header Phase. Default value when not specified
         * in API or module is interpreted by ALB Controller as
         * phase:3,deny,status:403,log,auditlog.
         *
         * @param responseHdrDefaultAction New value for the property.
         */
        public Builder setResponseHdrDefaultAction(java.lang.String responseHdrDefaultAction) {
            this.responseHdrDefaultAction = responseHdrDefaultAction;
            return this;
        }

        /**
         * WAF Restricted File Extensions. Maximum of 256 items allowed.
         *
         * @param restrictedExtensions New value for the property.
         */
        public Builder setRestrictedExtensions(java.util.List<java.lang.String> restrictedExtensions) {
            this.restrictedExtensions = restrictedExtensions;
            return this;
        }

        /**
         * WAF Restricted HTTP Headers. Maximum of 64 items allowed.
         *
         * @param restrictedHeaders New value for the property.
         */
        public Builder setRestrictedHeaders(java.util.List<java.lang.String> restrictedHeaders) {
            this.restrictedHeaders = restrictedHeaders;
            return this;
        }

        /**
         * Maximum size for response body scanned by WAF. Allowed values are 1-32768. Unit
         * is KB. Default value when not specified in API or module is interpreted by ALB
         * Controller as 128. format: int64
         *
         * @param serverResponseMaxBodySize New value for the property.
         */
        public Builder setServerResponseMaxBodySize(java.lang.Long serverResponseMaxBodySize) {
            this.serverResponseMaxBodySize = serverResponseMaxBodySize;
            return this;
        }

        /**
         * WAF Static File Extensions. GET and HEAD requests with no query args and one of
         * these extensions are allowed and not checked by the ruleset. Maximum of 64 items
         * allowed.
         *
         * @param staticExtensions New value for the property.
         */
        public Builder setStaticExtensions(java.util.List<java.lang.String> staticExtensions) {
            this.staticExtensions = staticExtensions;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_0}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_100}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_101}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_200}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_201}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_202}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_203}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_204}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_205}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_206}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_300}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_301}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_302}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_303}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_304}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_305}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_307}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_400}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_401}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_402}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_403}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_404}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_405}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_406}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_407}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_408}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_409}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_410}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_411}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_412}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_413}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_414}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_415}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_416}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_417}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_426}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_470}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_475}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_500}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_501}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_502}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_503}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_504}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ALBWafConfig#STATUS_CODE_FOR_REJECTED_REQUESTS_505}</li>
         * </ul> HTTP status code used by WAF Positive Security Model when rejecting a
         * request. Enum options - HTTP_RESPONSE_CODE_0, HTTP_RESPONSE_CODE_100,
         * HTTP_RESPONSE_CODE_101, HTTP_RESPONSE_CODE_200, HTTP_RESPONSE_CODE_201,
         * HTTP_RESPONSE_CODE_202, HTTP_RESPONSE_CODE_203, HTTP_RESPONSE_CODE_204,
         * HTTP_RESPONSE_CODE_205, HTTP_RESPONSE_CODE_206, HTTP_RESPONSE_CODE_300,
         * HTTP_RESPONSE_CODE_301, HTTP_RESPONSE_CODE_302, HTTP_RESPONSE_CODE_303,
         * HTTP_RESPONSE_CODE_304, HTTP_RESPONSE_CODE_305, HTTP_RESPONSE_CODE_307,
         * HTTP_RESPONSE_CODE_400, HTTP_RESPONSE_CODE_401, HTTP_RESPONSE_CODE_402...
         * Default value when not specified in API or module is interpreted by ALB
         * Controller as HTTP_RESPONSE_CODE_403.
         *
         * @param statusCodeForRejectedRequests New value for the property.
         */
        public Builder setStatusCodeForRejectedRequests(java.lang.String statusCodeForRejectedRequests) {
            this.statusCodeForRejectedRequests = statusCodeForRejectedRequests;
            return this;
        }

        /**
         * Block or flag XML requests referring to External Entities. Default value when
         * not specified in API or module is interpreted by ALB Controller as true.
         *
         * @param xmlXxeProtection New value for the property.
         */
        public Builder setXmlXxeProtection(java.lang.Boolean xmlXxeProtection) {
            this.xmlXxeProtection = xmlXxeProtection;
            return this;
        }

        public ALBWafConfig build() {
            ALBWafConfig result = new ALBWafConfig();
            result.setAllowedHttpVersions(this.allowedHttpVersions);
            result.setAllowedMethods(this.allowedMethods);
            result.setAllowedRequestContentTypes(this.allowedRequestContentTypes);
            result.setArgumentSeparator(this.argumentSeparator);
            result.setClientRequestMaxBodySize(this.clientRequestMaxBodySize);
            result.setCookieFormatVersion(this.cookieFormatVersion);
            result.setIgnoreIncompleteRequestBodyError(this.ignoreIncompleteRequestBodyError);
            result.setMaxExecutionTime(this.maxExecutionTime);
            result.setRegexMatchLimit(this.regexMatchLimit);
            result.setRegexRecursionLimit(this.regexRecursionLimit);
            result.setRequestBodyDefaultAction(this.requestBodyDefaultAction);
            result.setRequestHdrDefaultAction(this.requestHdrDefaultAction);
            result.setResponseBodyDefaultAction(this.responseBodyDefaultAction);
            result.setResponseHdrDefaultAction(this.responseHdrDefaultAction);
            result.setRestrictedExtensions(this.restrictedExtensions);
            result.setRestrictedHeaders(this.restrictedHeaders);
            result.setServerResponseMaxBodySize(this.serverResponseMaxBodySize);
            result.setStaticExtensions(this.staticExtensions);
            result.setStatusCodeForRejectedRequests(this.statusCodeForRejectedRequests);
            result.setXmlXxeProtection(this.xmlXxeProtection);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allowed_http_versions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allowed_http_versions",
                                                                                "allowedHttpVersions",
                                                                                "getAllowedHttpVersions",
                                                                                "setAllowedHttpVersions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allowed_methods", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allowed_methods",
                                                                                "allowedMethods",
                                                                                "getAllowedMethods",
                                                                                "setAllowedMethods");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allowed_request_content_types", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allowed_request_content_types",
                                                                                "allowedRequestContentTypes",
                                                                                "getAllowedRequestContentTypes",
                                                                                "setAllowedRequestContentTypes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("argument_separator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("argument_separator",
                                                                                "argumentSeparator",
                                                                                "getArgumentSeparator",
                                                                                "setArgumentSeparator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_request_max_body_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_request_max_body_size",
                                                                                "clientRequestMaxBodySize",
                                                                                "getClientRequestMaxBodySize",
                                                                                "setClientRequestMaxBodySize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cookie_format_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cookie_format_version",
                                                                                "cookieFormatVersion",
                                                                                "getCookieFormatVersion",
                                                                                "setCookieFormatVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ignore_incomplete_request_body_error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ignore_incomplete_request_body_error",
                                                                                "ignoreIncompleteRequestBodyError",
                                                                                "getIgnoreIncompleteRequestBodyError",
                                                                                "setIgnoreIncompleteRequestBodyError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_execution_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_execution_time",
                                                                                "maxExecutionTime",
                                                                                "getMaxExecutionTime",
                                                                                "setMaxExecutionTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("regex_match_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("regex_match_limit",
                                                                                "regexMatchLimit",
                                                                                "getRegexMatchLimit",
                                                                                "setRegexMatchLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("regex_recursion_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("regex_recursion_limit",
                                                                                "regexRecursionLimit",
                                                                                "getRegexRecursionLimit",
                                                                                "setRegexRecursionLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_body_default_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_body_default_action",
                                                                                "requestBodyDefaultAction",
                                                                                "getRequestBodyDefaultAction",
                                                                                "setRequestBodyDefaultAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_hdr_default_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_hdr_default_action",
                                                                                "requestHdrDefaultAction",
                                                                                "getRequestHdrDefaultAction",
                                                                                "setRequestHdrDefaultAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_body_default_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_body_default_action",
                                                                                "responseBodyDefaultAction",
                                                                                "getResponseBodyDefaultAction",
                                                                                "setResponseBodyDefaultAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("response_hdr_default_action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("response_hdr_default_action",
                                                                                "responseHdrDefaultAction",
                                                                                "getResponseHdrDefaultAction",
                                                                                "setResponseHdrDefaultAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("restricted_extensions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("restricted_extensions",
                                                                                "restrictedExtensions",
                                                                                "getRestrictedExtensions",
                                                                                "setRestrictedExtensions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("restricted_headers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("restricted_headers",
                                                                                "restrictedHeaders",
                                                                                "getRestrictedHeaders",
                                                                                "setRestrictedHeaders");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_response_max_body_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_response_max_body_size",
                                                                                "serverResponseMaxBodySize",
                                                                                "getServerResponseMaxBodySize",
                                                                                "setServerResponseMaxBodySize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("static_extensions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("static_extensions",
                                                                                "staticExtensions",
                                                                                "getStaticExtensions",
                                                                                "setStaticExtensions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status_code_for_rejected_requests", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status_code_for_rejected_requests",
                                                                                "statusCodeForRejectedRequests",
                                                                                "getStatusCodeForRejectedRequests",
                                                                                "setStatusCodeForRejectedRequests");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("xml_xxe_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("xml_xxe_protection",
                                                                                "xmlXxeProtection",
                                                                                "getXmlXxeProtection",
                                                                                "setXmlXxeProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.ALB_waf_config",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ALBWafConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

